/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.SystemBundleTests;
import org.eclipse.osgi.util.ManifestElement;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleWiring;

public class AddDynamicImportTests
extends AbstractBundleTests {
    @Test
    public void testAddDynamicImportMultipleTimes() throws Exception {
        ManifestElement[] packageImport = ManifestElement.parseHeader((String)"DynamicImport-Package", (String)"org.osgi.framework");
        this.runTest(3, (a, b, threadPool) -> {
            int i = 0;
            while (i < 1000) {
                BundleLoader bl = ((ModuleClassLoader)((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader()).getBundleLoader();
                ConcurrentHashMap addedDynamicImport = new ConcurrentHashMap();
                Callable<Void> test = () -> {
                    addedDynamicImport.computeIfAbsent(bl, bl2 -> {
                        bl2.addDynamicImportPackage(packageImport);
                        return true;
                    });
                    b.loadClass("org.osgi.framework.Bundle");
                    return null;
                };
                List results = threadPool.invokeAll(Arrays.asList(test, test, test));
                for (Future result : results) {
                    result.get();
                }
                this.refresh(bl);
                ++i;
            }
        });
    }

    @Test
    public void testAddDynamicImportWhileDynamicWiring() throws Exception {
        ManifestElement[] packageImport = ManifestElement.parseHeader((String)"DynamicImport-Package", (String)"org.osgi.framework");
        this.runTest(5, (a, b, threadPool) -> {
            int i = 0;
            while (i < 1000) {
                System.out.println("Doing " + i);
                BundleLoader bl = ((ModuleClassLoader)((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader()).getBundleLoader();
                Callable<Void> addDynamic = () -> {
                    bl.addDynamicImportPackage(packageImport);
                    b.loadClass("org.osgi.framework.Bundle");
                    return null;
                };
                AtomicInteger pkgNumber = new AtomicInteger(1);
                Callable<Void> resolveDynamic = () -> {
                    a.getResource("test/export/pkg" + pkgNumber.getAndAdd(1) + "/DoesNotExist.txt");
                    return null;
                };
                List results = threadPool.invokeAll(Arrays.asList(addDynamic, resolveDynamic, resolveDynamic, resolveDynamic, resolveDynamic));
                for (Future result : results) {
                    result.get();
                }
                Assert.assertEquals((String)"Wrong number of required wires for wiring A", (long)4L, (long)((BundleWiring)a.adapt(BundleWiring.class)).getRequiredWires("osgi.wiring.package").size());
                this.refresh(bl);
                ++i;
            }
        });
    }

    private void refresh(BundleLoader bl) {
        Module module = bl.getWiring().getRevision().getRevisions().getModule();
        module.getContainer().refresh(Collections.singletonList(module));
    }

    private void runTest(int threads, ThrowingBiConsumer<Bundle, Bundle> testConsumer) throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> headersA = new HashMap<String, String>();
        headersA.put("Bundle-ManifestVersion", "2");
        headersA.put("Bundle-SymbolicName", this.getName() + "A");
        headersA.put("DynamicImport-Package", "test.export.*");
        HashMap<String, String> headersB = new HashMap<String, String>();
        headersB.put("Bundle-ManifestVersion", "2");
        headersB.put("Bundle-SymbolicName", this.getName() + "B");
        headersB.put("Export-Package", "test.export.pkg1, test.export.pkg2, test.export.pkg3, test.export.pkg4");
        config.mkdirs();
        File bundleAFile = SystemBundleTests.createBundle(config, this.getName() + "A", headersA, new Map[0]);
        File bundleBFile = SystemBundleTests.createBundle(config, this.getName(), headersB, new Map[0]);
        HashMap<String, String> fwkConfig = new HashMap<String, String>();
        fwkConfig.put("org.osgi.framework.storage", config.getAbsolutePath());
        fwkConfig.put("equinox.resolver.batch.timeout", "10000000");
        Equinox equinox = new Equinox(fwkConfig);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle bundleA = systemContext.installBundle(bundleAFile.toURI().toString());
            bundleA.start();
            Bundle bundleB = systemContext.installBundle(bundleBFile.toURI().toString());
            bundleB.start();
            Assert.assertThrows(ClassNotFoundException.class, () -> {
                Class clazz = bundleA.loadClass("org.osgi.framework.Bundle");
            });
            testConsumer.accept(bundleA, bundleB, executor);
        }
        finally {
            executor.shutdown();
            AddDynamicImportTests.stopQuietly((Framework)equinox);
        }
    }

    private static interface ThrowingBiConsumer<T, U> {
        public void accept(T var1, U var2, ExecutorService var3) throws Exception;
    }
}

