/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.InputStream;
import java.net.URL;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BundleExceptionTests
extends AbstractBundleTests {
    @Test
    public void testInvalidBundleActivator01() throws BundleException {
        Bundle error1 = installer.installBundle("activator.error1");
        BundleException e = (BundleException)Assert.assertThrows(BundleException.class, () -> ((Bundle)error1).start());
        Assert.assertEquals((String)"Expected activator error", (long)5L, (long)e.getType());
    }

    @Test
    public void testInvalidBundleActivator02() throws BundleException {
        Bundle error1 = installer.installBundle("activator.error2");
        BundleException e = (BundleException)Assert.assertThrows(BundleException.class, () -> ((Bundle)error1).start());
        Assert.assertEquals((String)"Expected activator error", (long)5L, (long)e.getType());
    }

    @Test
    public void testInvalidBundleActivator03() throws BundleException {
        Bundle error1 = installer.installBundle("activator.error3");
        error1.start();
        BundleException e = (BundleException)Assert.assertThrows(BundleException.class, () -> ((Bundle)error1).stop());
        Assert.assertEquals((String)"Expected activator error", (long)5L, (long)e.getType());
    }

    @Test
    public void testDuplicateError01() throws BundleException {
        installer.installBundle("activator.error1");
        BundleException e = (BundleException)Assert.assertThrows(BundleException.class, () -> {
            Bundle bundle = installer.installBundle("activator.error4");
        });
        Assert.assertEquals((String)"Expected duplicate error", (long)9L, (long)e.getType());
    }

    @Test
    public void testDuplicateError02() throws Exception {
        installer.installBundle("activator.error1");
        Bundle error2 = installer.installBundle("activator.error2");
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream input = new URL(installer.getBundleLocation("activator.error4")).openStream();){
            BundleException e = (BundleException)Assert.assertThrows(BundleException.class, () -> error2.update(input));
            Assert.assertEquals((String)"Expected duplicate error", (long)9L, (long)e.getType());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testUninstallSystemBundle() {
        Bundle systemBundle = OSGiTestsActivator.getContext().getBundle(0L);
        Assert.assertNotNull((String)"System Bundle is null!!", (Object)systemBundle);
        BundleException e = (BundleException)Assert.assertThrows(BundleException.class, () -> ((Bundle)systemBundle).uninstall());
        Assert.assertEquals((String)"Expected invalid error", (long)2L, (long)e.getType());
    }
}

