/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.SystemBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.wiring.BundleWiring;

public class BundleInstallUpdateTests
extends AbstractBundleTests {
    @Test
    public void testInstallWithLocation01() throws BundleException {
        String location = installer.getBundleLocation("test");
        Bundle test = installer.installBundleAtLocation(location);
        Assert.assertEquals((String)"Wrong BSN", (Object)"test1", (Object)test.getSymbolicName());
    }

    @Test
    public void testInstallWithLocation02() throws BundleException {
        String location = installer.getBundleLocation("test");
        Bundle test = installer.installBundleAtLocation(location);
        Assert.assertEquals((String)"Wrong BSN", (Object)"test1", (Object)test.getSymbolicName());
    }

    @Test
    public void testInstallWithStream03() throws Exception {
        String location1 = installer.getBundleLocation("test");
        String location2 = installer.getBundleLocation("test2");
        Bundle test = installer.installBundleAtLocation(location1, new URL(location2).openStream());
        Assert.assertEquals((String)"Wrong BSN", (Object)"test2", (Object)test.getSymbolicName());
    }

    @Test
    public void testUpdateNoStream01() throws BundleException {
        String location = installer.getBundleLocation("test");
        Bundle test = installer.installBundleAtLocation(location);
        Assert.assertEquals((String)"Wrong BSN", (Object)"test1", (Object)test.getSymbolicName());
        test.update();
        Assert.assertEquals((String)"Wrong BSN", (Object)"test1", (Object)test.getSymbolicName());
    }

    @Test
    public void testUpdateNoStream02() throws BundleException {
        String location = installer.getBundleLocation("test");
        Bundle test = installer.installBundleAtLocation(location);
        Assert.assertEquals((String)"Wrong BSN", (Object)"test1", (Object)test.getSymbolicName());
        test.update(null);
        Assert.assertEquals((String)"Wrong BSN", (Object)"test1", (Object)test.getSymbolicName());
    }

    @Test
    public void testUpdateWithStream01() throws Exception {
        String location1 = installer.getBundleLocation("test");
        String location2 = installer.getBundleLocation("test2");
        Bundle test = installer.installBundleAtLocation(location1);
        Assert.assertEquals((String)"Wrong BSN", (Object)"test1", (Object)test.getSymbolicName());
        test.update(new URL(location2).openStream());
        Assert.assertEquals((String)"Wrong BSN", (Object)"test2", (Object)test.getSymbolicName());
    }

    @Test
    public void testUpdateWithStream02() throws Exception {
        String location1 = installer.getBundleLocation("test");
        String location2 = installer.getBundleLocation("test2");
        Bundle test = installer.installBundleAtLocation(location1);
        Bundle b1 = installer.installBundle("chain.test");
        Assert.assertEquals((String)"Wrong BSN", (Object)"test1", (Object)test.getSymbolicName());
        test.update(new URL(location2).openStream());
        Assert.assertEquals((String)"Wrong BSN", (Object)"test2", (Object)test.getSymbolicName());
        Bundle[] bundles = OSGiTestsActivator.getContext().getBundles();
        Assert.assertTrue((String)("Wrong bundle at the end: " + String.valueOf(bundles[bundles.length - 1])), (bundles[bundles.length - 1] == b1 ? 1 : 0) != 0);
        Bundle[] tests = installer.getPackageAdmin().getBundles(test.getSymbolicName(), null);
        Assert.assertNotNull((String)"null tests", (Object)tests);
        Assert.assertEquals((String)"Wrong number", (long)1L, (long)tests.length);
        Assert.assertTrue((String)("Wrong bundle: " + String.valueOf(tests[0])), (tests[0] == test ? 1 : 0) != 0);
    }

    @Test
    public void testBug290193() throws Exception {
        URL testBundle = OSGiTestsActivator.getBundle().getEntry("test_files/security/bundles/signed.jar");
        File testFile = OSGiTestsActivator.getContext().getDataFile("test with space/test.jar");
        Assert.assertTrue((boolean)testFile.getParentFile().mkdirs());
        Files.copy(testBundle.openStream(), testFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        installer.installBundleAtLocation("reference:" + testFile.toURI().toString());
    }

    @Test
    public void testCollisionHook() throws BundleException, IOException {
        InputStream input;
        Bundle test1 = installer.installBundle("test");
        installer.installBundle("test2");
        URL testLocation = new URL(installer.getBundleLocation("test2"));
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            input = testLocation.openStream();
            try {
                Assert.assertThrows((String)"Expected to fail to update to another bsn/version that causes collision", BundleException.class, () -> test1.update(input));
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            input = testLocation.openStream();
            try {
                Assert.assertThrows((String)"Expected to fail to install duplication bsn/version that causes collision", BundleException.class, () -> {
                    Bundle bundle = installer.installBundleAtLocation("junk", input);
                });
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        installer.uninstallBundle("junk");
        CollisionHook hook = (operationType, target, collisionCandidates) -> collisionCandidates.clear();
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(CollisionHook.class, (Object)hook, null);
        try {
            InputStream input2;
            Throwable throwable4 = null;
            Object var6_12 = null;
            try {
                input2 = testLocation.openStream();
                try {
                    test1.update(input2);
                }
                finally {
                    if (input2 != null) {
                        input2.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable4 == null) {
                    throwable4 = throwable5;
                } else if (throwable4 != throwable5) {
                    throwable4.addSuppressed(throwable5);
                }
                throw throwable4;
            }
            throwable4 = null;
            var6_12 = null;
            try {
                input2 = testLocation.openStream();
                try {
                    installer.installBundleAtLocation("junk", input2);
                }
                finally {
                    if (input2 != null) {
                        input2.close();
                    }
                }
            }
            catch (Throwable throwable6) {
                if (throwable4 == null) {
                    throwable4 = throwable6;
                } else if (throwable4 != throwable6) {
                    throwable4.addSuppressed(throwable6);
                }
                throw throwable4;
            }
        }
        finally {
            reg.unregister();
        }
    }

    @Test
    public void testInstallWithInterruption() throws BundleException {
        Thread.currentThread().interrupt();
        installer.installBundle("test");
    }

    @Test
    public void testPercentLocation() throws Exception {
        this.doTestSpecialChars('%', false);
        this.doTestSpecialChars('%', true);
    }

    @Test
    public void testSpaceLocation() throws Exception {
        this.doTestSpecialChars(' ', false);
        this.doTestSpecialChars(' ', true);
    }

    @Test
    public void testPlusLocation() throws Exception {
        this.doTestSpecialChars('+', true);
        this.doTestSpecialChars('+', false);
    }

    @Test
    public void testOctothorpLocation() throws Exception {
        this.doTestSpecialChars('#', true);
        this.doTestSpecialChars('#', false, false, false);
    }

    @Test
    public void testQuestionMarkLocation() throws Exception {
        if (Platform.getOS().equals("win32")) {
            return;
        }
        this.doTestSpecialChars('?', true);
        this.doTestSpecialChars('?', false, true, false);
    }

    private void doTestSpecialChars(char c, boolean encode) throws Exception {
        this.doTestSpecialChars(c, encode, true, true);
    }

    private void doTestSpecialChars(char c, boolean encode, boolean refPass, boolean filePass) throws Exception {
        File bundlesDirectory = OSGiTestsActivator.getContext().getDataFile("file_with_" + c + "_char");
        bundlesDirectory.mkdirs();
        File testBundleJarFile = SystemBundleTests.createBundle(bundlesDirectory, this.getName() + "1", false, false);
        String testBundleJarFileURL = (encode ? testBundleJarFile.toURI() : testBundleJarFile.toURL()).toString();
        File testBundleDirFile = SystemBundleTests.createBundle(bundlesDirectory, this.getName() + "2", false, true);
        String testBundleDirFileURL = (encode ? testBundleDirFile.toURI() : testBundleDirFile.toURL()).toString();
        String refToJarURL = "reference:" + testBundleJarFileURL;
        this.testInstallSpecialCharBundle(refToJarURL, true, refPass);
        this.testInstallSpecialCharBundle(refToJarURL, false, refPass);
        this.testInstallSpecialCharBundle("reference:" + testBundleDirFileURL, false, refPass);
        this.testInstallSpecialCharBundle(testBundleJarFileURL, false, filePass);
        this.testInstallSpecialCharBundle(testBundleDirFileURL, false, filePass);
    }

    void testInstallSpecialCharBundle(String location, boolean openStream, boolean expectSuccess) throws Exception {
        Callable<Void> testInstall = () -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream input = openStream ? new URL(location).openStream() : null;){
                Bundle b = installer.installBundleAtLocation(location, input);
                b.start();
                b.uninstall();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return null;
        };
        if (expectSuccess) {
            testInstall.call();
        } else {
            Assert.assertThrows(Exception.class, testInstall::call);
        }
    }

    @Test
    public void testPercentCharBundleEntry() throws IOException, BundleException {
        this.doTestSpaceCharsBundleEntry('%');
    }

    @Test
    public void testSpaceCharBundleEntry() throws IOException, BundleException {
        this.doTestSpaceCharsBundleEntry(' ');
    }

    @Test
    public void testPlusCharBundleEntry() throws IOException, BundleException {
        this.doTestSpaceCharsBundleEntry('+');
    }

    public void doTestSpaceCharsBundleEntry(char c) throws IOException, BundleException {
        String entryName = "file_with_" + c + "_char";
        File bundlesDirectory = OSGiTestsActivator.getContext().getDataFile(this.getName());
        bundlesDirectory.mkdirs();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-SymbolicName", this.getName());
        Map<CallSite, String> entry = Collections.singletonMap(entryName, "value");
        File testBundleJarFile = SystemBundleTests.createBundle(bundlesDirectory, this.getName(), headers, entry);
        Bundle testBundle = this.getContext().installBundle(this.getName(), (InputStream)new FileInputStream(testBundleJarFile));
        URL entryURL = testBundle.getEntry(entryName);
        Assert.assertNotNull((String)"Entry not found.", (Object)entryURL);
        InputStream is = entryURL.openStream();
        is.close();
        String encodeEntry = URLEncoder.encode(entryName, StandardCharsets.UTF_8);
        Object urlString = entryURL.toExternalForm();
        urlString = ((String)urlString).substring(0, ((String)urlString).indexOf(entryName)) + encodeEntry;
        URL encodedURL = new URL((String)urlString);
        is = encodedURL.openStream();
        is.close();
    }

    public static Method findDeclaredMethod(Class<?> clazz, String method, Class ... args) throws NoSuchMethodException {
        while (true) {
            try {
                return clazz.getDeclaredMethod(method, args);
            }
            catch (NoSuchMethodException e) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw new NoSuchMethodException(method);
            }
            break;
        }
    }

    @Test
    public void testEscapeZipRoot() throws Exception {
        String entry1 = "../../escapedZipRoot1.txt";
        String entry2 = "dir1/../../../escapedZipRoot2.txt";
        String cp1 = "../../cp.jar";
        String nativeCode = "../../lib/nativeCode";
        File bundlesDirectory = OSGiTestsActivator.getContext().getDataFile(this.getName());
        bundlesDirectory.mkdirs();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-SymbolicName", this.getName());
        headers.put("Bundle-ClassPath", "., " + cp1);
        headers.put("Bundle-NativeCode", nativeCode);
        HashMap<String, String> entries = new HashMap<String, String>();
        entries.put(entry1, "value");
        entries.put(entry2, "value");
        entries.put(cp1, "value");
        entries.put(nativeCode, "value");
        File testBundleJarFile = SystemBundleTests.createBundle(bundlesDirectory, this.getName(), headers, entries);
        Bundle testBundle = this.getContext().installBundle(this.getName(), (InputStream)new FileInputStream(testBundleJarFile));
        testBundle.start();
        try {
            testBundle.loadClass("does.not.exist.Test");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ClassLoader cl = ((BundleWiring)testBundle.adapt(BundleWiring.class)).getClassLoader();
        Method findLibrary = BundleInstallUpdateTests.findDeclaredMethod(cl.getClass(), "findLibrary", String.class);
        findLibrary.setAccessible(true);
        Assert.assertNull((String)"Found library.", (Object)findLibrary.invoke((Object)cl, "nativeCode"));
        URLConverter bundleURLConverter = (URLConverter)this.getContext().getService((ServiceReference)this.getContext().getServiceReferences(URLConverter.class, "(protocol=bundleentry)").iterator().next());
        URL dir1 = bundleURLConverter.toFileURL(testBundle.getEntry("dir1/"));
        File dir1File = new File(dir1.toExternalForm().substring(5));
        File dir1EscapedFile2 = new File(dir1File, entry2.substring("dir1".length()));
        Assert.assertFalse((String)("File escaped zip root: " + dir1EscapedFile2.getCanonicalPath()), (boolean)dir1EscapedFile2.exists());
        URL root = bundleURLConverter.toFileURL(testBundle.getEntry("/"));
        File rootFile = new File(root.toExternalForm().substring(5));
        File rootEscapedFile1 = new File(rootFile, entry1);
        Assert.assertFalse((String)("File escaped zip root: " + rootEscapedFile1.getCanonicalPath()), (boolean)rootEscapedFile1.exists());
        File rootEscapedFile2 = new File(rootFile, entry2);
        Assert.assertFalse((String)("File escaped zip root: " + rootEscapedFile2.getCanonicalPath()), (boolean)rootEscapedFile2.exists());
        File rootEscapedFile3 = new File(rootFile, cp1);
        Assert.assertFalse((String)("File escaped zip root: " + rootEscapedFile3.getCanonicalPath()), (boolean)rootEscapedFile3.exists());
    }
}

