/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class BundleInstaller {
    private final BundleContext context;
    private final String rootLocation;
    private Map<String, Bundle> bundles = new HashMap<String, Bundle>();
    private final ServiceTracker<?, PackageAdmin> packageAdmin;
    private final ServiceTracker<?, StartLevel> startlevel;
    private final ServiceTracker<?, URLConverter> converter;
    private final ServiceTracker<?, PlatformAdmin> platformAdmin;

    public BundleInstaller(String bundlesRoot, BundleContext context) throws InvalidSyntaxException {
        this.context = context;
        this.rootLocation = bundlesRoot;
        this.converter = new ServiceTracker(context, context.createFilter("(&(objectClass=" + URLConverter.class.getName() + ")(protocol=bundleentry))"), null);
        this.converter.open();
        this.startlevel = new ServiceTracker(context, StartLevel.class.getName(), null);
        this.startlevel.open();
        this.packageAdmin = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.packageAdmin.open();
        this.platformAdmin = new ServiceTracker(context, PlatformAdmin.class.getName(), null);
        this.platformAdmin.open();
    }

    public synchronized Bundle installBundle(String name) throws BundleException {
        return this.installBundle(name, true);
    }

    public synchronized Bundle installBundle(String name, boolean track) throws BundleException {
        String location = this.getBundleLocation(name);
        return this.install(location, null, name, track);
    }

    public synchronized Bundle installBundleAtLocation(String location) throws BundleException {
        return this.install(location, null, location, true);
    }

    public synchronized Bundle installBundleAtLocation(String location, InputStream input) throws BundleException {
        return this.install(location, input, location, true);
    }

    private Bundle install(String location, InputStream input, String name, boolean track) throws BundleException {
        if (this.bundles == null && track) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream in = input;){
                Bundle bundle = this.context.installBundle(location, input);
                if (track) {
                    this.bundles.put(name, bundle);
                }
                return bundle;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new BundleException("Failed to close bundle's input stream", (Throwable)e);
        }
    }

    public String getBundleLocation(String name) throws BundleException {
        if (System.getSecurityManager() == null) {
            return this.getBundleLocation0(name);
        }
        try {
            return (String)AccessController.doPrivileged(() -> this.getBundleLocation0(name));
        }
        catch (PrivilegedActionException e) {
            throw (BundleException)((Object)e.getException());
        }
    }

    String getBundleLocation0(String name) throws BundleException {
        String bundleFileName = this.rootLocation + "/" + name;
        URL bundleURL = this.context.getBundle().getEntry(bundleFileName + ".jar");
        if (bundleURL == null) {
            bundleURL = this.context.getBundle().getEntry(bundleFileName);
        }
        if (bundleURL == null) {
            throw new BundleException("Could not find bundle to install at: " + name);
        }
        try {
            bundleURL = ((URLConverter)this.converter.getService()).resolve(bundleURL);
        }
        catch (IOException e) {
            throw new BundleException("Converter error", (Throwable)e);
        }
        Object location = bundleURL.toExternalForm();
        if ("file".equals(bundleURL.getProtocol())) {
            location = "reference:" + (String)location;
        }
        return location;
    }

    public synchronized Bundle updateBundle(String fromName, String toName) throws BundleException {
        if (this.bundles == null) {
            return null;
        }
        Bundle fromBundle = this.bundles.get(fromName);
        if (fromBundle == null) {
            throw new BundleException("The bundle to update does not exist!! " + fromName);
        }
        String bundleFileName = this.rootLocation + "/" + toName;
        URL bundleURL = this.context.getBundle().getEntry(bundleFileName + ".jar");
        if (bundleURL == null) {
            bundleURL = this.context.getBundle().getEntry(bundleFileName);
        }
        try {
            bundleURL = ((URLConverter)this.converter.getService()).resolve(bundleURL);
        }
        catch (IOException e) {
            throw new BundleException("Converter error", (Throwable)e);
        }
        Object location = bundleURL.toExternalForm();
        if ("file".equals(bundleURL.getProtocol())) {
            location = "reference:" + (String)location;
        }
        try {
            fromBundle.update(new URL((String)location).openStream());
        }
        catch (Exception e) {
            throw new BundleException("Errors when updating bundle " + String.valueOf(fromBundle), (Throwable)e);
        }
        this.bundles.remove(fromName);
        this.bundles.put(toName, fromBundle);
        return fromBundle;
    }

    public synchronized Bundle uninstallBundle(String name) throws BundleException {
        if (this.bundles == null) {
            return null;
        }
        Bundle bundle = this.bundles.remove(name);
        if (bundle == null) {
            return null;
        }
        bundle.uninstall();
        return bundle;
    }

    public synchronized Bundle[] uninstallAllBundles() {
        if (this.bundles == null) {
            return new Bundle[0];
        }
        ArrayList<Bundle> result = new ArrayList<Bundle>(this.bundles.size());
        for (Bundle bundle : this.bundles.values()) {
            try {
                bundle.uninstall();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
            result.add(bundle);
        }
        this.bundles.clear();
        return result.toArray(new Bundle[result.size()]);
    }

    public synchronized void shutdown() {
        if (this.bundles == null) {
            return;
        }
        Bundle[] result = this.uninstallAllBundles();
        this.refreshPackages(result);
        this.packageAdmin.close();
        this.startlevel.close();
        this.converter.close();
        this.platformAdmin.close();
        this.bundles = null;
    }

    public synchronized Bundle[] refreshPackages(Bundle[] refresh) {
        HashSet refreshed;
        block6: {
            if (this.bundles == null) {
                return null;
            }
            PackageAdmin pa = (PackageAdmin)this.packageAdmin.getService();
            CountDownLatch flag = new CountDownLatch(1);
            FrameworkListener listener = event -> {
                if (event.getType() == 4) {
                    flag.countDown();
                }
            };
            this.context.addFrameworkListener(listener);
            refreshed = new HashSet();
            SynchronousBundleListener refreshBundleListener = event -> {
                boolean bl = refreshed.add(event.getBundle());
            };
            this.context.addBundleListener((BundleListener)refreshBundleListener);
            try {
                try {
                    pa.refreshPackages(refresh);
                    Assert.assertTrue((String)"refreshPackages timed out", (boolean)flag.await(30L, TimeUnit.SECONDS));
                }
                catch (InterruptedException interruptedException) {
                    this.context.removeFrameworkListener(listener);
                    this.context.removeBundleListener((BundleListener)refreshBundleListener);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.context.removeFrameworkListener(listener);
                this.context.removeBundleListener((BundleListener)refreshBundleListener);
                throw throwable;
            }
            this.context.removeFrameworkListener(listener);
            this.context.removeBundleListener((BundleListener)refreshBundleListener);
        }
        return refreshed.toArray(new Bundle[refreshed.size()]);
    }

    public synchronized boolean resolveBundles(Bundle[] resolve) {
        if (this.bundles == null) {
            return false;
        }
        PackageAdmin pa = (PackageAdmin)this.packageAdmin.getService();
        return pa.resolveBundles(resolve);
    }

    public synchronized Bundle getBundle(String name) {
        if (this.bundles == null) {
            return null;
        }
        return this.bundles.get(name);
    }

    public StartLevel getStartLevel() {
        return (StartLevel)this.startlevel.getService();
    }

    public PackageAdmin getPackageAdmin() {
        return (PackageAdmin)this.packageAdmin.getService();
    }

    public PlatformAdmin getPlatformAdmin() {
        return (PlatformAdmin)this.platformAdmin.getService();
    }
}

