/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.SystemBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleWiring;

public class BundleNativeCodeTests
extends AbstractBundleTests {
    @Test
    public void testMultipleBundleNativeHostOnlyOneMatch() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> hostHeaders = new HashMap<String, String>();
        hostHeaders.put("Bundle-ManifestVersion", "2");
        hostHeaders.put("Bundle-SymbolicName", this.getName() + ".host");
        hostHeaders.put("Bundle-NativeCode", "nativeCode1.txt; selection-filter=\"(library.match=1)\",nativeCode2.txt; selection-filter=\"(library.match=2)\",nativeCode3.txt; selection-filter=\"(library.match=3)\",*");
        File hostBundleFile = SystemBundleTests.createBundle(config, (String)hostHeaders.get("Bundle-SymbolicName"), hostHeaders, Collections.singletonMap("nativeCode1.txt", "nativeCode1.txt"), Collections.singletonMap("nativeCode2.txt", "nativeCode2.txt"), Collections.singletonMap("nativeCode3.txt", "nativeCode3.txt"));
        this.doTestNativeCode(config, "1", "nativeCode1.txt", hostBundleFile, new File[0]);
        this.doTestNativeCode(config, "2", "nativeCode2.txt", hostBundleFile, new File[0]);
        this.doTestNativeCode(config, "3", "nativeCode3.txt", hostBundleFile, new File[0]);
    }

    @Test
    public void testSingleBundleNativeHostOneMatch() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> hostHeaders = new HashMap<String, String>();
        hostHeaders.put("Bundle-ManifestVersion", "2");
        hostHeaders.put("Bundle-SymbolicName", this.getName() + ".host");
        hostHeaders.put("Bundle-NativeCode", "nativeCode1.txt; selection-filter=\"(library.match=1)\",*");
        File hostBundleFile = SystemBundleTests.createBundle(config, (String)hostHeaders.get("Bundle-SymbolicName"), hostHeaders, Collections.singletonMap("nativeCode1.txt", "nativeCode1.txt"));
        this.doTestNativeCode(config, "1", "nativeCode1.txt", hostBundleFile, new File[0]);
    }

    @Test
    public void testMultipleBundleNativeHostWithFragmentsOneMatch() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> hostHeaders = new HashMap<String, String>();
        hostHeaders.put("Bundle-ManifestVersion", "2");
        hostHeaders.put("Bundle-SymbolicName", this.getName() + ".host");
        hostHeaders.put("Bundle-NativeCode", "nativeCode1.txt; selection-filter=\"(library.match=1)\",nativeCode2.txt; selection-filter=\"(library.match=2)\",nativeCode3.txt; selection-filter=\"(library.match=3)\",*");
        File hostBundleFile = SystemBundleTests.createBundle(config, (String)hostHeaders.get("Bundle-SymbolicName"), hostHeaders, Collections.singletonMap("nativeCode1.txt", "nativeCode1.txt"), Collections.singletonMap("nativeCode2.txt", "nativeCode2.txt"), Collections.singletonMap("nativeCode3.txt", "nativeCode3.txt"));
        HashMap<String, String> frag1Headers = new HashMap<String, String>();
        frag1Headers.put("Bundle-ManifestVersion", "2");
        frag1Headers.put("Bundle-SymbolicName", this.getName() + ".frag1");
        frag1Headers.put("Fragment-Host", this.getName() + ".host");
        frag1Headers.put("Bundle-NativeCode", "nativeCode4.txt; selection-filter=\"(library.match=4)\",nativeCode5.txt; selection-filter=\"(library.match=5)\",nativeCode6.txt; selection-filter=\"(library.match=6)\",*");
        File frag1BundleFile = SystemBundleTests.createBundle(config, (String)frag1Headers.get("Bundle-SymbolicName"), frag1Headers, Collections.singletonMap("nativeCode4.txt", "nativeCode4.txt"), Collections.singletonMap("nativeCode5.txt", "nativeCode5.txt"), Collections.singletonMap("nativeCode6.txt", "nativeCode6.txt"));
        this.doTestNativeCode(config, "1", "nativeCode1.txt", hostBundleFile, frag1BundleFile);
        this.doTestNativeCode(config, "2", "nativeCode2.txt", hostBundleFile, frag1BundleFile);
        this.doTestNativeCode(config, "3", "nativeCode3.txt", hostBundleFile, frag1BundleFile);
        this.doTestNativeCode(config, "4", "nativeCode4.txt", hostBundleFile, frag1BundleFile);
        this.doTestNativeCode(config, "5", "nativeCode5.txt", hostBundleFile, frag1BundleFile);
        this.doTestNativeCode(config, "6", "nativeCode6.txt", hostBundleFile, frag1BundleFile);
    }

    @Test
    public void testSingleBundleNativeHostWithFragmentsOneMatch() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> hostHeaders = new HashMap<String, String>();
        hostHeaders.put("Bundle-ManifestVersion", "2");
        hostHeaders.put("Bundle-SymbolicName", this.getName() + ".host");
        hostHeaders.put("Bundle-NativeCode", "nativeCode1.txt; selection-filter=\"(library.match=1)\",*");
        File hostBundleFile = SystemBundleTests.createBundle(config, (String)hostHeaders.get("Bundle-SymbolicName"), hostHeaders, Collections.singletonMap("nativeCode1.txt", "nativeCode1.txt"));
        HashMap<String, String> frag1Headers = new HashMap<String, String>();
        frag1Headers.put("Bundle-ManifestVersion", "2");
        frag1Headers.put("Bundle-SymbolicName", this.getName() + ".frag1");
        frag1Headers.put("Fragment-Host", this.getName() + ".host");
        frag1Headers.put("Bundle-NativeCode", "nativeCode4.txt; selection-filter=\"(library.match=4)\",*");
        File frag1BundleFile = SystemBundleTests.createBundle(config, (String)frag1Headers.get("Bundle-SymbolicName"), frag1Headers, Collections.singletonMap("nativeCode4.txt", "nativeCode4.txt"));
        this.doTestNativeCode(config, "1", "nativeCode1.txt", hostBundleFile, frag1BundleFile);
        this.doTestNativeCode(config, "4", "nativeCode4.txt", hostBundleFile, frag1BundleFile);
    }

    @Test
    public void testMultipleBundleNativeHostWithFragmentsMultipleMatch() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> hostHeaders = new HashMap<String, String>();
        hostHeaders.put("Bundle-ManifestVersion", "2");
        hostHeaders.put("Bundle-SymbolicName", this.getName() + ".host");
        hostHeaders.put("Bundle-NativeCode", "nativeCode1.txt; selection-filter=\"(library.match=1)\",nativeCode2.txt; selection-filter=\"(library.match=2)\",nativeCode3.txt; selection-filter=\"(library.match=3)\",*");
        File hostBundleFile = SystemBundleTests.createBundle(config, (String)hostHeaders.get("Bundle-SymbolicName"), hostHeaders, Collections.singletonMap("nativeCode1.txt", "nativeCode1.txt"), Collections.singletonMap("nativeCode2.txt", "nativeCode2.txt"), Collections.singletonMap("nativeCode3.txt", "nativeCode3.txt"));
        HashMap<String, String> frag1Headers = new HashMap<String, String>();
        frag1Headers.put("Bundle-ManifestVersion", "2");
        frag1Headers.put("Bundle-SymbolicName", this.getName() + ".frag1");
        frag1Headers.put("Fragment-Host", this.getName() + ".host");
        frag1Headers.put("Bundle-NativeCode", "nativeCode4.txt; selection-filter=\"(library.match=1)\",nativeCode5.txt; selection-filter=\"(library.match=2)\",nativeCode6.txt; selection-filter=\"(library.match=3)\",*");
        File frag1BundleFile = SystemBundleTests.createBundle(config, (String)frag1Headers.get("Bundle-SymbolicName"), frag1Headers, Collections.singletonMap("nativeCode4.txt", "nativeCode4.txt"), Collections.singletonMap("nativeCode5.txt", "nativeCode5.txt"), Collections.singletonMap("nativeCode6.txt", "nativeCode6.txt"));
        this.doTestNativeCode(config, "1", "nativeCode1.txt", hostBundleFile, frag1BundleFile);
        this.doTestNativeCode(config, "2", "nativeCode2.txt", hostBundleFile, frag1BundleFile);
        this.doTestNativeCode(config, "3", "nativeCode3.txt", hostBundleFile, frag1BundleFile);
        this.doTestNativeCode(config, "1", "nativeCode4.txt", hostBundleFile, frag1BundleFile);
        this.doTestNativeCode(config, "2", "nativeCode5.txt", hostBundleFile, frag1BundleFile);
        this.doTestNativeCode(config, "3", "nativeCode6.txt", hostBundleFile, frag1BundleFile);
    }

    @Test
    public void testSingleBundleNativeHostWithFragmentsMultipleMatch() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> hostHeaders = new HashMap<String, String>();
        hostHeaders.put("Bundle-ManifestVersion", "2");
        hostHeaders.put("Bundle-SymbolicName", this.getName() + ".host");
        hostHeaders.put("Bundle-NativeCode", "nativeCode1.txt; selection-filter=\"(library.match=1)\",*");
        File hostBundleFile = SystemBundleTests.createBundle(config, (String)hostHeaders.get("Bundle-SymbolicName"), hostHeaders, Collections.singletonMap("nativeCode1.txt", "nativeCode1.txt"));
        HashMap<String, String> frag1Headers = new HashMap<String, String>();
        frag1Headers.put("Bundle-ManifestVersion", "2");
        frag1Headers.put("Bundle-SymbolicName", this.getName() + ".frag1");
        frag1Headers.put("Fragment-Host", this.getName() + ".host");
        frag1Headers.put("Bundle-NativeCode", "nativeCode4.txt; selection-filter=\"(library.match=1)\",*");
        File frag1BundleFile = SystemBundleTests.createBundle(config, (String)frag1Headers.get("Bundle-SymbolicName"), frag1Headers, Collections.singletonMap("nativeCode4.txt", "nativeCode4.txt"));
        this.doTestNativeCode(config, "1", "nativeCode1.txt", hostBundleFile, frag1BundleFile);
        this.doTestNativeCode(config, "1", "nativeCode4.txt", hostBundleFile, frag1BundleFile);
    }

    private void doTestNativeCode(File config, String libraryMatchValue, String nativeCodeName, File hostBundleFile, File ... fragmentBundleFiles) throws Exception {
        HashMap<String, String> fwkConfig = new HashMap<String, String>();
        fwkConfig.put("org.osgi.framework.storage", config.getAbsolutePath());
        fwkConfig.put("org.osgi.framework.storage.clean", "onFirstInit");
        fwkConfig.put("library.match", libraryMatchValue);
        Equinox equinox = new Equinox(fwkConfig);
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            File[] fileArray = fragmentBundleFiles;
            int n = fragmentBundleFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File fragmentBundleFile = fileArray[n2];
                systemContext.installBundle(fragmentBundleFile.toURI().toString());
                ++n2;
            }
            Bundle host = systemContext.installBundle(hostBundleFile.toURI().toString());
            host.start();
            ClassLoader cl = ((BundleWiring)host.adapt(BundleWiring.class)).getClassLoader();
            Method findLibrary = this.findDeclaredMethod(cl.getClass(), "findLibrary", String.class);
            findLibrary.setAccessible(true);
            String libraryPath = (String)findLibrary.invoke((Object)cl, nativeCodeName);
            Assert.assertNotNull((String)("No library found: " + nativeCodeName), (Object)libraryPath);
            Assert.assertTrue((String)("Wrong library found: " + libraryPath), (boolean)libraryPath.endsWith(nativeCodeName));
        }
        finally {
            BundleNativeCodeTests.stopQuietly((Framework)equinox);
        }
    }

    private Method findDeclaredMethod(Class<?> clazz, String method, Class ... args) throws NoSuchMethodException {
        while (true) {
            try {
                return clazz.getDeclaredMethod(method, args);
            }
            catch (NoSuchMethodException e) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw new NoSuchMethodException(method);
            }
            break;
        }
    }
}

