/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.BundleInstaller;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class BundleResourceTests {
    private BundleInstaller installer;

    @Before
    public void setUp() throws Exception {
        this.installer = new BundleInstaller("test_files/resourcetests/bundles", OSGiTestsActivator.getContext());
    }

    @After
    public void tearDown() throws Exception {
        this.installer.shutdown();
    }

    @Test
    public void testBug320546_01() throws Exception {
        Bundle bundle = this.installer.installBundle("test");
        URL result = bundle.getEntry("../../../../security");
        Assert.assertNull((String)"Found resource!", (Object)result);
        result = bundle.getEntry("../file.txt");
        Assert.assertNull((String)"Found resource!", (Object)result);
        result = bundle.getEntry("../../");
        Assert.assertNull((String)"Found resource!", (Object)result);
        result = bundle.getEntry("folder/../../file.txt");
        Assert.assertNull((String)"Found resource!", (Object)result);
        result = bundle.getEntry("folder/../plugin.xml");
        Assert.assertNotNull((String)"Did not find resource!", (Object)result);
        result = bundle.getEntry("/plugin.xml");
        Assert.assertNotNull((String)"Did not find resource!", (Object)result);
    }

    @Test
    public void testBug320546_02() throws Exception {
        Bundle bundle = this.installer.installBundle("test");
        Enumeration paths = bundle.getEntryPaths("../");
        Assert.assertNull((String)"found resource!", (Object)paths);
        paths = bundle.getEntryPaths("folder");
        Assert.assertNotNull((String)"Did not find resource!", (Object)paths);
        paths = bundle.getEntryPaths("folder/../../");
        Assert.assertNull((String)"found resource!", (Object)paths);
        paths = bundle.getEntryPaths("folder/..");
        Assert.assertNotNull((String)"Did not find resource!", (Object)paths);
    }

    @Test
    public void testBreakOutDirBundle() throws Exception {
        Bundle bundle = this.installer.installBundle("test");
        URL result = bundle.getEntry("../testout/file.txt");
        Assert.assertNull((String)"Found resource!", (Object)result);
    }

    @Test
    public void testBug395274() throws Exception {
        ServiceReference infoRef = OSGiTestsActivator.getContext().getServiceReference(EnvironmentInfo.class);
        EnvironmentInfo info = (EnvironmentInfo)OSGiTestsActivator.getContext().getService(infoRef);
        String original = info.setProperty("osgi.strictBundleEntryPath", "true");
        try {
            Bundle bundle = this.installer.installBundle("test");
            URL path = bundle.getEntry("META-INF./MANIFEST.MF");
            Assert.assertNull((String)"found resource!", (Object)path);
            path = bundle.getEntry("META-INF/MANIFEST.MF");
            Assert.assertNotNull((String)"Did not find resource!", (Object)path);
            path = bundle.getEntry("folder/file1.TXT");
            Assert.assertNull((String)"found resource!", (Object)path);
            path = bundle.getEntry("folder/file1.txt");
            Assert.assertNotNull((String)"Did not find resource!", (Object)path);
            this.checkEntries(bundle, "/./file1.txt", 1);
            this.checkEntries(bundle, "//file1.txt", 1);
            this.checkEntries(bundle, "/", 1);
            this.checkEntries(bundle, "/.", 1);
        }
        finally {
            info.setProperty("osgi.strictBundleEntryPath", original);
            OSGiTestsActivator.getContext().ungetService(infoRef);
        }
    }

    @Test
    public void testBug328795() throws BundleException {
        Bundle bundle = this.installer.installBundle("test");
        this.checkEntries(bundle, "notFound\\", 0);
        this.checkEntries(bundle, "notFound\\\\", 0);
        this.checkEntries(bundle, "notFound(", 0);
        this.checkEntries(bundle, "notFound\\(", 0);
        this.checkEntries(bundle, "notFound)", 0);
        this.checkEntries(bundle, "notFound\\)", 0);
        this.checkEntries(bundle, "notFound*", 0);
        this.checkEntries(bundle, "notFound\\*", 0);
        this.checkEntries(bundle, "paren(.txt", 1);
        this.checkEntries(bundle, "paren\\(.txt", 1);
        this.checkEntries(bundle, "paren\\\\(.txt", 0);
        this.checkEntries(bundle, "paren).txt", 1);
        this.checkEntries(bundle, "paren\\).txt", 1);
        this.checkEntries(bundle, "paren\\\\).txt", 0);
        this.checkEntries(bundle, "paren(", 1);
        this.checkEntries(bundle, "paren\\(", 1);
        this.checkEntries(bundle, "paren\\\\(", 0);
        this.checkEntries(bundle, "paren)", 1);
        this.checkEntries(bundle, "paren\\)", 1);
        this.checkEntries(bundle, "paren\\\\)", 0);
        this.checkEntries(bundle, "paren*", 4);
        this.checkEntries(bundle, "paren*.txt", 2);
        this.checkEntries(bundle, "paren\\*", 0);
        this.checkEntries(bundle, "paren\\\\*", 0);
        this.checkEntries(bundle, "p*r*n*", 4);
        this.checkEntries(bundle, "p*r*n*.txt", 2);
        this.checkEntries(bundle, "*)*", 2);
        this.checkEntries(bundle, "*(*", 2);
        this.checkEntries(bundle, "*\\)*", 2);
        this.checkEntries(bundle, "*\\(*", 2);
    }

    @Test
    public void testBug338081() throws BundleException {
        Bundle bundle = this.installer.installBundle("test");
        Enumeration entries = bundle.findEntries("", "file1.txt", false);
        Assert.assertNotNull((String)"An entry should have been found", (Object)entries);
        Assert.assertTrue((String)"An entry should have been found", (boolean)entries.hasMoreElements());
        Assert.assertTrue((String)"Wrong entry found", (((URL)entries.nextElement()).toString().indexOf("file1.txt") > -1 ? 1 : 0) != 0);
        Assert.assertFalse((String)"Only one entry should have been found", (boolean)entries.hasMoreElements());
    }

    private void checkEntries(Bundle bundle, String filePattern, int expectedNumber) {
        Enumeration entries = bundle.findEntries("folder", filePattern, false);
        if (expectedNumber == 0) {
            Assert.assertNull((String)"Expected nothing here.", (Object)entries);
            return;
        }
        int i = 0;
        while (entries.hasMoreElements()) {
            entries.nextElement();
            ++i;
        }
        Assert.assertEquals((String)"Unexpected number of entries", (long)expectedNumber, (long)i);
    }
}

