/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.FrameworkWiring;

public class CascadeConfigTests
extends AbstractBundleTests {
    @Test
    public void testCascadeConfigBundleInstall() throws Exception {
        File configParent = OSGiTestsActivator.getContext().getDataFile(this.getName() + "_parent");
        HashMap<String, String> parentMap = new HashMap<String, String>();
        parentMap.put("org.osgi.framework.storage", configParent.getAbsolutePath());
        Equinox equinox = new Equinox(parentMap);
        equinox.init();
        BundleContext systemContext = equinox.getBundleContext();
        systemContext.installBundle(installer.getBundleLocation("test"));
        CascadeConfigTests.stopQuietly((Framework)equinox);
        File configChild = OSGiTestsActivator.getContext().getDataFile(this.getName() + "_child");
        HashMap<String, String> childMap = new HashMap<String, String>();
        childMap.put("org.osgi.framework.storage", configChild.getAbsolutePath());
        childMap.put("osgi.sharedConfiguration.area", configParent.getCanonicalPath());
        equinox = new Equinox(childMap);
        equinox.init();
        systemContext = equinox.getBundleContext();
        Bundle test1 = systemContext.getBundle(installer.getBundleLocation("test"));
        Assert.assertNotNull((String)"Missing bundle.", (Object)test1);
        systemContext.installBundle(installer.getBundleLocation("test2"));
        CascadeConfigTests.stop((Framework)equinox);
        equinox = new Equinox(childMap);
        equinox.init();
        systemContext = equinox.getBundleContext();
        test1 = systemContext.getBundle(installer.getBundleLocation("test"));
        Assert.assertNotNull((String)"Missing bundle.", (Object)test1);
        Bundle test2 = systemContext.getBundle(installer.getBundleLocation("test2"));
        Assert.assertNotNull((String)"Missing bundle.", (Object)test2);
        CascadeConfigTests.stop((Framework)equinox);
        equinox = new Equinox(parentMap);
        equinox.init();
        systemContext = equinox.getBundleContext();
        test1 = systemContext.getBundle(installer.getBundleLocation("test"));
        Assert.assertNotNull((String)"Missing bundle.", (Object)test1);
        test2 = systemContext.getBundle(installer.getBundleLocation("test2"));
        Assert.assertNull((String)"Unexpected bundle.", (Object)test2);
        CascadeConfigTests.stop((Framework)equinox);
    }

    @Test
    public void testCascadeConfigDataArea() throws Exception {
        File configParent = OSGiTestsActivator.getContext().getDataFile(this.getName() + "_parent");
        HashMap<String, String> parentMap = new HashMap<String, String>();
        parentMap.put("org.osgi.framework.storage", configParent.getAbsolutePath());
        Equinox equinox = new Equinox(parentMap);
        equinox.init();
        BundleContext systemContext = equinox.getBundleContext();
        Bundle b = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        ((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Collections.singletonList(b));
        CascadeConfigTests.stop((Framework)equinox);
        File configChild = OSGiTestsActivator.getContext().getDataFile(this.getName() + "_child");
        HashMap<String, String> childMap = new HashMap<String, String>();
        childMap.put("org.osgi.framework.storage", configChild.getAbsolutePath());
        childMap.put("osgi.sharedConfiguration.area", configParent.getCanonicalPath());
        equinox = new Equinox(childMap);
        equinox.init();
        systemContext = equinox.getBundleContext();
        b = systemContext.getBundle(installer.getBundleLocation("substitutes.a"));
        Assert.assertNotNull((String)"Missing bundle.", (Object)b);
        equinox.start();
        b.start();
        BundleContext test1Context = b.getBundleContext();
        File dataFile = test1Context.getDataFile("test1");
        Assert.assertTrue((boolean)dataFile.getAbsolutePath().startsWith(configChild.getAbsolutePath()));
        CascadeConfigTests.stop((Framework)equinox);
        equinox = new Equinox(parentMap);
        equinox.start();
        systemContext = equinox.getBundleContext();
        b = systemContext.getBundle(installer.getBundleLocation("substitutes.a"));
        Assert.assertNotNull((String)"Missing bundle.", (Object)b);
        Assert.assertEquals((String)"Bundle is not resolved.", (long)4L, (long)b.getState());
        b.start();
        test1Context = b.getBundleContext();
        dataFile = test1Context.getDataFile("test1");
        Assert.assertTrue((boolean)dataFile.getAbsolutePath().startsWith(configParent.getAbsolutePath()));
        CascadeConfigTests.stop((Framework)equinox);
    }

    @Test
    public void testCascadeConfigIni() throws Exception {
        File configParent = OSGiTestsActivator.getContext().getDataFile(this.getName() + "_parent");
        configParent.mkdirs();
        File parentConfigIni = new File(configParent, "config.ini");
        Properties parentProps = new Properties();
        parentProps.put("parent.key", "parent");
        parentProps.put("parent.child.key", "parent");
        parentProps.store(new FileOutputStream(parentConfigIni), "Parent config.ini");
        File configChild = OSGiTestsActivator.getContext().getDataFile(this.getName() + "_child");
        configChild.mkdirs();
        File childConfigIni = new File(configChild, "config.ini");
        Properties childProps = new Properties();
        childProps.put("parent.child.key", "child");
        childProps.put("child.key", "child");
        childProps.store(new FileOutputStream(childConfigIni), "Parent config.ini");
        HashMap<String, String> childMap = new HashMap<String, String>();
        childMap.put("org.osgi.framework.storage", configChild.getAbsolutePath());
        childMap.put("osgi.sharedConfiguration.area", configParent.getCanonicalPath());
        Equinox equinox = new Equinox(childMap);
        equinox.init();
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertEquals((String)"Wrong value for parent.key", (Object)"parent", (Object)systemContext.getProperty("parent.key"));
        Assert.assertEquals((String)"Wrong value for parent.child.key", (Object)"child", (Object)systemContext.getProperty("parent.child.key"));
        Assert.assertEquals((String)"Wrong value for child.key", (Object)"child", (Object)systemContext.getProperty("child.key"));
        CascadeConfigTests.stop((Framework)equinox);
    }
}

