/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import junit.framework.AssertionFailedError;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.storage.StorageUtil;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.BundleInstallUpdateTests;
import org.eclipse.osgi.tests.bundles.ITestRunner;
import org.eclipse.osgi.tests.bundles.SystemBundleTests;
import org.eclipse.osgi.tests.bundles.classes.ExternalClassPathActivator;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class ClassLoadingBundleTests
extends AbstractBundleTests {
    @Test
    public void testSimple() throws Exception {
        Bundle test = installer.installBundle("test");
        test.start();
        installer.shutdown();
        Object[] expectedEvents = new Object[]{new BundleEvent(1, test), new BundleEvent(32, test), new BundleEvent(2, test), new BundleEvent(4, test), new BundleEvent(64, test), new BundleEvent(16, test)};
        Object[] actualEvents = listenerResults.getResults(expectedEvents.length);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    @Test
    public void testLoadTriggerClass() throws Exception {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        installer.installBundle("chain.test.b");
        installer.installBundle("chain.test.c");
        installer.installBundle("chain.test.d");
        Assert.assertTrue((String)"Did not resolve chainTest", (boolean)installer.resolveBundles(new Bundle[]{chainTest}));
        chainTest.start(2);
        chainTestA.start(2);
        Assert.assertEquals((String)"Wrong state", (long)8L, (long)chainTest.getState());
        chainTest.loadClass("org.osgi.framework.BundleActivator");
        Assert.assertEquals((String)"Wrong state", (long)8L, (long)chainTest.getState());
        Assert.assertEquals((String)"Wrong state", (long)8L, (long)chainTestA.getState());
        chainTest.loadClass("chain.test.a.AChain");
        Assert.assertEquals((String)"Wrong state", (long)8L, (long)chainTest.getState());
        Assert.assertEquals((String)"Wrong state", (long)32L, (long)chainTestA.getState());
    }

    @Test
    public void testChainDepedencies() throws Exception {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        installer.installBundle("chain.test.c");
        installer.installBundle("chain.test.d");
        ((ITestRunner)chainTest.loadClass("chain.test.TestSingleChain").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).testIt();
        Object[] expectedEvents = new Object[]{new BundleEvent(2, chainTestB), new BundleEvent(2, chainTestA), new BundleEvent(4, chainTestA), new BundleEvent(4, chainTestB), new BundleEvent(2, chainTestB), new BundleEvent(2, chainTestA)};
        installer.refreshPackages(new Bundle[]{chainTestB});
        ((ITestRunner)chainTest.loadClass("chain.test.TestSingleChain").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).testIt();
        Object[] actualEvents = simpleResults.getResults(6);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    @Test
    public void testMultiChainDepedencies01() throws Exception {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        chainTest.loadClass("chain.test.TestMultiChain").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Object[] expectedEvents = new Object[]{new BundleEvent(2, chainTestD), new BundleEvent(2, chainTestB), new BundleEvent(2, chainTestC), new BundleEvent(2, chainTestA), new BundleEvent(4, chainTestA), new BundleEvent(4, chainTestB), new BundleEvent(4, chainTestC), new BundleEvent(4, chainTestD)};
        installer.refreshPackages(new Bundle[]{chainTestC, chainTestD});
        Object[] actualEvents = simpleResults.getResults(8);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        chainTest.loadClass("chain.test.TestMultiChain").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        expectedEvents = new Object[]{new BundleEvent(2, chainTestD), new BundleEvent(2, chainTestB), new BundleEvent(2, chainTestC), new BundleEvent(2, chainTestA)};
        actualEvents = simpleResults.getResults(4);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    @Test
    public void testMultiChainDepedencies02() throws Exception {
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        syncListenerResults.getResults(0);
        installer.resolveBundles(new Bundle[]{chainTestA, chainTestB, chainTestC, chainTestD});
        Object[] expectedEvents = new Object[]{new BundleEvent(32, chainTestD), new BundleEvent(32, chainTestC), new BundleEvent(32, chainTestB), new BundleEvent(32, chainTestA), new BundleEvent(512, chainTestD), new BundleEvent(512, chainTestC), new BundleEvent(512, chainTestB), new BundleEvent(512, chainTestA)};
        Object[] actualEvents = syncListenerResults.getResults(8);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        installer.refreshPackages(new Bundle[]{chainTestC, chainTestD});
        expectedEvents = new Object[]{new BundleEvent(256, chainTestA), new BundleEvent(4, chainTestA), new BundleEvent(256, chainTestB), new BundleEvent(4, chainTestB), new BundleEvent(256, chainTestC), new BundleEvent(4, chainTestC), new BundleEvent(256, chainTestD), new BundleEvent(4, chainTestD), new BundleEvent(64, chainTestA), new BundleEvent(64, chainTestB), new BundleEvent(64, chainTestC), new BundleEvent(64, chainTestD), new BundleEvent(32, chainTestD), new BundleEvent(32, chainTestC), new BundleEvent(32, chainTestB), new BundleEvent(32, chainTestA), new BundleEvent(512, chainTestD), new BundleEvent(512, chainTestC), new BundleEvent(512, chainTestB), new BundleEvent(512, chainTestA)};
        actualEvents = syncListenerResults.getResults(12);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    @Test
    public void testBug300692_01() throws BundleException {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        syncListenerResults.getResults(0);
        StartLevel sl = installer.getStartLevel();
        int currentSL = sl.getStartLevel();
        int testSL = currentSL + 1;
        sl.setBundleStartLevel(chainTest, testSL);
        sl.setBundleStartLevel(chainTestA, testSL);
        sl.setBundleStartLevel(chainTestB, testSL);
        sl.setBundleStartLevel(chainTestC, testSL);
        sl.setBundleStartLevel(chainTestD, testSL);
        installer.resolveBundles(new Bundle[]{chainTest, chainTestA, chainTestB, chainTestC, chainTestD});
        Object[] expectedEvents = new Object[]{new BundleEvent(32, chainTestD), new BundleEvent(32, chainTestC), new BundleEvent(32, chainTestB), new BundleEvent(32, chainTestA), new BundleEvent(32, chainTest)};
        Object[] actualEvents = syncListenerResults.getResults(5);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        try {
            System.setProperty("test.bug300692", "true");
            chainTest.start();
            sl.setStartLevel(testSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            expectedEvents = new Object[14];
            int i = 0;
            expectedEvents[i++] = new BundleEvent(512, chainTestA);
            expectedEvents[i++] = new BundleEvent(512, chainTestB);
            expectedEvents[i++] = new BundleEvent(512, chainTestC);
            expectedEvents[i++] = new BundleEvent(512, chainTestD);
            expectedEvents[i++] = new BundleEvent(128, chainTest);
            expectedEvents[i++] = new BundleEvent(128, chainTestD);
            expectedEvents[i++] = new BundleEvent(2, chainTestD);
            expectedEvents[i++] = new BundleEvent(128, chainTestB);
            expectedEvents[i++] = new BundleEvent(2, chainTestB);
            expectedEvents[i++] = new BundleEvent(128, chainTestC);
            expectedEvents[i++] = new BundleEvent(2, chainTestC);
            expectedEvents[i++] = new BundleEvent(128, chainTestA);
            expectedEvents[i++] = new BundleEvent(2, chainTestA);
            expectedEvents[i++] = new BundleEvent(2, chainTest);
            actualFrameworkEvents = syncListenerResults.getResults(14);
            ClassLoadingBundleTests.compareResults(expectedEvents, actualFrameworkEvents);
        }
        catch (Throwable throwable) {
            System.getProperties().remove("test.bug300692");
            sl.setStartLevel(currentSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            throw throwable;
        }
        System.getProperties().remove("test.bug300692");
        sl.setStartLevel(currentSL);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
    }

    @Test
    public void testBug300692_02() throws BundleException {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        syncListenerResults.getResults(0);
        StartLevel sl = installer.getStartLevel();
        int currentSL = sl.getStartLevel();
        int testSL = currentSL + 1;
        sl.setBundleStartLevel(chainTest, testSL);
        sl.setBundleStartLevel(chainTestA, testSL);
        sl.setBundleStartLevel(chainTestB, testSL);
        sl.setBundleStartLevel(chainTestC, testSL);
        sl.setBundleStartLevel(chainTestD, testSL);
        installer.resolveBundles(new Bundle[]{chainTest, chainTestA, chainTestB, chainTestC, chainTestD});
        Object[] expectedEvents = new Object[]{new BundleEvent(32, chainTestD), new BundleEvent(32, chainTestC), new BundleEvent(32, chainTestB), new BundleEvent(32, chainTestA), new BundleEvent(32, chainTest)};
        Object[] actualEvents = syncListenerResults.getResults(5);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        try {
            System.setProperty("test.bug300692", "true");
            System.setProperty("test.bug300692.listener", "true");
            chainTest.start();
            sl.setStartLevel(testSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            expectedEvents = new Object[14];
            int i = 0;
            expectedEvents[i++] = new BundleEvent(512, chainTestA);
            expectedEvents[i++] = new BundleEvent(512, chainTestB);
            expectedEvents[i++] = new BundleEvent(512, chainTestC);
            expectedEvents[i++] = new BundleEvent(512, chainTestD);
            expectedEvents[i++] = new BundleEvent(128, chainTest);
            expectedEvents[i++] = new BundleEvent(128, chainTestD);
            expectedEvents[i++] = new BundleEvent(2, chainTestD);
            expectedEvents[i++] = new BundleEvent(128, chainTestB);
            expectedEvents[i++] = new BundleEvent(2, chainTestB);
            expectedEvents[i++] = new BundleEvent(128, chainTestC);
            expectedEvents[i++] = new BundleEvent(2, chainTestC);
            expectedEvents[i++] = new BundleEvent(128, chainTestA);
            expectedEvents[i++] = new BundleEvent(2, chainTestA);
            expectedEvents[i++] = new BundleEvent(2, chainTest);
            actualFrameworkEvents = syncListenerResults.getResults(14);
            ClassLoadingBundleTests.compareResults(expectedEvents, actualFrameworkEvents);
        }
        catch (Throwable throwable) {
            System.getProperties().remove("test.bug300692");
            System.getProperties().remove("test.bug300692.listener");
            sl.setStartLevel(currentSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            throw throwable;
        }
        System.getProperties().remove("test.bug300692");
        System.getProperties().remove("test.bug300692.listener");
        sl.setStartLevel(currentSL);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
    }

    @Test
    public void testBug408629() throws BundleException {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        syncListenerResults.getResults(0);
        StartLevel sl = installer.getStartLevel();
        int currentSL = sl.getStartLevel();
        int testSL = currentSL + 1;
        sl.setBundleStartLevel(chainTest, testSL);
        sl.setBundleStartLevel(chainTestA, testSL);
        sl.setBundleStartLevel(chainTestB, testSL);
        sl.setBundleStartLevel(chainTestC, testSL);
        sl.setBundleStartLevel(chainTestD, testSL);
        installer.resolveBundles(new Bundle[]{chainTest, chainTestA, chainTestB, chainTestC, chainTestD});
        chainTestD.start();
        Object[] expectedEvents1 = new Object[]{new BundleEvent(32, chainTestD), new BundleEvent(32, chainTestC), new BundleEvent(32, chainTestB), new BundleEvent(32, chainTestA), new BundleEvent(32, chainTest)};
        Object[] actualEvents = syncListenerResults.getResults(5);
        ClassLoadingBundleTests.compareResults(expectedEvents1, actualEvents);
        try {
            System.setProperty("test.bug300692", "true");
            System.setProperty("test.bug300692.listener", "true");
            chainTest.start();
            sl.setStartLevel(testSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            expectedEvents1 = new Object[14];
            Object[] expectedEvents2 = new Object[14];
            int i1 = 0;
            int i2 = 0;
            expectedEvents1[i1++] = new BundleEvent(512, chainTestA);
            expectedEvents2[i2++] = new BundleEvent(512, chainTestA);
            expectedEvents1[i1++] = new BundleEvent(512, chainTestB);
            expectedEvents2[i2++] = new BundleEvent(512, chainTestB);
            expectedEvents1[i1++] = new BundleEvent(512, chainTestC);
            expectedEvents2[i2++] = new BundleEvent(512, chainTestC);
            expectedEvents1[i1++] = new BundleEvent(128, chainTest);
            expectedEvents2[i2++] = new BundleEvent(128, chainTest);
            expectedEvents1[i1++] = new BundleEvent(512, chainTestD);
            expectedEvents1[i1++] = new BundleEvent(128, chainTestB);
            expectedEvents2[i2++] = new BundleEvent(128, chainTestB);
            expectedEvents1[i1++] = new BundleEvent(2, chainTestB);
            expectedEvents2[i2++] = new BundleEvent(2, chainTestB);
            expectedEvents2[i2++] = new BundleEvent(512, chainTestD);
            expectedEvents1[i1++] = new BundleEvent(128, chainTestD);
            expectedEvents2[i2++] = new BundleEvent(128, chainTestD);
            expectedEvents1[i1++] = new BundleEvent(2, chainTestD);
            expectedEvents2[i2++] = new BundleEvent(2, chainTestD);
            expectedEvents1[i1++] = new BundleEvent(128, chainTestC);
            expectedEvents2[i2++] = new BundleEvent(128, chainTestC);
            expectedEvents1[i1++] = new BundleEvent(2, chainTestC);
            expectedEvents2[i2++] = new BundleEvent(2, chainTestC);
            expectedEvents1[i1++] = new BundleEvent(128, chainTestA);
            expectedEvents2[i2++] = new BundleEvent(128, chainTestA);
            expectedEvents1[i1++] = new BundleEvent(2, chainTestA);
            expectedEvents2[i2++] = new BundleEvent(2, chainTestA);
            expectedEvents1[i1++] = new BundleEvent(2, chainTest);
            expectedEvents2[i2++] = new BundleEvent(2, chainTest);
            actualFrameworkEvents = syncListenerResults.getResults(14);
            try {
                ClassLoadingBundleTests.compareResults(expectedEvents1, actualFrameworkEvents);
            }
            catch (AssertionFailedError e) {
                ClassLoadingBundleTests.compareResults(expectedEvents2, actualFrameworkEvents);
            }
        }
        catch (Throwable throwable) {
            System.getProperties().remove("test.bug300692");
            System.getProperties().remove("test.bug300692.listener");
            sl.setStartLevel(currentSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            throw throwable;
        }
        System.getProperties().remove("test.bug300692");
        System.getProperties().remove("test.bug300692.listener");
        sl.setStartLevel(currentSL);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
    }

    @Test
    public void testClassCircularityError() throws Exception {
        Bundle circularityTest = installer.installBundle("circularity.test");
        Bundle circularityTestA = installer.installBundle("circularity.test.a");
        circularityTest.loadClass("circularity.test.TestCircularity");
        Object[] expectedEvents = new Object[]{new BundleEvent(2, circularityTest), new BundleEvent(2, circularityTestA)};
        Object[] actualEvents = simpleResults.getResults(2);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    @Test
    public void testFragmentPackageAccess() throws Exception {
        Bundle hostA = installer.installBundle("fragment.test.attach.host.a");
        Bundle fragA = installer.installBundle("fragment.test.attach.frag.a");
        Assert.assertTrue((String)"Host/Frag resolve", (boolean)installer.resolveBundles(new Bundle[]{hostA, fragA}));
        ITestRunner testRunner = (ITestRunner)hostA.loadClass("fragment.test.attach.host.a.internal.test.TestPackageAccess").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        testRunner.testIt();
    }

    @Test
    public void testFragmentMultiHost() throws Exception {
        Bundle hostA1 = installer.installBundle("fragment.test.attach.host.a");
        Bundle hostA2 = installer.installBundle("fragment.test.attach.host.a.v2");
        Bundle fragA = installer.installBundle("fragment.test.attach.frag.a");
        Assert.assertTrue((String)"Host/Frag resolve", (boolean)installer.resolveBundles(new Bundle[]{hostA1, hostA2, fragA}));
        Assert.assertEquals((String)"Wrong number of hosts", (long)2L, (long)installer.getPackageAdmin().getHosts(fragA).length);
        this.runTestRunner(hostA1, "fragment.test.attach.host.a.internal.test.TestPackageAccess");
        this.runTestRunner(hostA2, "fragment.test.attach.host.a.internal.test.TestPackageAccess2");
    }

    private void runTestRunner(Bundle host, String classname) throws Exception {
        ITestRunner testRunner = (ITestRunner)host.loadClass(classname).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        testRunner.testIt();
    }

    @Test
    public void testFragmentExportPackage() throws Exception {
        Bundle hostA = installer.installBundle("fragment.test.attach.host.a");
        Assert.assertTrue((String)"Host resolve", (boolean)installer.resolveBundles(new Bundle[]{hostA}));
        hostA.loadClass("fragment.test.attach.host.a.internal.test.PackageAccessTest");
        Bundle fragB = installer.installBundle("fragment.test.attach.frag.b");
        Bundle hostARequire = installer.installBundle("fragment.test.attach.host.a.require");
        Assert.assertTrue((String)"RequireA/Frag", (boolean)installer.resolveBundles(new Bundle[]{hostARequire, fragB}));
        hostARequire.loadClass("fragment.test.attach.frag.b.Test");
    }

    @Test
    public void testLegacyLazyStart() throws Exception {
        Bundle legacy = installer.installBundle("legacy.lazystart");
        Bundle legacyA = installer.installBundle("legacy.lazystart.a");
        Bundle legacyB = installer.installBundle("legacy.lazystart.b");
        Bundle legacyC = installer.installBundle("legacy.lazystart.c");
        Assert.assertTrue((String)"legacy lazy start resolve", (boolean)installer.resolveBundles(new Bundle[]{legacy, legacyA, legacyB, legacyC}));
        ((ITestRunner)legacy.loadClass("legacy.lazystart.SimpleLegacy").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).testIt();
        Object[] expectedEvents = new Object[]{new BundleEvent(2, legacyA)};
        Object[] actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        ((ITestRunner)legacy.loadClass("legacy.lazystart.TrueExceptionLegacy1").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).testIt();
        Assert.assertTrue((String)"exceptions no event", (simpleResults.getResults(0).length == 0 ? 1 : 0) != 0);
        ((ITestRunner)legacy.loadClass("legacy.lazystart.TrueExceptionLegacy2").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).testIt();
        expectedEvents = new Object[]{new BundleEvent(2, legacyB)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        ((ITestRunner)legacy.loadClass("legacy.lazystart.FalseExceptionLegacy1").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).testIt();
        Assert.assertTrue((String)"exceptions no event", (simpleResults.getResults(0).length == 0 ? 1 : 0) != 0);
        ((ITestRunner)legacy.loadClass("legacy.lazystart.FalseExceptionLegacy2").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).testIt();
        expectedEvents = new Object[]{new BundleEvent(2, legacyC)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    @Test
    public void testLegacyLoadActivation() throws Exception {
        Bundle test = installer.installBundle("test");
        Assert.assertThrows(ClassNotFoundException.class, () -> {
            Class clazz = test.loadClass("does.not.exist.Test");
        });
        Object[] expectedEvents = new Object[]{};
        Object[] actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        Bundle legacyA = installer.installBundle("legacy.lazystart.a");
        Assert.assertThrows(ClassNotFoundException.class, () -> {
            Class clazz = legacyA.loadClass("does.not.exist.Test");
        });
        expectedEvents = new Object[]{};
        actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        Assert.assertEquals((String)"Wrong state for lazy bundle.", (long)8L, (long)legacyA.getState());
    }

    @Test
    public void testOSGiLazyStart() throws Exception {
        Bundle osgi = installer.installBundle("osgi.lazystart");
        Bundle osgiA = installer.installBundle("osgi.lazystart.a");
        Bundle osgiB = installer.installBundle("osgi.lazystart.b");
        Bundle osgiC = installer.installBundle("osgi.lazystart.c");
        Assert.assertTrue((String)"osgi lazy start resolve", (boolean)installer.resolveBundles(new Bundle[]{osgi, osgiA, osgiB, osgiC}));
        ((ITestRunner)osgi.loadClass("osgi.lazystart.LazySimple").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).testIt();
        Object[] expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        Object[] actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        ((ITestRunner)osgi.loadClass("osgi.lazystart.LazyExclude1").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).testIt();
        Assert.assertTrue((String)"exceptions no event", (simpleResults.getResults(0).length == 0 ? 1 : 0) != 0);
        ((ITestRunner)osgi.loadClass("osgi.lazystart.LazyExclude2").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).testIt();
        expectedEvents = new Object[]{new BundleEvent(2, osgiB)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        ((ITestRunner)osgi.loadClass("osgi.lazystart.LazyInclude1").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).testIt();
        Assert.assertTrue((String)"exceptions no event", (simpleResults.getResults(0).length == 0 ? 1 : 0) != 0);
        ((ITestRunner)osgi.loadClass("osgi.lazystart.LazyInclude2").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).testIt();
        expectedEvents = new Object[]{new BundleEvent(2, osgiC)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    @Test
    public void testOSGiLazyStartDelay() throws Exception {
        Bundle osgiD = installer.installBundle("osgi.lazystart.d");
        Bundle osgiE = installer.installBundle("osgi.lazystart.e");
        Assert.assertTrue((String)"osgi lazy start resolve", (boolean)installer.resolveBundles(new Bundle[]{osgiD, osgiE}));
        Thread t = new Thread(() -> {
            try {
                osgiD.loadClass("osgi.lazystart.d.DTest");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }, "Starting: " + String.valueOf(osgiD));
        t.start();
        Thread.sleep(100L);
        long startTime = System.currentTimeMillis();
        osgiE.start();
        long endTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)("Starting of test bundle was too short: " + endTime), (endTime > 3000L ? 1 : 0) != 0);
    }

    @Test
    public void testStartTransientByLoadClass() throws Exception {
        Bundle osgiA = installer.installBundle("osgi.lazystart.a");
        installer.resolveBundles(new Bundle[]{osgiA});
        StartLevel startLevel = installer.getStartLevel();
        startLevel.setBundleStartLevel(osgiA, startLevel.getStartLevel() + 10);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        Object[] expectedEvents = new Object[]{};
        Object[] actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        osgiA.loadClass("osgi.lazystart.a.ATest");
        expectedEvents = new Object[]{};
        actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(4, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        osgiA.loadClass("osgi.lazystart.a.ATest");
        expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(4, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    @Test
    public void testStartTransient() throws Exception {
        Bundle osgiA = installer.installBundle("osgi.lazystart.a");
        installer.resolveBundles(new Bundle[]{osgiA});
        StartLevel startLevel = installer.getStartLevel();
        startLevel.setBundleStartLevel(osgiA, startLevel.getStartLevel() + 10);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        Object[] expectedEvents = new Object[]{};
        Object[] actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        try {
            osgiA.start(1);
            Assert.assertFalse((String)"Bundle is started!!", (osgiA.getState() == 32 ? 1 : 0) != 0);
        }
        catch (BundleException e) {
            Assert.assertEquals((String)"Expected invalid operation", (long)10L, (long)e.getType());
        }
        expectedEvents = new Object[]{};
        actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{};
        actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        osgiA.start(1);
        expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(4, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    @Test
    public void testStartResolve() throws Exception {
        Bundle test = installer.installBundle("test");
        StartLevel startLevel = installer.getStartLevel();
        startLevel.setBundleStartLevel(test, startLevel.getStartLevel() + 10);
        test.start();
        Assert.assertEquals((String)"Wrong state", (long)2L, (long)test.getState());
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        Assert.assertEquals((String)"Wrong state", (long)32L, (long)test.getState());
    }

    @Test
    public void testStopTransient() throws Exception {
        Bundle osgiA = installer.installBundle("osgi.lazystart.a");
        installer.resolveBundles(new Bundle[]{osgiA});
        StartLevel startLevel = installer.getStartLevel();
        startLevel.setBundleStartLevel(osgiA, startLevel.getStartLevel() + 10);
        osgiA.start();
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        Object[] expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        Object[] actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(4, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        osgiA.stop(1);
        expectedEvents = new Object[]{new BundleEvent(4, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(4, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    @Test
    public void testBug258659_01() throws Exception {
        Bundle osgiA = installer.installBundle("osgi.lazystart.a");
        SynchronousBundleListener testLoadClassListener = event -> {
            if (event.getType() == 512) {
                try {
                    event.getBundle().loadClass("osgi.lazystart.a.ATest");
                }
                catch (ClassNotFoundException e) {
                    simpleResults.addEvent(e);
                }
            }
        };
        OSGiTestsActivator.getContext().addBundleListener((BundleListener)testLoadClassListener);
        try {
            osgiA.start(2);
            Object[] expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
            Object[] actualEvents = simpleResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        }
        finally {
            OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testLoadClassListener);
        }
    }

    @Test
    public void testBug258659_02() throws Exception {
        Bundle osgiA = installer.installBundle("osgi.lazystart.a");
        osgiA.start(2);
        SynchronousBundleListener testLoadClassListener = event -> {
            if (event.getType() == 512) {
                try {
                    event.getBundle().loadClass("osgi.lazystart.a.ATest");
                }
                catch (ClassNotFoundException e) {
                    simpleResults.addEvent(e);
                }
            }
        };
        OSGiTestsActivator.getContext().addBundleListener((BundleListener)testLoadClassListener);
        try {
            installer.refreshPackages(new Bundle[]{osgiA});
            Object[] expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
            Object[] actualEvents = simpleResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        }
        finally {
            OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testLoadClassListener);
        }
    }

    @Test
    public void testBug258659_03() throws Exception {
        Bundle test = installer.installBundle("test");
        SynchronousBundleListener testLoadClassListener = event -> {
            if (event.getType() == 2) {
                try {
                    event.getBundle().stop();
                }
                catch (BundleException e) {
                    simpleResults.addEvent((Object)e);
                }
            }
        };
        OSGiTestsActivator.getContext().addBundleListener((BundleListener)testLoadClassListener);
        try {
            test.start();
            Object[] expectedEvents = new Object[]{new BundleEvent(2, test), new BundleEvent(4, test)};
            Object[] actualEvents = simpleResults.getResults(2);
            ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        }
        finally {
            OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testLoadClassListener);
        }
    }

    @Test
    public void testBug258659_04() throws Exception {
        Bundle test = installer.installBundle("test");
        test.start();
        SynchronousBundleListener testLoadClassListener = event -> {
            if (event.getType() == 2) {
                try {
                    event.getBundle().stop();
                }
                catch (BundleException e) {
                    simpleResults.addEvent((Object)e);
                }
            }
        };
        simpleResults.getResults(0);
        OSGiTestsActivator.getContext().addBundleListener((BundleListener)testLoadClassListener);
        try {
            installer.refreshPackages(new Bundle[]{test});
            Object[] expectedEvents = new Object[]{new BundleEvent(4, test), new BundleEvent(2, test), new BundleEvent(4, test)};
            Object[] actualEvents = simpleResults.getResults(3);
            ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        }
        finally {
            OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testLoadClassListener);
        }
    }

    @Test
    public void testBug213791() throws Exception {
        Bundle osgiA = installer.installBundle("osgi.lazystart.a");
        installer.resolveBundles(new Bundle[]{osgiA});
        if (osgiA.getState() == 8) {
            osgiA.stop();
        }
        osgiA.start(2);
        Object[] expectedEvents = new Object[]{};
        Object[] actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        osgiA.start(2);
        expectedEvents = new Object[]{};
        actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        osgiA.loadClass("osgi.lazystart.a.ATest");
        expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    @Test
    public void testThreadLock() throws Exception {
        Bundle threadLockTest = installer.installBundle("thread.locktest");
        threadLockTest.loadClass("thread.locktest.ATest");
        Object[] expectedEvents = new Object[]{5000L, new BundleEvent(2, threadLockTest)};
        Object[] actualEvents = simpleResults.getResults(2);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    @Test
    public void testURLsBug164077() throws Exception {
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        URL[] urls = new URL[]{test.getResource("a/b/c/d"), test.getEntry("a/b/c/d")};
        Assert.assertNotNull((String)"resource", (Object)urls[0]);
        Assert.assertNotNull((String)"entry", (Object)urls[1]);
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            URL testURL = new URL(url, "g");
            Assert.assertEquals((String)"g", (Object)"/a/b/c/g", (Object)testURL.getPath());
            testURL = new URL(url, "./g");
            Assert.assertEquals((String)"./g", (Object)"/a/b/c/g", (Object)testURL.getPath());
            testURL = new URL(url, "g/");
            Assert.assertEquals((String)"g/", (Object)"/a/b/c/g/", (Object)testURL.getPath());
            testURL = new URL(url, "/g");
            Assert.assertEquals((String)"/g", (Object)"/g", (Object)testURL.getPath());
            testURL = new URL(url, "?y");
            Assert.assertEquals((String)"?y", (Object)"/a/b/c/?y", (Object)testURL.getPath());
            testURL = new URL(url, "g?y");
            Assert.assertEquals((String)"g?y", (Object)"/a/b/c/g?y", (Object)testURL.getPath());
            testURL = new URL(url, "g#s");
            Assert.assertEquals((String)"g#s", (Object)"/a/b/c/g#s", (Object)(testURL.getPath() + "#s"));
            testURL = new URL(url, "g?y#s");
            Assert.assertEquals((String)"g?y#s", (Object)"/a/b/c/g?y#s", (Object)(testURL.getPath() + "#s"));
            testURL = new URL(url, ";x");
            Assert.assertEquals((String)";x", (Object)"/a/b/c/;x", (Object)testURL.getPath());
            testURL = new URL(url, "g;x");
            Assert.assertEquals((String)"g;x", (Object)"/a/b/c/g;x", (Object)testURL.getPath());
            testURL = new URL(url, "g;x?y#s");
            Assert.assertEquals((String)"g;x?y#s", (Object)"/a/b/c/g;x?y#s", (Object)(testURL.getPath() + "#s"));
            testURL = new URL(url, ".");
            Assert.assertEquals((String)".", (Object)"/a/b/c/", (Object)testURL.getPath());
            testURL = new URL(url, "./");
            Assert.assertEquals((String)"./", (Object)"/a/b/c/", (Object)testURL.getPath());
            testURL = new URL(url, "..");
            Assert.assertEquals((String)"..", (Object)"/a/b/", (Object)testURL.getPath());
            testURL = new URL(url, "../");
            Assert.assertEquals((String)"../", (Object)"/a/b/", (Object)testURL.getPath());
            testURL = new URL(url, "../g");
            Assert.assertEquals((String)"../g", (Object)"/a/b/g", (Object)testURL.getPath());
            testURL = new URL(url, "../..");
            Assert.assertEquals((String)"../..", (Object)"/a/", (Object)testURL.getPath());
            testURL = new URL(url, "../../");
            Assert.assertEquals((String)"../../", (Object)"/a/", (Object)testURL.getPath());
            testURL = new URL(url, "../../g");
            Assert.assertEquals((String)"../../g", (Object)"/a/g", (Object)testURL.getPath());
            ++n2;
        }
    }

    @Test
    public void testEntryURLEqualsHashCode() throws Exception {
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        URL testEntry1 = test.getEntry("a/b/c/d");
        URL testEntry2 = test.getEntry("a/b/c/d");
        Assert.assertEquals((String)"url equals 1.0", (Object)testEntry1, (Object)testEntry2);
        Assert.assertEquals((String)"hashcode equals 1.1", (long)testEntry1.hashCode(), (long)testEntry2.hashCode());
        URL testEntry3 = new URL(testEntry1, "./d");
        Assert.assertEquals((String)"url equals 2.0", (Object)testEntry1, (Object)testEntry3);
        Assert.assertEquals((String)"hashcode equals 2.1", (long)testEntry1.hashCode(), (long)testEntry3.hashCode());
        URL testEntry4 = new URL(testEntry3.toString());
        Assert.assertEquals((String)"url equals 3.0", (Object)testEntry4, (Object)testEntry3);
        Assert.assertEquals((String)"hashcode equals 3.1", (long)testEntry4.hashCode(), (long)testEntry3.hashCode());
    }

    @Test
    public void testResourceURLEqualsHashCode() throws Exception {
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        URL testResource1 = test.getResource("a/b/c/d");
        URL testResource2 = test.getResource("a/b/c/d");
        Assert.assertEquals((String)"url equals 1.0", (Object)testResource1, (Object)testResource2);
        Assert.assertEquals((String)"hashcode equals 1.1", (long)testResource1.hashCode(), (long)testResource2.hashCode());
        URL testResource3 = new URL(testResource1, "./d");
        Assert.assertEquals((String)"url equals 2.0", (Object)testResource1, (Object)testResource3);
        Assert.assertEquals((String)"hashcode equals 2.1", (long)testResource1.hashCode(), (long)testResource3.hashCode());
        URL testResource4 = new URL(testResource3.toString());
        Assert.assertEquals((String)"url equals 3.0", (Object)testResource4, (Object)testResource3);
        Assert.assertEquals((String)"hashcode equals 3.1", (long)testResource4.hashCode(), (long)testResource3.hashCode());
    }

    @Test
    public void testGetEntryDir01() throws BundleException {
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        URL aDir = test.getEntry("a");
        Assert.assertNotNull((String)"aDir", (Object)aDir);
        Assert.assertTrue((String)aDir.toExternalForm(), (boolean)aDir.getFile().endsWith("/"));
        URL bDir = test.getEntry("a/b");
        Assert.assertNotNull((String)"bDir", (Object)bDir);
        Assert.assertTrue((String)bDir.toExternalForm(), (boolean)bDir.getFile().endsWith("/"));
        aDir = test.getEntry("a/");
        Assert.assertNotNull((String)"aDir", (Object)aDir);
        Assert.assertTrue((String)aDir.toExternalForm(), (boolean)aDir.getFile().endsWith("/"));
        bDir = test.getEntry("a/b/");
        Assert.assertNotNull((String)"bDir", (Object)bDir);
        Assert.assertTrue((String)bDir.toExternalForm(), (boolean)bDir.getFile().endsWith("/"));
        URL dResource = test.getEntry("a/b/c/d");
        Assert.assertNotNull((String)"dResource", (Object)dResource);
        Assert.assertFalse((String)dResource.toExternalForm(), (boolean)dResource.getFile().endsWith("/"));
        dResource = test.getEntry("a/b/c/d/");
        if (dResource != null) {
            Assert.assertFalse((String)dResource.toExternalForm(), (boolean)dResource.getFile().endsWith("/"));
        }
    }

    @Test
    public void testGetResourceDir01() throws BundleException {
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        URL aDir = test.getResource("a");
        Assert.assertNotNull((String)"aDir", (Object)aDir);
        Assert.assertTrue((String)aDir.toExternalForm(), (boolean)aDir.getFile().endsWith("/"));
        URL bDir = test.getResource("a/b");
        Assert.assertNotNull((String)"bDir", (Object)bDir);
        Assert.assertTrue((String)bDir.toExternalForm(), (boolean)bDir.getFile().endsWith("/"));
        aDir = test.getResource("a/");
        Assert.assertNotNull((String)"aDir", (Object)aDir);
        Assert.assertTrue((String)aDir.toExternalForm(), (boolean)aDir.getFile().endsWith("/"));
        bDir = test.getResource("a/b/");
        Assert.assertNotNull((String)"bDir", (Object)bDir);
        Assert.assertTrue((String)bDir.toExternalForm(), (boolean)bDir.getFile().endsWith("/"));
        URL dResource = test.getResource("a/b/c/d");
        Assert.assertNotNull((String)"dResource", (Object)dResource);
        Assert.assertFalse((String)dResource.toExternalForm(), (boolean)dResource.getFile().endsWith("/"));
        dResource = test.getResource("a/b/c/d/");
        if (dResource != null) {
            Assert.assertFalse((String)dResource.toExternalForm(), (boolean)dResource.getFile().endsWith("/"));
        }
    }

    @Test
    public void testBootGetResources01() throws Exception {
        if (System.getProperty("org.osgi.framework.bootdelegation") != null) {
            return;
        }
        Bundle test = installer.installBundle("test");
        Enumeration manifests = test.getResources("META-INF/MANIFEST.MF");
        Assert.assertNotNull((String)"manifests", (Object)manifests);
        ArrayList manifestURLs = Collections.list(manifests);
        Assert.assertEquals((String)"manifest number", (long)1L, (long)manifestURLs.size());
        URL manifest = (URL)manifestURLs.get(0);
        int dotIndex = manifest.getHost().indexOf(46);
        long bundleId = dotIndex >= 0 && dotIndex < manifest.getHost().length() - 1 ? Long.parseLong(manifest.getHost().substring(0, dotIndex)) : Long.parseLong(manifest.getHost());
        Assert.assertEquals((String)"host id", (long)test.getBundleId(), (long)bundleId);
    }

    @Test
    public void testBootGetResources02() throws Exception {
        if (System.getProperty("org.osgi.framework.bootdelegation") != null) {
            return;
        }
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        BundleWiring wiring = (BundleWiring)test.adapt(BundleWiring.class);
        ClassLoader bcl = wiring.getClassLoader();
        URLClassLoader cl = new URLClassLoader(new URL[0], bcl);
        Enumeration<URL> manifests = cl.getResources("META-INF/MANIFEST.MF");
        Assert.assertNotNull((String)"manifests", manifests);
        ArrayList<URL> manifestURLs = Collections.list(manifests);
        Assert.assertEquals((String)"manifest number", (long)1L, (long)manifestURLs.size());
        URL manifest = (URL)manifestURLs.get(0);
        Assert.assertEquals((String)"wrong protocol", (Object)"bundleresource", (Object)manifest.getProtocol());
        int dotIndex = manifest.getHost().indexOf(46);
        long bundleId = dotIndex >= 0 && dotIndex < manifest.getHost().length() - 1 ? Long.parseLong(manifest.getHost().substring(0, dotIndex)) : Long.parseLong(manifest.getHost());
        Assert.assertEquals((String)"host id", (long)test.getBundleId(), (long)bundleId);
        cl.close();
    }

    @Test
    public void testMultipleGetResources01() throws Exception {
        Bundle test = installer.installBundle("test");
        Enumeration resources = test.getResources("data/resource1");
        Assert.assertNotNull((String)"resources", (Object)resources);
        ArrayList resourceURLs = Collections.list(resources);
        Assert.assertEquals((String)"resource number", (long)2L, (long)resourceURLs.size());
        Assert.assertEquals((String)"root resource", (Object)"root classpath", (Object)this.readURL((URL)resourceURLs.get(0)));
        Assert.assertEquals((String)"stuff resource", (Object)"stuff classpath", (Object)this.readURL((URL)resourceURLs.get(1)));
    }

    @Test
    public void testMultipleGetResources01a() throws Exception {
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        BundleWiring wiring = (BundleWiring)test.adapt(BundleWiring.class);
        ClassLoader bcl = wiring.getClassLoader();
        URLClassLoader cl = new URLClassLoader(new URL[0], bcl);
        Enumeration<URL> resources = cl.getResources("data/resource1");
        Assert.assertNotNull((String)"resources", resources);
        ArrayList<URL> resourceURLs = Collections.list(resources);
        Assert.assertEquals((String)"resource number", (long)2L, (long)resourceURLs.size());
        Assert.assertEquals((String)"root resource", (Object)"root classpath", (Object)this.readURL((URL)resourceURLs.get(0)));
        Assert.assertEquals((String)"stuff resource", (Object)"stuff classpath", (Object)this.readURL((URL)resourceURLs.get(1)));
        cl.close();
    }

    @Test
    public void testMultipleGetResources02() throws Exception {
        installer.installBundle("test");
        Bundle test2 = installer.installBundle("test2");
        Enumeration resources = test2.getResources("data/resource1");
        Assert.assertNotNull((String)"resources", (Object)resources);
        ArrayList resourceURLs = Collections.list(resources);
        Assert.assertEquals((String)"resource number", (long)4L, (long)resourceURLs.size());
        Assert.assertEquals((String)"root resource", (Object)"root classpath", (Object)this.readURL((URL)resourceURLs.get(0)));
        Assert.assertEquals((String)"stuff resource", (Object)"stuff classpath", (Object)this.readURL((URL)resourceURLs.get(1)));
        Assert.assertEquals((String)"root resource", (Object)"root classpath test2", (Object)this.readURL((URL)resourceURLs.get(2)));
        Assert.assertEquals((String)"stuff resource", (Object)"stuff classpath test2", (Object)this.readURL((URL)resourceURLs.get(3)));
    }

    @Test
    public void testMultipleGetResources03() throws Exception {
        installer.installBundle("test");
        Bundle test2 = installer.installBundle("test2");
        Enumeration resources = test2.getResources("data/");
        Assert.assertNotNull((String)"resources", (Object)resources);
        ArrayList resourceURLs = Collections.list(resources);
        Assert.assertEquals((String)"resource number", (long)4L, (long)resourceURLs.size());
        Assert.assertEquals((String)"root resource", (Object)"root classpath", (Object)this.readURL(new URL((URL)resourceURLs.get(0), "resource1")));
        Assert.assertEquals((String)"stuff resource", (Object)"stuff classpath", (Object)this.readURL(new URL((URL)resourceURLs.get(1), "resource1")));
        Assert.assertEquals((String)"root resource", (Object)"root classpath test2", (Object)this.readURL(new URL((URL)resourceURLs.get(2), "resource1")));
        Assert.assertEquals((String)"stuff resource", (Object)"stuff classpath test2", (Object)this.readURL(new URL((URL)resourceURLs.get(3), "resource1")));
    }

    @Test
    public void testListResources() throws BundleException {
        installer.installBundle("test");
        Bundle test2 = installer.installBundle("test2");
        Assert.assertTrue((String)"Could not resolve test2 bundle", (boolean)installer.resolveBundles(new Bundle[]{test2}));
        BundleWiring test2Wiring = (BundleWiring)test2.adapt(BundleWiring.class);
        Collection resources = test2Wiring.listResources("/", "*", 0);
        Assert.assertTrue((String)"could not find resource", (boolean)resources.contains("resource2"));
        resources = test2Wiring.listResources("data/", "resource2", 0);
        Assert.assertTrue((String)"could not find resource", (boolean)resources.contains("data/resource2"));
        resources = test2Wiring.listResources("/", "resource*", 1);
        Assert.assertTrue((String)"could not find resource", (boolean)resources.contains("data/resource2"));
    }

    @Test
    public void testURLExternalFormat01() throws Exception {
        Bundle test = installer.installBundle("test");
        URL entry = test.getEntry("data/resource1");
        Assert.assertNotNull((String)"entry", (Object)entry);
        Assert.assertEquals((String)"root resource", (Object)"root classpath", (Object)this.readURL(entry));
        URL entryCopy = new URL(entry.toExternalForm());
        Assert.assertEquals((String)"external format", (Object)entry.toExternalForm(), (Object)entryCopy.toExternalForm());
        Assert.assertEquals((String)"root resource", (Object)"root classpath", (Object)this.readURL(entryCopy));
    }

    @Test
    public void testURLExternalFormat02() throws Exception {
        Bundle test = installer.installBundle("test");
        URL entry = test.getResource("data/resource1");
        Assert.assertNotNull((String)"entry", (Object)entry);
        Assert.assertEquals((String)"root resource", (Object)"root classpath", (Object)this.readURL(entry));
        URL entryCopy = new URL(entry.toExternalForm());
        Assert.assertEquals((String)"external format", (Object)entry.toExternalForm(), (Object)entryCopy.toExternalForm());
        Assert.assertEquals((String)"root resource", (Object)"root classpath", (Object)this.readURL(entryCopy));
    }

    @Test
    public void testURLExternalFormat03() throws Exception {
        Bundle test = installer.installBundle("test");
        URL entry = test.getEntry("data/resource1");
        Assert.assertNotNull((String)"entry", (Object)entry);
        URI uri1 = new URI(entry.getProtocol(), null, entry.getHost(), entry.getPort(), entry.getPath(), null, entry.getQuery());
        URI uri2 = new URI(entry.getProtocol(), entry.getHost(), entry.getPath(), entry.getQuery());
        URI uri3 = new URI(entry.toExternalForm());
        URL url1 = uri1.toURL();
        URL url2 = uri2.toURL();
        URL url3 = uri3.toURL();
        URL url4 = new URL(uri1.toString());
        this.checkURL("root classpath", entry, url1);
        this.checkURL("root classpath", entry, url2);
        this.checkURL("root classpath", entry, url3);
        this.checkURL("root classpath", entry, url4);
    }

    @Test
    public void testURLExternalFormat04() throws Exception {
        Bundle test = installer.installBundle("test");
        URL entry = test.getResource("data/resource1");
        Assert.assertNotNull((String)"entry", (Object)entry);
        URI uri1 = new URI(entry.getProtocol(), null, entry.getHost(), entry.getPort(), entry.getPath(), null, entry.getQuery());
        URI uri2 = new URI(entry.getProtocol(), entry.getHost(), entry.getPath(), entry.getQuery());
        URI uri3 = new URI(entry.toExternalForm());
        URL url1 = uri1.toURL();
        URL url2 = uri2.toURL();
        URL url3 = uri3.toURL();
        URL url4 = new URL(uri1.toString());
        this.checkURL("root classpath", entry, url1);
        this.checkURL("root classpath", entry, url2);
        this.checkURL("root classpath", entry, url3);
        this.checkURL("root classpath", entry, url4);
    }

    private void checkURL(String content, URL orig, URL copy) throws Exception {
        Assert.assertEquals((String)"external format", (Object)orig.toExternalForm(), (Object)copy.toExternalForm());
        Assert.assertEquals((String)content, (Object)content, (Object)this.readURL(copy));
    }

    @Test
    public void testURI() throws URISyntaxException {
        new URI("bundleentry", "1", "/test", null);
    }

    @Test
    public void testMultipleExportFragments01() throws Exception {
        Bundle host = installer.installBundle("host.multiple.exports");
        Bundle frag = installer.installBundle("frag.multiple.exports");
        installer.resolveBundles(new Bundle[]{host, frag});
        PackageAdmin packageAdmin = installer.getPackageAdmin();
        ExportedPackage[] hostExports = packageAdmin.getExportedPackages(host);
        Assert.assertEquals((String)"Number host exports", (long)4L, (long)(hostExports == null ? 0 : hostExports.length));
        BundleWiring hostWiring = (BundleWiring)host.adapt(BundleWiring.class);
        Assert.assertNotNull((String)"No host wiring", (Object)hostWiring);
        List packageCapabilities = hostWiring.getCapabilities("osgi.wiring.package");
        Assert.assertEquals((String)"Number host export capabilities", (long)4L, (long)packageCapabilities.size());
        Assert.assertEquals((String)"Check export name", (Object)"host.multiple.exports", ((BundleCapability)packageCapabilities.get(0)).getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Check include directive", (Object)"Public*", ((BundleCapability)packageCapabilities.get(0)).getDirectives().get("include"));
        Assert.assertEquals((String)"Check export name", (Object)"host.multiple.exports.onlyone", ((BundleCapability)packageCapabilities.get(1)).getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Check export name", (Object)"host.multiple.exports", ((BundleCapability)packageCapabilities.get(2)).getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Check scope attribute", (Object)"private", ((BundleCapability)packageCapabilities.get(2)).getAttributes().get("scope"));
        Assert.assertEquals((String)"Check export name", (Object)"host.multiple.exports.onlyone", ((BundleCapability)packageCapabilities.get(3)).getAttributes().get("osgi.wiring.package"));
    }

    @Test
    public void testMultipleExportFragments02() throws Exception {
        Bundle host = installer.installBundle("host.multiple.exports");
        Bundle frag = installer.installBundle("frag.multiple.exports");
        Bundle client1 = installer.installBundle("client1.multiple.exports");
        installer.resolveBundles(new Bundle[]{host, frag, client1});
        client1.start();
        client1.stop();
        Object[] expectedEvents = new Object[]{"host.multiple.exports.PublicClass1", "host.multiple.exports.PublicClass2", "success", "success"};
        Object[] actualEvents = simpleResults.getResults(4);
        Assert.assertArrayEquals((Object[])expectedEvents, (Object[])actualEvents);
    }

    @Test
    public void testMultipleExportFragments03() throws Exception {
        Bundle host = installer.installBundle("host.multiple.exports");
        Bundle frag = installer.installBundle("frag.multiple.exports");
        Bundle client2 = installer.installBundle("client2.multiple.exports");
        installer.resolveBundles(new Bundle[]{host, frag, client2});
        client2.start();
        client2.stop();
        Object[] expectedEvents = new Object[]{"host.multiple.exports.PublicClass1", "host.multiple.exports.PublicClass2", "host.multiple.exports.PrivateClass1", "host.multiple.exports.PrivateClass2"};
        Object[] actualEvents = simpleResults.getResults(4);
        Assert.assertArrayEquals((Object[])expectedEvents, (Object[])actualEvents);
    }

    @Test
    @Ignore
    public void testXFriends() throws Exception {
        Bundle test1 = installer.installBundle("xfriends.test1");
        Bundle test2 = installer.installBundle("xfriends.test2");
        Bundle test3 = installer.installBundle("xfriends.test3");
        installer.resolveBundles(new Bundle[]{test1, test2, test3});
        test2.start();
        test2.stop();
        test3.start();
        test3.stop();
        Object[] expectedEvents = new Object[]{"xfriends.test1.onlyforfriends.TestFriends", "xfriends.test1.external.TestFriends", "success", "xfriends.test1.external.TestFriends"};
        Object[] actualEvents = simpleResults.getResults(4);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    @Test
    public void testImporterExporter01() throws BundleException {
        Bundle importerExporter1 = installer.installBundle("exporter.importer1");
        installer.resolveBundles(new Bundle[]{importerExporter1});
        PackageAdmin pa = installer.getPackageAdmin();
        ExportedPackage[] origExportedPackages = pa.getExportedPackages("exporter.importer.test");
        Assert.assertNotNull((String)"No exporter.importer.test found", (Object)origExportedPackages);
        Assert.assertEquals((String)"Wrong number of exports", (long)1L, (long)origExportedPackages.length);
        Bundle exporter = origExportedPackages[0].getExportingBundle();
        Assert.assertEquals((String)"Wrong exporter", (Object)importerExporter1, (Object)exporter);
        Bundle[] origImporters = origExportedPackages[0].getImportingBundles();
        Assert.assertTrue((String)"Should have no importers", (origImporters == null || origImporters.length == 0 ? 1 : 0) != 0);
        Bundle importerExporter2 = installer.installBundle("exporter.importer2");
        installer.resolveBundles(new Bundle[]{importerExporter2});
        origImporters = origExportedPackages[0].getImportingBundles();
        Assert.assertNotNull((String)"No importers found", (Object)origImporters);
        Assert.assertEquals((String)"Wrong number of importers", (long)1L, (long)origImporters.length);
        Assert.assertEquals((String)"Wrong importer", (Object)importerExporter2, (Object)origImporters[0]);
        ExportedPackage[] newExportedPackages = pa.getExportedPackages("exporter.importer.test");
        Assert.assertNotNull((String)"No exporter.importer.test found", (Object)newExportedPackages);
        Assert.assertEquals((String)"Wrong number of exports", (long)1L, (long)newExportedPackages.length);
        exporter = newExportedPackages[0].getExportingBundle();
        Assert.assertEquals((String)"Wrong exporter", (Object)importerExporter1, (Object)exporter);
        Bundle[] newImporters = newExportedPackages[0].getImportingBundles();
        Assert.assertNotNull((String)"No importers found", (Object)newImporters);
        Assert.assertEquals((String)"Wrong number of importers", (long)1L, (long)newImporters.length);
        Assert.assertEquals((String)"Wrong importer", (Object)importerExporter2, (Object)newImporters[0]);
    }

    @Test
    public void testImporterExporter02() throws BundleException {
        Bundle importerExporter3 = installer.installBundle("exporter.importer3");
        Bundle importerExporter4 = installer.installBundle("exporter.importer4");
        installer.resolveBundles(new Bundle[]{importerExporter3, importerExporter4});
        importerExporter3.start();
        importerExporter3.stop();
        importerExporter3.update();
        importerExporter3.start();
    }

    @Test
    public void testUninstallInUse01() throws BundleException {
        if (this.getContext().getServiceReference("org.eclipse.equinox.region.RegionDigraph") != null) {
            System.out.println("Cannot test uninstall in use with RegionDigraph service");
            return;
        }
        Bundle exporter1 = installer.installBundle("exporter.importer1");
        BundleRevision iExporter1 = (BundleRevision)exporter1.adapt(BundleRevision.class);
        Bundle exporter2 = installer.installBundle("exporter.importer2");
        installer.resolveBundles(new Bundle[]{exporter1, exporter2});
        exporter1.uninstall();
        Bundle importer = installer.installBundle("exporter.importer4");
        installer.resolveBundles(new Bundle[]{importer});
        BundleWiring importerWiring = (BundleWiring)importer.adapt(BundleWiring.class);
        Assert.assertNotNull((String)"Bundle b has no wiring.", (Object)importerWiring);
        List bImports = importerWiring.getRequiredWires("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of imported packages.", (long)1L, (long)bImports.size());
        Assert.assertEquals((String)"Wrong exporter.", (Object)iExporter1, (Object)((BundleWire)bImports.get(0)).getProvider());
    }

    @Test
    public void testBug207847() throws BundleException {
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        test.start();
        Bundle frag1 = installer.installBundle("test.fragment1");
        Bundle frag2 = installer.installBundle("test.fragment2");
        Bundle frag3 = installer.installBundle("test.fragment3");
        Bundle frag4 = installer.installBundle("test.fragment4");
        Bundle frag5 = installer.installBundle("test.fragment5");
        installer.resolveBundles(new Bundle[]{frag1, frag2, frag3, frag4, frag5});
        Assert.assertTrue((String)"host is not resolved", ((test.getState() & 0x20) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"frag1 is not resolved", ((frag1.getState() & 4) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"frag2 is not resolved", ((frag2.getState() & 4) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"frag3 is not resolved", ((frag3.getState() & 4) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"frag4 is not resolved", ((frag4.getState() & 4) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"frag5 is not resolved", ((frag5.getState() & 4) != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBug235958() throws BundleException {
        Bundle testX = installer.installBundle("test.bug235958.x");
        Bundle testY = installer.installBundle("test.bug235958.y");
        installer.resolveBundles(new Bundle[]{testX, testY});
        testX.start();
    }

    @Test
    public void testBuddyClassLoadingRegistered1() throws Exception {
        Bundle registeredA = installer.installBundle("buddy.registered.a");
        installer.resolveBundles(new Bundle[]{registeredA});
        Enumeration testFiles = registeredA.getResources("resources/test.txt");
        Assert.assertNotNull((String)"testFiles", (Object)testFiles);
        ArrayList<String> texts = new ArrayList<String>();
        while (testFiles.hasMoreElements()) {
            texts.add(this.readURL((URL)testFiles.nextElement()));
        }
        Assert.assertEquals((String)"test.txt number", (long)1L, (long)texts.size());
        Assert.assertTrue((String)"buddy.registered.a", (boolean)texts.contains("buddy.registered.a"));
        Bundle registeredATest1 = installer.installBundle("buddy.registered.a.test1");
        Bundle registeredATest2 = installer.installBundle("buddy.registered.a.test2");
        installer.resolveBundles(new Bundle[]{registeredATest1, registeredATest2});
        testFiles = registeredA.getResources("resources/test.txt");
        Assert.assertNotNull((String)"testFiles", (Object)testFiles);
        texts = new ArrayList();
        while (testFiles.hasMoreElements()) {
            texts.add(this.readURL((URL)testFiles.nextElement()));
        }
        Assert.assertEquals((String)"test.txt number", (long)3L, (long)texts.size());
        Assert.assertTrue((String)"buddy.registered.a", (boolean)texts.contains("buddy.registered.a"));
        Assert.assertTrue((String)"buddy.registered.a.test1", (boolean)texts.contains("buddy.registered.a.test1"));
        Assert.assertTrue((String)"buddy.registered.a.test2", (boolean)texts.contains("buddy.registered.a.test2"));
    }

    @Test
    public void testBuddyClassLoadingRegistered2() throws Exception {
        Bundle registeredA = installer.installBundle("buddy.registered.a");
        installer.resolveBundles(new Bundle[]{registeredA});
        URL testFile = registeredA.getResource("resources/test1.txt");
        Assert.assertNull((String)"test1.txt", (Object)testFile);
        testFile = registeredA.getResource("resources/test2.txt");
        Assert.assertNull((String)"test2.txt", (Object)testFile);
        Bundle registeredATest1 = installer.installBundle("buddy.registered.a.test1");
        Bundle registeredATest2 = installer.installBundle("buddy.registered.a.test2");
        installer.resolveBundles(new Bundle[]{registeredATest1, registeredATest2});
        testFile = registeredA.getResource("resources/test1.txt");
        Assert.assertNotNull((String)"test1.txt", (Object)testFile);
        Assert.assertEquals((String)"buddy.registered.a.test1", (Object)"buddy.registered.a.test1", (Object)this.readURL(testFile));
        testFile = registeredA.getResource("resources/test2.txt");
        Assert.assertNotNull((String)"test2.txt", (Object)testFile);
        Assert.assertEquals((String)"buddy.registered.a.test2", (Object)"buddy.registered.a.test2", (Object)this.readURL(testFile));
    }

    @Test
    public void testBuddyClassLoadingRegistered3() throws Exception {
        Bundle registeredA = installer.installBundle("buddy.registered.a");
        installer.resolveBundles(new Bundle[]{registeredA});
        Assert.assertThrows(ClassNotFoundException.class, () -> {
            Class clazz = registeredA.loadClass("buddy.registered.a.test1.ATest");
        });
        Assert.assertThrows(ClassNotFoundException.class, () -> {
            Class clazz = registeredA.loadClass("buddy.registered.a.test2.ATest");
        });
        Bundle registeredATest1 = installer.installBundle("buddy.registered.a.test1");
        Bundle registeredATest2 = installer.installBundle("buddy.registered.a.test2");
        installer.resolveBundles(new Bundle[]{registeredATest1, registeredATest2});
        Assert.assertNotNull((String)"Class buddy.registered.a.test1.ATest", (Object)registeredA.loadClass("buddy.registered.a.test1.ATest"));
        Assert.assertNotNull((String)"Class buddy.registered.a.test2.ATest", (Object)registeredA.loadClass("buddy.registered.a.test2.ATest"));
    }

    @Test
    public void testBuddyClassLoadingRegisteredListResources() throws Exception {
        Bundle registeredA = installer.installBundle("buddy.registered.a");
        installer.resolveBundles(new Bundle[]{registeredA});
        Bundle registeredATest1 = installer.installBundle("buddy.registered.a.test1");
        Bundle registeredATest2 = installer.installBundle("buddy.registered.a.test2");
        installer.resolveBundles(new Bundle[]{registeredATest1, registeredATest2});
        Collection result = ((BundleWiring)registeredA.adapt(BundleWiring.class)).listResources("resources", "*", 1);
        Assert.assertEquals((String)("Wrong number of resources listed: " + String.valueOf(result)), (long)3L, (long)result.size());
        Assert.assertTrue((String)"resources/test.txt", (boolean)result.contains("resources/test.txt"));
        Assert.assertTrue((String)"resources/test1.txt", (boolean)result.contains("resources/test1.txt"));
        Assert.assertTrue((String)"resources/test2.txt", (boolean)result.contains("resources/test2.txt"));
        result = ((BundleWiring)registeredA.adapt(BundleWiring.class)).listResources("resources", "*", 3);
        Assert.assertEquals((String)("Wrong number of resources listed: " + String.valueOf(result)), (long)1L, (long)result.size());
        Assert.assertTrue((String)"resources/test.txt", (boolean)result.contains("resources/test.txt"));
        result = ((BundleWiring)registeredA.adapt(BundleWiring.class)).listResources("buddy/registered/a", "*.class", 1);
        Assert.assertEquals((String)("Wrong number of resources listed: " + String.valueOf(result)), (long)2L, (long)result.size());
        Assert.assertTrue((String)"buddy/registered/a/test1/ATest.class", (boolean)result.contains("buddy/registered/a/test1/ATest.class"));
        Assert.assertTrue((String)"buddy/registered/a/test2/ATest.class", (boolean)result.contains("buddy/registered/a/test2/ATest.class"));
        result = ((BundleWiring)registeredA.adapt(BundleWiring.class)).listResources("", this.getClass().getSimpleName() + ".class", 1);
        Assert.assertEquals((String)("Wrong number of resources listed: " + String.valueOf(result)), (long)1L, (long)result.size());
    }

    @Test
    public void testBuddyClassLoadingDependentListResources() throws Exception {
        Bundle registeredA = installer.installBundle("buddy.dependent.a");
        installer.resolveBundles(new Bundle[]{registeredA});
        Bundle registeredATest1 = installer.installBundle("buddy.dependent.a.test1");
        Bundle registeredATest2 = installer.installBundle("buddy.dependent.a.test2");
        installer.resolveBundles(new Bundle[]{registeredATest1, registeredATest2});
        Collection result = ((BundleWiring)registeredA.adapt(BundleWiring.class)).listResources("resources", "*", 1);
        Assert.assertEquals((String)("Wrong number of resources listed: " + String.valueOf(result)), (long)3L, (long)result.size());
        Assert.assertTrue((String)"resources/test.txt", (boolean)result.contains("resources/test.txt"));
        Assert.assertTrue((String)"resources/test1.txt", (boolean)result.contains("resources/test1.txt"));
        Assert.assertTrue((String)"resources/test2.txt", (boolean)result.contains("resources/test2.txt"));
        result = ((BundleWiring)registeredA.adapt(BundleWiring.class)).listResources("resources", "*", 3);
        Assert.assertEquals((String)("Wrong number of resources listed: " + String.valueOf(result)), (long)1L, (long)result.size());
        Assert.assertTrue((String)"resources/test.txt", (boolean)result.contains("resources/test.txt"));
        result = ((BundleWiring)registeredA.adapt(BundleWiring.class)).listResources("buddy/dependent/a", "*.class", 1);
        Assert.assertEquals((String)("Wrong number of resources listed: " + String.valueOf(result)), (long)2L, (long)result.size());
        Assert.assertTrue((String)"buddy/dependent/a/test1/ATest.class", (boolean)result.contains("buddy/dependent/a/test1/ATest.class"));
        Assert.assertTrue((String)"buddy/dependent/a/test2/ATest.class", (boolean)result.contains("buddy/dependent/a/test2/ATest.class"));
        result = ((BundleWiring)registeredA.adapt(BundleWiring.class)).listResources("", this.getClass().getSimpleName() + ".class", 1);
        Assert.assertEquals((String)("Wrong number of resources listed: " + String.valueOf(result)), (long)1L, (long)result.size());
    }

    @Test
    public void testBuddyClassLoadingDependent1() throws Exception {
        Bundle dependentA = installer.installBundle("buddy.dependent.a");
        installer.resolveBundles(new Bundle[]{dependentA});
        Enumeration testFiles = dependentA.getResources("resources/test.txt");
        Assert.assertNotNull((String)"testFiles", (Object)testFiles);
        ArrayList<String> texts = new ArrayList<String>();
        while (testFiles.hasMoreElements()) {
            texts.add(this.readURL((URL)testFiles.nextElement()));
        }
        Assert.assertEquals((String)"test.txt number", (long)1L, (long)texts.size());
        Assert.assertTrue((String)"buddy.dependent.a", (boolean)texts.contains("buddy.dependent.a"));
        Bundle dependentATest1 = installer.installBundle("buddy.dependent.a.test1");
        Bundle dependentATest2 = installer.installBundle("buddy.dependent.a.test2");
        installer.resolveBundles(new Bundle[]{dependentATest1, dependentATest2});
        testFiles = dependentA.getResources("resources/test.txt");
        Assert.assertNotNull((String)"testFiles", (Object)testFiles);
        texts = new ArrayList();
        while (testFiles.hasMoreElements()) {
            texts.add(this.readURL((URL)testFiles.nextElement()));
        }
        Assert.assertEquals((String)"test.txt number", (long)3L, (long)texts.size());
        Assert.assertTrue((String)"buddy.dependent.a", (boolean)texts.contains("buddy.dependent.a"));
        Assert.assertTrue((String)"buddy.dependent.a.test1", (boolean)texts.contains("buddy.dependent.a.test1"));
        Assert.assertTrue((String)"buddy.dependent.a.test2", (boolean)texts.contains("buddy.dependent.a.test2"));
    }

    @Test
    public void testBuddyClassLoadingDependent2() throws Exception {
        Bundle dependentA = installer.installBundle("buddy.dependent.a");
        installer.resolveBundles(new Bundle[]{dependentA});
        URL testFile = dependentA.getResource("resources/test1.txt");
        Assert.assertNull((String)"test1.txt", (Object)testFile);
        testFile = dependentA.getResource("resources/test2.txt");
        Assert.assertNull((String)"test2.txt", (Object)testFile);
        Bundle dependentATest1 = installer.installBundle("buddy.dependent.a.test1");
        Bundle dependentATest2 = installer.installBundle("buddy.dependent.a.test2");
        installer.resolveBundles(new Bundle[]{dependentATest1, dependentATest2});
        testFile = dependentA.getResource("resources/test1.txt");
        Assert.assertNotNull((String)"test1.txt", (Object)testFile);
        Assert.assertEquals((String)"buddy.dependent.a.test1", (Object)"buddy.dependent.a.test1", (Object)this.readURL(testFile));
        testFile = dependentA.getResource("resources/test2.txt");
        Assert.assertNotNull((String)"test2.txt", (Object)testFile);
        Assert.assertEquals((String)"buddy.dependent.a.test2", (Object)"buddy.dependent.a.test2", (Object)this.readURL(testFile));
    }

    @Test
    public void testBuddyClassLoadingDependent3() throws Exception {
        Bundle dependentA = installer.installBundle("buddy.dependent.a");
        installer.resolveBundles(new Bundle[]{dependentA});
        Assert.assertThrows(ClassNotFoundException.class, () -> {
            Class clazz = dependentA.loadClass("buddy.dependent.a.test1.ATest");
        });
        Assert.assertThrows(ClassNotFoundException.class, () -> {
            Class clazz = dependentA.loadClass("buddy.dependent.a.test2.ATest");
        });
        Bundle dependentATest1 = installer.installBundle("buddy.dependent.a.test1");
        Bundle dependentATest2 = installer.installBundle("buddy.dependent.a.test2");
        installer.resolveBundles(new Bundle[]{dependentATest1, dependentATest2});
        Assert.assertNotNull((String)"Class buddy.dependent.a.test1.ATest", (Object)dependentA.loadClass("buddy.dependent.a.test1.ATest"));
        Assert.assertNotNull((String)"Class buddy.dependent.a.test2.ATest", (Object)dependentA.loadClass("buddy.dependent.a.test2.ATest"));
    }

    @Test
    public void testBuddyClassLoadingInvalid() throws Exception {
        Bundle invalidA = installer.installBundle("buddy.invalid.a");
        installer.resolveBundles(new Bundle[]{invalidA});
        invalidA.getResource("doesNotExist");
        Assert.assertThrows(ClassNotFoundException.class, () -> {
            Class clazz = invalidA.loadClass("does.not.Exist");
        });
    }

    @Test
    public void testBuddyClassloadingBug438904() throws Exception {
        Bundle host = installer.installBundle("test.bug438904.host");
        Bundle frag = installer.installBundle("test.bug438904.frag");
        Bundle global = installer.installBundle("test.bug438904.global");
        installer.resolveBundles(new Bundle[]{host, frag, global});
        global.loadClass("test.bug438904.host.Test1");
        global.loadClass("test.bug438904.frag.Test2");
    }

    @Test
    public void testBuddyClassLoadingGlobalNotFound() throws Exception {
        Bundle global = installer.installBundle("test.bug438904.global");
        Assert.assertThrows(ClassNotFoundException.class, () -> {
            Class clazz = global.loadClass("does.not.exist.Test");
        });
        Assert.assertNull((String)"Expected null resource found.", (Object)global.getResource("does/not/exist/Test.txt"));
    }

    @Test
    public void testBuddyClassLoadingGlobalFound() throws Exception {
        Bundle global = installer.installBundle("test.bug438904.global");
        global.loadClass("org.osgi.framework.Bundle");
    }

    @Test
    public void testUnitTestForcompoundEnumerations() {
        Enumeration result = BundleLoader.compoundEnumerations(null, Collections.emptyEnumeration());
        Assert.assertNotNull((String)"Null result.", (Object)result);
        Assert.assertFalse((String)"Found elements.", (boolean)result.hasMoreElements());
        result = BundleLoader.compoundEnumerations(Collections.emptyEnumeration(), null);
        Assert.assertNotNull((String)"Null result.", (Object)result);
        Assert.assertFalse((String)"Found elements.", (boolean)result.hasMoreElements());
        result = BundleLoader.compoundEnumerations(null, null);
        Assert.assertNotNull((String)"Null result.", (Object)result);
        Assert.assertFalse((String)"Found elements.", (boolean)result.hasMoreElements());
        result = BundleLoader.compoundEnumerations(Collections.emptyEnumeration(), Collections.emptyEnumeration());
        Assert.assertNotNull((String)"Null result.", (Object)result);
        Assert.assertFalse((String)"Found elements.", (boolean)result.hasMoreElements());
    }

    @Test
    public void testBundleClassLoaderEmptyGetResources() throws Exception {
        ClassLoader bundleClassLoader = this.getClass().getClassLoader();
        String resource = "META-INF/services/test.does.note.ExistService";
        this.doTestEmptyGetResources(bundleClassLoader, "META-INF/services/test.does.note.ExistService");
    }

    private void doTestEmptyGetResources(ClassLoader testClassLoader, String resource) throws Exception {
        URL systemURL = ClassLoader.getSystemClassLoader().getResource(resource);
        Assert.assertNull((String)("Found a parent resource: " + resource), (Object)systemURL);
        URL testurl = testClassLoader.getResource(resource);
        Assert.assertNull((String)("Found a resource: " + resource), (Object)testurl);
        Enumeration<URL> testResources = testClassLoader.getResources(resource);
        Assert.assertNotNull((String)("null resources from testClassLoader: " + resource), testResources);
        Assert.assertFalse((String)"Resources has elements.", (boolean)testResources.hasMoreElements());
    }

    @Test
    public void testBundleReference01() throws Exception {
        Bundle test = installer.installBundle("test");
        Class clazz = test.loadClass("test1.Activator");
        Bundle bundle = FrameworkUtil.getBundle((Class)clazz);
        Assert.assertEquals((String)"Wrong bundle", (Object)test, (Object)bundle);
    }

    @Test
    public void testBundleReference02() throws Exception {
        Bundle test = installer.installBundle("test");
        Class clazz = test.loadClass("test1.Activator");
        ClassLoader cl = clazz.getClassLoader();
        Assert.assertTrue((String)"ClassLoader is not of type BundleReference", (boolean)(cl instanceof BundleReference));
        Assert.assertEquals((String)"Wrong bundle", (Object)test, (Object)((BundleReference)cl).getBundle());
    }

    @Test
    public void testResolveURLRelativeBundleResourceWithPort() throws Exception {
        URL directory = new URL("bundleresource://82:1/dictionaries/");
        Assert.assertEquals((long)1L, (long)directory.getPort());
        URL resource = new URL(directory, "en_GB.dictionary");
        Assert.assertEquals((long)1L, (long)resource.getPort());
    }

    @Test
    public void testManifestPackageSpec() throws BundleException {
        Bundle test = installer.installBundle("test.manifestpackage");
        test.start();
    }

    @Test
    public void testArrayTypeLoad() throws ClassNotFoundException {
        this.doTestArrayTypeLoad("[B");
        this.doTestArrayTypeLoad("[C");
        this.doTestArrayTypeLoad("[D");
        this.doTestArrayTypeLoad("[F");
        this.doTestArrayTypeLoad("[I");
        this.doTestArrayTypeLoad("[J");
        this.doTestArrayTypeLoad("[S");
        this.doTestArrayTypeLoad("[Z");
        this.doTestArrayTypeLoad("[Lorg.eclipse.osgi.tests.bundles.ArrayTest;");
        this.doTestArrayTypeLoad("[[D");
        this.doTestArrayTypeLoad("[[Lorg.eclipse.osgi.tests.bundles.ArrayTest;");
    }

    @Test
    public void testSystemBundleGetResources01() throws IOException {
        Bundle systemBundle = OSGiTestsActivator.getContext().getBundle(0L);
        Assert.assertNotNull((String)"Resources is null", (Object)systemBundle.getResources("systembundle.properties"));
    }

    @Test
    public void testSystemBundleGetResources02() throws IOException {
        Bundle systemBundle = OSGiTestsActivator.getContext().getBundle(0L);
        Assert.assertNull((String)"Resources is not null", (Object)systemBundle.getResources("java/lang/test.resource"));
    }

    @Test
    public void testBug299921() throws Exception {
        ClassLoader cl = this.getClass().getClassLoader();
        Method findMethod = BundleInstallUpdateTests.findDeclaredMethod(cl.getClass(), "findResources", String.class);
        findMethod.setAccessible(true);
        Enumeration<URL> resources = (Enumeration<URL>)findMethod.invoke((Object)cl, "test/doesnotexist.txt");
        Assert.assertNotNull((String)"Should not be null", (Object)resources);
        Assert.assertFalse((String)"Found resources!", (boolean)resources.hasMoreElements());
        resources = cl.getResources("test/doesnotexist.txt");
        Assert.assertNotNull((String)"Should not be null", resources);
        Assert.assertFalse((String)"Found resources!", (boolean)resources.hasMoreElements());
    }

    @Test
    public void testBug306181() throws BundleException {
        StartLevel sl = installer.getStartLevel();
        int origSL = sl.getStartLevel();
        int origBundleSL = sl.getInitialBundleStartLevel();
        int newSL = origSL + 1;
        sl.setInitialBundleStartLevel(newSL);
        try {
            Bundle a = installer.installBundle("test.bug306181a");
            Bundle b = installer.installBundle("test.bug306181b");
            sl.setBundleStartLevel(a, newSL);
            sl.setBundleStartLevel(b, newSL);
            installer.resolveBundles(new Bundle[]{a, b});
            a.start();
            b.start(2);
            sl.setStartLevel(newSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            Assert.assertEquals((String)"Bundle A is not active", (long)32L, (long)a.getState());
            Assert.assertEquals((String)"Bundle B is not active", (long)8L, (long)b.getState());
            ServiceReference[] regs = a.getRegisteredServices();
            if (regs != null && regs.length > 0) {
                Assert.fail((String)OSGiTestsActivator.getContext().getService(regs[0]).toString());
            }
        }
        catch (Throwable throwable) {
            sl.setInitialBundleStartLevel(origBundleSL);
            sl.setStartLevel(origSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            throw throwable;
        }
        sl.setInitialBundleStartLevel(origBundleSL);
        sl.setStartLevel(origSL);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
    }

    @Test
    public void testBug348805() throws BundleException {
        final boolean[] endCalled = new boolean[1];
        ResolverHookFactory error = triggers -> new ResolverHook(){

            public void filterSingletonCollisions(BundleCapability singleton, Collection collisionCandidates) {
            }

            public void filterResolvable(Collection candidates) {
                throw new RuntimeException("Error");
            }

            public void filterMatches(BundleRequirement requirement, Collection candidates) {
            }

            public void end() {
                endCalled[0] = true;
            }
        };
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(ResolverHookFactory.class, (Object)error, null);
        try {
            Bundle test = installer.installBundle("test");
            BundleException e = (BundleException)Assert.assertThrows(BundleException.class, () -> ((Bundle)test).start());
            Assert.assertEquals((String)"Wrong exception type.", (long)12L, (long)e.getType());
        }
        finally {
            reg.unregister();
        }
        Assert.assertTrue((String)"end is not called", (boolean)endCalled[0]);
    }

    @Test
    public void testBug348806() throws BundleException {
        ResolverHookFactory error = triggers -> new ResolverHook(){

            public void filterSingletonCollisions(BundleCapability singleton, Collection collisionCandidates) {
            }

            public void filterResolvable(Collection candidates) {
            }

            public void filterMatches(BundleRequirement requirement, Collection candidates) {
            }

            public void end() {
                throw new RuntimeException("Error");
            }
        };
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(ResolverHookFactory.class, (Object)error, null);
        try {
            Bundle test = installer.installBundle("test");
            BundleException e = (BundleException)Assert.assertThrows(BundleException.class, () -> ((Bundle)test).start());
            Assert.assertEquals((String)"Wrong exception type.", (long)12L, (long)e.getType());
        }
        finally {
            reg.unregister();
        }
    }

    @Test
    public void testBug370258_beginException() throws BundleException {
        final boolean[] endCalled = new boolean[1];
        ResolverHookFactory endHook = triggers -> new ResolverHook(){

            public void filterSingletonCollisions(BundleCapability singleton, Collection collisionCandidates) {
            }

            public void filterResolvable(Collection candidates) {
                throw new RuntimeException("Error");
            }

            public void filterMatches(BundleRequirement requirement, Collection candidates) {
            }

            public void end() {
                endCalled[0] = true;
            }
        };
        ResolverHookFactory error = triggers -> {
            throw new RuntimeException("Error");
        };
        ServiceRegistration endReg = OSGiTestsActivator.getContext().registerService(ResolverHookFactory.class, (Object)endHook, null);
        ServiceRegistration errorReg = OSGiTestsActivator.getContext().registerService(ResolverHookFactory.class, (Object)error, null);
        try {
            Bundle test = installer.installBundle("test");
            BundleException e = (BundleException)Assert.assertThrows(BundleException.class, () -> ((Bundle)test).start());
            Assert.assertEquals((String)"Wrong exception type.", (long)12L, (long)e.getType());
        }
        finally {
            errorReg.unregister();
            endReg.unregister();
        }
        Assert.assertTrue((String)"end is not called", (boolean)endCalled[0]);
    }

    @Test
    public void testBug370258_endException() throws BundleException {
        final boolean[] endCalled = new boolean[1];
        ResolverHookFactory endHook = triggers -> new ResolverHook(){

            public void filterSingletonCollisions(BundleCapability singleton, Collection collisionCandidates) {
            }

            public void filterResolvable(Collection candidates) {
                throw new RuntimeException("Error");
            }

            public void filterMatches(BundleRequirement requirement, Collection candidates) {
            }

            public void end() {
                endCalled[0] = true;
            }
        };
        ResolverHookFactory error = triggers -> new ResolverHook(){

            public void filterSingletonCollisions(BundleCapability singleton, Collection collisionCandidates) {
            }

            public void filterResolvable(Collection candidates) {
            }

            public void filterMatches(BundleRequirement requirement, Collection candidates) {
            }

            public void end() {
                throw new RuntimeException("Error");
            }
        };
        ServiceRegistration errorReg = OSGiTestsActivator.getContext().registerService(ResolverHookFactory.class, (Object)error, null);
        ServiceRegistration endReg = OSGiTestsActivator.getContext().registerService(ResolverHookFactory.class, (Object)endHook, null);
        try {
            Bundle test = installer.installBundle("test");
            BundleException e = (BundleException)Assert.assertThrows(BundleException.class, () -> ((Bundle)test).start());
            Assert.assertEquals((String)"Wrong exception type.", (long)12L, (long)e.getType());
        }
        finally {
            errorReg.unregister();
            endReg.unregister();
        }
        Assert.assertTrue((String)"end is not called", (boolean)endCalled[0]);
    }

    @Test
    public void testLoadClassUnresolved() throws Exception {
        Bundle chainTest = installer.installBundle("chain.test");
        Assert.assertFalse((String)("Should not resolve bundle: " + String.valueOf(chainTest)), (boolean)installer.resolveBundles(new Bundle[]{chainTest}));
        Assert.assertThrows((String)"Should not be able to load class: chain.test.TestSingleChain", ClassNotFoundException.class, () -> {
            Class clazz = chainTest.loadClass("chain.test.TestSingleChain");
        });
    }

    private void doTestArrayTypeLoad(String name) throws ClassNotFoundException {
        Class arrayType = OSGiTestsActivator.getBundle().loadClass(name);
        Assert.assertNotNull((String)"Null class", (Object)arrayType);
        Assert.assertTrue((String)("Class is not an array: " + String.valueOf(arrayType)), (boolean)arrayType.isArray());
    }

    private String readURL(URL url) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            return reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testDefaultLocalUninstall() throws Exception {
        Bundle test = installer.installBundle("security.a");
        test.uninstall();
        Dictionary headers = test.getHeaders();
        String bundleName = (String)headers.get("Bundle-Name");
        Assert.assertEquals((String)"Wrong bundle name header.", (Object)"default", (Object)bundleName);
    }

    @Test
    public void testBug490902() throws BundleException, InterruptedException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Bundle a1 = installer.installBundle("test.bug490902.a");
        Bundle b1 = installer.installBundle("test.bug490902.b");
        installer.resolveBundles(new Bundle[]{a1, b1});
        CountDownLatch startingB = new CountDownLatch(1);
        CountDownLatch endedSecondThread = new CountDownLatch(1);
        SynchronousBundleListener delayB1 = event -> {
            if (event.getBundle() == b1 && 128 == event.getType()) {
                try {
                    startingB.countDown();
                    System.out.println(this.getName() + ": Delaying now ...");
                    Thread.sleep(15000L);
                    System.out.println(this.getName() + ": Done delaying.");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        this.getContext().addBundleListener((BundleListener)delayB1);
        try {
            new Thread(() -> {
                try {
                    System.out.println(this.getName() + ": Initial load test.");
                    a1.loadClass("test.bug490902.a.TestLoadA1").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }, "Initial load test thread.").start();
            startingB.await();
            Thread secondThread = new Thread(() -> {
                try {
                    try {
                        System.out.println(this.getName() + ": Second load test.");
                        a1.loadClass("test.bug490902.a.TestLoadA1").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        endedSecondThread.countDown();
                    }
                }
                finally {
                    endedSecondThread.countDown();
                }
            }, "Second load test thread.");
            secondThread.start();
            Thread.sleep(10000L);
            System.out.println(this.getName() + ": About to interrupt:" + secondThread.getName());
            secondThread.interrupt();
            endedSecondThread.await();
            a1.loadClass("test.bug490902.a.TestLoadA1").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        finally {
            this.getContext().removeBundleListener((BundleListener)delayB1);
        }
    }

    @Test
    public void testRecursiveWeavingHookFactory() {
        final ThreadLocal<Boolean> testThread = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        testThread.set(Boolean.TRUE);
        final HashSet weavingHookClasses = new HashSet();
        final ArrayList called = new ArrayList();
        final AtomicBoolean loadNewClassInWeave = new AtomicBoolean(false);
        ServiceFactory<WeavingHook> topFactory = new ServiceFactory<WeavingHook>(){

            public WeavingHook getService(Bundle bundle, ServiceRegistration<WeavingHook> registration) {
                if (!((Boolean)testThread.get()).booleanValue()) {
                    return null;
                }
                WeavingHook hook = wovenClass -> {
                    if (loadNewClassInWeave.get()) {
                        Runnable run = new Runnable(){

                            @Override
                            public void run() {
                            }
                        };
                        run.run();
                        weavingHookClasses.add(run.getClass().getName());
                    }
                    called.add(wovenClass);
                };
                weavingHookClasses.add(hook.getClass().getName());
                return hook;
            }

            public void ungetService(Bundle bundle, ServiceRegistration<WeavingHook> registration, WeavingHook service) {
            }
        };
        ServiceRegistration reg = this.getContext().registerService(WeavingHook.class, (ServiceFactory)topFactory, null);
        Runnable run = null;
        try {
            topFactory.getService(null, null);
            loadNewClassInWeave.set(true);
            run = new Runnable(){

                @Override
                public void run() {
                }
            };
            run.run();
        }
        finally {
            reg.unregister();
        }
        Assert.assertEquals((String)"Unexpected number of woven classes.", (long)2L, (long)called.size());
        for (WovenClass wovenClass : called) {
            if (weavingHookClasses.contains(wovenClass.getClassName())) {
                Assert.assertNull((String)("Did not expect to find class: " + String.valueOf(wovenClass.getDefinedClass())), (Object)wovenClass.getDefinedClass());
                continue;
            }
            Assert.assertEquals((String)"Expected the inner runnable class.", run.getClass(), (Object)wovenClass.getDefinedClass());
        }
    }

    @Test
    public void testLoaderUninstalledBundle() throws BundleException, IOException {
        String testResourcePath = "testResource";
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> testHeaders = new HashMap<String, String>();
        testHeaders.put("Bundle-ManifestVersion", "2");
        testHeaders.put("Bundle-SymbolicName", this.getName());
        config.mkdirs();
        File testBundleFile = SystemBundleTests.createBundle(config, this.getName(), testHeaders, Collections.singletonMap(testResourcePath, "testValue"));
        Bundle test = this.getContext().installBundle(this.getName(), (InputStream)new FileInputStream(testBundleFile));
        test.start();
        BundleWiring wiring = (BundleWiring)test.adapt(BundleWiring.class);
        Assert.assertNotNull((String)"No wiring found.", (Object)wiring);
        ModuleClassLoader bundleClassLoader = (ModuleClassLoader)wiring.getClassLoader();
        URL testResource = bundleClassLoader.findLocalResource(testResourcePath);
        Assert.assertNotNull((String)"No test resource found.", (Object)testResource);
        test.update((InputStream)new FileInputStream(testBundleFile));
        testResource = bundleClassLoader.findLocalResource(testResourcePath);
        Assert.assertNull((String)"Found resource.", (Object)testResource);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(32, test, null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        wiring = (BundleWiring)test.adapt(BundleWiring.class);
        Assert.assertNotNull((String)"No wiring found.", (Object)wiring);
        bundleClassLoader = (ModuleClassLoader)wiring.getClassLoader();
        testResource = bundleClassLoader.findLocalResource(testResourcePath);
        Assert.assertNotNull((String)"No test resource found.", (Object)testResource);
        test.uninstall();
        testResource = bundleClassLoader.findLocalResource(testResourcePath);
        Assert.assertNull((String)"Found resource.", (Object)testResource);
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
    }

    @Test
    public void testStaleLoaderNPE() throws BundleException, IOException, InterruptedException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> exporterHeaders = new HashMap<String, String>();
        exporterHeaders.put("Bundle-ManifestVersion", "2");
        exporterHeaders.put("Bundle-SymbolicName", "exporter");
        exporterHeaders.put("Export-Package", "export1, export2, export3, export4");
        HashMap<String, String> exporterContent = new HashMap<String, String>();
        exporterContent.put("export1/", null);
        exporterContent.put("export1/SomeClass.class", "SomeClass.class");
        exporterContent.put("export2/", null);
        exporterContent.put("export2/SomeClass.class", "SomeClass.class");
        exporterContent.put("export3/", null);
        exporterContent.put("export3/resource.txt", "resource.txt");
        exporterContent.put("export4/", null);
        exporterContent.put("export4/resource.txt", "resource.txt");
        File exporterBundleFile = SystemBundleTests.createBundle(config, this.getName() + "-exporter", exporterHeaders, exporterContent);
        HashMap<String, String> importerHeaders = new HashMap<String, String>();
        importerHeaders.put("Bundle-ManifestVersion", "2");
        importerHeaders.put("Bundle-SymbolicName", "importer");
        importerHeaders.put("Import-Package", "export1, export2, export3, export4");
        HashMap<String, String> importerContent = new HashMap<String, String>();
        importerContent.put("importer/", null);
        importerContent.put("importer/resource.txt", "resource.txt");
        importerContent.put("importer/SomeClass.class", "SomeClass.class");
        File importerBundleFile = SystemBundleTests.createBundle(config, this.getName() + "-importer", importerHeaders, importerContent);
        HashMap<String, String> requirerHeaders = new HashMap<String, String>();
        requirerHeaders.put("Bundle-ManifestVersion", "2");
        requirerHeaders.put("Bundle-SymbolicName", "requirer");
        requirerHeaders.put("Require-Bundle", "exporter");
        HashMap<String, String> requirerContent = new HashMap<String, String>();
        requirerContent.put("requirer/", null);
        requirerContent.put("requirer/resource.txt", "resource.txt");
        requirerContent.put("requirer/SomeClass.class", "SomeClass.class");
        File requirerBundleFile = SystemBundleTests.createBundle(config, this.getName() + "-requirer", requirerHeaders, requirerContent);
        Bundle exporter = this.getContext().installBundle(this.getName() + "-exporter", (InputStream)new FileInputStream(exporterBundleFile));
        exporter.start();
        Bundle importer = this.getContext().installBundle(this.getName() + "-importer", (InputStream)new FileInputStream(importerBundleFile));
        importer.start();
        Bundle requirer = this.getContext().installBundle(this.getName() + "-requirer", (InputStream)new FileInputStream(requirerBundleFile));
        requirer.start();
        BundleWiring importerWiring = (BundleWiring)importer.adapt(BundleWiring.class);
        BundleWiring requirerWiring = (BundleWiring)requirer.adapt(BundleWiring.class);
        ClassLoader importerCL = importerWiring.getClassLoader();
        ClassLoader requirerCL = requirerWiring.getClassLoader();
        Assert.assertThrows(LinkageError.class, () -> {
            Class<?> clazz = importerCL.loadClass("export1.SomeClass");
        });
        URL export3Resource = importerCL.getResource("export3/resource.txt");
        Assert.assertNotNull((String)"Missing resource.", (Object)export3Resource);
        Assert.assertThrows(LinkageError.class, () -> {
            Class<?> clazz = requirerCL.loadClass("export1.SomeClass");
        });
        export3Resource = requirerCL.getResource("export3/resource.txt");
        Assert.assertNotNull((String)"Missing resource.", (Object)export3Resource);
        this.refreshBundles(Collections.singleton(exporter));
        LinkedBlockingQueue events = new LinkedBlockingQueue();
        this.getContext().addFrameworkListener(event -> {
            if (event.getBundle() == requirer) {
                events.add(event);
            }
        });
        Assert.assertThrows(LinkageError.class, () -> {
            Class<?> clazz = importerCL.loadClass("export2.SomeClass");
        });
        URL export4Resource = importerCL.getResource("export4/resource.txt");
        Assert.assertNotNull((String)"Missing resource.", (Object)export4Resource);
        Assert.assertThrows(ClassNotFoundException.class, () -> {
            Class<?> clazz = requirerCL.loadClass("export2.SomeClass");
        });
        export4Resource = requirerCL.getResource("export4/resource.txt");
        Assert.assertNull((String)"Found resource from invalid wire.", (Object)export4Resource);
        FrameworkEvent event2 = (FrameworkEvent)events.poll(5L, TimeUnit.SECONDS);
        Assert.assertNotNull((String)"No FrameworkEvent found.", (Object)event2);
        Assert.assertEquals((String)"Wrong bundle for event.", (Object)requirer, (Object)event2.getBundle());
        Assert.assertEquals((String)"Wrong event type.", (long)2L, (long)event2.getType());
        Assert.assertTrue((String)("Wrong exception: " + String.valueOf(event2.getThrowable())), (boolean)(event2.getThrowable() instanceof RuntimeException));
        Assert.assertTrue((String)("Wrong message: " + event2.getThrowable().getMessage()), (boolean)event2.getThrowable().getMessage().startsWith("Invalid class loader"));
        Assert.assertNull((String)"Found more events.", events.poll(1L, TimeUnit.SECONDS));
    }

    @Test
    public void testBug565522FragmentClasspath() throws Exception {
        JarOutputStream libResourceJar22;
        ByteArrayOutputStream libResourceJarBytes1 = new ByteArrayOutputStream();
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            libResourceJar22 = new JarOutputStream(libResourceJarBytes1);
            try {
                libResourceJar22.putNextEntry(new JarEntry("META-INF/"));
                libResourceJar22.closeEntry();
                libResourceJar22.putNextEntry(new JarEntry("META-INF/services/"));
                libResourceJar22.closeEntry();
                libResourceJar22.putNextEntry(new JarEntry("META-INF/services/some.bundle.Factory"));
                libResourceJar22.write("testFactory1".getBytes());
                libResourceJar22.closeEntry();
            }
            finally {
                if (libResourceJar22 != null) {
                    libResourceJar22.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        ByteArrayOutputStream libResourceJarBytes2 = new ByteArrayOutputStream();
        throwable2 = null;
        libResourceJar22 = null;
        try (JarOutputStream libResourceJar = new JarOutputStream(libResourceJarBytes2);){
            libResourceJar.putNextEntry(new JarEntry("META-INF/"));
            libResourceJar.closeEntry();
            libResourceJar.putNextEntry(new JarEntry("META-INF/services/"));
            libResourceJar.closeEntry();
            libResourceJar.putNextEntry(new JarEntry("META-INF/services/some.bundle.Factory"));
            libResourceJar.write("testFactory2".getBytes());
            libResourceJar.closeEntry();
        }
        catch (Throwable libResourceJar22) {
            if (throwable2 == null) {
                throwable2 = libResourceJar22;
            } else if (throwable2 != libResourceJar22) {
                throwable2.addSuppressed(libResourceJar22);
            }
            throw throwable2;
        }
        File outputDir = OSGiTestsActivator.getContext().getDataFile(this.getName());
        outputDir.mkdirs();
        HashMap<String, String> hostHeaders = new HashMap<String, String>();
        hostHeaders.put("Bundle-ManifestVersion", "2");
        hostHeaders.put("Bundle-SymbolicName", "host");
        hostHeaders.put("Bundle-ClassPath", "., lib/resource.jar");
        HashMap<String, byte[]> hostEntries = new HashMap<String, byte[]>();
        hostEntries.put("lib/", null);
        hostEntries.put("lib/resource.jar", libResourceJarBytes1.toByteArray());
        File hostFile = SystemBundleTests.createBundleWithBytes(outputDir, "host", hostHeaders, hostEntries);
        HashMap<String, String> fragHeaders = new HashMap<String, String>();
        fragHeaders.put("Bundle-ManifestVersion", "2");
        fragHeaders.put("Bundle-SymbolicName", "fragment");
        fragHeaders.put("Bundle-ClassPath", "., lib/resource.jar");
        fragHeaders.put("Fragment-Host", "host");
        HashMap<String, byte[]> fragEntries = new HashMap<String, byte[]>();
        fragEntries.put("lib/", null);
        fragEntries.put("lib/resource.jar", libResourceJarBytes2.toByteArray());
        File fragFile = SystemBundleTests.createBundleWithBytes(outputDir, "frag", fragHeaders, fragEntries);
        Bundle host = null;
        Bundle frag = null;
        try {
            host = this.getContext().installBundle(hostFile.toURI().toASCIIString());
            frag = this.getContext().installBundle(fragFile.toURI().toASCIIString());
            host.start();
            Enumeration eResources = host.getResources("META-INF/services/some.bundle.Factory");
            Assert.assertNotNull((String)"No resources found.", (Object)eResources);
            ArrayList resources = Collections.list(eResources);
            Assert.assertEquals((String)"Wrong number of resources.", (long)2L, (long)resources.size());
            Assert.assertEquals((String)"Wrong content for resource 1", (Object)"testFactory1", (Object)this.readURL((URL)resources.get(0)));
            Assert.assertEquals((String)"Wrong content for resource 2", (Object)"testFactory2", (Object)this.readURL((URL)resources.get(1)));
            URL copyURL1 = new URL(((URL)resources.get(0)).toExternalForm());
            URL copyURL2 = new URL(((URL)resources.get(1)).toExternalForm());
            Assert.assertEquals((String)"Wrong content for url copy 1", (Object)"testFactory1", (Object)this.readURL(copyURL1));
            Assert.assertEquals((String)"Wrong content for url copy 2", (Object)"testFactory2", (Object)this.readURL(copyURL2));
        }
        finally {
            if (host != null) {
                host.uninstall();
            }
            if (frag != null) {
                frag.uninstall();
            }
        }
    }

    @Test
    public void testExternalClasspath() throws Exception {
        File outputDir = OSGiTestsActivator.getContext().getDataFile(this.getName());
        outputDir.mkdirs();
        HashMap<String, String> hostHeaders = new HashMap<String, String>();
        hostHeaders.put("Bundle-ManifestVersion", "2");
        hostHeaders.put("Bundle-SymbolicName", "testClassPathHost");
        hostHeaders.put("Bundle-ClassPath", "., external:$TEST_CLASS_PATH_EXTERNAL$");
        hostHeaders.put("Bundle-Activator", ExternalClassPathActivator.class.getName());
        hostHeaders.put("Import-Package", "org.osgi.framework, org.osgi.framework.wiring");
        HashMap<CallSite, byte[]> hostEntries = new HashMap<CallSite, byte[]>();
        String activatorResourcePath = ExternalClassPathActivator.class.getName().replace('.', '/') + ".class";
        hostEntries.put((CallSite)((Object)activatorResourcePath), StorageUtil.getBytes((InputStream)OSGiTestsActivator.getBundle().getResource(activatorResourcePath).openStream(), (int)-1, (int)4000));
        File hostFile = SystemBundleTests.createBundleWithBytes(outputDir, "host", hostHeaders, hostEntries);
        HashMap<String, String> externalHeaders = new HashMap<String, String>();
        HashMap<String, byte[]> externalEntries = new HashMap<String, byte[]>();
        externalEntries.put("lib/", null);
        externalEntries.put("lib/resource.txt", "Some Text".getBytes());
        File externalFile = SystemBundleTests.createBundleWithBytes(outputDir, "external", externalHeaders, externalEntries);
        System.setProperty("TEST_CLASS_PATH_EXTERNAL", externalFile.getAbsolutePath());
        Bundle host = null;
        try {
            host = this.getContext().installBundle(hostFile.toURI().toASCIIString());
            host.start();
            URL resource = ((BundleWiring)host.adapt(BundleWiring.class)).getClassLoader().getResource("lib/resource.txt");
            Assert.assertNotNull((String)"No resources found.", (Object)resource);
            Assert.assertEquals((String)"Wrong content for resource", (Object)"Some Text", (Object)this.readURL(resource));
        }
        finally {
            if (host != null) {
                host.uninstall();
            }
        }
    }

    @Test
    public void testDynamicImportStarXInternal() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> headersExportHeaders = new HashMap<String, String>();
        headersExportHeaders.put("Bundle-ManifestVersion", "2");
        headersExportHeaders.put("Bundle-SymbolicName", this.getName() + "Export");
        headersExportHeaders.put("Export-Package", "test.internal.pkg1; x-internal:=true, test.friends.pkg1; x-friends:=nobody");
        HashMap<String, String> headersImportHeaders = new HashMap<String, String>();
        headersImportHeaders.put("Bundle-ManifestVersion", "2");
        headersImportHeaders.put("Bundle-SymbolicName", this.getName() + "Import");
        headersImportHeaders.put("DynamicImport-Package", "*");
        config.mkdirs();
        File bundleExportFile = SystemBundleTests.createBundle(config, this.getName() + "Export", headersExportHeaders, new Map[0]);
        File bundleImportFile = SystemBundleTests.createBundle(config, this.getName() + "Import", headersImportHeaders, new Map[0]);
        HashMap<String, String> fwkConfig = new HashMap<String, String>();
        fwkConfig.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(fwkConfig);
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle bundleExport = systemContext.installBundle(bundleExportFile.toURI().toString());
            bundleExport.start();
            Bundle bundleImport = systemContext.installBundle(bundleImportFile.toURI().toString());
            bundleImport.start();
            Assert.assertThrows(ClassNotFoundException.class, () -> {
                Class clazz = bundleImport.loadClass("test.internal.pkg1.DoesNotExistTest");
            });
            BundleWiring importWiring = (BundleWiring)bundleImport.adapt(BundleWiring.class);
            Assert.assertNotNull((String)"No wiring", (Object)importWiring);
            List importWires = importWiring.getRequiredWires("osgi.wiring.package");
            Assert.assertEquals((String)"Expected 1 import", (long)1L, (long)importWires.size());
            BundleWire testWire = (BundleWire)importWires.get(0);
            Assert.assertEquals((String)"Expected a dynamic wire", (Object)"dynamic", testWire.getRequirement().getDirectives().get("resolution"));
            Assert.assertEquals((String)"Wrong package wired", (Object)"test.internal.pkg1", testWire.getCapability().getAttributes().get("osgi.wiring.package"));
            Assert.assertThrows(ClassNotFoundException.class, () -> {
                Class clazz = bundleImport.loadClass("test.friends.pkg1.DoesNotExistTest");
            });
            importWires = importWiring.getRequiredWires("osgi.wiring.package");
            Assert.assertEquals((String)"Expected 2 imports", (long)2L, (long)importWires.size());
            testWire = (BundleWire)importWires.get(1);
            Assert.assertEquals((String)"Expected a dynamic wire", (Object)"dynamic", testWire.getRequirement().getDirectives().get("resolution"));
            Assert.assertEquals((String)"Wrong package wired", (Object)"test.friends.pkg1", testWire.getCapability().getAttributes().get("osgi.wiring.package"));
        }
        finally {
            ClassLoadingBundleTests.stopQuietly((Framework)equinox);
        }
    }

    void refreshBundles(Collection<Bundle> bundles) throws InterruptedException {
        CountDownLatch refreshSignal = new CountDownLatch(1);
        ((FrameworkWiring)this.getContext().getBundle("System Bundle").adapt(FrameworkWiring.class)).refreshBundles(bundles, new FrameworkListener[]{event -> {
            if (event.getType() == 4) {
                refreshSignal.countDown();
            }
        }});
        refreshSignal.await(30L, TimeUnit.SECONDS);
    }
}

