/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import junit.framework.TestCase;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.launch.EquinoxFactory;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.classes.Activator;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.connect.ConnectContent;
import org.osgi.framework.connect.ConnectModule;
import org.osgi.framework.connect.ModuleConnector;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.condition.Condition;

public class ConnectTests
extends AbstractBundleTests {
    static final TestConnectModule BUNDLE_EXCEPTION = new TestConnectModule(null);

    void cleanStorage() {
        ConnectTests.delete(this.getContext().getDataFile(this.getName()));
    }

    void doTestConnect(ModuleConnector moduleConnector, Map<String, String> fwkConfig, Consumer<Framework> test) {
        this.doTestConnect(moduleConnector, fwkConfig, test, false);
    }

    void doTestConnect(ModuleConnector moduleConnector, Map<String, String> fwkConfig, Consumer<Framework> test, boolean enableRuntimeVerification) {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        fwkConfig = new HashMap<String, String>(fwkConfig);
        fwkConfig.put("org.osgi.framework.storage", config.getAbsolutePath());
        if (enableRuntimeVerification) {
            fwkConfig.put("osgi.signedcontent.support", "runtime");
        }
        EquinoxFactory fwkFactory = new EquinoxFactory();
        Framework framework = fwkFactory.newFramework(fwkConfig, moduleConnector);
        boolean passed = false;
        try {
            test.accept(framework);
            passed = true;
        }
        finally {
            block9: {
                try {
                    framework.stop();
                    framework.waitForStop(10000L);
                }
                catch (Exception e) {
                    if (!passed) break block9;
                    ConnectTests.sneakyThrow(e);
                }
            }
        }
    }

    @Test
    public void testConnectFactoryNoModules() {
        TestCountingModuleConnector connector = new TestCountingModuleConnector();
        this.doTestConnect(connector, Collections.emptyMap(), f -> {
            try {
                f.start();
                f.stop();
                f.waitForStop(5000L);
                f.start();
                f.stop();
                f.waitForStop(5000L);
            }
            catch (Throwable t) {
                ConnectTests.sneakyThrow(t);
            }
        });
        this.doTestConnect(connector, Collections.emptyMap(), f -> {
            try {
                f.start();
                f.stop();
            }
            catch (BundleException e) {
                ConnectTests.sneakyThrow(e);
            }
        });
        Assert.assertEquals((String)"Wrong number of init called.", (long)2L, (long)connector.getInitializeCnt());
        Assert.assertEquals((String)"Wrong number of create activator called.", (long)3L, (long)connector.getCreateBundleActivatorCnt());
    }

    @Test
    public void testConnectActivator() {
        final AtomicInteger bundleActvatorStartCalled = new AtomicInteger();
        final AtomicInteger bundleActvatorStopCalled = new AtomicInteger();
        TestCountingModuleConnector activatorModuleConnector = new TestCountingModuleConnector(){

            @Override
            public Optional<BundleActivator> newBundleActivator() {
                super.newBundleActivator();
                return Optional.of(new BundleActivator(){

                    public void start(BundleContext context) throws Exception {
                        bundleActvatorStartCalled.getAndIncrement();
                    }

                    public void stop(BundleContext context) throws Exception {
                        bundleActvatorStopCalled.getAndIncrement();
                    }
                });
            }
        };
        this.doTestConnect(activatorModuleConnector, Collections.emptyMap(), f -> {
            try {
                f.start();
                f.stop();
                f.waitForStop(5000L);
                f.start();
                f.stop();
                f.waitForStop(5000L);
            }
            catch (Exception e) {
                ConnectTests.sneakyThrow(e);
            }
        });
        Assert.assertEquals((String)"Wrong number of start called.", (long)2L, (long)bundleActvatorStartCalled.get());
        Assert.assertEquals((String)"Wrong number of stop called.", (long)2L, (long)bundleActvatorStopCalled.get());
    }

    @Test
    public void testTrueCondition() {
        final AtomicReference trueConditionStart = new AtomicReference();
        final AtomicReference trueConditionStop = new AtomicReference();
        TestCountingModuleConnector activatorModuleConnector = new TestCountingModuleConnector(){

            @Override
            public Optional<BundleActivator> newBundleActivator() {
                super.newBundleActivator();
                return Optional.of(new BundleActivator(){

                    public void start(BundleContext context) throws Exception {
                        trueConditionStart.set((ServiceReference)context.getServiceReferences(Condition.class, "(osgi.condition.id=true)").iterator().next());
                    }

                    public void stop(BundleContext context) throws Exception {
                        trueConditionStop.set((ServiceReference)context.getServiceReferences(Condition.class, "(osgi.condition.id=true)").iterator().next());
                    }
                });
            }
        };
        this.doTestConnect(activatorModuleConnector, Collections.emptyMap(), f -> {
            try {
                f.start();
                ServiceReference trueCondition = (ServiceReference)trueConditionStart.get();
                Assert.assertNotNull((String)"No true condition found.", (Object)trueCondition);
                Assert.assertEquals((String)"Wrong bundle.", (Object)f.getBundleContext().getBundle(), (Object)trueCondition.getBundle());
                f.stop();
                f.waitForStop(5000L);
                Assert.assertEquals((String)"Different true condition found on start and stop.", (Object)trueCondition, trueConditionStop.get());
                Assert.assertNull((String)"True condition should be unregistered on stop.", (Object)trueCondition.getBundle());
            }
            catch (Exception e) {
                ConnectTests.sneakyThrow(e);
            }
        });
    }

    @Test
    public void testConnectInit() {
        final AtomicReference initFile = new AtomicReference();
        AtomicReference storeFile = new AtomicReference();
        final AtomicReference initConfig = new AtomicReference();
        TestCountingModuleConnector initParamsModuleConnector = new TestCountingModuleConnector(){

            @Override
            public void initialize(File storage, Map<String, String> config) {
                super.initialize(storage, config);
                initFile.set(storage);
                initConfig.set(config);
            }
        };
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("k1", "v1");
        config.put("k2", "v2");
        this.doTestConnect(initParamsModuleConnector, config, f -> {
            try {
                f.init();
                BundleContext bc = f.getBundleContext();
                storeFile.set(new File(bc.getProperty("org.osgi.framework.storage")));
            }
            catch (Exception e) {
                ConnectTests.sneakyThrow(e);
            }
        });
        TestCase.assertEquals((String)"Wrong init store file.", storeFile.get(), initFile.get());
        Assert.assertTrue((String)("Did not find all init configs: " + String.valueOf(initConfig.get())), (boolean)((Map)initConfig.get()).entrySet().containsAll(config.entrySet()));
        Assert.assertThrows(UnsupportedOperationException.class, () -> {
            String string = ((Map)initConfig.get()).put("k3", "v3");
        });
    }

    @Test
    public void testConnectContentHeaders() throws IOException {
        this.doTestConnectContentSimple(false);
    }

    @Test
    public void testConnectContentManifest() throws IOException {
        this.doTestConnectContentSimple(true);
    }

    void doTestConnectContentSimple(boolean withManifest) throws IOException {
        TestCountingModuleConnector connector = new TestCountingModuleConnector();
        List<String> locations = Arrays.asList("b.1", "b.2", "b.3", "b.4");
        for (String l : locations) {
            connector.setModule(l, withManifest ? this.createSimpleManifestModule(l) : this.createSimpleHeadersModule(l));
        }
        this.doTestConnect(connector, Collections.emptyMap(), f -> {
            try {
                f.init();
                for (String l : locations) {
                    Bundle b = f.getBundleContext().installBundle(l);
                    Assert.assertEquals((String)"Wrong symbolic name.", (Object)l, (Object)b.getSymbolicName());
                    ConnectTests.checkConnectTag(b);
                }
                ConnectTests.checkConnectTags(f, locations);
            }
            catch (Throwable t) {
                ConnectTests.sneakyThrow(t);
            }
        });
        this.doTestConnect(connector, Collections.emptyMap(), f -> {
            try {
                f.init();
                Bundle[] bundles = f.getBundleContext().getBundles();
                Assert.assertEquals((String)"Wrong number of bundles from cache.", (long)(locations.size() + 1), (long)bundles.length);
                for (String l : locations) {
                    Bundle b = f.getBundleContext().getBundle(l);
                    Assert.assertNotNull((String)("No bundle at location: " + l), (Object)b);
                    Assert.assertEquals((String)"Wrong symbolic name.", (Object)l, (Object)b.getSymbolicName());
                    ConnectTests.checkConnectTag(b);
                    ConnectTests.checkConnectTags(f, locations);
                }
            }
            catch (BundleException e) {
                ConnectTests.sneakyThrow(e);
            }
        });
        connector.setModule("b.2", null);
        connector.setModule("b.3", BUNDLE_EXCEPTION);
        this.doTestConnect(connector, Collections.emptyMap(), f -> {
            try {
                f.init();
                Bundle[] bundles = f.getBundleContext().getBundles();
                Assert.assertEquals((String)"Wrong number of bundles from cache.", (long)(locations.size() - 1), (long)bundles.length);
                for (String l : locations) {
                    Bundle b = f.getBundleContext().getBundle(l);
                    if ("b.2".equals(l) || "b.3".equals(l)) {
                        Assert.assertNull((String)"Found unexpected bundle.", (Object)b);
                        continue;
                    }
                    Assert.assertNotNull((String)("No bundle at location: " + l), (Object)b);
                    Assert.assertEquals((String)"Wrong symbolic name.", (Object)l, (Object)b.getSymbolicName());
                    ConnectTests.checkConnectTag(b);
                }
            }
            catch (BundleException e) {
                ConnectTests.sneakyThrow(e);
            }
        });
    }

    private static void checkConnectTag(Bundle b) {
        ArrayList<String> namespaces = new ArrayList<String>(Arrays.asList("osgi.wiring.bundle", "osgi.wiring.host", "osgi.identity"));
        ((BundleRevision)b.adapt(BundleRevision.class)).getCapabilities(null).stream().filter(c -> namespaces.contains(c.getNamespace())).forEach(c -> {
            List tags = (List)c.getAttributes().get("tags");
            Assert.assertNotNull((String)"No tags found.", (Object)tags);
            Assert.assertEquals((String)"Wrong number of tags.", (long)1L, (long)tags.size());
            Assert.assertTrue((String)"Connect tag not found.", (boolean)tags.contains("osgi.connect"));
            namespaces.remove(c.getNamespace());
        });
        Assert.assertTrue((String)("Connect tag namespaces were not removed completely. Found " + String.valueOf(namespaces)), (boolean)namespaces.isEmpty());
    }

    private static void checkConnectTags(Framework f, List<String> locations) {
        Collection osgiConnectTags = ((FrameworkWiring)f.adapt(FrameworkWiring.class)).findProviders(ModuleContainer.createRequirement((String)"osgi.identity", Collections.singletonMap("filter", "(tags=osgi.connect)"), Collections.emptyMap()));
        osgiConnectTags.forEach(c -> Assert.assertTrue((String)("Unexpected tag on bundle: " + String.valueOf(c.getRevision().getBundle())), (boolean)locations.contains(c.getRevision().getBundle().getLocation())));
    }

    @Test
    public void testConnectContentActivatorsWithFrameworkLoaders() {
        this.doTestConnectContentActivators(false);
    }

    @Test
    public void testConnectContentActivatorsWithProvidedLoaders() {
        this.doTestConnectContentActivators(true);
    }

    void doTestConnectContentActivators(boolean provideLoader) {
        TestCountingModuleConnector connector = new TestCountingModuleConnector();
        List<Integer> ids = Arrays.asList(1, 2, 3);
        for (Integer id : ids) {
            connector.setModule(id.toString(), this.createAdvancedModule(id, provideLoader));
        }
        this.doTestConnect(connector, Collections.emptyMap(), f -> {
            try {
                f.start();
                for (Integer id : ids) {
                    Bundle b = f.getBundleContext().installBundle(id.toString());
                    Assert.assertEquals((String)"Wrong symbolic name.", (Object)id.toString(), (Object)b.getSymbolicName());
                    b.start();
                    ServiceReference[] registered = b.getRegisteredServices();
                    Assert.assertNotNull((String)"No services found.", (Object)registered);
                    Assert.assertEquals((String)"Wrong number of services.", (long)1L, (long)registered.length);
                    Assert.assertEquals((String)"Wrong service property.", (Object)(Activator.class.getSimpleName() + String.valueOf(id)), (Object)registered[0].getProperty("activator"));
                    if (provideLoader) {
                        Assert.assertTrue((String)"Expected the same classes.", (boolean)Activator.class.equals((Object)b.loadClass(Activator.class.getName())));
                        continue;
                    }
                    Assert.assertFalse((String)"Expected different classes.", (boolean)Activator.class.equals((Object)b.loadClass(Activator.class.getName())));
                }
            }
            catch (Throwable t) {
                ConnectTests.sneakyThrow(t);
            }
        });
    }

    @Test
    public void testConnectContentEntriesWithFrameworkLoaders() {
        this.doTestConnectContentEntries(false);
    }

    @Test
    public void testConnectContentEntriesWithProvidedLoaders() {
        this.doTestConnectContentEntries(true);
    }

    void doTestConnectContentEntries(boolean provideLoader) {
        TestCountingModuleConnector connector = new TestCountingModuleConnector();
        List<Integer> ids = Arrays.asList(1, 2, 3);
        HashMap<Integer, TestConnectModule> modules = new HashMap<Integer, TestConnectModule>();
        for (Integer id : ids) {
            TestConnectModule m = this.createAdvancedModule(id, provideLoader);
            modules.put(id, m);
            connector.setModule(id.toString(), m);
        }
        this.doTestConnect(connector, Collections.emptyMap(), f -> {
            try {
                f.start();
                for (Integer id : ids) {
                    Bundle b = f.getBundleContext().installBundle(id.toString());
                    Assert.assertEquals((String)"Wrong symbolic name.", (Object)id.toString(), (Object)b.getSymbolicName());
                    TestConnectModule m = (TestConnectModule)modules.get(id);
                    ArrayList<String> entries = new ArrayList<String>();
                    for (String entry : m.getContent().getEntries()) {
                        entries.add(entry);
                    }
                    HashSet<String> bundleEntryUrls = new HashSet<String>();
                    Enumeration eUrls = b.findEntries("/", "*", true);
                    while (eUrls.hasMoreElements()) {
                        bundleEntryUrls.add(((URL)eUrls.nextElement()).getPath().substring(1));
                    }
                    Assert.assertEquals((String)"Wrong number of bundle entry URLs.", (long)entries.size(), (long)bundleEntryUrls.size());
                    Assert.assertTrue((String)("Wrong bundle entry URLs: " + String.valueOf(bundleEntryUrls)), (boolean)entries.containsAll(bundleEntryUrls));
                    ArrayList<String> bundleEntryPaths = new ArrayList<String>();
                    Enumeration ePaths = b.getEntryPaths("org/eclipse/osgi/tests/bundles/resources");
                    while (ePaths.hasMoreElements()) {
                        bundleEntryPaths.add((String)ePaths.nextElement());
                    }
                    Assert.assertEquals((String)"Wrong number of bundle entry paths from root.", (long)1L, (long)bundleEntryPaths.size());
                    Assert.assertEquals((String)"Wrong bundle entry found at root.", (Object)("org/eclipse/osgi/tests/bundles/resources/" + String.valueOf(id) + ".txt"), bundleEntryPaths.get(0));
                    BundleWiring wiring = (BundleWiring)b.adapt(BundleWiring.class);
                    Assert.assertNotNull((String)"No wiring.", (Object)wiring);
                    Collection wiringResourcePaths = wiring.listResources("/", "*", 3);
                    Assert.assertEquals((String)"Wrong number of resource paths.", (long)entries.size(), (long)wiringResourcePaths.size());
                    Assert.assertTrue((String)("Wrong resource paths: " + String.valueOf(wiringResourcePaths)), (boolean)entries.containsAll(wiringResourcePaths));
                    HashSet<String> wiringEntryUrls = new HashSet<String>();
                    for (URL url : wiring.findEntries("/", "*", 1)) {
                        wiringEntryUrls.add(url.getPath().substring(1));
                    }
                    Assert.assertEquals((String)"Wrong number of wiring entry URLs.", (long)entries.size(), (long)wiringEntryUrls.size());
                    Assert.assertTrue((String)("Wrong wiring entry URLs: " + String.valueOf(wiringEntryUrls)), (boolean)entries.containsAll(wiringEntryUrls));
                    String txtPathDir = "org/eclipse/osgi/tests/bundles/resources/";
                    String txtPath = txtPathDir + String.valueOf(id) + ".txt";
                    Optional<ConnectContent.ConnectEntry> txtConnectEntry = m.getContent().getEntry(txtPath);
                    Assert.assertTrue((String)"Could not find text entry.", (boolean)txtConnectEntry.isPresent());
                    this.checkEntry(txtConnectEntry.get(), b.getEntry(txtPath), id);
                    this.checkEntry(txtConnectEntry.get(), b.getResource(txtPath), id);
                    Enumeration found = b.findEntries(txtPathDir, "*.txt", false);
                    this.checkEntry(txtConnectEntry.get(), (URL)found.nextElement(), id);
                    Assert.assertFalse((String)"More entries found.", (boolean)found.hasMoreElements());
                    String slashTxtPath = "/" + txtPath;
                    this.checkEntry(txtConnectEntry.get(), b.getEntry(slashTxtPath), id);
                    this.checkEntry(txtConnectEntry.get(), b.getResource(slashTxtPath), id);
                    found = b.findEntries("/" + txtPathDir, "*.txt", false);
                    this.checkEntry(txtConnectEntry.get(), (URL)found.nextElement(), id);
                    Assert.assertFalse((String)"More entries found.", (boolean)found.hasMoreElements());
                    URLConverter converter = (URLConverter)f.getBundleContext().getService(f.getBundleContext().getServiceReference(URLConverter.class));
                    URL connectEntry = b.getEntry(txtPath);
                    URL resolvedEntry = converter.resolve(connectEntry);
                    if (provideLoader) {
                        Assert.assertNotEquals((String)"Should not be equal", (Object)connectEntry, (Object)resolvedEntry);
                        continue;
                    }
                    Assert.assertEquals((String)"Should be equal", (Object)connectEntry, (Object)resolvedEntry);
                }
            }
            catch (Throwable t) {
                ConnectTests.sneakyThrow(t);
            }
        });
    }

    @Test
    public void testOpenCloseUpdateConnectContent() {
        String NAME1 = "testUpdate.1";
        String NAME2 = "testUpdate.2";
        TestCountingModuleConnector connector = new TestCountingModuleConnector();
        TestConnectModule m = this.createSimpleHeadersModule("testUpdate.1");
        connector.setModule("testUpdate.1", m);
        this.doTestConnect(connector, Collections.emptyMap(), f -> {
            try {
                f.start();
                Bundle b = f.getBundleContext().installBundle("testUpdate.1");
                Assert.assertEquals((String)"Wrong name.", (Object)"testUpdate.1", (Object)b.getSymbolicName());
                Assert.assertNull((Object)b.getEntry("doesNotExist.txt"));
                TestConnectContent original = m.getContent();
                Assert.assertTrue((String)"Original content is not open.", (boolean)original.isOpen());
                m.setContent(this.createSimpleHeadersContent("testUpdate.2"));
                FrameworkWiring fwkWiring = (FrameworkWiring)f.adapt(FrameworkWiring.class);
                CountDownLatch refreshDone = new CountDownLatch(1);
                fwkWiring.refreshBundles(Collections.singletonList(b), new FrameworkListener[]{e -> refreshDone.countDown()});
                refreshDone.await();
                Assert.assertEquals((String)"Wrong name.", (Object)"testUpdate.1", (Object)b.getSymbolicName());
                Assert.assertTrue((String)"Original content is not open.", (boolean)original.isOpen());
                b.update();
                Assert.assertEquals((String)"Wrong name.", (Object)"testUpdate.2", (Object)b.getSymbolicName());
                Assert.assertNull((Object)b.getEntry("doesNotExist.txt"));
                TestConnectContent newContent = m.getContent();
                Assert.assertTrue((String)"New content is not open.", (boolean)newContent.isOpen());
                Assert.assertFalse((String)"Original content is open.", (boolean)original.isOpen());
                b.update();
                Assert.assertNull((Object)b.getEntry("doesNotExist.txt"));
                Assert.assertTrue((String)"New content is not open.", (boolean)newContent.isOpen());
                Assert.assertFalse((String)"Original content is open.", (boolean)original.isOpen());
            }
            catch (Throwable t) {
                ConnectTests.sneakyThrow(t);
            }
        });
    }

    @Test
    public void testConnectBundleHeaders() throws IOException {
        this.doTestConnectBundleHeaders(false, false);
        this.doTestConnectBundleHeaders(true, false);
        this.doTestConnectBundleHeaders(false, true);
        this.doTestConnectBundleHeaders(true, true);
    }

    void doTestConnectBundleHeaders(boolean withSignedHook, boolean withManifest) throws IOException {
        String NAME1 = "bundle1";
        String NAME2 = "bundle2";
        TestCountingModuleConnector connector = new TestCountingModuleConnector();
        TestConnectModule m = withManifest ? this.createSimpleManifestModule("bundle1") : this.createSimpleHeadersModule("bundle1");
        connector.setModule("bundle1", m);
        this.doTestConnect(connector, Collections.emptyMap(), f -> {
            try {
                f.start();
                Bundle b = f.getBundleContext().installBundle("bundle1");
                Dictionary headers1 = b.getHeaders();
                Assert.assertEquals((String)"Wrong name.", (Object)"bundle1", (Object)b.getSymbolicName());
                if (withManifest) {
                    Assert.assertEquals((String)"Wrong symbolic name header.", (Object)"bundle1", headers1.get("Bundle-SymbolicName"));
                } else {
                    this.checkHeaders(m.getContent().getHeaders().get(), headers1);
                }
                m.setContent(withManifest ? this.createSimpleManifestContent("bundle2") : this.createSimpleHeadersContent("bundle2"));
                b.update();
                Dictionary headers2 = b.getHeaders();
                Assert.assertNotEquals((String)"Headers not updated", (Object)headers1, (Object)headers2);
                Assert.assertEquals((String)"Wrong name.", (Object)"bundle2", (Object)b.getSymbolicName());
                if (withManifest) {
                    Assert.assertEquals((String)"Wrong symbolic name header.", (Object)"bundle2", headers2.get("Bundle-SymbolicName"));
                } else {
                    this.checkHeaders(m.getContent().getHeaders().get(), headers2);
                }
                b.uninstall();
            }
            catch (Throwable t) {
                ConnectTests.sneakyThrow(t);
            }
        }, withSignedHook);
    }

    @Test
    public void testGetConnectHeaders() throws Exception {
        String NAME = "bundle";
        AtomicReference headers1 = new AtomicReference();
        AtomicReference headers2 = new AtomicReference();
        TestCountingModuleConnector connector = new TestCountingModuleConnector();
        TestConnectModule m = this.createSimpleHeadersModule("bundle");
        connector.setModule("bundle", m);
        this.doTestConnect(connector, Collections.emptyMap(), f -> {
            try {
                f.start();
                Bundle b = f.getBundleContext().installBundle("bundle");
                Assert.assertEquals((String)"Wrong name.", (Object)"bundle", (Object)b.getSymbolicName());
                headers1.set(b.getHeaders());
                f.stop();
                f.waitForStop(5000L);
            }
            catch (Throwable t) {
                ConnectTests.sneakyThrow(t);
            }
        });
        this.doTestConnect(connector, Collections.singletonMap("osgi.hook.configurators.exclude", "org.eclipse.equinox.weaving.hooks.WeavingHook"), f -> {
            try {
                f.start();
                Bundle b = f.getBundleContext().getBundle("bundle");
                Assert.assertFalse((String)"Content is not closed", (boolean)m.getContent().isOpen());
                headers2.set(b.getHeaders());
                Assert.assertTrue((String)"Content is not open", (boolean)m.getContent().isOpen());
                f.stop();
                f.waitForStop(5000L);
            }
            catch (Throwable t) {
                ConnectTests.sneakyThrow(t);
            }
        });
        Dictionary h1 = (Dictionary)headers1.get();
        Dictionary h2 = (Dictionary)headers2.get();
        Assert.assertEquals((String)"Headers size not equal", (long)h1.size(), (long)h2.size());
        Enumeration keys = h1.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Assert.assertEquals((String)(key + " header value not equal"), h1.get(key), h2.get(key));
        }
    }

    @Test
    public void testInstallUpdateWithInputStream() throws Exception {
        this.dotestInstallUpdate(false, false);
        this.dotestInstallUpdate(false, true);
        this.dotestInstallUpdate(true, false);
        this.dotestInstallUpdate(true, true);
    }

    void dotestInstallUpdate(boolean installWithInputStream, boolean updateWithInputStream) throws Exception {
        InputStream in1 = installWithInputStream ? new URL(installer.getBundleLocation("test")).openStream() : null;
        InputStream in2 = updateWithInputStream ? new URL(installer.getBundleLocation("test2")).openStream() : null;
        String NAME1 = installWithInputStream ? "test1" : "bundle1";
        String NAME2 = updateWithInputStream ? "test2" : "bundle2";
        TestCountingModuleConnector connector = new TestCountingModuleConnector();
        TestConnectModule m = this.createSimpleHeadersModule(NAME1);
        connector.setModule(NAME1, m);
        this.doTestConnect(connector, Collections.emptyMap(), f -> {
            try {
                try {
                    f.start();
                    Bundle test = f.getBundleContext().installBundle(NAME1, in1);
                    Assert.assertEquals((String)"Wrong name.", (Object)NAME1, (Object)test.getSymbolicName());
                    if (installWithInputStream) {
                        Assert.assertNotNull((String)"Resource not found", (Object)test.getResource("stuff/data/resource1"));
                    }
                    m.setContent(this.createSimpleHeadersContent(NAME2));
                    test.update(in2);
                    Assert.assertEquals((String)"Wrong name.", (Object)NAME2, (Object)test.getSymbolicName());
                    if (updateWithInputStream) {
                        Assert.assertNotNull((String)"Resource not found", (Object)test.getResource("stuff/data/resource2"));
                    }
                    f.stop();
                    f.waitForStop(5000L);
                }
                catch (Throwable t) {
                    ConnectTests.sneakyThrow(t);
                    this.cleanStorage();
                }
            }
            finally {
                this.cleanStorage();
            }
        });
    }

    @Test
    public void testSystemBundleContent() {
        TestCountingModuleConnector connector = new TestCountingModuleConnector();
        Bundle systemBundle = this.getContext().getBundle("System Bundle");
        HashMap<String, String> headers = new HashMap<String, String>(FrameworkUtil.asMap((Dictionary)systemBundle.getHeaders()));
        headers.put("test.key", "test.value");
        TestConnectModule systemModule = new TestConnectModule(new TestConnectContent(headers, ((BundleWiring)systemBundle.adapt(BundleWiring.class)).getClassLoader()));
        connector.setModule("System Bundle", systemModule);
        Consumer<Framework> test = f -> {
            try {
                f.init();
                Dictionary h = f.getHeaders();
                Assert.assertEquals((String)"Wrong system BSN", (Object)systemBundle.getSymbolicName(), (Object)f.getSymbolicName());
                Assert.assertEquals((String)"Wrong test value", (Object)"test.value", h.get("test.key"));
            }
            catch (Throwable t) {
                ConnectTests.sneakyThrow(t);
            }
        };
        this.doTestConnect(connector, Collections.emptyMap(), test);
        this.doTestConnect(connector, Collections.emptyMap(), test);
    }

    @Test
    public void testJavaExportsConnect() {
        TestCountingModuleConnector connector = new TestCountingModuleConnector();
        connector.setModule("javaExport", this.createJavaExportModule());
        this.doTestConnect(connector, Collections.emptyMap(), f -> {
            try {
                f.start();
                Bundle b = f.getBundleContext().installBundle("javaExport");
                b.start();
                Assert.assertTrue((String)"No java export found.", (boolean)((BundleWiring)b.adapt(BundleWiring.class)).getCapabilities("osgi.wiring.package").stream().findFirst().map(c -> "java.test.export".equals(c.getAttributes().get("osgi.wiring.package"))).orElse(false));
            }
            catch (Throwable t) {
                ConnectTests.sneakyThrow(t);
            }
        });
    }

    private ConnectModule createJavaExportModule() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-SymbolicName", "javaExport");
        headers.put("Export-Package", "java.test.export");
        TestConnectContent c = new TestConnectContent(headers, null);
        return new TestConnectModule(c);
    }

    private void checkHeaders(Map<String, String> expected, Dictionary<String, String> actual) {
        Assert.assertEquals((String)"Headers size not equals", (long)expected.size(), (long)actual.size());
        for (Map.Entry<String, String> entry : expected.entrySet()) {
            String key = entry.getKey();
            Assert.assertEquals((String)(key + " header value not equal"), (Object)entry.getValue(), (Object)actual.get(key));
        }
    }

    void checkEntry(ConnectContent.ConnectEntry expected, URL actual, Integer id) throws IOException {
        Assert.assertNotNull((String)"No entry found.", (Object)actual);
        Assert.assertEquals((String)"Wrong path.", (Object)expected.getName(), (Object)actual.getPath().substring(1));
        URLConnection connection = actual.openConnection();
        Assert.assertEquals((String)"Wrong last modified.", (long)expected.getLastModified(), (long)connection.getLastModified());
        Assert.assertEquals((String)"Wrong content length.", (long)expected.getContentLength(), (long)connection.getContentLengthLong());
        byte[] expectedBytes = ConnectTests.getBytes(expected.getInputStream());
        byte[] actualBytes = ConnectTests.getBytes(connection.getInputStream());
        Assert.assertEquals((String)"Wrong input steam size.", (long)expectedBytes.length, (long)actualBytes.length);
        int i = 0;
        while (i < expectedBytes.length) {
            Assert.assertEquals((String)("Wrong byte at: " + i), (long)expectedBytes[i], (long)actualBytes[i]);
            ++i;
        }
        String actualString = new String(actualBytes);
        Assert.assertEquals((String)"Wrong entry string.", (Object)id.toString(), (Object)actualString.trim());
    }

    TestConnectModule createSimpleHeadersModule(String name) {
        return new TestConnectModule(this.createSimpleHeadersContent(name));
    }

    TestConnectContent createSimpleHeadersContent(String name) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-SymbolicName", name);
        headers.put("Import-Package", "org.osgi.framework");
        return new TestConnectContent(headers, null);
    }

    TestConnectModule createSimpleManifestModule(String name) throws IOException {
        return new TestConnectModule(this.createSimpleManifestContent(name));
    }

    TestConnectContent createSimpleManifestContent(String name) throws IOException {
        Manifest manifest = new Manifest();
        Attributes headers = manifest.getMainAttributes();
        headers.putValue("Manifest-Version", "1");
        headers.putValue("Bundle-ManifestVersion", "2");
        headers.putValue("Bundle-SymbolicName", name);
        headers.putValue("Import-Package", "org.osgi.framework");
        ByteArrayOutputStream manifestBytes = new ByteArrayOutputStream();
        manifest.write(manifestBytes);
        TestConnectContent c = new TestConnectContent(null, null);
        this.addEntry("META-INF/MANIFEST.MF", manifestBytes.toByteArray(), c);
        return c;
    }

    TestConnectModule createAdvancedModule(Integer id, boolean provideLoader) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-SymbolicName", id.toString());
        headers.put("Import-Package", "org.osgi.framework");
        headers.put("Bundle-Activator", Activator.class.getName() + String.valueOf(id));
        TestConnectContent c = new TestConnectContent(headers, provideLoader ? this.getClass().getClassLoader() : null);
        this.addEntry("org/", c);
        this.addEntry("org/eclipse/", c);
        this.addEntry("org/eclipse/osgi/", c);
        this.addEntry("org/eclipse/osgi/tests/", c);
        this.addEntry("org/eclipse/osgi/tests/bundles/", c);
        this.addEntry("org/eclipse/osgi/tests/bundles/classes/", c);
        this.addEntry("org/eclipse/osgi/tests/bundles/classes/Activator.class", c);
        this.addEntry("org/eclipse/osgi/tests/bundles/classes/Activator" + String.valueOf(id) + ".class", c);
        this.addEntry("org/eclipse/osgi/tests/bundles/resources/", c);
        this.addEntry("org/eclipse/osgi/tests/bundles/resources/" + String.valueOf(id) + ".txt", c);
        return new TestConnectModule(c);
    }

    void addEntry(String name, TestConnectContent content) {
        content.addEntry(name, new TestConnectEntryURL(name, this.getClass().getResource("/" + name)));
    }

    void addEntry(String name, byte[] bytes, TestConnectContent content) {
        content.addEntry(name, new TestConnectEntryBytes(name, bytes));
    }

    static byte[] getBytes(InputStream in) throws IOException {
        byte[] classbytes;
        int bytesread = 0;
        try {
            byte[] oldbytes;
            int length = 1024;
            classbytes = new byte[length];
            while (true) {
                if (bytesread < length) {
                    int readcount = in.read(classbytes, bytesread, length - bytesread);
                    if (readcount <= 0) break;
                    bytesread += readcount;
                    continue;
                }
                oldbytes = classbytes;
                classbytes = new byte[length += 1024];
                System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
            }
            if (classbytes.length > bytesread) {
                oldbytes = classbytes;
                classbytes = new byte[bytesread];
                System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return classbytes;
    }

    public static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    public static class TestConnectContent
    implements ConnectContent {
        private final Map<String, String> headers;
        private final Map<String, ConnectContent.ConnectEntry> entries = new LinkedHashMap<String, ConnectContent.ConnectEntry>();
        private final ClassLoader loader;
        private final AtomicBoolean isOpen = new AtomicBoolean();

        public TestConnectContent(Map<String, String> headers, ClassLoader loader) {
            this.headers = headers;
            this.loader = loader;
        }

        public Optional<Map<String, String>> getHeaders() {
            this.checkOpen();
            return Optional.ofNullable(this.headers);
        }

        public Iterable<String> getEntries() throws IOException {
            this.checkOpen();
            return this.entries.keySet();
        }

        public Optional<ConnectContent.ConnectEntry> getEntry(String name) {
            this.checkOpen();
            return Optional.ofNullable(this.entries.get(name));
        }

        public Optional<ClassLoader> getClassLoader() {
            this.checkOpen();
            return Optional.ofNullable(this.loader);
        }

        public void open() throws IOException {
            if (!this.isOpen.compareAndSet(false, true)) {
                throw new IllegalStateException("Already Opened.");
            }
        }

        public void close() throws IOException {
            if (!this.isOpen.compareAndSet(true, false)) {
                throw new IllegalStateException("Already Closed.");
            }
        }

        void addEntry(String path, ConnectContent.ConnectEntry entry) {
            this.entries.put(path, entry);
        }

        private void checkOpen() {
            if (!this.isOpen.get()) {
                throw new IllegalStateException("Not Opened.");
            }
        }

        boolean isOpen() {
            return this.isOpen.get();
        }
    }

    public static class TestConnectEntryBytes
    implements ConnectContent.ConnectEntry {
        private final String name;
        private final byte[] bytes;

        public TestConnectEntryBytes(String name, byte[] bytes) {
            this.name = name;
            this.bytes = bytes;
        }

        public String getName() {
            return this.name;
        }

        public long getContentLength() {
            return this.bytes.length;
        }

        public long getLastModified() {
            return 0L;
        }

        public byte[] getBytes() {
            return (byte[])this.bytes.clone();
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    public static class TestConnectEntryURL
    implements ConnectContent.ConnectEntry {
        private final String name;
        private final URL content;

        public TestConnectEntryURL(String name, URL content) {
            this.name = name;
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public long getContentLength() {
            try {
                return this.content.openConnection().getContentLengthLong();
            }
            catch (IOException e) {
                return 0L;
            }
        }

        public long getLastModified() {
            try {
                return this.content.openConnection().getLastModified();
            }
            catch (IOException e) {
                return 0L;
            }
        }

        public InputStream getInputStream() throws IOException {
            return this.content.openStream();
        }
    }

    public static class TestConnectModule
    implements ConnectModule {
        private volatile TestConnectContent content;

        public TestConnectModule(TestConnectContent content) {
            this.content = content;
        }

        public TestConnectContent getContent() {
            return this.content;
        }

        void setContent(TestConnectContent updatedContent) {
            this.content = updatedContent;
        }
    }

    public static class TestCountingModuleConnector
    implements ModuleConnector {
        private final AtomicInteger initializeCalled = new AtomicInteger();
        private final Queue<String> getModuleCalled = new ConcurrentLinkedQueue<String>();
        private final AtomicInteger createBundleActivatorCalled = new AtomicInteger();
        private final Map<String, ConnectModule> modules = new ConcurrentHashMap<String, ConnectModule>();

        public void initialize(File storage, Map<String, String> config) {
            this.initializeCalled.getAndIncrement();
        }

        public Optional<ConnectModule> connect(String location) throws BundleException {
            this.getModuleCalled.add(location);
            ConnectModule m = this.modules.get(location);
            if (m == BUNDLE_EXCEPTION) {
                throw new BundleException("Test fail install with getModule");
            }
            return Optional.ofNullable(m);
        }

        public Optional<BundleActivator> newBundleActivator() {
            this.createBundleActivatorCalled.getAndIncrement();
            return Optional.empty();
        }

        int getInitializeCnt() {
            return this.initializeCalled.get();
        }

        List<String> getModuleLocations() {
            return new ArrayList<String>(this.getModuleCalled);
        }

        int getCreateBundleActivatorCnt() {
            return this.createBundleActivatorCalled.get();
        }

        void setModule(String location, ConnectModule module) {
            if (module == null) {
                this.modules.remove(location);
            } else {
                this.modules.put(location, module);
            }
        }
    }
}

