/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.SystemBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

public class DiscardBundleTests
extends AbstractBundleTests {
    private static final String BUNDLE_DIR = "discardable";
    private static final String BUNDLE_JAR = "discardable.jar";
    private static final String BUNDLE_MANIFEST = "META-INF/MANIFEST.MF";
    private static final String OSGI_DEV = "osgi.dev";
    private static final String OSGI_CHECKCONFIGURATION = "osgi.checkConfiguration";
    private static final String REFERENCE_PROTOCOL = "reference:";
    private File root;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.root = OSGiTestsActivator.getContext().getDataFile(this.getName());
        this.root.mkdirs();
        this.createBundleDirectory();
        this.createBundleJar();
    }

    @Test
    public void testDiscardOsgiCheckConfigurationTrueOsgiDevSpecified() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(OSGI_CHECKCONFIGURATION, Boolean.TRUE.toString());
        configuration.put(OSGI_DEV, "");
        this.doTest(configuration, true);
    }

    @Test
    public void testDiscardOsgiCheckConfigurationTrueOsgiDevUnspecified() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(OSGI_CHECKCONFIGURATION, Boolean.TRUE.toString());
        this.doTest(configuration, true);
    }

    @Test
    public void testDiscardOsgiCheckConfigurationUnspecifiedOsgiDevSpecified() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(OSGI_DEV, "");
        this.doTest(configuration, true);
    }

    @Test
    public void testNoDiscardOsgiCheckConfigurationFalseOsgiDevSpecified() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(OSGI_CHECKCONFIGURATION, Boolean.FALSE.toString());
        configuration.put(OSGI_DEV, "");
        this.doTest(configuration, false);
    }

    @Test
    public void testNoDiscardOsgiCheckConfigurationFalseOsgiDevUnspecified() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(OSGI_CHECKCONFIGURATION, Boolean.FALSE.toString());
        this.doTest(configuration, false);
    }

    @Test
    public void testNoDiscardOsgiCheckConfigurationUnspecifiedOsgiDevUnspecified() throws Exception {
        this.doTest(this.createConfiguration(), false);
    }

    @Test
    public void testDiscardDeletedBundleFile() throws Exception {
        this.doTestDiscardDeletedBundleFile(this.getDirectoryLocation());
        this.doTestDiscardDeletedBundleFile(this.getJarLocation());
    }

    @Test
    public void testLimitResolutionAfterDiscard() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(OSGI_CHECKCONFIGURATION, Boolean.TRUE.toString());
        Equinox equinox = new Equinox(configuration);
        this.initAndStart(equinox);
        try {
            File discard = SystemBundleTests.createBundle(this.root, "discard", Collections.singletonMap("Export-Package", "discard"), new Map[0]);
            String discardLocation = REFERENCE_PROTOCOL + String.valueOf(discard.toURI());
            File importDiscard = SystemBundleTests.createBundle(this.root, "importDiscard", Collections.singletonMap("Import-Package", "discard; resolution:=optional"), new Map[0]);
            String importDiscardLocation = REFERENCE_PROTOCOL + String.valueOf(importDiscard.toURI());
            Hashtable<String, String> extensionHeaders = new Hashtable<String, String>();
            extensionHeaders.put("Fragment-Host", "system.bundle");
            extensionHeaders.put("Bundle-ManifestVersion", "2");
            extensionHeaders.put("Bundle-SymbolicName", "discardExtension");
            extensionHeaders.put("Export-Package", "discard.extension");
            File discardExtension = SystemBundleTests.createBundle(this.root, "discardExtension", extensionHeaders, new Map[0]);
            String discardExtensionLocation = REFERENCE_PROTOCOL + String.valueOf(discardExtension.toURI());
            extensionHeaders.remove("Export-Package");
            extensionHeaders.put("Bundle-SymbolicName", "importDiscardExtension");
            extensionHeaders.put("Import-Package", "discard.extesion; resolution:=optional");
            File importDiscardExtension = SystemBundleTests.createBundle(this.root, "importDiscardExtension", extensionHeaders, new Map[0]);
            String importDiscardExtensionLocation = REFERENCE_PROTOCOL + String.valueOf(importDiscardExtension.toURI());
            equinox.getBundleContext().installBundle(discardLocation).start();
            equinox.getBundleContext().installBundle(importDiscardLocation).start();
            equinox.getBundleContext().installBundle(discardExtensionLocation);
            equinox.getBundleContext().installBundle(importDiscardExtensionLocation);
            Assert.assertEquals((String)"Wrong number of bundles.", (long)5L, (long)equinox.getBundleContext().getBundles().length);
            DiscardBundleTests.stop((Framework)equinox);
            this.touchFile(discard);
            this.touchFile(discardExtension);
            equinox = new Equinox(configuration);
            equinox.init();
            this.assertDiscarded(discardLocation, equinox);
            Assert.assertEquals((String)"importDiscard should be in the installed state", (long)2L, (long)equinox.getBundleContext().getBundle(importDiscardLocation).getState());
            Assert.assertEquals((String)"importDiscardExtension should be in the resolved state", (long)4L, (long)equinox.getBundleContext().getBundle(importDiscardExtensionLocation).getState());
            Assert.assertEquals((String)"Wrong number of bundles.", (long)3L, (long)equinox.getBundleContext().getBundles().length);
        }
        finally {
            DiscardBundleTests.stopQuietly((Framework)equinox);
        }
    }

    private void doTestDiscardDeletedBundleFile(File bundleFile) throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        Equinox equinox = new Equinox(configuration);
        this.initAndStart(equinox);
        try {
            String location = REFERENCE_PROTOCOL + String.valueOf(bundleFile.toURI());
            equinox.getBundleContext().installBundle(location);
            equinox = this.restart(equinox, configuration);
            this.assertNotDiscarded(location, equinox);
            DiscardBundleTests.stop((Framework)equinox);
            DiscardBundleTests.delete(bundleFile);
            equinox = this.restart(equinox, configuration);
            this.assertDiscarded(location, equinox);
        }
        finally {
            DiscardBundleTests.stopQuietly((Framework)equinox);
        }
    }

    private void assertDiscarded(String location, Equinox equinox) {
        Assert.assertNull((String)"The bundle was not discarded", (Object)equinox.getBundleContext().getBundle(location));
    }

    private void assertNotDiscarded(String location, Equinox equinox) {
        Assert.assertNotNull((String)"The bundle was discarded", (Object)equinox.getBundleContext().getBundle(location));
    }

    private void createBundleDirectory() throws IOException {
        File file = new File(this.root, "discardable/META-INF/MANIFEST.MF");
        Assert.assertTrue((String)"Could not make directories", (boolean)file.getParentFile().mkdirs());
        Manifest manifest = this.createBundleManifest();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream fos = new FileOutputStream(file);){
            manifest.write(fos);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createBundleJar() throws IOException {
        Manifest manifest = this.createBundleManifest();
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(new File(this.root, BUNDLE_JAR)), manifest);
        target.close();
    }

    private Manifest createBundleManifest() {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().putValue("Bundle-SymbolicName", BUNDLE_DIR);
        return manifest;
    }

    private void doTest(Map<String, ?> configuration, boolean discard) throws Exception {
        this.doTest(configuration, discard, this.getDirectoryLocation());
        this.doTest(configuration, discard, this.getJarLocation());
    }

    private void doTest(Map<String, ?> configuration, boolean discard, File bundleFile) throws Exception {
        Equinox equinox = new Equinox(configuration);
        this.initAndStart(equinox);
        try {
            String location = REFERENCE_PROTOCOL + String.valueOf(bundleFile.toURI());
            equinox.getBundleContext().installBundle(location);
            try {
                equinox = this.restart(equinox, configuration);
                this.assertNotDiscarded(location, equinox);
                DiscardBundleTests.stop((Framework)equinox);
                this.touchFile(bundleFile);
                equinox = this.restart(equinox, configuration);
                if (discard) {
                    this.assertDiscarded(location, equinox);
                } else {
                    this.assertNotDiscarded(location, equinox);
                }
            }
            finally {
                try {
                    equinox.getBundleContext().getBundle(location).uninstall();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            DiscardBundleTests.stopQuietly((Framework)equinox);
        }
    }

    private File getDirectoryLocation() {
        return new File(this.root, BUNDLE_DIR);
    }

    private File getJarLocation() {
        return new File(this.root, BUNDLE_JAR);
    }

    private Equinox restart(Equinox equinox, Map<String, ?> configuration) throws BundleException {
        DiscardBundleTests.stop((Framework)equinox);
        equinox = new Equinox(configuration);
        this.initAndStart(equinox);
        return equinox;
    }

    private void touchFile(File file) {
        if (file.isDirectory()) {
            file = new File(file, BUNDLE_MANIFEST);
        }
        Assert.assertTrue((String)("Could not set last modified: " + String.valueOf(file)), (boolean)file.setLastModified(file.lastModified() + 1000L));
    }
}

