/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.File;
import java.net.URL;
import java.security.Permission;
import java.security.ProtectionDomain;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.securityadmin.SecurityManagerTests;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class EquinoxBundleAdaptTests
extends AbstractBundleTests {
    @Test
    public void testAdapt_Module() throws Exception {
        Bundle bundle = installer.installBundle("test");
        Module module = (Module)bundle.adapt(Module.class);
        Assert.assertEquals((Object)((EquinoxBundle)bundle).getModule(), (Object)module);
    }

    @Test
    public void testAdapt_ProtectionDomain() throws Exception {
        Assume.assumeTrue((String)"Security-Manager is disallowed", (boolean)SecurityManagerTests.isSecurityManagerAllowed());
        Bundle bundle = installer.installBundle("test");
        SecurityManager previousSM = System.getSecurityManager();
        try {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm) {
                }
            });
            ProtectionDomain domain = (ProtectionDomain)bundle.adapt(ProtectionDomain.class);
            Assert.assertNotNull((Object)domain);
        }
        finally {
            System.setSecurityManager(previousSM);
        }
    }

    @Test
    public void testAdapt_SignedContent() throws Exception {
        Bundle bundle = installer.installBundle("test");
        SignedContent content = (SignedContent)bundle.adapt(SignedContent.class);
        Assert.assertNotNull((Object)content);
    }

    @Test
    public void testAdapt_File() throws Exception {
        URL testBundleURL = FrameworkUtil.getBundle(EquinoxBundleAdaptTests.class).getEntry(".");
        File testBundleRoot = new File(FileLocator.toFileURL((URL)testBundleURL).toURI()).getCanonicalFile();
        Bundle bundle = installer.installBundle("test");
        File file = ((File)bundle.adapt(File.class)).getCanonicalFile();
        Assert.assertEquals((Object)new File(testBundleRoot, "bundle_tests"), (Object)file.getParentFile());
        Assert.assertEquals((Object)"test", (Object)file.getName().replace(".jar", ""));
    }
}

