/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.SystemBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.startlevel.BundleStartLevel;

public class ExceptionMessageTest
extends AbstractBundleTests {
    @Test
    public void testTrasientStartLevelError() throws BundleException {
        Bundle b = installer.installBundle("test");
        ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(500);
        BundleException e = (BundleException)Assert.assertThrows(BundleException.class, () -> b.start(1));
        Assert.assertTrue((String)("Wrong message: " + e.getMessage()), (boolean)e.getMessage().endsWith(((Module)b.adapt(Module.class)).toString()));
    }

    @Test
    public void testUninstallModuleError() throws BundleException {
        Bundle b = installer.installBundle("test");
        BundleStartLevel bsl = (BundleStartLevel)b.adapt(BundleStartLevel.class);
        b.uninstall();
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> {
            int n = bsl.getStartLevel();
        });
        Assert.assertTrue((String)("Wrong message: " + e.getMessage()), (boolean)e.getMessage().endsWith(((Module)b.adapt(Module.class)).toString()));
    }

    @Test
    public void testStartFragmentError() throws BundleException, IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "fragment");
        headers.put("Fragment-Host", "host");
        File bundles = OSGiTestsActivator.getContext().getDataFile("/");
        File bundleFile = SystemBundleTests.createBundle(bundles, this.getName(), headers, new Map[0]);
        Bundle b = OSGiTestsActivator.getContext().installBundle(bundleFile.toURI().toString());
        BundleException e = (BundleException)Assert.assertThrows(BundleException.class, () -> b.start());
        b.uninstall();
        Assert.assertTrue((String)("Wrong message: " + e.getMessage()), (boolean)e.getMessage().endsWith(((Module)b.adapt(Module.class)).toString()));
    }

    @Test
    public void testLoadActivatorError() throws IOException, BundleException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-Activator", "does.not.Exist");
        headers.put("Bundle-SymbolicName", "no.activator");
        File bundles = OSGiTestsActivator.getContext().getDataFile("/");
        File bundleFile = SystemBundleTests.createBundle(bundles, this.getName(), headers, new Map[0]);
        Bundle b = OSGiTestsActivator.getContext().installBundle(bundleFile.toURI().toString());
        BundleException e = (BundleException)Assert.assertThrows(BundleException.class, () -> b.start());
        Assert.assertTrue((String)("Wrong message: " + e.getMessage()), (boolean)e.getMessage().endsWith(b.toString()));
    }

    @Test
    public void testUnregisterSetPropsError() throws BundleException {
        Bundle b = installer.installBundle("test");
        b.start();
        Dictionary<String, Object> props1 = this.getDicinotary("k1", "v1");
        ServiceRegistration reg = b.getBundleContext().registerService(Object.class, new Object(), props1);
        reg.unregister();
        Dictionary<String, Object> props2 = this.getDicinotary("k2", "v2");
        IllegalStateException e1 = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> reg.setProperties(props2));
        Assert.assertTrue((String)("Wrong message: " + e1.getMessage()), (boolean)e1.getMessage().endsWith(reg.toString()));
        IllegalStateException e3 = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> {
            ServiceReference serviceReference = reg.getReference();
        });
        Assert.assertTrue((String)("Wrong message: " + e3.getMessage()), (boolean)e3.getMessage().endsWith(reg.toString()));
    }

    private Dictionary<String, Object> getDicinotary(String key, Object value) {
        return FrameworkUtil.asDictionary(Collections.singletonMap(key, value));
    }
}

