/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class ExtensionBundleTests
extends AbstractBundleTests {
    public static List<String> events = new ArrayList<String>();

    @Test
    public void testFrameworkExtension01() throws Exception {
        Bundle fwkext = installer.installBundle("ext.framework.a", false);
        Bundle importer = installer.installBundle("ext.framework.a.importer");
        installer.resolveBundles(new Bundle[]{fwkext, importer});
        importer.start();
        importer.stop();
        Object[] results = simpleResults.getResults(2);
        Assert.assertTrue((String)"1.0", (results.length == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"1.1", (Object)"success", (Object)results[0]);
        Assert.assertEquals((String)"1.2", (Object)"success", (Object)results[1]);
    }

    @Test
    public void testFrameworkExtension02() throws Exception {
        Bundle fwkext = installer.installBundle("ext.framework.a", false);
        Bundle importer = installer.installBundle("ext.framework.a.requires");
        installer.resolveBundles(new Bundle[]{fwkext, importer});
        importer.start();
        importer.stop();
        Object[] results = simpleResults.getResults(2);
        Assert.assertTrue((String)"1.0", (results.length == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"1.1", (Object)"success", (Object)results[0]);
        Assert.assertEquals((String)"1.2", (Object)"success", (Object)results[1]);
    }

    @Test
    public void testExtClasspathExtension01() throws Exception {
        Bundle fwkext = installer.installBundle("ext.extclasspath.a", false);
        Bundle importer = installer.installBundle("ext.extclasspath.a.importer");
        installer.resolveBundles(new Bundle[]{fwkext, importer});
        importer.start();
        importer.stop();
        Object[] results = simpleResults.getResults(2);
        Assert.assertTrue((String)"1.0", (results.length == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"1.1", (Object)"success", (Object)results[0]);
        Assert.assertEquals((String)"1.2", (Object)"success", (Object)results[1]);
    }

    @Test
    public void testExtensionBundleWithRequireCapabilityOsgiEeInstalls() throws BundleException {
        Bundle b = installer.installBundle("ext.framework.osgiee.b", false);
        Assert.assertTrue((String)("Could not resolve bundle: " + String.valueOf(b)), (boolean)installer.resolveBundles(new Bundle[]{b}));
        BundleWiring wiring = (BundleWiring)b.adapt(BundleWiring.class);
        Assert.assertNotNull((String)("No wiring for bundle: " + String.valueOf(b)), (Object)wiring);
        List allRequired = wiring.getRequiredWires(null);
        Assert.assertEquals((String)("Wrong number of wires: " + String.valueOf(allRequired)), (long)2L, (long)allRequired.size());
        BundleWire hostWire = (BundleWire)wiring.getRequiredWires("osgi.wiring.host").get(0);
        Assert.assertEquals((String)("Wrong provider for host: " + String.valueOf(hostWire.getProvider().getBundle())), (long)0L, (long)hostWire.getProvider().getBundle().getBundleId());
        BundleWire eeWire = (BundleWire)wiring.getRequiredWires("osgi.ee").get(0);
        Assert.assertEquals((String)("Wrong provider for osgi.ee: " + String.valueOf(eeWire.getProvider().getBundle())), (long)0L, (long)eeWire.getProvider().getBundle().getBundleId());
    }

    @Test
    public void testActivatorOrder() throws Exception {
        Bundle b = installer.installBundle("ext.framework.a", false);
        Bundle bImp = installer.installBundle("ext.framework.a.importer");
        Bundle bReq = installer.installBundle("ext.framework.a.requires");
        installer.resolveBundles(new Bundle[]{b, bImp, bReq});
        try {
            bImp.start();
            bReq.start();
        }
        finally {
            installer.uninstallAllBundles();
        }
        List<String> expectedEvents = Arrays.asList(bImp.getSymbolicName() + " STARTED", bReq.getSymbolicName() + " STARTED", bReq.getSymbolicName() + " STOPPED", bImp.getSymbolicName() + " STOPPED");
        Assert.assertEquals((String)"Expected number of events not found", (long)expectedEvents.size(), (long)events.size());
        int i = 0;
        while (i < events.size()) {
            Assert.assertEquals((String)"Expected event not found", (Object)expectedEvents.get(i), (Object)events.get(i));
            ++i;
        }
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        events.clear();
    }
}

