/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.condition.Condition;

public class IllegalStateExceptionTests
extends AbstractBundleTests {
    @Test
    public void testUninstall() throws Exception {
        Bundle bundle = installer.installBundle("test");
        bundle.uninstall();
        bundle.uninstall();
    }

    @Test
    public void testCreateFilter() throws Exception {
        Filter testFilter = this.getInvalidContext().createFilter("(test=illegalstateexception)");
        Assert.assertNotNull((String)"Null filter returned", (Object)testFilter);
    }

    @Test
    public void testGetBundle() throws Exception {
        BundleContext invalidContext = this.getInvalidContext();
        Assert.assertNotNull((String)"Null bundle returned", (Object)invalidContext.getBundle());
        Assert.assertNotNull((String)"Null system bundle returned", (Object)invalidContext.getBundle("System Bundle"));
        Assert.assertNotNull((String)"Null system bundle returned", (Object)invalidContext.getBundle(0L));
    }

    @Test
    public void testGetProperty() throws Exception {
        BundleContext invalidContext = this.getInvalidContext();
        Assert.assertNotNull((String)"Null UUID Property", (Object)invalidContext.getProperty("org.osgi.framework.uuid"));
    }

    @Test
    public void testRemoveServiceListener() throws Exception {
        BundleContext invalidContext = this.getInvalidContext();
        invalidContext.removeServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
            }
        });
    }

    @Test
    public void testRemoveBundleListener() throws Exception {
        BundleContext invalidContext = this.getInvalidContext();
        invalidContext.removeBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
            }
        });
    }

    @Test
    public void testFrameworkListener() throws Exception {
        BundleContext invalidContext = this.getInvalidContext();
        invalidContext.removeFrameworkListener(new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
            }
        });
    }

    @Test
    public void testContextUngetService() throws Exception {
        BundleContext invalidContext = this.getInvalidContext();
        invalidContext.ungetService(this.getContext().getServiceReference("org.osgi.service.condition.Condition"));
    }

    @Test
    public void testServiceObjectsUngetService() throws Exception {
        Bundle bundle = installer.installBundle("test");
        bundle.start();
        BundleContext context = bundle.getBundleContext();
        ServiceReference ref = context.getServiceReference(Condition.class);
        ServiceObjects serviceObjects = context.getServiceObjects(ref);
        Condition c = (Condition)serviceObjects.getService();
        bundle.stop();
        serviceObjects.ungetService((Object)c);
    }

    @Test
    public void testUnregister() throws Exception {
        Bundle bundle = installer.installBundle("test");
        bundle.start();
        BundleContext context = bundle.getBundleContext();
        ServiceRegistration reg = context.registerService(Condition.class, (Object)Condition.INSTANCE, null);
        reg.unregister();
        reg.unregister();
    }

    public BundleContext getInvalidContext() throws Exception {
        Bundle bundle = installer.installBundle("test");
        bundle.start();
        BundleContext context = bundle.getBundleContext();
        bundle.stop();
        return context;
    }
}

