/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.SystemBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class ImportJavaSEPackagesTests
extends AbstractBundleTests {
    private static final String JAVA_LANG = "java.lang";
    private static final String JAVA_UTIL = "java.util";
    private static String originalSpecVersion;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        originalSpecVersion = System.getProperty("java.specification.version");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        System.setProperty("java.specification.version", originalSpecVersion);
    }

    @Test
    public void testExportPackageCannotContainJavaPackages() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-SymbolicName", this.getName());
        headers.put("Export-Package", JAVA_LANG);
        config.mkdirs();
        File bundle = SystemBundleTests.createBundle(config, this.getName(), headers, new Map[0]);
        Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
        try {
            BundleException e = (BundleException)Assert.assertThrows(BundleException.class, () -> {
                equinox.start();
                BundleContext systemContext = equinox.getBundleContext();
                Bundle testBundle = systemContext.installBundle(bundle.toURI().toString());
                testBundle.start();
            });
            Assert.assertEquals((String)"It should throw a bundle exception of type manifest error", (long)3L, (long)e.getType());
            Assert.assertTrue((String)"It should throw a Bundle Exception stating Invalid manifest header Export-Package", (boolean)e.getMessage().contains("Cannot specify java.* packages in Export headers"));
        }
        finally {
            ImportJavaSEPackagesTests.stopQuietly((Framework)equinox);
        }
    }

    @Test
    public void testImportPackageCanContainJavaPackages() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-SymbolicName", this.getName());
        headers.put("Import-Package", JAVA_LANG);
        config.mkdirs();
        File bundle = SystemBundleTests.createBundle(config, this.getName(), headers, new Map[0]);
        Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle testBundle = systemContext.installBundle(bundle.toURI().toString());
            testBundle.start();
            Dictionary testHeaders = testBundle.getHeaders();
            Assert.assertTrue((String)"Import-Package does not contain the java.* package", (boolean)((String)testHeaders.get("Import-Package")).contains(JAVA_LANG));
            List pkgWires = ((BundleWiring)testBundle.adapt(BundleWiring.class)).getRequiredWires("osgi.wiring.package");
            Assert.assertEquals((String)"Wrong number of package requiremens: ", (long)1L, (long)pkgWires.size());
            Assert.assertEquals((String)("Wrong package found: " + String.valueOf(pkgWires.get(0))), (Object)JAVA_LANG, ((BundleWire)pkgWires.get(0)).getCapability().getAttributes().get("osgi.wiring.package"));
        }
        finally {
            ImportJavaSEPackagesTests.stopQuietly((Framework)equinox);
        }
    }

    @Test
    public void testSystemPackages() throws Exception {
        HashMap<Integer, Integer> packagesPerVersion = new HashMap<Integer, Integer>();
        packagesPerVersion.put(8, 63);
        if (!originalSpecVersion.startsWith("1.")) {
            packagesPerVersion.put(9, this.calculateJavaPackageCount());
        } else {
            packagesPerVersion.put(9, 66);
        }
        for (Map.Entry entry : packagesPerVersion.entrySet()) {
            this.doSystemPackages((Integer)entry.getKey(), (Integer)entry.getValue());
        }
    }

    private int calculateJavaPackageCount() throws Exception {
        int javaPackages = 0;
        Class<?> moduleLayerClass = Class.forName("java.lang.ModuleLayer");
        Method boot = moduleLayerClass.getMethod("boot", new Class[0]);
        Method modules = moduleLayerClass.getMethod("modules", new Class[0]);
        Class<?> moduleClass = Class.forName("java.lang.Module");
        Method getDescriptor = moduleClass.getMethod("getDescriptor", new Class[0]);
        Class<?> moduleDescriptorClass = Class.forName("java.lang.module.ModuleDescriptor");
        Method exports = moduleDescriptorClass.getMethod("exports", new Class[0]);
        Method isAutomatic = moduleDescriptorClass.getMethod("isAutomatic", new Class[0]);
        Method packagesMethod = moduleDescriptorClass.getMethod("packages", new Class[0]);
        Class<?> exportsClass = Class.forName("java.lang.module.ModuleDescriptor$Exports");
        Method isQualified = exportsClass.getMethod("isQualified", new Class[0]);
        Method source = exportsClass.getMethod("source", new Class[0]);
        Object bootLayer = boot.invoke(null, new Object[0]);
        Set bootModules = (Set)modules.invoke(bootLayer, new Object[0]);
        for (Object m : bootModules) {
            Object descriptor = getDescriptor.invoke(m, new Object[0]);
            if (((Boolean)isAutomatic.invoke(descriptor, new Object[0])).booleanValue()) {
                for (String packageName : (Set)packagesMethod.invoke(descriptor, new Object[0])) {
                    if (!packageName.startsWith("java.")) continue;
                    ++javaPackages;
                }
                continue;
            }
            for (Object export : (Set)exports.invoke(descriptor, new Object[0])) {
                String pkg = (String)source.invoke(export, new Object[0]);
                if (((Boolean)isQualified.invoke(export, new Object[0])).booleanValue() || !pkg.startsWith("java.")) continue;
                ++javaPackages;
            }
        }
        return javaPackages;
    }

    public void doSystemPackages(int rv, int expectedPackages) throws Exception {
        if (rv < 9) {
            System.setProperty("java.specification.version", "1." + rv);
        } else {
            System.setProperty("java.specification.version", Integer.toString(rv));
        }
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-SymbolicName", this.getName());
        config.mkdirs();
        File bundle = SystemBundleTests.createBundle(config, this.getName(), headers, new Map[0]);
        Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Dictionary testHeaders = equinox.getHeaders();
            Assert.assertTrue((String)"Export-Package does not contain the java.lang package", (boolean)((String)testHeaders.get("Export-Package")).contains(JAVA_LANG));
            Assert.assertTrue((String)"Export-Package does not contain the java.util package", (boolean)((String)testHeaders.get("Export-Package")).contains(JAVA_UTIL));
            List capabilities = ((BundleWiring)equinox.adapt(BundleWiring.class)).getCapabilities("osgi.wiring.package");
            int count = 0;
            for (BundleCapability cap : capabilities) {
                if (!cap.getAttributes().get("osgi.wiring.package").toString().startsWith("java.")) continue;
                ++count;
            }
            Assert.assertEquals((String)("Wrong number of java.* packages for version " + rv), (long)expectedPackages, (long)count);
            Bundle testBundle = systemContext.installBundle(bundle.toURI().toString());
            testBundle.start();
            String systemPackages = testBundle.getBundleContext().getProperty("org.osgi.framework.system.packages");
            Assert.assertTrue((String)"System packages should include java.lang packages", (boolean)systemPackages.contains(JAVA_LANG));
            Assert.assertTrue((String)"System packages should include java.util packages", (boolean)systemPackages.contains(JAVA_UTIL));
        }
        finally {
            ImportJavaSEPackagesTests.stopQuietly((Framework)equinox);
        }
    }
}

