/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.TestResults;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.FrameworkStartLevel;

public class ListenerTests
extends AbstractBundleTests {
    private String methodName;
    private List<Bundle> bundles;
    private Equinox equinox;
    private BundleContext bundleContext;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.methodName = this.getName();
        simpleResults = new TestResults();
        this.bundles = new ArrayList<Bundle>();
        Map<String, Object> configuration = this.createConfiguration();
        this.equinox = new Equinox(configuration);
        this.initAndStart(this.equinox);
        this.bundleContext = this.equinox.getBundleContext();
        int i = 0;
        while (i < 50) {
            Bundle b = this.installBundle(this.methodName + i);
            this.bundles.add(b);
            b.start();
            ++i;
        }
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        simpleResults = null;
        for (Bundle b : this.bundles) {
            if (b == null) continue;
            b.stop();
            Object var1_2 = null;
        }
        ListenerTests.stopQuietly((Framework)this.equinox);
    }

    @Test
    public void testBundleListenersOrder() throws Exception {
        BundleListener bundleListener;
        Object[] expectedBundleListeners = new BundleListener[200];
        int i = 100;
        for (Bundle b : this.bundles) {
            BundleListener bundleListener2 = this.createBundleListener();
            b.getBundleContext().addBundleListener(bundleListener2);
            expectedBundleListeners[i] = bundleListener2;
            i += 2;
        }
        int j = 101;
        for (Bundle b : this.bundles) {
            bundleListener = this.createBundleListener();
            b.getBundleContext().addBundleListener(bundleListener);
            expectedBundleListeners[j] = bundleListener;
            j += 2;
        }
        i = 0;
        for (Bundle b : this.bundles) {
            bundleListener = this.createSynchronousBundleListener();
            b.getBundleContext().addBundleListener(bundleListener);
            expectedBundleListeners[i] = bundleListener;
            i += 2;
        }
        j = 1;
        for (Bundle b : this.bundles) {
            bundleListener = this.createSynchronousBundleListener();
            b.getBundleContext().addBundleListener(bundleListener);
            expectedBundleListeners[j] = bundleListener;
            j += 2;
        }
        this.installBundle(this.methodName + "51");
        Object[] actualBundleListeners = simpleResults.getResults(200);
        Assert.assertArrayEquals((Object[])expectedBundleListeners, (Object[])actualBundleListeners);
    }

    @Test
    public void testFrameworkListenersOrder() throws Exception {
        Object[] expectedFrameworkListeners = new FrameworkListener[100];
        int i = 0;
        for (Bundle b : this.bundles) {
            FrameworkListener frameworkListener = this.createFrameworkListener();
            b.getBundleContext().addFrameworkListener(frameworkListener);
            expectedFrameworkListeners[i] = frameworkListener;
            i += 2;
        }
        int j = 1;
        for (Bundle b : this.bundles) {
            FrameworkListener frameworkListener = this.createFrameworkListener();
            b.getBundleContext().addFrameworkListener(frameworkListener);
            expectedFrameworkListeners[j] = frameworkListener;
            j += 2;
        }
        ((FrameworkStartLevel)this.equinox.adapt(FrameworkStartLevel.class)).setStartLevel(5, new FrameworkListener[0]);
        Object[] actualFrameworkListeners = simpleResults.getResults(100);
        Assert.assertArrayEquals((Object[])expectedFrameworkListeners, (Object[])actualFrameworkListeners);
    }

    @Test
    public void testServiceListenersOrder() throws Exception {
        Object[] expectedServiceListeners = new ServiceListener[100];
        int i = 0;
        for (Bundle b : this.bundles) {
            ServiceListener serviceListener = this.createServiceListener();
            b.getBundleContext().addServiceListener(serviceListener);
            expectedServiceListeners[i] = serviceListener;
            i += 2;
        }
        int j = 1;
        for (Bundle b : this.bundles) {
            ServiceListener serviceListener = this.createServiceListener();
            b.getBundleContext().addServiceListener(serviceListener);
            expectedServiceListeners[j] = serviceListener;
            j += 2;
        }
        Bundle bundle = this.installBundle(this.methodName + "51");
        bundle.start();
        ServiceRegistration reg = bundle.getBundleContext().registerService(Object.class, new Object(), null);
        Object[] actualServiceListeners = simpleResults.getResults(100);
        Assert.assertArrayEquals((Object[])expectedServiceListeners, (Object[])actualServiceListeners);
        if (reg != null) {
            reg.unregister();
        }
    }

    private BundleListener createBundleListener() {
        BundleListener bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                simpleResults.addEvent(this);
            }
        };
        return bundleListener;
    }

    private BundleListener createSynchronousBundleListener() {
        SynchronousBundleListener bundleListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                simpleResults.addEvent(this);
            }
        };
        return bundleListener;
    }

    private FrameworkListener createFrameworkListener() {
        FrameworkListener frameworkListener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                simpleResults.addEvent(this);
            }
        };
        return frameworkListener;
    }

    private ServiceListener createServiceListener() {
        ServiceListener serviceListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                simpleResults.addEvent(this);
            }
        };
        return serviceListener;
    }

    private Bundle installBundle(String name) throws BundleException, IOException {
        Bundle bundle = this.bundleContext.installBundle(name, new AbstractBundleTests.BundleBuilder().symbolicName(name).build());
        Assert.assertNotNull((String)(name + " bundle does not exist"), (Object)this.bundleContext.getBundle(name));
        return bundle;
    }
}

