/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.Logger;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class LoggingTests
extends AbstractBundleTests {
    static final String EQUINOX_LOGGER = "org.eclipse.equinox.logger";

    private LogServiceReference getLogService(BundleContext bc) {
        ServiceReference logRef = bc.getServiceReference(ExtendedLogService.class.getName());
        Assert.assertNotNull((String)"log service ref is null", (Object)logRef);
        ServiceReference readerRef = bc.getServiceReference(ExtendedLogReaderService.class.getName());
        Assert.assertNotNull((String)"log reader ref is null", (Object)readerRef);
        ServiceReference fwkLogRef = bc.getServiceReference(FrameworkLog.class.getName());
        Assert.assertNotNull((String)"framework log ref is null", (Object)fwkLogRef);
        ExtendedLogService logService = (ExtendedLogService)bc.getService(logRef);
        Assert.assertNotNull((String)"log service is null", (Object)logService);
        ExtendedLogReaderService readerService = (ExtendedLogReaderService)bc.getService(readerRef);
        Assert.assertNotNull((String)"reader service is null", (Object)readerService);
        FrameworkLog fwkLog = (FrameworkLog)bc.getService(fwkLogRef);
        Assert.assertNotNull((String)"framework log is null", (Object)fwkLog);
        return new LogServiceReference(logRef, logService, readerRef, readerService, fwkLogRef, fwkLog);
    }

    @Test
    public void testLogService() throws BundleException {
        Bundle testBundle = installer.installBundle("test.logging.a");
        testBundle.start();
        BundleContext bc = testBundle.getBundleContext();
        LogServiceReference logRef = this.getLogService(bc);
        Status a = new Status(4, testBundle.getSymbolicName(), this.getName());
        ArrayList<Status> context = new ArrayList<Status>();
        context.add(a);
        TestILogListener iLogListener1 = new TestILogListener(new ArrayList(context));
        TestILogListener iLogListener2 = new TestILogListener(new ArrayList(context));
        TestLogListener logListener = new TestLogListener(new ArrayList(context));
        ILog testLog = ILog.of((Bundle)testBundle);
        testLog.addLogListener((ILogListener)iLogListener1);
        Platform.addLogListener((ILogListener)iLogListener2);
        logRef.readerService.addLogListener((LogListener)logListener, (LogFilter)logListener);
        try {
            ExtendedLogService logService = logRef.logService;
            Logger logger = logService.getLogger(testBundle, EQUINOX_LOGGER);
            logger.log((Object)a, 1, a.getMessage());
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
            iLogListener1.addContext(new ArrayList(context));
            iLogListener2.addContext(new ArrayList(context));
            logListener.addContext(new ArrayList(context));
            logger.log((Object)new FrameworkLogEntry((Object)a, testBundle.getSymbolicName(), a.getSeverity(), a.getCode(), a.getMessage(), 0, null, null), 1, a.getMessage());
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
            iLogListener1.addContext(new ArrayList(context));
            iLogListener2.addContext(new ArrayList(context));
            logListener.addContext(new ArrayList(context));
            logListener.entries.clear();
            logger.log(1, a.getMessage());
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            Assert.assertFalse((String)"Missing context", (boolean)logListener.waitforContext());
            Assert.assertEquals((String)"Wrong number of entries", (long)1L, (long)logListener.entries.size());
        }
        finally {
            testLog.removeLogListener((ILogListener)iLogListener1);
            Platform.removeLogListener((ILogListener)iLogListener2);
            logRef.readerService.removeLogListener((LogListener)logListener);
            logRef.unget(bc);
        }
    }

    @Test
    public void testPluginILog() throws BundleException {
        Bundle testBundle = installer.installBundle("test.logging.a");
        testBundle.start();
        BundleContext bc = testBundle.getBundleContext();
        LogServiceReference logRef = this.getLogService(bc);
        Status a = new Status(4, testBundle.getSymbolicName(), this.getName());
        ArrayList<Status> context = new ArrayList<Status>();
        context.add(a);
        TestILogListener iLogListener1 = new TestILogListener(new ArrayList(context));
        TestILogListener iLogListener2 = new TestILogListener(new ArrayList(context));
        TestLogListener logListener = new TestLogListener(new ArrayList(context));
        ILog testLog = ILog.of((Bundle)testBundle);
        testLog.addLogListener((ILogListener)iLogListener1);
        Platform.addLogListener((ILogListener)iLogListener2);
        logRef.readerService.addLogListener((LogListener)logListener, (LogFilter)logListener);
        try {
            testLog.log((IStatus)a);
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
            iLogListener1.addContext(new ArrayList(context));
            iLogListener2.addContext(new ArrayList(context));
            logListener.addContext(new ArrayList(context));
            testLog.log((IStatus)a);
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
        }
        finally {
            testLog.removeLogListener((ILogListener)iLogListener1);
            Platform.removeLogListener((ILogListener)iLogListener2);
            logRef.readerService.removeLogListener((LogListener)logListener);
            logRef.unget(bc);
        }
    }

    @Test
    public void testRuntimeLog() throws BundleException {
        Bundle testBundle = installer.installBundle("test.logging.a");
        testBundle.start();
        BundleContext bc = testBundle.getBundleContext();
        LogServiceReference logRef = this.getLogService(bc);
        Status a = new Status(4, testBundle.getSymbolicName(), this.getName());
        ArrayList<Status> context = new ArrayList<Status>();
        context.add(a);
        TestILogListener iLogListener1 = new TestILogListener(new ArrayList(context));
        TestILogListener iLogListener2 = new TestILogListener(new ArrayList(context));
        TestLogListener logListener = new TestLogListener(new ArrayList(context));
        ILog testLog = ILog.of((Bundle)testBundle);
        testLog.addLogListener((ILogListener)iLogListener1);
        Platform.addLogListener((ILogListener)iLogListener2);
        logRef.readerService.addLogListener((LogListener)logListener, (LogFilter)logListener);
        try {
            RuntimeLog.log((IStatus)a);
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
            iLogListener1.addContext(new ArrayList(context));
            iLogListener2.addContext(new ArrayList(context));
            logListener.addContext(new ArrayList(context));
            RuntimeLog.log((IStatus)a);
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
        }
        finally {
            testLog.removeLogListener((ILogListener)iLogListener1);
            Platform.removeLogListener((ILogListener)iLogListener2);
            logRef.readerService.removeLogListener((LogListener)logListener);
            logRef.unget(bc);
        }
    }

    @Test
    public void testFrameworkLog() throws BundleException {
        Bundle testBundle = installer.installBundle("test.logging.a");
        testBundle.start();
        BundleContext bc = testBundle.getBundleContext();
        LogServiceReference logRef = this.getLogService(bc);
        Status a = new Status(4, testBundle.getSymbolicName(), this.getName());
        ArrayList<Status> context = new ArrayList<Status>();
        context.add(a);
        TestILogListener iLogListener1 = new TestILogListener(new ArrayList(context));
        TestILogListener iLogListener2 = new TestILogListener(new ArrayList(context));
        TestLogListener logListener = new TestLogListener(new ArrayList(context));
        ILog testLog = ILog.of((Bundle)testBundle);
        testLog.addLogListener((ILogListener)iLogListener1);
        Platform.addLogListener((ILogListener)iLogListener2);
        logRef.readerService.addLogListener((LogListener)logListener, (LogFilter)logListener);
        try {
            FrameworkLogEntry fwkLogEntry = new FrameworkLogEntry((Object)a, testBundle.getSymbolicName(), a.getSeverity(), a.getCode(), a.getMessage(), 0, null, null);
            logRef.fwkLog.log(fwkLogEntry);
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
            iLogListener1.addContext(new ArrayList(context));
            iLogListener2.addContext(new ArrayList(context));
            logListener.addContext(new ArrayList(context));
            logRef.fwkLog.log(fwkLogEntry);
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
            iLogListener1.addContext(new ArrayList(context));
            iLogListener2.addContext(new ArrayList(context));
            logListener.addContext(new ArrayList(context));
            logListener.entries.clear();
            logRef.fwkLog.log(new FrameworkLogEntry(testBundle.getSymbolicName(), a.getSeverity(), a.getCode(), a.getMessage(), 0, null, null));
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            Assert.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            Assert.assertFalse((String)"Missing context", (boolean)logListener.waitforContext());
            Assert.assertEquals((String)"Wrong number of entries", (long)1L, (long)logListener.entries.size());
        }
        finally {
            testLog.removeLogListener((ILogListener)iLogListener1);
            Platform.removeLogListener((ILogListener)iLogListener2);
            logRef.readerService.removeLogListener((LogListener)logListener);
            logRef.unget(bc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventAdminAdapter1() {
        ServiceReference eventRef = this.getContext().getServiceReference(EventAdmin.class.getName());
        Assert.assertNotNull((String)"No eventAdmin.", (Object)eventRef);
        LogServiceReference logRef = this.getLogService(this.getContext());
        ArrayList events = new ArrayList();
        EventHandler testHandler = event -> {
            List list2 = events;
            synchronized (list2) {
                events.add(event);
                events.notifyAll();
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("event.topics", "org/osgi/service/log/LogEntry/*");
        ServiceRegistration handlerReg = this.getContext().registerService(EventHandler.class.getName(), (Object)testHandler, props);
        try {
            logRef.logService.log(1, this.getName());
            Event testEvent = null;
            ArrayList arrayList = events;
            synchronized (arrayList) {
                if (events.size() == 0) {
                    try {
                        events.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (events.size() > 0) {
                    testEvent = (Event)events.get(0);
                }
            }
            Assert.assertNotNull((String)"No event fired", (Object)testEvent);
            Assert.assertEquals((String)"Wrong message", (Object)this.getName(), (Object)testEvent.getProperty("message"));
        }
        finally {
            handlerReg.unregister();
            logRef.unget(this.getContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventAdminAdapter2() {
        ServiceReference eventRef = this.getContext().getServiceReference(EventAdmin.class.getName());
        Assert.assertNotNull((String)"No eventAdmin.", (Object)eventRef);
        LogServiceReference logRef = this.getLogService(this.getContext());
        ArrayList events = new ArrayList();
        EventHandler testHandler = event -> {
            List list2 = events;
            synchronized (list2) {
                events.add(event);
                events.notifyAll();
            }
            throw new NullPointerException();
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("event.topics", "org/osgi/service/log/LogEntry/*");
        ServiceRegistration handlerReg = this.getContext().registerService(EventHandler.class.getName(), (Object)testHandler, props);
        try {
            logRef.logService.log(1, this.getName());
            int size = 0;
            ArrayList arrayList = events;
            synchronized (arrayList) {
                int i = 0;
                while (i < 3 && events.size() < 3) {
                    try {
                        events.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    ++i;
                }
                size = events.size();
            }
            Assert.assertEquals((String)"Should only get one event from bad handler", (long)2L, (long)size);
        }
        finally {
            handlerReg.unregister();
            logRef.unget(this.getContext());
        }
    }

    @Test
    public void testBug347183() throws BundleException {
        Bundle testBundle = installer.installBundle("test.logging.a");
        testBundle.start();
        LogServiceReference logRef = this.getLogService(this.getContext());
        ILogListener recurseLog = (status, plugin) -> ILog.of((Bundle)testBundle).log(status);
        Platform.addLogListener((ILogListener)recurseLog);
        try {
            logRef.fwkLog.log(new FrameworkLogEntry(this.getContext().getBundle().getSymbolicName(), 4, 0, "Test message", 0, null, null));
            ILog.of((Bundle)testBundle);
            logRef.fwkLog.log(new FrameworkLogEntry(this.getContext().getBundle().getSymbolicName(), 4, 0, "Test message", 0, null, null));
        }
        finally {
            Platform.removeLogListener((ILogListener)recurseLog);
        }
    }

    class ILogEntry {
        final IStatus status;
        final String plugin;

        ILogEntry(IStatus status, String plugin) {
            this.status = status;
            this.plugin = plugin;
        }
    }

    class LogServiceReference {
        private final ServiceReference logRef;
        final ExtendedLogService logService;
        private final ServiceReference readerRef;
        final ExtendedLogReaderService readerService;
        private final ServiceReference fwkLogRef;
        final FrameworkLog fwkLog;

        public LogServiceReference(ServiceReference logRef, ExtendedLogService logService, ServiceReference readerRef, ExtendedLogReaderService readerService, ServiceReference fwkLogRef, FrameworkLog fwkLog) {
            this.logRef = logRef;
            this.logService = logService;
            this.readerRef = readerRef;
            this.readerService = readerService;
            this.fwkLogRef = fwkLogRef;
            this.fwkLog = fwkLog;
        }

        public void unget(BundleContext bc) {
            bc.ungetService(this.logRef);
            bc.ungetService(this.readerRef);
            bc.ungetService(this.fwkLogRef);
        }
    }

    class TestILogListener
    extends TestListener
    implements ILogListener {
        TestILogListener(List context) {
            super(context);
        }

        public void logging(IStatus status, String plugin) {
            this.checkContext(status);
        }
    }

    class TestListener {
        final List context;
        boolean found = false;

        TestListener(List context) {
            this.context = context;
        }

        synchronized boolean waitforContext() {
            if (this.context.size() > 0) {
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.context.size() == 0;
        }

        synchronized void checkContext(IStatus check) {
            if (check == null) {
                return;
            }
            if (this.context.size() > 0) {
                IStatus expected = (IStatus)this.context.get(0);
                try {
                    Assert.assertEquals((long)expected.getSeverity(), (long)check.getSeverity());
                    Assert.assertEquals((long)expected.getCode(), (long)check.getCode());
                    Assert.assertEquals((Object)expected.getMessage(), (Object)check.getMessage());
                    Assert.assertEquals((Object)expected.getPlugin(), (Object)check.getPlugin());
                }
                catch (AssertionFailedError e) {
                    return;
                }
                this.context.remove(0);
                if (this.context.size() == 0) {
                    this.notifyAll();
                }
            }
        }

        synchronized void addContext(List moreContext) {
            this.context.addAll(moreContext);
        }
    }

    class TestLogListener
    extends TestListener
    implements LogListener,
    LogFilter {
        List entries;

        TestLogListener(List context) {
            super(context);
            this.entries = new ArrayList();
        }

        public void logged(LogEntry entry) {
            this.entries.add(entry);
            Object check = ((ExtendedLogEntry)entry).getContext();
            if (check instanceof FrameworkLogEntry) {
                check = ((FrameworkLogEntry)check).getContext();
            }
            if (check instanceof IStatus) {
                this.checkContext((IStatus)check);
            }
        }

        List getEntries() {
            return this.entries;
        }

        public boolean isLoggable(Bundle bundle, String loggerName, int logLevel) {
            return LoggingTests.EQUINOX_LOGGER.equals(loggerName);
        }
    }
}

