/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

public class NativeCodeBundleTests
extends AbstractBundleTests {
    @Test
    public void testNativeCode01() throws Exception {
        Bundle nativetestA1 = installer.installBundle("nativetest.a1");
        nativetestA1.start();
        nativetestA1.stop();
        Object[] a1Results = simpleResults.getResults(1);
        installer.updateBundle("nativetest.a1", "nativetest.a2");
        nativetestA1.start();
        nativetestA1.stop();
        Object[] a2Results = simpleResults.getResults(1);
        Assert.assertTrue((String)"1.0", (a1Results.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.1", (a2Results.length == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"1.2", (Object)a1Results[0]);
        Assert.assertNotNull((String)"1.3", (Object)a2Results[0]);
        Assert.assertFalse((String)"1.4", (boolean)a1Results[0].equals(a2Results[0]));
    }

    @Test
    public void testNativeCode02() throws Exception {
        Bundle nativetestB1 = installer.installBundle("nativetest.b1");
        nativetestB1.start();
        nativetestB1.stop();
        Object[] b1Results = simpleResults.getResults(1);
        installer.updateBundle("nativetest.b1", "nativetest.b2");
        nativetestB1.start();
        nativetestB1.stop();
        Object[] b2Results = simpleResults.getResults(1);
        Assert.assertTrue((String)"1.0", (b1Results.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.1", (b2Results.length == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"1.2", (Object)b1Results[0]);
        Assert.assertNotNull((String)"1.3", (Object)b2Results[0]);
        Assert.assertFalse((String)"1.4", (boolean)b1Results[0].equals(b2Results[0]));
    }

    @Test
    public void testNativeCode03() throws Exception {
        this.setNativeAttribute("nativecodetest", "1");
        Bundle nativetestC = installer.installBundle("nativetest.c");
        nativetestC.start();
        nativetestC.stop();
        Object[] results = simpleResults.getResults(1);
        Assert.assertTrue((String)"1.0", (results.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"1.1", (Object)"libs.test1", (Object)this.getContent((String)results[0]));
    }

    @Test
    public void testNativeCode04() throws Exception {
        this.setNativeAttribute("nativecodetest", "unresolved");
        Bundle nativetestC = installer.installBundle("nativetest.c");
        installer.resolveBundles(new Bundle[]{nativetestC});
        Assert.assertTrue((String)"1.0", (nativetestC.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testNativeCode05() throws Exception {
        this.setNativeAttribute("nativecodetest", "2");
        Bundle nativetestC = installer.installBundle("nativetest.c");
        nativetestC.start();
        nativetestC.stop();
        Object[] results = simpleResults.getResults(1);
        Assert.assertTrue((String)"1.0", (results.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"1.1", (Object)"libs.test3", (Object)this.getContent((String)results[0]));
    }

    @Test
    public void testNativeCode06() throws Exception {
        this.setNativeAttribute("nativecodetest", "3");
        Bundle nativetestC = installer.installBundle("nativetest.c");
        nativetestC.start();
        nativetestC.stop();
        Object[] results = simpleResults.getResults(1);
        Assert.assertTrue((String)"1.0", (results.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"1.1", (Object)"libs.test2", (Object)this.getContent((String)results[0]));
    }

    @Test
    public void testNativeCode07() throws Exception {
        Bundle nativetestC = installer.installBundle("nativetest.d");
        nativetestC.start();
        nativetestC.stop();
        Object[] results = simpleResults.getResults(1);
        Assert.assertTrue((String)"1.0", (results.length == 1 ? 1 : 0) != 0);
        Assert.assertNull((String)"1.1", (Object)results[0]);
    }

    @Test
    public void testNativeCode08() throws Exception {
        this.setNativeAttribute("nativecodetest", "4");
        Bundle nativetestC = installer.installBundle("nativetest.c");
        nativetestC.start();
        nativetestC.stop();
        Object[] results = simpleResults.getResults(1);
        Assert.assertTrue((String)"1.0", (results.length == 1 ? 1 : 0) != 0);
        Assert.assertNull((String)"1.1", (Object)results[0]);
    }

    @Test
    public void testNativeCode09() throws Exception {
        this.setNativeAttribute("nativecodetest", "1");
        Bundle nativetest = installer.installBundle("nativetest.e");
        nativetest.start();
        nativetest.stop();
        Object[] results = simpleResults.getResults(1);
        Assert.assertTrue((String)"1.0", (results.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"1.1", (Object)"libs.test1", (Object)this.getContent((String)results[0]));
    }

    private String getContent(String file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            return br.readLine();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void setNativeAttribute(String key, String value) {
        Bundle systemBundle = OSGiTestsActivator.getContext().getBundle(0L);
        ModuleRevision systemRevision = (ModuleRevision)systemBundle.adapt(BundleRevision.class);
        ModuleCapability nativeCapability = (ModuleCapability)systemRevision.getModuleCapabilities("osgi.native").get(0);
        HashMap<String, String> attrs = new HashMap<String, String>(nativeCapability.getAttributes());
        attrs.put(key, value);
        nativeCapability.setTransientAttrs(attrs);
    }
}

