/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class PackageAdminBundleTests
extends AbstractBundleTests {
    @Test
    public void testBundleEvents01() throws Exception {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        Bundle[] resolveBundles = new Bundle[]{chainTestC, chainTestA, chainTestB, chainTest, chainTestD};
        Bundle[] dependencyOrder = new Bundle[]{chainTest, chainTestA, chainTestB, chainTestC, chainTestD};
        TestListener testListener = new TestListener();
        OSGiTestsActivator.getContext().addBundleListener((BundleListener)testListener);
        try {
            installer.resolveBundles(resolveBundles);
            BundleEvent[] events = testListener.getEvents();
            Assert.assertEquals((String)"Event count", (long)10L, (long)events.length);
            int j = 0;
            int i = dependencyOrder.length - 1;
            while (i >= 0) {
                Assert.assertTrue((String)("Resolved Event Bundle: " + dependencyOrder[i].getSymbolicName()), (dependencyOrder[i] == events[j].getBundle() ? 1 : 0) != 0);
                Assert.assertEquals((String)"Expecting Resolved event", (long)32L, (long)events[j].getType());
                --i;
                ++j;
            }
            j = 5;
            i = dependencyOrder.length - 1;
            while (i >= 0) {
                Assert.assertTrue((String)("Lazy Starting Bundle: " + dependencyOrder[i].getSymbolicName()), (dependencyOrder[i] == events[j].getBundle() ? 1 : 0) != 0);
                Assert.assertEquals((String)"Expecting Lazy Starting event", (long)512L, (long)events[j].getType());
                --i;
                ++j;
            }
        }
        finally {
            OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testListener);
        }
    }

    @Test
    public void testBundleEvents02() throws Exception {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        Bundle[] resolveBundles = new Bundle[]{chainTestC, chainTestA, chainTestB, chainTest, chainTestD};
        Bundle[] dependencyOrder = new Bundle[]{chainTest, chainTestA, chainTestB, chainTestC, chainTestD};
        TestListener testListener = new TestListener();
        OSGiTestsActivator.getContext().addBundleListener((BundleListener)testListener);
        try {
            installer.resolveBundles(resolveBundles);
            BundleEvent[] events = testListener.getEvents();
            installer.refreshPackages(resolveBundles);
            events = testListener.getEvents();
            Assert.assertEquals((String)"Event count", (long)25L, (long)events.length);
            int j = 0;
            int i = 0;
            while (i < dependencyOrder.length) {
                Assert.assertTrue((String)("Stopping Event Bundle: " + dependencyOrder[i].getSymbolicName()), (dependencyOrder[i] == events[j].getBundle() ? 1 : 0) != 0);
                Assert.assertEquals((String)"Expecting Stopping event", (long)256L, (long)events[j].getType());
                Assert.assertTrue((String)("Stopped Event Bundle: " + dependencyOrder[i].getSymbolicName()), (dependencyOrder[i] == events[j + 1].getBundle() ? 1 : 0) != 0);
                Assert.assertEquals((String)"Expecting Stopping event", (long)4L, (long)events[j + 1].getType());
                ++i;
                j += 2;
            }
            j = 10;
            i = 0;
            while (i < dependencyOrder.length) {
                Assert.assertTrue((String)("Unresolved Event Bundle: " + dependencyOrder[i].getSymbolicName()), (dependencyOrder[i] == events[j].getBundle() ? 1 : 0) != 0);
                Assert.assertEquals((String)"Expecting Unresolved event", (long)64L, (long)events[j].getType());
                ++i;
                ++j;
            }
            j = 15;
            i = dependencyOrder.length - 1;
            while (i >= 0) {
                Assert.assertTrue((String)("Resolved Event Bundle: " + dependencyOrder[i].getSymbolicName()), (dependencyOrder[i] == events[j].getBundle() ? 1 : 0) != 0);
                Assert.assertEquals((String)"Expecting Resolved event", (long)32L, (long)events[j].getType());
                --i;
                ++j;
            }
            j = 20;
            i = dependencyOrder.length - 1;
            while (i >= 0) {
                Assert.assertTrue((String)("Lazy Starting Event Bundle: " + dependencyOrder[i].getSymbolicName()), (dependencyOrder[i] == events[j].getBundle() ? 1 : 0) != 0);
                Assert.assertEquals((String)"Expecting Lazy Starting event", (long)512L, (long)events[j].getType());
                --i;
                ++j;
            }
        }
        finally {
            OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testListener);
        }
    }

    @Test
    public void testBug259903() throws Exception {
        Bundle bug259903a = installer.installBundle("test.bug259903.a");
        Bundle bug259903b = installer.installBundle("test.bug259903.b");
        Bundle bug259903c = installer.installBundle("test.bug259903.c");
        installer.resolveBundles(new Bundle[]{bug259903a, bug259903b, bug259903c});
        bug259903c.start();
        bug259903a.uninstall();
        installer.installBundle("test.bug259903.a.update");
        installer.refreshPackages(new Bundle[]{bug259903a});
        Object[] expectedEvents = new Object[]{new BundleEvent(4, bug259903c)};
        Object[] actualEvents = simpleResults.getResults(expectedEvents.length);
        PackageAdminBundleTests.compareResults(expectedEvents, actualEvents);
    }

    @Test
    public void testBug287636() throws Exception {
        Bundle bug287636a = installer.installBundle("test.bug287636.a1");
        Bundle bug287636b = installer.installBundle("test.bug287636.b");
        bug287636a.start();
        bug287636b.start();
        Assert.assertTrue((String)"Bundles are not resolved", (boolean)installer.resolveBundles(new Bundle[]{bug287636a, bug287636b}));
        ExportedPackage ep = installer.getPackageAdmin().getExportedPackage("test.bug287636.a");
        Assert.assertNotNull((String)"Could not find exported package", (Object)ep);
        Assert.assertEquals((String)"Wrong version", (Object)new Version(1, 0, 0), (Object)ep.getVersion());
        String updateLocation = installer.getBundleLocation("test.bug287636.a2");
        bug287636a.update(new URL(updateLocation).openStream());
        bug287636b.update();
        updateLocation = installer.getBundleLocation("test.bug287636.a1");
        bug287636a.update(new URL(updateLocation).openStream());
        bug287636b.update();
        updateLocation = installer.getBundleLocation("test.bug287636.a2");
        bug287636a.update(new URL(updateLocation).openStream());
        bug287636b.update();
        installer.refreshPackages(null);
        ep = installer.getPackageAdmin().getExportedPackage("test.bug287636.a");
        Assert.assertNotNull((String)"Could not find exported package", (Object)ep);
        Assert.assertEquals((String)"Wrong version", (Object)new Version(1, 1, 0), (Object)ep.getVersion());
        ExportedPackage[] eps = installer.getPackageAdmin().getExportedPackages("test.bug287636.a");
        Assert.assertNotNull((String)"Could not find exported package", (Object)eps);
        Assert.assertEquals((String)"Wrong number of exports", (long)1L, (long)eps.length);
        Assert.assertEquals((String)"Wrong version", (Object)new Version(1, 1, 0), (Object)eps[0].getVersion());
        eps = installer.getPackageAdmin().getExportedPackages(bug287636a);
        Assert.assertNotNull((String)"Could not find exported package", (Object)eps);
        Assert.assertEquals((String)"Wrong number of exports", (long)1L, (long)eps.length);
        Assert.assertEquals((String)"Wrong version", (Object)new Version(1, 1, 0), (Object)eps[0].getVersion());
    }

    @Test
    public void testBug289719() throws Exception {
        Bundle bug259903a = installer.installBundle("test.bug259903.a");
        Bundle bug259903b = installer.installBundle("test.bug259903.b");
        Bundle bug259903c = installer.installBundle("test.bug259903.c");
        Bug289719Listener testListener = new Bug289719Listener();
        try {
            installer.resolveBundles(new Bundle[]{bug259903a, bug259903b, bug259903c});
            bug259903a.start();
            bug259903b.start();
            bug259903c.start();
            installer.getStartLevel().setBundleStartLevel(bug259903c, 2);
            installer.getStartLevel().setBundleStartLevel(bug259903b, 3);
            installer.getStartLevel().setBundleStartLevel(bug259903a, 4);
            OSGiTestsActivator.getContext().addBundleListener((BundleListener)testListener);
            BundleEvent[] expectedEvents = new BundleEvent[]{new BundleEvent(256, bug259903a), new BundleEvent(4, bug259903a), new BundleEvent(256, bug259903b), new BundleEvent(4, bug259903b), new BundleEvent(256, bug259903c), new BundleEvent(4, bug259903c), new BundleEvent(64, bug259903a), new BundleEvent(64, bug259903b), new BundleEvent(64, bug259903c), new BundleEvent(32, bug259903c), new BundleEvent(32, bug259903b), new BundleEvent(32, bug259903a), new BundleEvent(128, bug259903c), new BundleEvent(2, bug259903c), new BundleEvent(128, bug259903b), new BundleEvent(2, bug259903b), new BundleEvent(128, bug259903a), new BundleEvent(2, bug259903a)};
            testListener.setExpectedEvents(expectedEvents);
            Thread.sleep(500L);
            installer.refreshPackages(new Bundle[]{bug259903a});
            Throwable[] results = testListener.getFailures();
            Assert.assertEquals((String)this.getMessage(results), (long)0L, (long)results.length);
            expectedEvents = new BundleEvent[]{new BundleEvent(256, bug259903c), new BundleEvent(4, bug259903c), new BundleEvent(256, bug259903b), new BundleEvent(4, bug259903b), new BundleEvent(256, bug259903a), new BundleEvent(4, bug259903a), new BundleEvent(64, bug259903c), new BundleEvent(64, bug259903b), new BundleEvent(64, bug259903a), new BundleEvent(32, bug259903a), new BundleEvent(32, bug259903b), new BundleEvent(32, bug259903c), new BundleEvent(128, bug259903a), new BundleEvent(2, bug259903a), new BundleEvent(128, bug259903b), new BundleEvent(2, bug259903b), new BundleEvent(128, bug259903c), new BundleEvent(2, bug259903c)};
            testListener.setExpectedEvents(expectedEvents);
            installer.getStartLevel().setBundleStartLevel(bug259903c, 4);
            installer.getStartLevel().setBundleStartLevel(bug259903b, 4);
            installer.getStartLevel().setBundleStartLevel(bug259903a, 4);
            Thread.sleep(500L);
            installer.refreshPackages(new Bundle[]{bug259903a});
            results = testListener.getFailures();
            Assert.assertEquals((String)this.getMessage(results), (long)0L, (long)results.length);
        }
        finally {
            OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testListener);
        }
    }

    @Test
    public void testBug415447() {
        PackageAdmin pa = installer.getPackageAdmin();
        Bundle[] systemBundles = pa.getBundles("system.bundle", null);
        Assert.assertNotNull((String)"No system bundles found.", (Object)systemBundles);
        Assert.assertEquals((String)"Srong number of system bundles.", (long)1L, (long)systemBundles.length);
        Assert.assertEquals((String)"Wrong system bundle found.", (Object)OSGiTestsActivator.getContext().getBundle("System Bundle"), (Object)systemBundles[0]);
    }

    @Test
    public void testUninstallWhileResolving() throws BundleException {
        ServiceRegistration resolverHookReg = this.getContext().registerService(ResolverHookFactory.class, triggers -> new ResolverHook(){

            public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
            }

            public void filterResolvable(Collection<BundleRevision> candidates) {
                candidates.clear();
            }

            public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
            }

            public void end() {
            }
        }, null);
        try {
            Bundle b1 = installer.installBundle("test.uninstall.start1");
            Bundle b2 = installer.installBundle("test.uninstall.start2");
            try {
                b1.start();
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
            try {
                b2.start();
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
            resolverHookReg.unregister();
            resolverHookReg = null;
            ((FrameworkWiring)this.getContext().getBundle("System Bundle").adapt(FrameworkWiring.class)).resolveBundles(Arrays.asList(b1, b2));
        }
        finally {
            if (resolverHookReg != null) {
                resolverHookReg.unregister();
            }
        }
    }

    private String getMessage(Throwable[] results) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Throwable[] throwableArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            Throwable result = throwableArray[n2];
            result.printStackTrace(pw);
            ++n2;
        }
        return sw.toString();
    }

    public class Bug289719Listener
    implements SynchronousBundleListener {
        ArrayList expectedEvents = new ArrayList();
        ArrayList failures = new ArrayList();
        int i = 0;

        public synchronized void setExpectedEvents(BundleEvent[] events) {
            this.i = 0;
            this.failures.clear();
            this.expectedEvents.clear();
            this.expectedEvents.addAll(Arrays.asList(events));
        }

        public synchronized void bundleChanged(BundleEvent event) {
            BundleEvent expected = this.expectedEvents.size() == 0 ? null : (BundleEvent)this.expectedEvents.remove(0);
            try {
                try {
                    PackageAdminBundleTests.assertEqualEvent("Compare results: " + this.i, expected, event);
                }
                catch (Throwable t) {
                    this.failures.add(t);
                    ++this.i;
                }
            }
            finally {
                ++this.i;
            }
        }

        public synchronized Throwable[] getFailures() {
            Throwable[] results = this.failures.toArray(new Throwable[this.failures.size()]);
            this.setExpectedEvents(new BundleEvent[0]);
            return results;
        }
    }

    public class TestListener
    implements SynchronousBundleListener {
        ArrayList events = new ArrayList();

        public synchronized void bundleChanged(BundleEvent event) {
            this.events.add(event);
        }

        public synchronized BundleEvent[] getEvents() {
            try {
                BundleEvent[] bundleEventArray = this.events.toArray(new BundleEvent[0]);
                return bundleEventArray;
            }
            finally {
                this.events.clear();
            }
        }
    }
}

