/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.util.Map;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.launch.Framework;

public class PersistedBundleTests
extends AbstractBundleTests {
    private static final String ECLIPSE_STATESAVEDELAYINTERVAL = "eclipse.stateSaveDelayInterval";
    private static final String IMMEDIATE_PERSISTENCE = "0";
    private static final String NO_PERSISTENCE = "-1";
    private static final String PERIODIC_PERSISTENCE = "4000";

    @Test
    public void testImmediatePersistence() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(ECLIPSE_STATESAVEDELAYINTERVAL, IMMEDIATE_PERSISTENCE);
        Equinox equinox1 = new Equinox(configuration);
        this.initAndStart(equinox1);
        try {
            Assert.assertNull((String)"Bundle exists", (Object)equinox1.getBundleContext().getBundle(this.getName()));
            equinox1.getBundleContext().installBundle(this.getName(), new AbstractBundleTests.BundleBuilder().symbolicName(this.getName()).build());
            Equinox equinox2 = new Equinox(configuration);
            this.initAndStart(equinox2);
            try {
                Assert.assertNotNull((String)"Bundle does not exist", (Object)equinox2.getBundleContext().getBundle(this.getName()));
            }
            finally {
                PersistedBundleTests.stopQuietly((Framework)equinox2);
            }
        }
        finally {
            PersistedBundleTests.stopQuietly((Framework)equinox1);
        }
    }

    @Test
    public void testNoPersistence() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(ECLIPSE_STATESAVEDELAYINTERVAL, NO_PERSISTENCE);
        Equinox equinox1 = new Equinox(configuration);
        this.initAndStart(equinox1);
        try {
            Assert.assertNull((String)"Bundle exists", (Object)equinox1.getBundleContext().getBundle(this.getName()));
            equinox1.getBundleContext().installBundle(this.getName(), new AbstractBundleTests.BundleBuilder().symbolicName(this.getName()).build());
            Thread.sleep(Long.valueOf(PERIODIC_PERSISTENCE));
            Equinox equinox2 = new Equinox(configuration);
            this.initAndStart(equinox2);
            try {
                Assert.assertNull((String)"Bundle exists", (Object)equinox2.getBundleContext().getBundle(this.getName()));
            }
            finally {
                PersistedBundleTests.stopQuietly((Framework)equinox2);
            }
        }
        finally {
            PersistedBundleTests.stopQuietly((Framework)equinox1);
        }
        equinox1 = new Equinox(configuration);
        this.initAndStart(equinox1);
        try {
            Assert.assertNotNull((String)"Bundle does not exists", (Object)equinox1.getBundleContext().getBundle(this.getName()));
        }
        finally {
            PersistedBundleTests.stopQuietly((Framework)equinox1);
        }
    }

    @Test
    public void testPeriodicPersistence() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(ECLIPSE_STATESAVEDELAYINTERVAL, PERIODIC_PERSISTENCE);
        Equinox equinox1 = new Equinox(configuration);
        this.initAndStart(equinox1);
        try {
            Assert.assertNull((String)"Bundle exists", (Object)equinox1.getBundleContext().getBundle(this.getName()));
            equinox1.getBundleContext().installBundle(this.getName(), new AbstractBundleTests.BundleBuilder().symbolicName(this.getName()).build());
            Equinox equinox2 = new Equinox(configuration);
            this.initAndStart(equinox2);
            try {
                Assert.assertNull((String)"Bundle exists", (Object)equinox2.getBundleContext().getBundle(this.getName()));
                PersistedBundleTests.stopQuietly((Framework)equinox2);
                Thread.sleep(Long.valueOf(PERIODIC_PERSISTENCE) + 2000L);
                equinox2 = new Equinox(configuration);
                this.initAndStart(equinox2);
                Assert.assertNotNull((String)"Bundle does not exist", (Object)equinox2.getBundleContext().getBundle(this.getName()));
            }
            finally {
                PersistedBundleTests.stopQuietly((Framework)equinox2);
            }
        }
        finally {
            PersistedBundleTests.stopQuietly((Framework)equinox1);
        }
    }
}

