/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.BundleInstaller;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;

public class PlatformAdminBundleTests
extends AbstractBundleTests {
    @Test
    public void testInstallUninstallBundle() throws BundleException {
        PlatformAdmin pa = installer.getPlatformAdmin();
        State systemState = pa.getState(false);
        BundleDescription testDesc = systemState.getBundleByLocation(installer.getBundleLocation("test"));
        Assert.assertNull((String)"Should not find bundle.", (Object)testDesc);
        Bundle test = installer.installBundle("test");
        testDesc = systemState.getBundleByLocation(installer.getBundleLocation("test"));
        Assert.assertNotNull((String)"Should find bundle.", (Object)testDesc);
        test.uninstall();
        testDesc = systemState.getBundleByLocation(installer.getBundleLocation("test"));
        Assert.assertNull((String)"Should not find bundle.", (Object)testDesc);
    }

    @Test
    public void testResolveRefresh() throws Exception {
        PlatformAdmin pa = installer.getPlatformAdmin();
        State systemState = pa.getState(false);
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        Assert.assertTrue((String)"Could not resolve bundles.", (boolean)((FrameworkWiring)this.getContext().getBundle(0L).adapt(FrameworkWiring.class)).resolveBundles(Arrays.asList(chainTestA, chainTestB, chainTestC, chainTestD)));
        BundleDescription testADesc = systemState.getBundle(chainTestA.getBundleId());
        BundleDescription testBDesc = systemState.getBundle(chainTestB.getBundleId());
        BundleDescription testCDesc = systemState.getBundle(chainTestC.getBundleId());
        BundleDescription testDDesc = systemState.getBundle(chainTestD.getBundleId());
        Assert.assertNotNull((String)"testADesc null!!", (Object)testADesc);
        Assert.assertNotNull((String)"testBDesc null!!", (Object)testBDesc);
        Assert.assertNotNull((String)"testCDesc null!!", (Object)testCDesc);
        Assert.assertNotNull((String)"testDDesc null!!", (Object)testDDesc);
        Assert.assertTrue((String)"testADesc is not resolved!!", (boolean)testADesc.isResolved());
        Assert.assertTrue((String)"testBDesc is not resolved!!", (boolean)testBDesc.isResolved());
        Assert.assertTrue((String)"testCDesc is not resolved!!", (boolean)testCDesc.isResolved());
        Assert.assertTrue((String)"testCDesc is not resolved!!", (boolean)testDDesc.isResolved());
        chainTestD.uninstall();
        installer.refreshPackages(new Bundle[]{chainTestD});
        if (testADesc.isResolved()) {
            Thread.sleep(1000L);
        }
        Assert.assertFalse((String)"testADesc is resolved!!", (boolean)testADesc.isResolved());
        Assert.assertFalse((String)"testBDesc is resolved!!", (boolean)testBDesc.isResolved());
        Assert.assertFalse((String)"testCDesc is resolved!!", (boolean)testCDesc.isResolved());
    }

    @Test
    @Ignore
    public void testUnresolvedLeaves01() throws Exception {
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle[] allBundles = new Bundle[]{chainTestA, chainTestB, chainTestC};
        PlatformAdmin pa = installer.getPlatformAdmin();
        State systemState = pa.getState(false);
        BundleDescription testADesc = systemState.getBundle(chainTestA.getBundleId());
        BundleDescription testBDesc = systemState.getBundle(chainTestB.getBundleId());
        BundleDescription testCDesc = systemState.getBundle(chainTestC.getBundleId());
        Assert.assertNotNull((String)"testADesc null!!", (Object)testADesc);
        Assert.assertNotNull((String)"testBDesc null!!", (Object)testBDesc);
        Assert.assertNotNull((String)"testCDesc null!!", (Object)testCDesc);
        installer.resolveBundles(allBundles);
        Assert.assertFalse((String)"testADesc is resolved!!", (boolean)testADesc.isResolved());
        Assert.assertFalse((String)"testBDesc is resolved!!", (boolean)testBDesc.isResolved());
        Assert.assertFalse((String)"testCDesc is resolved!!", (boolean)testCDesc.isResolved());
        VersionConstraint[] unsatifiedLeaves = pa.getStateHelper().getUnsatisfiedLeaves(new BundleDescription[]{testADesc});
        Assert.assertNotNull((String)"Unsatified constraints is null!!", (Object)unsatifiedLeaves);
        Assert.assertEquals((String)"Wrong number of constraints!!", (long)2L, (long)unsatifiedLeaves.length);
        int i = 0;
        while (i < unsatifiedLeaves.length) {
            Assert.assertTrue((String)("Constraint type is not import package: " + String.valueOf(unsatifiedLeaves[i])), (boolean)(unsatifiedLeaves[i] instanceof ImportPackageSpecification));
            Assert.assertEquals((String)("Package name is wrong: " + i), (Object)"chain.test.d", (Object)unsatifiedLeaves[i].getName());
            MatcherAssert.assertThat((String)("Wrong bundle for the constraint: " + String.valueOf(unsatifiedLeaves[i].getBundle())), (Object)unsatifiedLeaves[i].getBundle(), (Matcher)CoreMatchers.either((Matcher)CoreMatchers.is((Object)testBDesc)).or(CoreMatchers.is((Object)testCDesc)));
            ++i;
        }
    }

    @Test
    public void testR3Bundle() throws BundleException, InvalidSyntaxException {
        PlatformAdmin pa = installer.getPlatformAdmin();
        State systemState = pa.getState(false);
        BundleInstaller r3Installer = new BundleInstaller("test_files/platformAdmin", OSGiTestsActivator.getContext());
        try {
            Bundle b = r3Installer.installBundle("b1");
            BundleDescription bDesc = systemState.getBundle(b.getBundleId());
            Assert.assertNotNull((String)"No bundle description.", (Object)bDesc);
            ExportPackageDescription[] exports = bDesc.getExportPackages();
            ImportPackageSpecification[] imports = bDesc.getImportPackages();
            Assert.assertEquals((String)"Wrong number of exports", (long)1L, (long)exports.length);
            Assert.assertEquals((String)"Wrong number of imports.", (long)2L, (long)imports.length);
        }
        finally {
            r3Installer.shutdown();
        }
    }

    @Test
    public void testNativeCodeFilterWithSpecialChars() throws BundleException, InterruptedException {
        AtomicReference error = new AtomicReference();
        CountDownLatch errorCnt = new CountDownLatch(1);
        FrameworkListener errorListener = event -> {
            if (event.getType() == 2) {
                error.set(event);
                errorCnt.countDown();
            }
        };
        this.getContext().addFrameworkListener(errorListener);
        try {
            PlatformAdmin pa = installer.getPlatformAdmin();
            State systemState = pa.getState(false);
            Assert.assertNotNull((Object)systemState.getBundle(0L));
            Bundle nativeTestF = installer.installBundle("nativetest.f");
            nativeTestF.start();
            errorCnt.await(5L, TimeUnit.SECONDS);
            Assert.assertNull((String)("Found an error: " + String.valueOf(error.get())), error.get());
        }
        finally {
            this.getContext().removeFrameworkListener(errorListener);
        }
    }

    @Test
    public void testTimestamp() throws BundleException {
        PlatformAdmin pa = installer.getPlatformAdmin();
        State systemState = pa.getState(false);
        long initialTimeStamp = systemState.getTimeStamp();
        Bundle test = installer.installBundle("test");
        Assert.assertTrue((String)"Timestamp has not changed.", (initialTimeStamp != systemState.getTimeStamp() ? 1 : 0) != 0);
        initialTimeStamp = systemState.getTimeStamp();
        ((BundleStartLevel)test.adapt(BundleStartLevel.class)).setStartLevel(1000);
        Assert.assertTrue((String)"Timestamp has not changed.", (initialTimeStamp == systemState.getTimeStamp() ? 1 : 0) != 0);
        initialTimeStamp = systemState.getTimeStamp();
        test.uninstall();
        Assert.assertTrue((String)"Timestamp has not changed.", (initialTimeStamp != systemState.getTimeStamp() ? 1 : 0) != 0);
    }
}

