/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class SubstituteExportsBundleTests
extends AbstractBundleTests {
    @Test
    public void testSubstituteExports01x() throws Exception {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle c = installer.installBundle("substitutes.c");
        Bundle d = installer.installBundle("substitutes.d");
        String className = "substitutes.x.Ax";
        Class ax = a.loadClass(className);
        Assert.assertEquals((String)"class from b is wrong", (Object)ax, (Object)b.loadClass(className));
        Assert.assertEquals((String)"class from c is wrong", (Object)ax, (Object)c.loadClass(className));
        Assert.assertEquals((String)"class from d is wrong", (Object)ax, (Object)d.loadClass(className));
    }

    @Test
    public void testSubstituteExports01y() throws Exception {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle c = installer.installBundle("substitutes.c");
        Bundle d = installer.installBundle("substitutes.d");
        String className = "substitutes.y.Ay";
        Class ax = a.loadClass(className);
        Assert.assertEquals((String)"class from b is wrong", (Object)ax, (Object)b.loadClass(className));
        Assert.assertEquals((String)"class from c is wrong", (Object)ax, (Object)c.loadClass(className));
        Assert.assertEquals((String)"class from d is wrong", (Object)ax, (Object)d.loadClass(className));
    }

    @Test
    public void testSubstituteExports02() throws Exception {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle e = installer.installBundle("substitutes.e");
        Bundle f = installer.installBundle("substitutes.f");
        String className = "substitutes.x.Ax";
        Class ax = a.loadClass(className);
        Assert.assertEquals((String)"class from b is wrong", (Object)ax, (Object)b.loadClass(className));
        Assert.assertEquals((String)"class from c is wrong", (Object)ax, (Object)e.loadClass(className));
        Assert.assertEquals((String)"class from d is wrong", (Object)ax, (Object)f.loadClass(className));
    }

    @Test
    public void testSubstituteExports03() throws Exception {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle e = installer.installBundle("substitutes.e");
        Bundle f = installer.installBundle("substitutes.f");
        Bundle g = installer.installBundle("substitutes.g");
        Bundle h = installer.installBundle("substitutes.h");
        String className = "substitutes.x.Ax";
        Class ax = a.loadClass(className);
        Assert.assertEquals((String)"class from b is wrong", (Object)ax, (Object)b.loadClass(className));
        Assert.assertEquals((String)"class from c is wrong", (Object)ax, (Object)e.loadClass(className));
        Assert.assertEquals((String)"class from d is wrong", (Object)ax, (Object)f.loadClass(className));
        Assert.assertEquals((String)"class from d is wrong", (Object)ax, (Object)g.loadClass(className));
        Assert.assertEquals((String)"class from d is wrong", (Object)ax, (Object)h.loadClass(className));
    }

    @Test
    public void testSubstituteExports04() throws Exception {
        Bundle a = installer.installBundle("substitutes.a");
        installer.installBundle("substitutes.a.frag");
        Bundle b = installer.installBundle("substitutes.b");
        installer.installBundle("substitutes.b.frag");
        Bundle c = installer.installBundle("substitutes.c");
        Bundle d = installer.installBundle("substitutes.d");
        String className = "substitutes.x.Ax";
        Class ax = a.loadClass(className);
        Assert.assertEquals((String)"class from b is wrong", (Object)ax, (Object)b.loadClass(className));
        Assert.assertEquals((String)"class from c is wrong", (Object)ax, (Object)c.loadClass(className));
        Assert.assertEquals((String)"class from d is wrong", (Object)ax, (Object)d.loadClass(className));
        String className2 = "substitutes.q.AFq";
        Class aq = a.loadClass(className2);
        Assert.assertEquals((String)"class from b is wrong", (Object)aq, (Object)b.loadClass(className2));
        Assert.assertEquals((String)"class from c is wrong", (Object)aq, (Object)c.loadClass(className2));
        Assert.assertEquals((String)"class from d is wrong", (Object)aq, (Object)d.loadClass(className2));
    }

    @Test
    public void testSubstituteExports05() throws Exception {
        Bundle a = installer.installBundle("substitutes.a");
        installer.installBundle("substitutes.a.frag");
        Bundle b = installer.installBundle("substitutes.b");
        installer.installBundle("substitutes.b.frag");
        Bundle e = installer.installBundle("substitutes.e");
        Bundle f = installer.installBundle("substitutes.f");
        Bundle g = installer.installBundle("substitutes.g");
        Bundle h = installer.installBundle("substitutes.h");
        String className = "substitutes.x.Ax";
        Class ax = a.loadClass(className);
        Assert.assertEquals((String)"class from b is wrong", (Object)ax, (Object)b.loadClass(className));
        Assert.assertEquals((String)"class from c is wrong", (Object)ax, (Object)e.loadClass(className));
        Assert.assertEquals((String)"class from d is wrong", (Object)ax, (Object)f.loadClass(className));
        Assert.assertEquals((String)"class from d is wrong", (Object)ax, (Object)g.loadClass(className));
        Assert.assertEquals((String)"class from d is wrong", (Object)ax, (Object)h.loadClass(className));
        String className2 = "substitutes.q.AFq";
        Class aq = a.loadClass(className2);
        Assert.assertEquals((String)"class from b is wrong", (Object)aq, (Object)b.loadClass(className2));
        Assert.assertEquals((String)"class from c is wrong", (Object)aq, (Object)e.loadClass(className2));
        Assert.assertEquals((String)"class from d is wrong", (Object)aq, (Object)f.loadClass(className2));
        Assert.assertEquals((String)"class from d is wrong", (Object)aq, (Object)g.loadClass(className2));
        Assert.assertEquals((String)"class from d is wrong", (Object)aq, (Object)h.loadClass(className2));
    }

    @Test
    public void testSubstituteExports06() throws Exception {
        String[] unexpectedClasseNames;
        Bundle iBundle = installer.installBundle("substitutes.i");
        Bundle jBundle = installer.installBundle("substitutes.j");
        Bundle kBundle = installer.installBundle("substitutes.k");
        Bundle lBundle = installer.installBundle("substitutes.l");
        Bundle mBundle = installer.installBundle("substitutes.m");
        Bundle nBundle = installer.installBundle("substitutes.n");
        Bundle pBundle = installer.installBundle("substitutes.p");
        Bundle qBundle = installer.installBundle("substitutes.q");
        Bundle[] allBundles = new Bundle[]{iBundle, jBundle, kBundle, lBundle, mBundle, nBundle, pBundle, qBundle};
        String classNameIx = "substitutes.x.Ix";
        String classNameKx = "substitutes.x.Kx";
        String classNameMx = "substitutes.x.Mx";
        String classNameIy = "substitutes.y.Iy";
        String classNameKy = "substitutes.y.Ky";
        String classNameMy = "substitutes.y.My";
        Class iX = iBundle.loadClass(classNameIx);
        Assert.assertEquals((String)"jBundle has different copy of iX", (Object)iX, (Object)jBundle.loadClass(classNameIx));
        Assert.assertEquals((String)"mBundle has different copy of iX", (Object)iX, (Object)mBundle.loadClass(classNameIx));
        Assert.assertEquals((String)"nBundle has different copy of iX", (Object)iX, (Object)nBundle.loadClass(classNameIx));
        Assert.assertEquals((String)"pBundle has different copy of iX", (Object)iX, (Object)pBundle.loadClass(classNameIx));
        Assert.assertEquals((String)"qBundle has different copy of iX", (Object)iX, (Object)qBundle.loadClass(classNameIx));
        Class iY = iBundle.loadClass(classNameIy);
        Assert.assertEquals((String)"jBundle has different copy of iY", (Object)iY, (Object)jBundle.loadClass(classNameIy));
        Assert.assertEquals((String)"mBundle has different copy of iY", (Object)iY, (Object)mBundle.loadClass(classNameIy));
        Assert.assertEquals((String)"nBundle has different copy of iY", (Object)iY, (Object)nBundle.loadClass(classNameIy));
        Assert.assertEquals((String)"pBundle has different copy of iY", (Object)iY, (Object)pBundle.loadClass(classNameIy));
        Assert.assertEquals((String)"qBundle has different copy of iY", (Object)iY, (Object)qBundle.loadClass(classNameIy));
        Class kX = kBundle.loadClass(classNameKx);
        Assert.assertEquals((String)"lBundle has different copy of Kx", (Object)kX, (Object)lBundle.loadClass(classNameKx));
        Assert.assertEquals((String)"mBundle has different copy of Kx", (Object)kX, (Object)mBundle.loadClass(classNameKx));
        Assert.assertEquals((String)"nBundle has different copy of Kx", (Object)kX, (Object)nBundle.loadClass(classNameKx));
        Assert.assertEquals((String)"pBundle has different copy of Kx", (Object)kX, (Object)pBundle.loadClass(classNameKx));
        Assert.assertEquals((String)"qBundle has different copy of Kx", (Object)kX, (Object)qBundle.loadClass(classNameKx));
        Class kY = kBundle.loadClass(classNameKy);
        Assert.assertEquals((String)"lBundle has different copy of Ky", (Object)kY, (Object)lBundle.loadClass(classNameKy));
        Assert.assertEquals((String)"mBundle has different copy of Ky", (Object)kY, (Object)mBundle.loadClass(classNameKy));
        Assert.assertEquals((String)"nBundle has different copy of Ky", (Object)kY, (Object)nBundle.loadClass(classNameKy));
        Assert.assertEquals((String)"pBundle has different copy of Ky", (Object)kY, (Object)pBundle.loadClass(classNameKy));
        Assert.assertEquals((String)"qBundle has different copy of Ky", (Object)kY, (Object)qBundle.loadClass(classNameKy));
        Class mX = mBundle.loadClass(classNameMx);
        Assert.assertEquals((String)"nBundle has different copy of mX", (Object)mX, (Object)nBundle.loadClass(classNameMx));
        Assert.assertEquals((String)"pBundle has different copy of mX", (Object)mX, (Object)pBundle.loadClass(classNameMx));
        Assert.assertEquals((String)"qBundle has different copy of mX", (Object)mX, (Object)qBundle.loadClass(classNameMx));
        Class mY = mBundle.loadClass(classNameMy);
        Assert.assertEquals((String)"nBundle has different copy of mY", (Object)mY, (Object)nBundle.loadClass(classNameMy));
        Assert.assertEquals((String)"pBundle has different copy of mY", (Object)mY, (Object)pBundle.loadClass(classNameMy));
        Assert.assertEquals((String)"qBundle has different copy of mY", (Object)mY, (Object)qBundle.loadClass(classNameMy));
        String[] stringArray = unexpectedClasseNames = new String[]{"substitutes.x.Jx", "substitutes.x.Lx", "substitutes.x.Nx", "substitutes.y.Jy", "substitutes.y.Ly", "substitutes.y.Ny"};
        int n = unexpectedClasseNames.length;
        int n2 = 0;
        while (n2 < n) {
            String unexpectedClasseName = stringArray[n2];
            Bundle[] bundleArray = allBundles;
            int n3 = allBundles.length;
            int n4 = 0;
            while (n4 < n3) {
                Bundle bundle = bundleArray[n4];
                Assert.assertThrows((String)("Found class " + unexpectedClasseName + " in bundle " + String.valueOf(bundle)), ClassNotFoundException.class, () -> {
                    Class clazz = bundle.loadClass(unexpectedClasseName);
                });
                ++n4;
            }
            ++n2;
        }
    }

    @Test
    public void testSubstituteExports07() throws Exception {
        String[] unexpectedClasseNames;
        Bundle jBundle = installer.installBundle("substitutes.j");
        Bundle iBundle = installer.installBundle("substitutes.i");
        Bundle lBundle = installer.installBundle("substitutes.l");
        Bundle kBundle = installer.installBundle("substitutes.k");
        Bundle nBundle = installer.installBundle("substitutes.n");
        Bundle mBundle = installer.installBundle("substitutes.m");
        Bundle qBundle = installer.installBundle("substitutes.q");
        Bundle pBundle = installer.installBundle("substitutes.p");
        Bundle[] allBundles = new Bundle[]{iBundle, jBundle, kBundle, lBundle, mBundle, nBundle, pBundle, qBundle};
        String classNameJx = "substitutes.x.Jx";
        String classNameLx = "substitutes.x.Lx";
        String classNameNx = "substitutes.x.Nx";
        String classNameJy = "substitutes.y.Jy";
        String classNameLy = "substitutes.y.Ly";
        String classNameNy = "substitutes.y.Ny";
        Class jX = jBundle.loadClass(classNameJx);
        Assert.assertEquals((String)"iBundle has different copy of Jx", (Object)jX, (Object)iBundle.loadClass(classNameJx));
        Assert.assertEquals((String)"mBundle has different copy of Jx", (Object)jX, (Object)mBundle.loadClass(classNameJx));
        Assert.assertEquals((String)"nBundle has different copy of Jx", (Object)jX, (Object)nBundle.loadClass(classNameJx));
        Assert.assertEquals((String)"pBundle has different copy of Jx", (Object)jX, (Object)pBundle.loadClass(classNameJx));
        Assert.assertEquals((String)"qBundle has different copy of Jx", (Object)jX, (Object)qBundle.loadClass(classNameJx));
        Class jY = jBundle.loadClass(classNameJy);
        Assert.assertEquals((String)"jBundle has different copy of Jy", (Object)jY, (Object)iBundle.loadClass(classNameJy));
        Assert.assertEquals((String)"mBundle has different copy of Jy", (Object)jY, (Object)mBundle.loadClass(classNameJy));
        Assert.assertEquals((String)"nBundle has different copy of Jy", (Object)jY, (Object)nBundle.loadClass(classNameJy));
        Assert.assertEquals((String)"pBundle has different copy of Jy", (Object)jY, (Object)pBundle.loadClass(classNameJy));
        Assert.assertEquals((String)"qBundle has different copy of Jy", (Object)jY, (Object)qBundle.loadClass(classNameJy));
        Class lX = lBundle.loadClass(classNameLx);
        Assert.assertEquals((String)"lBundle has different copy of Lx", (Object)lX, (Object)kBundle.loadClass(classNameLx));
        Assert.assertEquals((String)"mBundle has different copy of Lx", (Object)lX, (Object)mBundle.loadClass(classNameLx));
        Assert.assertEquals((String)"nBundle has different copy of Lx", (Object)lX, (Object)nBundle.loadClass(classNameLx));
        Assert.assertEquals((String)"pBundle has different copy of Lx", (Object)lX, (Object)pBundle.loadClass(classNameLx));
        Assert.assertEquals((String)"qBundle has different copy of Lx", (Object)lX, (Object)qBundle.loadClass(classNameLx));
        Class lY = lBundle.loadClass(classNameLy);
        Assert.assertEquals((String)"lBundle has different copy of Ly", (Object)lY, (Object)kBundle.loadClass(classNameLy));
        Assert.assertEquals((String)"mBundle has different copy of Ly", (Object)lY, (Object)mBundle.loadClass(classNameLy));
        Assert.assertEquals((String)"nBundle has different copy of Ly", (Object)lY, (Object)nBundle.loadClass(classNameLy));
        Assert.assertEquals((String)"pBundle has different copy of Ly", (Object)lY, (Object)pBundle.loadClass(classNameLy));
        Assert.assertEquals((String)"qBundle has different copy of Ly", (Object)lY, (Object)qBundle.loadClass(classNameLy));
        Class nX = nBundle.loadClass(classNameNx);
        Assert.assertEquals((String)"nBundle has different copy of Nx", (Object)nX, (Object)mBundle.loadClass(classNameNx));
        Assert.assertEquals((String)"pBundle has different copy of Nx", (Object)nX, (Object)pBundle.loadClass(classNameNx));
        Assert.assertEquals((String)"qBundle has different copy of Nx", (Object)nX, (Object)qBundle.loadClass(classNameNx));
        Class nY = nBundle.loadClass(classNameNy);
        Assert.assertEquals((String)"nBundle has different copy of Ny", (Object)nY, (Object)mBundle.loadClass(classNameNy));
        Assert.assertEquals((String)"pBundle has different copy of Ny", (Object)nY, (Object)pBundle.loadClass(classNameNy));
        Assert.assertEquals((String)"qBundle has different copy of Ny", (Object)nY, (Object)qBundle.loadClass(classNameNy));
        String[] stringArray = unexpectedClasseNames = new String[]{"substitutes.x.Ix", "substitutes.x.Kx", "substitutes.x.Mx", "substitutes.y.Iy", "substitutes.y.Ky", "substitutes.y.My"};
        int n = unexpectedClasseNames.length;
        int n2 = 0;
        while (n2 < n) {
            String unexpectedClasseName = stringArray[n2];
            Bundle[] bundleArray = allBundles;
            int n3 = allBundles.length;
            int n4 = 0;
            while (n4 < n3) {
                Bundle bundle = bundleArray[n4];
                Assert.assertThrows((String)("Found class " + unexpectedClasseName + " in bundle " + String.valueOf(bundle)), ClassNotFoundException.class, () -> {
                    Class clazz = bundle.loadClass(unexpectedClasseName);
                });
                ++n4;
            }
            ++n2;
        }
    }

    @Test
    public void testSubstituteExports08() throws BundleException {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle c = installer.installBundle("substitutes.c");
        Bundle d = installer.installBundle("substitutes.d");
        Bundle[] allBundles = new Bundle[]{a, b, c, d};
        this.doRefreshTest(allBundles, a);
    }

    @Test
    public void testSubstituteExports09() throws BundleException {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle e = installer.installBundle("substitutes.e");
        Bundle f = installer.installBundle("substitutes.f");
        Bundle[] allBundles = new Bundle[]{a, b, e, f};
        this.doRefreshTest(allBundles, a);
    }

    @Test
    public void testSubstituteExports10() throws BundleException {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle e = installer.installBundle("substitutes.e");
        Bundle f = installer.installBundle("substitutes.f");
        Bundle g = installer.installBundle("substitutes.g");
        Bundle h = installer.installBundle("substitutes.h");
        Bundle[] allBundles = new Bundle[]{a, b, e, f, g, h};
        this.doRefreshTest(allBundles, a);
    }

    @Test
    public void testSubstituteExports11() throws BundleException {
        Bundle iBundle = installer.installBundle("substitutes.i");
        Bundle jBundle = installer.installBundle("substitutes.j");
        installer.installBundle("substitutes.k");
        installer.installBundle("substitutes.l");
        Bundle mBundle = installer.installBundle("substitutes.m");
        Bundle nBundle = installer.installBundle("substitutes.n");
        Bundle pBundle = installer.installBundle("substitutes.p");
        Bundle qBundle = installer.installBundle("substitutes.q");
        Bundle[] allBundles = new Bundle[]{iBundle, jBundle, mBundle, nBundle, pBundle, qBundle};
        this.doRefreshTest(allBundles, iBundle);
    }

    @Test
    public void testSubstituteExports12() throws BundleException {
        Bundle jBundle = installer.installBundle("substitutes.j");
        Bundle iBundle = installer.installBundle("substitutes.i");
        installer.installBundle("substitutes.l");
        installer.installBundle("substitutes.k");
        Bundle nBundle = installer.installBundle("substitutes.n");
        Bundle mBundle = installer.installBundle("substitutes.m");
        Bundle qBundle = installer.installBundle("substitutes.q");
        Bundle pBundle = installer.installBundle("substitutes.p");
        Bundle[] allBundles = new Bundle[]{iBundle, jBundle, mBundle, nBundle, pBundle, qBundle};
        this.doRefreshTest(allBundles, jBundle);
    }

    private void doRefreshTest(Bundle[] allBundles, Bundle toRefresh) {
        installer.resolveBundles(allBundles);
        Bundle[] refreshed = installer.refreshPackages(new Bundle[]{toRefresh});
        Bundle[] bundleArray = allBundles;
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle allBundle = bundleArray[n2];
            boolean found = false;
            int j = 0;
            while (j < refreshed.length && !found) {
                found = allBundle == refreshed[j];
                ++j;
            }
            Assert.assertTrue((String)("bundle did not get refreshed: " + String.valueOf(allBundle)), (boolean)found);
            ++n2;
        }
        Assert.assertEquals((String)"Wrong number of bundles refreshed", (long)allBundles.length, (long)refreshed.length);
    }

    @Test
    public void testSubstituteExports13() throws BundleException {
        Bundle[] expectedImporters;
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle c = installer.installBundle("substitutes.c");
        Bundle d = installer.installBundle("substitutes.d");
        Bundle[] allBundles = new Bundle[]{a, b, c, d};
        Assert.assertTrue((String)"Bundles are not resolved", (boolean)installer.resolveBundles(allBundles));
        PackageAdmin pa = installer.getPackageAdmin();
        ExportedPackage[] xPackages = pa.getExportedPackages("substitutes.x");
        Assert.assertNotNull((String)"xPackages is null", (Object)xPackages);
        Assert.assertEquals((String)"xPackages wrong number", (long)1L, (long)xPackages.length);
        Assert.assertEquals((String)"Wrong exporter", (Object)a, (Object)xPackages[0].getExportingBundle());
        Bundle[] xImporters = xPackages[0].getImportingBundles();
        Assert.assertNotNull((String)"xImporters is null", (Object)xImporters);
        Assert.assertEquals((String)"Wrong number of xImporters", (long)3L, (long)xImporters.length);
        ExportedPackage[] yPackages = pa.getExportedPackages("substitutes.y");
        Assert.assertNotNull((String)"yPackages is null", (Object)yPackages);
        Assert.assertEquals((String)"yPackages wrong number", (long)1L, (long)yPackages.length);
        Assert.assertEquals((String)"Wrong exporter", (Object)a, (Object)yPackages[0].getExportingBundle());
        Bundle[] yImporters = yPackages[0].getImportingBundles();
        Assert.assertNotNull((String)"yImporters is null", (Object)yImporters);
        Assert.assertEquals((String)"Wrong number of yImporters", (long)3L, (long)yImporters.length);
        Bundle[] bundleArray = expectedImporters = new Bundle[]{b, c, d};
        int n = expectedImporters.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle expectedImporter = bundleArray[n2];
            this.contains("xPackages importers does not contain", xImporters, expectedImporter);
            this.contains("yPackages importers does not contain", yImporters, expectedImporter);
            ++n2;
        }
    }

    @Test
    public void testSubstituteExports14() throws BundleException {
        Bundle[] expectedExporters;
        Bundle iBundle = installer.installBundle("substitutes.i");
        Bundle jBundle = installer.installBundle("substitutes.j");
        Bundle kBundle = installer.installBundle("substitutes.k");
        Bundle lBundle = installer.installBundle("substitutes.l");
        Bundle mBundle = installer.installBundle("substitutes.m");
        Bundle nBundle = installer.installBundle("substitutes.n");
        Bundle pBundle = installer.installBundle("substitutes.p");
        Bundle qBundle = installer.installBundle("substitutes.q");
        Bundle[] allBundles = new Bundle[]{iBundle, jBundle, kBundle, lBundle, mBundle, nBundle, pBundle, qBundle};
        Assert.assertTrue((String)"Bundles are not resolved", (boolean)installer.resolveBundles(allBundles));
        PackageAdmin pa = installer.getPackageAdmin();
        ExportedPackage[] xPackages = pa.getExportedPackages("substitutes.x");
        Assert.assertNotNull((String)"xPackages is null", (Object)xPackages);
        Assert.assertEquals((String)"xPackages wrong number", (long)3L, (long)xPackages.length);
        ExportedPackage[] yPackages = pa.getExportedPackages("substitutes.y");
        Assert.assertNotNull((String)"yPackages is null", (Object)yPackages);
        Assert.assertEquals((String)"yPackages wrong number", (long)3L, (long)yPackages.length);
        Bundle[] bundleArray = expectedExporters = new Bundle[]{iBundle, kBundle, mBundle};
        int n = expectedExporters.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle expectedExporter = bundleArray[n2];
            boolean found = false;
            int j = 0;
            while (j < xPackages.length && !found) {
                boolean bl = found = expectedExporter == xPackages[j].getExportingBundle();
                if (found) {
                    Bundle[] importingBundles = xPackages[j].getImportingBundles();
                    Bundle[] expectedImporters = null;
                    String message = null;
                    if (expectedExporter == iBundle) {
                        expectedImporters = new Bundle[]{jBundle, mBundle, nBundle, pBundle, qBundle};
                        message = "iBundle ";
                    } else if (expectedExporter == kBundle) {
                        expectedImporters = new Bundle[]{lBundle, mBundle, nBundle, pBundle, qBundle};
                        message = "kBundle ";
                    } else if (expectedExporter == mBundle) {
                        expectedImporters = new Bundle[]{nBundle, pBundle, qBundle};
                        message = "mBundle ";
                    }
                    Assert.assertEquals(message, (long)expectedImporters.length, (long)importingBundles.length);
                    Bundle[] bundleArray2 = expectedImporters;
                    int n3 = expectedImporters.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Bundle expectedImporter = bundleArray2[n4];
                        this.contains(message, importingBundles, expectedImporter);
                        ++n4;
                    }
                }
                ++j;
            }
            ++n2;
        }
    }

    private void contains(String message, Bundle[] bundles, Bundle b) {
        boolean found = false;
        int i = 0;
        while (i < bundles.length && !found) {
            found = bundles[i] == b;
            ++i;
        }
        Assert.assertTrue((String)(message + String.valueOf(b)), (boolean)found);
    }
}

