/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.net.SocketFactory;
import junit.framework.AssertionFailedError;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.test.TestListener;
import org.eclipse.equinox.log.test.TestListener2;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.framework.util.FilePath;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.eclipse.osgi.storage.url.reference.Handler;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.BundleInstaller;
import org.eclipse.osgi.tests.security.BaseSecurityTest;
import org.eclipse.osgi.tests.securityadmin.SecurityManagerTests;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

public class SystemBundleTests
extends AbstractBundleTests {
    static final String nullTest = "null.test";

    @Test
    public void testSystemBundle01() throws BundleException, InvalidSyntaxException {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle01");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"SystemBundle context is null", (Object)systemContext);
        ServiceReference[] refs = systemContext.getServiceReferences(Location.class.getName(), "(type=osgi.configuration.area)");
        Assert.assertNotNull((String)"Configuration Location refs is null", (Object)refs);
        Assert.assertEquals((String)"config refs length is wrong", (long)1L, (long)refs.length);
        Location configLocation = (Location)systemContext.getService(refs[0]);
        URL configURL = configLocation.getURL();
        Assert.assertTrue((String)"incorrect configuration location", (boolean)configURL.toExternalForm().endsWith("testSystemBundle01/"));
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testSystemBundle02() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle02");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testSystemBundle03() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle03");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        String configArea = systemContext.getProperty("osgi.configuration.area");
        Assert.assertNotNull((String)"config property is null", (Object)configArea);
        Assert.assertTrue((String)"Wrong configuration area", (boolean)configArea.endsWith("testSystemBundle03/"));
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testSystemBundle04() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle04");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle substitutesA = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        substitutesA.start();
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        Assert.assertEquals((String)"Wrong state for installed bundle", (long)32L, (long)substitutesA.getState());
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testSystemBundle05_1() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle05_1");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle substitutesA = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        Assert.assertEquals((String)"Wrong state for installed bundle", (long)2L, (long)substitutesA.getState());
        substitutesA.start();
        Assert.assertEquals((String)"Wrong state for active bundle", (long)32L, (long)substitutesA.getState());
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testSystemBundle05_2() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle05_2");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle substitutesA = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        Assert.assertEquals((String)"Wrong state for installed bundle", (long)2L, (long)substitutesA.getState());
        substitutesA.start();
        Assert.assertEquals((String)"Wrong state for active bundle", (long)32L, (long)substitutesA.getState());
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        Bundle substitutesA2 = equinox.getBundleContext().installBundle(installer.getBundleLocation("substitutes.a"));
        Assert.assertEquals((String)"Bundle ids are not the same", (long)substitutesA.getBundleId(), (long)substitutesA2.getBundleId());
        Assert.assertEquals((String)"Wrong state for active bundle", (long)32L, (long)substitutesA2.getState());
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testSystemBundle06() throws BundleException {
        File config1 = OSGiTestsActivator.getContext().getDataFile("testSystemBundle06_1");
        HashMap<String, String> configuration1 = new HashMap<String, String>();
        configuration1.put("org.osgi.framework.storage", config1.getAbsolutePath());
        Equinox equinox1 = new Equinox(configuration1);
        equinox1.init();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox1.getState());
        File config2 = OSGiTestsActivator.getContext().getDataFile("testSystemBundle06_2");
        HashMap<String, String> configuration2 = new HashMap<String, String>();
        configuration2.put("org.osgi.framework.storage", config2.getAbsolutePath());
        Equinox equinox2 = new Equinox(configuration2);
        equinox2.init();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox2.getState());
        BundleContext systemContext1 = equinox1.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext1);
        BundleContext systemContext2 = equinox2.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext2);
        Assert.assertNotSame((Object)systemContext1, (Object)systemContext2);
        equinox1.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox1.getState());
        equinox2.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox2.getState());
        SystemBundleTests.stop((Framework)equinox1);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox1.getState());
        SystemBundleTests.stop((Framework)equinox2);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox2.getState());
    }

    @Test
    public void testSystemBundle07() throws BundleException, InvalidSyntaxException {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle07_01");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        equinox.init();
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"SystemBundle context is null", (Object)systemContext);
        equinox.init();
        ServiceReference[] refs = systemContext.getServiceReferences(Location.class.getName(), "(type=osgi.configuration.area)");
        Assert.assertNotNull((String)"Configuration Location refs is null", (Object)refs);
        Assert.assertEquals((String)"config refs length is wrong", (long)1L, (long)refs.length);
        Location configLocation = (Location)systemContext.getService(refs[0]);
        URL configURL = configLocation.getURL();
        Assert.assertTrue((String)"incorrect configuration location", (boolean)configURL.toExternalForm().endsWith("testSystemBundle07_01/"));
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testSystemBundle08() throws BundleException, InvalidSyntaxException {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle08_1");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle08_2");
        configuration = new HashMap();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        equinox = new Equinox(configuration);
        equinox.init();
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        ServiceReference[] refs = equinox.getBundleContext().getServiceReferences(Location.class.getName(), "(type=osgi.configuration.area)");
        Assert.assertNotNull((String)"Configuration Location refs is null", (Object)refs);
        Assert.assertEquals((String)"config refs length is wrong", (long)1L, (long)refs.length);
        Location configLocation = (Location)equinox.getBundleContext().getService(refs[0]);
        URL configURL = configLocation.getURL();
        Assert.assertTrue((String)"incorrect configuration location", (boolean)configURL.toExternalForm().endsWith("testSystemBundle08_2/"));
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testSystemBundle09() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle09");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        Bundle testFilterA = equinox.getBundleContext().installBundle(installer.getBundleLocation("test.filter.a"));
        testFilterA.start();
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testSystemBundle10() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle10");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        FrameworkEvent success = SystemBundleTests.update((Framework)equinox);
        Assert.assertEquals((String)"Wait for stop event type is wrong", (long)128L, (long)success.getType());
        int i = 0;
        while (i < 5 && 32 != equinox.getState()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testSystemBundle11() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle11");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.system.packages.extra", "test.pkg1, test.pkg2");
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"SystemBundle context is null", (Object)systemContext);
        PackageAdmin pa = (PackageAdmin)equinox.getBundleContext().getService(equinox.getBundleContext().getServiceReference(PackageAdmin.class.getName()));
        ExportedPackage[] pkg1 = pa.getExportedPackages("test.pkg1");
        Assert.assertNotNull((Object)pkg1);
        Assert.assertEquals((String)"Wrong number of exports", (long)1L, (long)pkg1.length);
        Assert.assertEquals((String)"Wrong package name", (Object)"test.pkg1", (Object)pkg1[0].getName());
        ExportedPackage[] pkg2 = pa.getExportedPackages("test.pkg2");
        Assert.assertNotNull((Object)pkg2);
        Assert.assertEquals((String)"Wrong number of exports", (long)1L, (long)pkg2.length);
        Assert.assertEquals((String)"Wrong package name", (Object)"test.pkg2", (Object)pkg2[0].getName());
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testSystemBundle12() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle12");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        equinox.start();
        FrameworkEvent stopEvent = equinox.waitForStop(1000L);
        Assert.assertNotNull((String)"Stop event is null", (Object)stopEvent);
        Assert.assertEquals((String)"Wrong stopEvent", (long)512L, (long)stopEvent.getType());
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        stopEvent = SystemBundleTests.stop((Framework)equinox);
        Assert.assertNotNull((String)"Stop event is null", (Object)stopEvent);
        Assert.assertEquals((String)"Wrong stopEvent", (long)64L, (long)stopEvent.getType());
    }

    @Test
    public void testSystemBundle13() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle13");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle substitutesA = null;
        substitutesA = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        Assert.assertEquals((String)"Wrong state for installed bundle", (long)2L, (long)substitutesA.getState());
        substitutesA.start();
        Assert.assertEquals((String)"Wrong state for active bundle", (long)32L, (long)substitutesA.getState());
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        configuration = new HashMap();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        equinox = new Equinox(configuration);
        equinox.init();
        substitutesA = equinox.getBundleContext().getBundle(1L);
        Assert.assertNotNull((String)"missing installed bundle", (Object)substitutesA);
        Assert.assertEquals((String)"Unexpected symbolic name", (Object)"substitutes.a", (Object)substitutesA.getSymbolicName());
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        configuration = new HashMap();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.storage.clean", "onFirstInit");
        equinox = new Equinox(configuration);
        equinox.init();
        substitutesA = equinox.getBundleContext().getBundle(1L);
        Assert.assertNull((String)"Unexpected bundle is installed", (Object)substitutesA);
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testSystemBundle14() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle14");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.startlevel.beginning", "10");
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        equinox.start();
        StartLevel st = (StartLevel)equinox.getBundleContext().getService(equinox.getBundleContext().getServiceReference(StartLevel.class.getName()));
        Assert.assertNotNull((String)"StartLevel service is null", (Object)st);
        Assert.assertEquals((String)"Unexpected start level", (long)10L, (long)st.getStartLevel());
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        FrameworkEvent stopEvent = SystemBundleTests.stop((Framework)equinox);
        Assert.assertNotNull((String)"Stop event is null", (Object)stopEvent);
        Assert.assertEquals((String)"Wrong stopEvent", (long)64L, (long)stopEvent.getType());
    }

    @Test
    public void testSystemBundle16() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.bundle.parent", "boot");
        this.checkParentClassLoader(configuration);
    }

    @Test
    public void testSystemBundle17() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.bundle.parent", "app");
        this.checkParentClassLoader(configuration);
    }

    @Test
    public void testSystemBundle18() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.bundle.parent", "ext");
        this.checkParentClassLoader(configuration);
    }

    @Test
    public void testSystemBundle19() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.bundle.parent", "framework");
        this.checkParentClassLoader(configuration);
    }

    private void checkParentClassLoader(Map<String, Object> configuration) throws BundleException, ClassNotFoundException {
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        Bundle test = equinox.getBundleContext().installBundle(installer.getBundleLocation("substitutes.a"));
        Class activatorClazz = test.loadClass("substitutes.x.Ax");
        ClassLoader parentCL = activatorClazz.getClassLoader().getParent();
        String configParent = (String)configuration.get("org.osgi.framework.bundle.parent");
        if ("app".equals(configParent)) {
            Assert.assertSame((String)"Wrong parent", (Object)ClassLoader.getSystemClassLoader(), (Object)parentCL);
        } else if ("ext".equals(configParent)) {
            Assert.assertSame((String)"Wrong parent", (Object)ClassLoader.getSystemClassLoader().getParent(), (Object)parentCL);
        } else if ("framework".equals(configParent)) {
            Assert.assertSame((String)"Wrong parent", (Object)equinox.getClass().getClassLoader(), (Object)parentCL);
        }
        SystemBundleTests.stop((Framework)equinox, 64);
    }

    @Test
    public void testChangeEE() throws IOException, BundleException {
        URL javaSE8Profile = OSGiTestsActivator.getContext().getBundle("System Bundle").getEntry("JavaSE-1.8.profile");
        URL javaSE9Profile = OSGiTestsActivator.getContext().getBundle("System Bundle").getEntry("JavaSE-9.profile");
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.java.profile", javaSE9Profile.toExternalForm());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        HashMap<String, String> testHeaders = new HashMap<String, String>();
        testHeaders.put("Bundle-ManifestVersion", "2");
        testHeaders.put("Bundle-SymbolicName", this.getName());
        testHeaders.put("Bundle-RequiredExecutionEnvironment", "JavaSE-9");
        File testBundle = SystemBundleTests.createBundle(config, this.getName(), testHeaders, new Map[0]);
        Bundle b = systemContext.installBundle("reference:file:///" + testBundle.getAbsolutePath());
        long bid = b.getBundleId();
        Assert.assertTrue((String)"Could not resolve bundle.", (boolean)((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(b)));
        SystemBundleTests.stop((Framework)equinox);
        configuration.put("osgi.java.profile", javaSE8Profile.toExternalForm());
        equinox = new Equinox(configuration);
        equinox.start();
        b = equinox.getBundleContext().getBundle(bid);
        Assert.assertFalse((String)"Could resolve bundle.", (boolean)((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(b)));
        SystemBundleTests.stop((Framework)equinox);
        configuration.put("osgi.java.profile", javaSE9Profile.toExternalForm());
        equinox = new Equinox(configuration);
        equinox.start();
        b = equinox.getBundleContext().getBundle(bid);
        Assert.assertTrue((String)"Could not resolve bundle.", (boolean)((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(b)));
        SystemBundleTests.stop((Framework)equinox);
    }

    @Test
    public void testMRUBundleFileList() throws Exception {
        this.doMRUBundleFileList(10);
    }

    @Test
    @Ignore
    public void testMRUBundleFileListExpectedToFail() throws Exception {
        this.doMRUBundleFileList(0);
    }

    private void doMRUBundleFileList(int limit) throws Exception {
        File[] testBundles;
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.bundlefile.limit", Integer.toString(limit));
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        File[] fileArray = testBundles = SystemBundleTests.createBundles(new File(config, "bundles"), 3000);
        int n = testBundles.length;
        int n2 = 0;
        while (n2 < n) {
            File testBundle = fileArray[n2];
            systemContext.installBundle("reference:file:///" + testBundle.getAbsolutePath());
            ++n2;
        }
        SystemBundleTests.stop((Framework)equinox);
        equinox.start();
        this.openAllBundleFiles(equinox.getBundleContext());
        SystemBundleTests.update((Framework)equinox);
        equinox.start();
        this.openAllBundleFiles(equinox.getBundleContext());
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    private void openAllBundleFiles(BundleContext context) {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Assert.assertNotNull((String)("No manifest for: " + String.valueOf(bundle)), (Object)bundle.getEntry("/META-INF/MANIFEST.MF"));
            ++n2;
        }
    }

    @Test
    public void testURLExternalFormat01() throws BundleException {
        File config1 = OSGiTestsActivator.getContext().getDataFile("testURLExternalFormat01_1");
        HashMap<String, String> configuration1 = new HashMap<String, String>();
        configuration1.put("org.osgi.framework.storage", config1.getAbsolutePath());
        Equinox equinox1 = new Equinox(configuration1);
        equinox1.init();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox1.getState());
        File config2 = OSGiTestsActivator.getContext().getDataFile("testURLExternalFormat01_2");
        HashMap<String, String> configuration2 = new HashMap<String, String>();
        configuration2.put("org.osgi.framework.storage", config2.getAbsolutePath());
        Equinox equinox2 = new Equinox(configuration2);
        equinox2.init();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox2.getState());
        BundleContext systemContext1 = equinox1.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext1);
        BundleContext systemContext2 = equinox2.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext2);
        Assert.assertNotSame((Object)systemContext1, (Object)systemContext2);
        Bundle test1 = null;
        Bundle test2 = null;
        test1 = systemContext1.installBundle(installer.getBundleLocation("test"));
        test2 = systemContext2.installBundle(installer.getBundleLocation("test"));
        URL entry1 = test1.getEntry("data/resource1");
        Assert.assertNotNull((String)"entry1", (Object)entry1);
        URL entry2 = test2.getEntry("data/resource1");
        Assert.assertNotNull((String)"entry2", (Object)entry2);
        Assert.assertFalse((String)("External form is equal: " + entry1.toExternalForm()), (boolean)entry1.toExternalForm().equals(entry2.toExternalForm()));
        Assert.assertFalse((String)("Host is equal: " + entry1.getHost()), (boolean)entry1.getHost().equals(entry2.getHost()));
        Assert.assertFalse((String)("URL is equal: " + entry1.toExternalForm()), (boolean)entry1.equals(entry2));
        Bundle substitutes1 = null;
        Bundle substitutes2 = null;
        substitutes1 = systemContext1.installBundle(installer.getBundleLocation("substitutes.a"));
        substitutes2 = systemContext2.installBundle(installer.getBundleLocation("substitutes.a"));
        entry1 = substitutes1.getResource("data/resource1");
        Assert.assertNotNull((String)"entry1", (Object)entry1);
        entry2 = substitutes2.getResource("data/resource1");
        Assert.assertNotNull((String)"entry2", (Object)entry2);
        Assert.assertFalse((String)("External form is equal: " + entry1.toExternalForm()), (boolean)entry1.toExternalForm().equals(entry2.toExternalForm()));
        Assert.assertFalse((String)("Host is equal: " + entry1.getHost()), (boolean)entry1.getHost().equals(entry2.getHost()));
        Assert.assertFalse((String)("URL is equal: " + entry1.toExternalForm()), (boolean)entry1.equals(entry2));
        SystemBundleTests.stop((Framework)equinox1);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox1.getState());
        SystemBundleTests.stop((Framework)equinox2);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox2.getState());
    }

    @Test
    public void testURLMultiplexing01() throws Exception {
        File config1 = OSGiTestsActivator.getContext().getDataFile(this.getName() + "_1");
        HashMap<String, String> configuration1 = new HashMap<String, String>();
        configuration1.put("org.osgi.framework.storage", config1.getAbsolutePath());
        Equinox equinox1 = new Equinox(configuration1);
        equinox1.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox1.getState());
        File config2 = OSGiTestsActivator.getContext().getDataFile(this.getName() + "_2");
        HashMap<String, String> configuration2 = new HashMap<String, String>();
        configuration2.put("org.osgi.framework.storage", config2.getAbsolutePath());
        Equinox equinox2 = new Equinox(configuration2);
        equinox2.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox2.getState());
        BundleContext systemContext1 = equinox1.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext1);
        BundleContext systemContext2 = equinox2.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext2);
        Assert.assertNotSame((Object)systemContext1, (Object)systemContext2);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("url.handler.protocol", this.getName().toLowerCase());
        ServiceRegistration handlerReg = OSGiTestsActivator.getContext().registerService(URLStreamHandlerService.class, (Object)new TestHandler(), props);
        URL baseTestUrl = new URL(this.getName().toLowerCase(), "", "/test/url");
        System.getProperties().put("test.url", baseTestUrl);
        System.setProperty("test.url.spec", baseTestUrl.toExternalForm());
        Bundle geturlBundle = systemContext1.installBundle(installer.getBundleLocation("geturl"));
        geturlBundle.start();
        PrivilegedAction geturlAction = (PrivilegedAction)systemContext1.getService(systemContext1.getServiceReference(PrivilegedAction.class));
        geturlAction.run();
        SystemBundleTests.stop((Framework)equinox1);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox1.getState());
        SystemBundleTests.stop((Framework)equinox2);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox2.getState());
        handlerReg.unregister();
        System.getProperties().remove("test.url");
    }

    @Test
    public void testUUID() throws BundleException {
        File config1 = OSGiTestsActivator.getContext().getDataFile(this.getName() + "_1");
        HashMap<String, String> configuration1 = new HashMap<String, String>();
        configuration1.put("org.osgi.framework.storage", config1.getAbsolutePath());
        Equinox equinox1 = new Equinox(configuration1);
        equinox1.init();
        String uuid1_1 = equinox1.getBundleContext().getProperty("org.osgi.framework.uuid");
        this.verifyUUID(uuid1_1);
        File config2 = OSGiTestsActivator.getContext().getDataFile(this.getName() + "_2");
        HashMap<String, String> configuration2 = new HashMap<String, String>();
        configuration2.put("org.osgi.framework.storage", config2.getAbsolutePath());
        Equinox equinox2 = new Equinox(configuration1);
        equinox2.init();
        String uuid2_1 = equinox2.getBundleContext().getProperty("org.osgi.framework.uuid");
        this.verifyUUID(uuid2_1);
        Assert.assertFalse((String)("UUIDs are the same: " + uuid1_1), (boolean)uuid1_1.equals(uuid2_1));
        SystemBundleTests.stop((Framework)equinox1);
        SystemBundleTests.stop((Framework)equinox2);
        equinox1.init();
        equinox2.init();
        String uuid1_2 = equinox1.getBundleContext().getProperty("org.osgi.framework.uuid");
        this.verifyUUID(uuid1_2);
        String uuid2_2 = equinox2.getBundleContext().getProperty("org.osgi.framework.uuid");
        this.verifyUUID(uuid2_2);
        Assert.assertFalse((String)("UUIDs are the same: " + uuid1_1), (boolean)uuid1_1.equals(uuid1_2));
        Assert.assertFalse((String)("UUIDs are the same: " + uuid1_2), (boolean)uuid1_2.equals(uuid2_2));
        Assert.assertFalse((String)("UUIDs are the same: " + uuid2_1), (boolean)uuid2_1.equals(uuid2_2));
        SystemBundleTests.stop((Framework)equinox1);
        SystemBundleTests.stop((Framework)equinox2);
    }

    private void verifyUUID(String uuid) {
        Assert.assertNotNull((String)"Null uuid.", (Object)uuid);
        StringTokenizer st = new StringTokenizer(uuid, "-");
        String[] uuidSections = new String[5];
        int i = 0;
        while (i < uuidSections.length) {
            uuidSections[i] = "0x" + st.nextToken();
            ++i;
        }
        Assert.assertThrows((String)("Too many sections in uuid: " + uuid), NoSuchElementException.class, () -> {
            String string = st.nextToken();
        });
        i = 0;
        while (i < uuidSections.length) {
            int limit = 0;
            switch (i) {
                case 0: {
                    limit = 10;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    limit = 6;
                    break;
                }
                case 4: {
                    limit = 14;
                    break;
                }
            }
            Assert.assertTrue((String)("UUIDSection is too big: " + uuidSections[i]), (uuidSections[i].length() <= limit ? 1 : 0) != 0);
            Long.decode(uuidSections[i]);
            ++i;
        }
    }

    @Test
    public void testBug304213() throws Exception {
        Bundle[] bundles;
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        File baseDir = new File(config, "bundles");
        baseDir.mkdirs();
        File bundleFile = SystemBundleTests.createBundle(baseDir, this.getName(), true, true);
        systemContext.installBundle("reference:file:///" + bundleFile.getAbsolutePath());
        SystemBundleTests.stop((Framework)equinox);
        equinox.start();
        new File(bundleFile, "META-INF/MANIFEST.MF").delete();
        systemContext = equinox.getBundleContext();
        Bundle[] bundleArray = bundles = systemContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            bundle.getHeaders();
            ++n2;
        }
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testBug351083DevClassPath() throws InvalidSyntaxException, BundleException {
        BundleInstaller testBundleInstaller = new BundleInstaller("test_files/devCPTests", OSGiTestsActivator.getContext());
        try {
            File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
            configuration.put("osgi.dev", "../devCP");
            Equinox equinox = new Equinox(configuration);
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Assert.assertNotNull((String)"System context is null", (Object)systemContext);
            Bundle tb1 = systemContext.installBundle(testBundleInstaller.getBundleLocation("tb1"));
            URL resource = tb1.getResource("tb1/resource.txt");
            Assert.assertNotNull((String)"Resource is null", (Object)resource);
            SystemBundleTests.stop((Framework)equinox);
            Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        }
        finally {
            testBundleInstaller.shutdown();
        }
    }

    @Test
    public void testBug352275() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.system.packages.extra", "");
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        equinox.start();
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    @Ignore
    public void tTestBug351519RefreshEnabled() throws Exception {
        this.doTestBug351519Refresh(Boolean.TRUE);
    }

    @Test
    public void testBug351519RefreshDisabled() throws Exception {
        this.doTestBug351519Refresh(Boolean.FALSE);
    }

    @Test
    public void testBug351519RefreshDefault() throws Exception {
        this.doTestBug351519Refresh(null);
    }

    @Test
    public void testWeavingPersistence() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle test1 = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        long testID1 = test1.getBundleId();
        Bundle testFinal1 = test1;
        ServiceRegistration reg = systemContext.registerService(WeavingHook.class, wovenClass -> {
            if (!testFinal1.equals(wovenClass.getBundleWiring().getBundle())) {
                return;
            }
            if (!"substitutes.x.Ax".equals(wovenClass.getClassName())) {
                return;
            }
            List dynamicImports = wovenClass.getDynamicImports();
            dynamicImports.add("*");
        }, null);
        try {
            testFinal1.loadClass("substitutes.x.Ax");
            testFinal1.loadClass("org.osgi.framework.hooks.bundle.FindHook");
        }
        finally {
            reg.unregister();
        }
        SystemBundleTests.stop((Framework)equinox);
        equinox.start();
        systemContext = equinox.getBundleContext();
        test1 = systemContext.getBundle(testID1);
        Bundle test2 = systemContext.installBundle(installer.getBundleLocation("exporter.importer1"));
        long testID2 = test2.getBundleId();
        Bundle testFinal2 = test2;
        reg = systemContext.registerService(WeavingHook.class, wovenClass -> {
            if (!testFinal2.equals(wovenClass.getBundleWiring().getBundle())) {
                return;
            }
            if (!"exporter.importer.test.Test1".equals(wovenClass.getClassName())) {
                return;
            }
            List dynamicImports = wovenClass.getDynamicImports();
            dynamicImports.add("*");
        }, null);
        try {
            testFinal2.loadClass("exporter.importer.test.Test1");
            testFinal2.loadClass("org.osgi.framework.hooks.service.FindHook");
        }
        finally {
            reg.unregister();
        }
        SystemBundleTests.stop((Framework)equinox);
        equinox.start();
        systemContext = equinox.getBundleContext();
        test1 = systemContext.getBundle(testID1);
        test2 = systemContext.getBundle(testID2);
        BundleRevision rev1 = (BundleRevision)test1.adapt(BundleRevision.class);
        BundleRevision rev2 = (BundleRevision)test2.adapt(BundleRevision.class);
        BundleWiring wiring1 = rev1.getWiring();
        BundleWiring wiring2 = rev2.getWiring();
        Assert.assertNotNull((String)"wiring1 is null", (Object)wiring1);
        Assert.assertNotNull((String)"wiring2 is null", (Object)wiring2);
        List packages1 = wiring1.getRequiredWires("osgi.wiring.package");
        List packages2 = wiring2.getRequiredWires("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of wires for wiring1", (long)1L, (long)packages1.size());
        Assert.assertEquals((String)"Wrong number of wires for wiring2", (long)1L, (long)packages2.size());
        SystemBundleTests.stop((Framework)equinox);
    }

    private void doTestBug351519Refresh(Boolean refreshDuplicates) throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        if (refreshDuplicates != null) {
            configuration.put("equinox.refresh.duplicate.bsn", refreshDuplicates.toString());
        } else {
            refreshDuplicates = Boolean.FALSE;
        }
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        systemContext.registerService(ResolverHookFactory.class, triggers -> new ResolverHook(){

            public void filterResolvable(Collection candidates) {
            }

            public void filterSingletonCollisions(BundleCapability singleton, Collection collisionCandidates) {
                collisionCandidates.clear();
            }

            public void filterMatches(BundleRequirement requirement, Collection candidates) {
            }

            public void end() {
            }
        }, null);
        BundleInstaller testBundleResolver = new BundleInstaller("test_files/wiringTests/bundles", systemContext);
        BundleInstaller testBundleInstaller = new BundleInstaller("test_files/wiringTests/bundles", this.getContext());
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle tb1v1 = null;
        Bundle tb1v2 = null;
        tb1v1 = systemContext.installBundle(testBundleInstaller.getBundleLocation("singleton.tb1v1"));
        tb1v2 = systemContext.installBundle(testBundleInstaller.getBundleLocation("singleton.tb1v2"));
        Assert.assertTrue((String)"Could not resolve test bundles", (boolean)testBundleResolver.resolveBundles(new Bundle[]{tb1v1, tb1v2}));
        Bundle[] refreshed = testBundleResolver.refreshPackages(new Bundle[]{tb1v1});
        if (refreshDuplicates.booleanValue()) {
            List<Bundle> refreshedList = Arrays.asList(refreshed);
            Assert.assertEquals((String)"Wrong number of refreshed bundles", (long)2L, (long)refreshed.length);
            Assert.assertTrue((String)"Refreshed bundles does not include v1", (boolean)refreshedList.contains(tb1v1));
            Assert.assertTrue((String)"Refreshed bundles does not include v2", (boolean)refreshedList.contains(tb1v2));
        } else {
            Assert.assertEquals((String)"Wrong number of refreshed bundles", (long)1L, (long)refreshed.length);
            Assert.assertEquals((String)"Refreshed bundles does not include v1", (Object)refreshed[0], (Object)tb1v1);
        }
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testBug375784() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.context.bootdelegation", "true");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle tb1 = systemContext.installBundle(installer.getBundleLocation("test.bug375784"));
        tb1.start();
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testBug258209_1() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Thread.currentThread().setContextClassLoader(current);
        BundleContext systemContext = equinox.getBundleContext();
        Bundle testTCCL = systemContext.installBundle(installer.getBundleLocation("test.tccl"));
        ((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Arrays.asList(testTCCL));
        testTCCL.start();
        Assert.assertEquals((String)"Unexpected state", (long)4L, (long)testTCCL.getState());
        equinox.start();
        Assert.assertEquals((String)"Unexpected state", (long)32L, (long)testTCCL.getState());
        SystemBundleTests.update((Framework)equinox);
        this.checkActive(testTCCL);
        systemContext = equinox.getBundleContext();
        Assert.assertEquals((String)"Unexpected state", (long)32L, (long)testTCCL.getState());
        ((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).refreshBundles(Arrays.asList(testTCCL), new FrameworkListener[0]);
        this.checkActive(testTCCL);
        Assert.assertEquals((String)"Unexpected state", (long)32L, (long)testTCCL.getState());
        ClassLoader serviceTCCL = (ClassLoader)systemContext.getService(systemContext.getServiceReferences(ClassLoader.class.getName(), "(equinox.classloader.type=contextClassLoader)")[0]);
        current = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(serviceTCCL);
        try {
            testTCCL.stop();
            testTCCL.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
        SystemBundleTests.stop((Framework)equinox);
    }

    private void checkActive(Bundle b) throws InterruptedException {
        Thread.sleep(500L);
        if (b.getState() != 32) {
            Thread.sleep(500L);
        }
    }

    @Test
    public void testBug413879() throws Exception {
        Bundle test1;
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle testFinal1 = test1 = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        ServiceRegistration reg = systemContext.registerService(WeavingHook.class, wovenClass -> {
            if (!testFinal1.equals(wovenClass.getBundleWiring().getBundle())) {
                return;
            }
            if (!"substitutes.x.Ax".equals(wovenClass.getClassName())) {
                return;
            }
            List dynamicImports = wovenClass.getDynamicImports();
            dynamicImports.add("*");
        }, null);
        ServiceRegistration resolverHookReg = systemContext.registerService(ResolverHookFactory.class, triggers -> {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            return null;
        }, null);
        Set errors = Collections.newSetFromMap(new ConcurrentHashMap());
        try {
            Runnable dynamicLoadClass = () -> {
                try {
                    testFinal1.loadClass("substitutes.x.Ax");
                    testFinal1.loadClass("org.osgi.framework.hooks.bundle.FindHook");
                }
                catch (Throwable t) {
                    errors.add(t);
                }
            };
            Thread t1 = new Thread(dynamicLoadClass, this.getName() + "-1");
            Thread t2 = new Thread(dynamicLoadClass, this.getName() + "-2");
            t1.start();
            t2.start();
            t1.join();
            t2.join();
        }
        finally {
            reg.unregister();
            resolverHookReg.unregister();
        }
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertTrue((String)"Failed to resolve dynamic", (boolean)errors.isEmpty());
    }

    @Test
    public void testBug414070() throws BundleException, InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        BundleContext systemContext = equinox.getBundleContext();
        Bundle systemBundle = systemContext.getBundle();
        Bundle chainTest = systemContext.installBundle(installer.getBundleLocation("chain.test"));
        Bundle chainTestD = systemContext.installBundle(installer.getBundleLocation("chain.test.d"));
        Bundle chainTestA = systemContext.installBundle(installer.getBundleLocation("chain.test.a"));
        Bundle chainTestB = systemContext.installBundle(installer.getBundleLocation("chain.test.b"));
        Bundle chainTestC = systemContext.installBundle(installer.getBundleLocation("chain.test.c"));
        systemContext.registerService(WeavingHook.class, wovenClass -> {
            if (!chainTestD.equals(wovenClass.getBundleWiring().getBundle())) {
                return;
            }
            if (!"chain.test.d.DMultipleChain1".equals(wovenClass.getClassName())) {
                return;
            }
            List dynamicImports = wovenClass.getDynamicImports();
            dynamicImports.add("*");
        }, null);
        equinox.start();
        chainTest.loadClass("chain.test.TestMultiChain").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        chainTestD.loadClass("chain.test.a.AMultiChain1");
        Assert.assertEquals((String)"A is not active.", (long)32L, (long)chainTestA.getState());
        Assert.assertEquals((String)"B is not active.", (long)32L, (long)chainTestB.getState());
        Assert.assertEquals((String)"C is not active.", (long)32L, (long)chainTestC.getState());
        Assert.assertEquals((String)"D is not active.", (long)32L, (long)chainTestD.getState());
        ArrayList stoppingOrder = new ArrayList();
        systemContext.addBundleListener((BundleListener)((SynchronousBundleListener)event -> {
            if (event.getType() == 256) {
                stoppingOrder.add(event.getBundle());
            }
        }));
        SystemBundleTests.stop((Framework)equinox);
        List<Bundle> expectedOrder = Arrays.asList(systemBundle, chainTest, chainTestA, chainTestB, chainTestC, chainTestD);
        Assert.assertArrayEquals((String)"Wrong stopping order", (Object[])expectedOrder.toArray(), (Object[])stoppingOrder.toArray());
    }

    @Test
    public void testBug412228() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        BundleContext systemContext = equinox.getBundleContext();
        Bundle b = systemContext.installBundle(installer.getBundleLocation("test.bug412228"));
        b.start();
        equinox.start();
        long startTime = System.currentTimeMillis();
        SystemBundleTests.stop((Framework)equinox, true, 500L);
        long stopTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)("waitForStop time took too long: " + stopTime), (stopTime <= 2000L ? 1 : 0) != 0);
    }

    @Test
    public void testBug432632() throws BundleException, IOException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        Properties configIni = new Properties();
        configIni.setProperty("test.substitute1", "Some.$test.prop1$.test");
        configIni.setProperty("test.substitute2", "Some.$test.prop2$.test");
        configIni.store(new FileOutputStream(new File(config, "config.ini")), "Test config.ini");
        System.setProperty("test.prop1", "PASSED");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertEquals((String)"Wrong value for test.substitute1", (Object)"Some.PASSED.test", (Object)systemContext.getProperty("test.substitute1"));
        Assert.assertEquals((String)"Wrong value for test.substitute2", (Object)"Some.$test.prop2$.test", (Object)systemContext.getProperty("test.substitute2"));
        SystemBundleTests.stop((Framework)equinox);
    }

    @Test
    public void testDynamicSecurityManager() throws BundleException {
        Assume.assumeTrue((String)"Security-Manager is disallowed", (boolean)SecurityManagerTests.isSecurityManagerAllowed());
        SecurityManager sm = System.getSecurityManager();
        Assert.assertNull((String)"SecurityManager must be null to test.", (Object)sm);
        try {
            File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
            Equinox equinox = new Equinox(configuration);
            equinox.start();
            Bundle substitutesA = null;
            substitutesA = equinox.getBundleContext().installBundle(installer.getBundleLocation("substitutes.a"));
            Assert.assertTrue((String)"BundleCould not resolve.", (boolean)((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(substitutesA)));
            ((BundleWiring)substitutesA.adapt(BundleWiring.class)).findEntries("/", null, 0);
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm, Object context) {
                }

                @Override
                public void checkPermission(Permission perm) {
                }
            });
            SystemBundleTests.stop((Framework)equinox);
            Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        }
        finally {
            System.setSecurityManager(null);
        }
    }

    @Test
    public void testNullConfigurationValue() throws BundleException {
        System.setProperty(nullTest, "system");
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put(nullTest, null);
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        String nullValue = equinox.getBundleContext().getProperty(nullTest);
        Assert.assertNull((String)("null.test is not null: " + nullValue), (Object)nullValue);
        String systemNullValue = System.getProperty(nullTest);
        Assert.assertEquals((String)"Wrong system null value.", (Object)"system", (Object)systemNullValue);
        equinox.stop();
    }

    @Test
    public void testNullConfigurationValueRequiredProperty() throws BundleException {
        String systemProcessor = System.getProperty("org.osgi.framework.processor");
        Assert.assertNotNull((Object)systemProcessor);
        try {
            System.setProperty("org.osgi.framework.processor", "hyperflux");
            File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
            configuration.put("org.osgi.framework.processor", null);
            Equinox equinox = new Equinox(configuration);
            equinox.start();
            String processor = equinox.getBundleContext().getProperty("org.osgi.framework.processor");
            Assert.assertEquals((String)"Wrong org.osgi.framework.processor", (Object)systemProcessor, (Object)processor);
            String systemValue = System.getProperty("org.osgi.framework.processor");
            Assert.assertEquals((String)"Wrong system value.", (Object)"hyperflux", (Object)systemValue);
            equinox.stop();
        }
        finally {
            System.setProperty("org.osgi.framework.processor", systemProcessor);
        }
    }

    @Test
    public void testAllNullConfigurationValues() throws BundleException {
        List<String> requiredProperties = Arrays.asList("org.osgi.framework.executionenvironment", "org.osgi.framework.language", "org.osgi.framework.os.name", "org.osgi.framework.os.version", "org.osgi.framework.processor", "org.osgi.framework.storage", "org.osgi.framework.system.capabilities", "org.osgi.framework.system.packages", "org.osgi.framework.uuid", "org.osgi.framework.vendor", "org.osgi.framework.version", "org.osgi.supports.framework.extension", "org.osgi.supports.framework.fragment", "org.osgi.supports.framework.requirebundle", "osgi.framework", "osgi.arch", "osgi.os", "osgi.ws", "osgi.ws", "osgi.nl", "eclipse.stateSaveDelayInterval", "equinox.init.uuid", "gosh.args", "eclipse.home.location", "osgi.configuration.area", "osgi.install.area", "osgi.logfile");
        Properties systemProperties = (Properties)System.getProperties().clone();
        HashMap<String, String> configuration = new HashMap<String, String>();
        for (Object key : systemProperties.keySet()) {
            configuration.put((String)key, null);
        }
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        for (Object key : systemProperties.keySet()) {
            String property = (String)key;
            String value = equinox.getBundleContext().getProperty(property);
            if (requiredProperties.contains(property)) {
                Assert.assertNotNull((String)(property + " is null"), (Object)value);
            } else {
                Assert.assertNull((String)(property + " is not null"), (Object)value);
            }
            String systemValue = System.getProperty(property);
            Assert.assertEquals((String)("Wrong system value for " + property), (Object)systemProperties.getProperty(property), (Object)systemValue);
        }
        Assert.assertEquals((Object)systemProperties, (Object)System.getProperties());
        equinox.stop();
    }

    @Test
    public void testNullConfigurationValueSystemProperties() throws BundleException {
        System.setProperty(nullTest, "system");
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.framework.useSystemProperties", "true");
        configuration.put(nullTest, null);
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        String nullValue = equinox.getBundleContext().getProperty(nullTest);
        Assert.assertNull((String)("null.test is not null: " + nullValue), (Object)nullValue);
        Assert.assertNull((String)"Did not get null system value.", (Object)System.getProperties().get(nullTest));
        ServiceReference envRef = equinox.getBundleContext().getServiceReference(EnvironmentInfo.class);
        EnvironmentInfo envInfo = (EnvironmentInfo)equinox.getBundleContext().getService(envRef);
        envInfo.setProperty(this.getName(), this.getName());
        Assert.assertEquals((String)"Got wrong value from system properties.", (Object)System.getProperty(this.getName()), (Object)this.getName());
        envInfo.setProperty(this.getName(), null);
        Assert.assertNull((String)"Did not get null system value.", (Object)System.getProperties().get(this.getName()));
        equinox.stop();
    }

    @Test
    public void testBackedBySystemReplaceSystemProperties() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.framework.useSystemProperties", "true");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        ServiceReference envRef = equinox.getBundleContext().getServiceReference(EnvironmentInfo.class);
        EnvironmentInfo envInfo = (EnvironmentInfo)equinox.getBundleContext().getService(envRef);
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)System.getProperties());
        System.setProperties(copy);
        String systemKey = this.getName() + ".system";
        System.setProperty(systemKey, this.getName());
        Assert.assertEquals((String)"Wrong context value", (Object)this.getName(), (Object)equinox.getBundleContext().getProperty(systemKey));
        Assert.assertEquals((String)"Wrong context value", (Object)this.getName(), (Object)envInfo.getProperty(systemKey));
        Assert.assertEquals((String)"Wrong EquinoxConfiguration config value", (Object)this.getName(), (Object)((EquinoxConfiguration)envInfo).getConfiguration(systemKey));
        String envKey = this.getName() + ".env";
        envInfo.setProperty(envKey, this.getName());
        Assert.assertEquals((String)"Wrong system value", (Object)this.getName(), (Object)System.getProperty(envKey));
        equinox.stop();
    }

    @Test
    public void testLocalConfigReplaceSystemProperties() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        ServiceReference envRef = equinox.getBundleContext().getServiceReference(EnvironmentInfo.class);
        EnvironmentInfo envInfo = (EnvironmentInfo)equinox.getBundleContext().getService(envRef);
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)System.getProperties());
        System.setProperties(copy);
        String systemKey = this.getName() + ".system";
        System.setProperty(systemKey, this.getName());
        Assert.assertEquals((String)"Wrong context value", (Object)this.getName(), (Object)equinox.getBundleContext().getProperty(systemKey));
        Assert.assertEquals((String)"Wrong context value", (Object)this.getName(), (Object)envInfo.getProperty(systemKey));
        Assert.assertNull((String)"Wrong EquinoxConfiguration config value", (Object)((EquinoxConfiguration)envInfo).getConfiguration(systemKey));
        String envKey = this.getName() + ".env";
        envInfo.setProperty(envKey, this.getName());
        Assert.assertNull((String)"Wrong system value", (Object)System.getProperty(envKey));
        equinox.stop();
    }

    @Test
    public void testSystemNLFragment() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.nl", "zh");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        equinox.getHeaders();
        BundleContext systemContext = equinox.getBundleContext();
        Bundle systemNLS = systemContext.installBundle(installer.getBundleLocation("test.system.nls"));
        ((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(systemNLS));
        Assert.assertEquals((String)"Wrong fragment state", (long)4L, (long)systemNLS.getState());
        Assert.assertEquals((String)"Wrong header value.", (Object)"TEST NAME", equinox.getHeaders().get("Bundle-Name"));
        equinox.stop();
    }

    @Test
    public void testNullConfiguration() {
        new Equinox(null);
    }

    @Test
    public void testNullStorageArea() throws BundleException {
        File install = this.getContext().getDataFile(this.getName());
        install.mkdirs();
        Equinox equinox = new Equinox(Collections.singletonMap("osgi.install.area", install.getAbsolutePath()));
        try {
            equinox.init();
            String storageArea = equinox.getBundleContext().getProperty("org.osgi.framework.storage");
            Assert.assertNotNull((String)"No storage area set.", (Object)storageArea);
        }
        finally {
            equinox.stop();
        }
    }

    @Test
    public void testOSGiDevSetsCheckConfiguration() throws BundleException {
        String originalCheckConfiguration = System.clearProperty("osgi.checkConfiguration");
        try {
            File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
            configuration.put("osgi.dev", "true");
            Equinox equinox = new Equinox(configuration);
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Assert.assertEquals((String)"Wrong value for: osgi.checkConfiguration", (Object)"true", (Object)systemContext.getProperty("osgi.checkConfiguration"));
            equinox.stop();
        }
        finally {
            if (originalCheckConfiguration != null) {
                System.setProperty("osgi.checkConfiguration", originalCheckConfiguration);
            }
        }
    }

    @Test
    public void testProvideOSGiEEandNative() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.equinox.allow.restricted.provides", "true");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        Bundle testBundle = systemContext.installBundle(installer.getBundleLocation("test.bug449484"));
        ((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(testBundle));
        Assert.assertEquals((String)"Wrong bundle state", (long)4L, (long)testBundle.getState());
        testBundle.uninstall();
        equinox.stop();
        configuration.remove("osgi.equinox.allow.restricted.provides");
        equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext1 = equinox.getBundleContext();
        Assert.assertThrows((String)"Expected to fail to install bundle with restricted provide capabilities.", BundleException.class, () -> systemContext1.installBundle(installer.getBundleLocation("test.bug449484")).uninstall());
        equinox.stop();
        configuration.put("osgi.equinox.allow.restricted.provides", "false");
        equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext2 = equinox.getBundleContext();
        Assert.assertThrows((String)"Expected to fail to install bundle with restricted provide capabilities.", BundleException.class, () -> systemContext2.installBundle(installer.getBundleLocation("test.bug449484")).uninstall());
        equinox.stop();
    }

    @Test
    public void testBootDelegationConfigIni() throws Exception {
        String compatBootDelegate = "osgi.compatibility.bootdelegation";
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        Properties configIni = new Properties();
        configIni.setProperty(compatBootDelegate, "true");
        configIni.store(new FileWriter(new File(config, "config.ini")), null);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertEquals((String)("Wrong value for: " + compatBootDelegate), (Object)"true", (Object)systemContext.getProperty(compatBootDelegate));
        File baseDir = new File(config, "bundles");
        baseDir.mkdirs();
        File bundleFile = SystemBundleTests.createBundle(baseDir, this.getName(), true, true);
        Bundle b = systemContext.installBundle("reference:file:///" + bundleFile.getAbsolutePath());
        b.loadClass(SocketFactory.class.getName());
        long bId = b.getBundleId();
        SystemBundleTests.stop((Framework)equinox);
        configIni.remove(compatBootDelegate);
        configIni.store(new FileWriter(new File(config, "config.ini")), null);
        equinox = new Equinox(configuration);
        equinox.start();
        systemContext = equinox.getBundleContext();
        Bundle b1 = systemContext.getBundle(bId);
        Assert.assertThrows((String)"Expected to fail to load the class from boot.", ClassNotFoundException.class, () -> {
            Class clazz = b1.loadClass(SocketFactory.class.getName());
        });
        equinox.stop();
    }

    @Test
    public void testSystemBundleListener() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        AtomicInteger stoppingEvent = new AtomicInteger();
        AtomicInteger stoppedEvent = new AtomicInteger();
        SynchronousBundleListener systemBundleListener = event -> {
            if (event.getBundle().getBundleId() == 0L) {
                switch (event.getType()) {
                    case 256: {
                        stoppingEvent.incrementAndGet();
                        break;
                    }
                    case 4: {
                        stoppedEvent.incrementAndGet();
                    }
                }
            }
        };
        systemContext.addBundleListener((BundleListener)systemBundleListener);
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong number of STOPPING events", (long)1L, (long)stoppingEvent.get());
        Assert.assertEquals((String)"Wrong number of STOPPED events", (long)1L, (long)stoppedEvent.get());
    }

    @Test
    public void testContextBootDelegation() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        Bundle b = systemContext.installBundle(installer.getBundleLocation("test.bug471551"));
        b.start();
        equinox.stop();
    }

    @Test
    public void testExtraSystemBundleHeaders() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=JavaSE; version:Version=1.8, something.system");
        configuration.put("org.osgi.framework.system.packages", "something.system");
        configuration.put("org.osgi.framework.system.capabilities.extra", "something.extra");
        configuration.put("org.osgi.framework.system.packages.extra", "something.extra");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        Dictionary headers = equinox.getHeaders();
        String provideCapability = (String)headers.get("Provide-Capability");
        String exportPackage = (String)headers.get("Export-Package");
        Assert.assertTrue((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.system"));
        Assert.assertTrue((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.system"));
        Assert.assertTrue((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.extra"));
        Assert.assertTrue((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.extra"));
        SystemBundleTests.stop((Framework)equinox);
        configuration.put("equinox.system.provide.header", "original");
        equinox = new Equinox(configuration);
        equinox.start();
        headers = equinox.getHeaders();
        provideCapability = (String)headers.get("Provide-Capability");
        exportPackage = (String)headers.get("Export-Package");
        Assert.assertFalse((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.system"));
        Assert.assertFalse((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.system"));
        Assert.assertFalse((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.extra"));
        Assert.assertFalse((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.extra"));
        SystemBundleTests.stop((Framework)equinox);
        configuration.put("equinox.system.provide.header", "system");
        equinox = new Equinox(configuration);
        equinox.start();
        headers = equinox.getHeaders();
        provideCapability = (String)headers.get("Provide-Capability");
        exportPackage = (String)headers.get("Export-Package");
        Assert.assertTrue((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.system"));
        Assert.assertTrue((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.system"));
        Assert.assertFalse((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.extra"));
        Assert.assertFalse((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.extra"));
        SystemBundleTests.stop((Framework)equinox);
        configuration.put("equinox.system.provide.header", "system.extra");
        equinox = new Equinox(configuration);
        equinox.start();
        headers = equinox.getHeaders();
        provideCapability = (String)headers.get("Provide-Capability");
        exportPackage = (String)headers.get("Export-Package");
        Assert.assertTrue((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.system"));
        Assert.assertTrue((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.system"));
        Assert.assertTrue((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.extra"));
        Assert.assertTrue((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.extra"));
        SystemBundleTests.stop((Framework)equinox);
    }

    @Test
    public void testSystemBundleLoader() {
        Bundle systemBundle = OSGiTestsActivator.getContext().getBundle("System Bundle");
        BundleWiring wiring = (BundleWiring)systemBundle.adapt(BundleWiring.class);
        ClassLoader cl = wiring.getClassLoader();
        Assert.assertNotNull((String)"No system bundle class loader.", (Object)cl);
    }

    @Test
    public void testJavaProfile() throws Exception {
        boolean isRunningJava9OrGreater = this.isJavaVersionGreaterThanOrEqualTo9();
        String originalSpecVersion = System.getProperty("java.specification.version");
        String originalJavaHome = System.getProperty("java.home");
        try {
            this.doTestJavaProfile("9.3.1", isRunningJava9OrGreater ? "JavaSE-9.3" : "JavaSE-9", null);
            this.doTestJavaProfile("9", "JavaSE-9", null);
            this.doTestJavaProfile("8.4", "JavaSE-1.8", null);
            this.doTestJavaProfile("1.10.1", "JavaSE-1.8", null);
            this.doTestJavaProfile("1.9", "JavaSE-1.8", null);
            this.doTestJavaProfile("1.8", "JavaSE-1.8", null);
            this.doTestJavaProfile("1.8", "JavaSE/compact3-1.8", "compact3");
            this.doTestJavaProfile("1.8", "JavaSE/compact3-1.8", "\"compact3\"");
            this.doTestJavaProfile("1.8", "JavaSE/compact3-1.8", " \"compact3\" ");
            this.doTestJavaProfile("1.8", "JavaSE/compact3-1.8", " compact3 ");
            this.doTestJavaProfile("1.8", "JavaSE-1.8", "\"compact4\"");
            if (!isRunningJava9OrGreater) {
                this.doTestJavaProfile("9", "JavaSE/compact3-1.8", "compact3");
                this.doTestJavaProfile("9", "JavaSE/compact3-1.8", "\"compact3\"");
                this.doTestJavaProfile("9", "JavaSE-9", "\"compact4\"");
            }
        }
        finally {
            System.setProperty("java.specification.version", originalSpecVersion);
            System.setProperty("java.home", originalJavaHome);
        }
    }

    private Boolean isJavaVersionGreaterThanOrEqualTo9() {
        Version javaVersion = Version.valueOf((String)"1.7");
        String javaSpecVersionProp = System.getProperty("java.specification.version");
        StringTokenizer st = new StringTokenizer(javaSpecVersionProp, " _-");
        javaSpecVersionProp = st.nextToken();
        try {
            String[] vComps = javaSpecVersionProp.split("\\.");
            int major = vComps.length > 0 ? Integer.parseInt(vComps[0]) : 0;
            int minor = vComps.length > 1 ? Integer.parseInt(vComps[1]) : 0;
            int micro = vComps.length > 2 ? Integer.parseInt(vComps[2]) : 0;
            javaVersion = new Version(major, minor, micro);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (javaVersion.compareTo(new Version(9, 0, 0)) >= 0) {
            return true;
        }
        return false;
    }

    private void doTestJavaProfile(String javaSpecVersion, String expectedEEName, String releaseName) throws Exception {
        if (releaseName != null) {
            File release = this.getContext().getDataFile("jre/release");
            release.getParentFile().mkdirs();
            Properties props = new Properties();
            props.put("JAVA_PROFILE", releaseName);
            Throwable throwable = null;
            Object var7_8 = null;
            try (FileOutputStream propStream = new FileOutputStream(release);){
                props.store(propStream, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            System.setProperty("java.home", release.getParentFile().getAbsolutePath());
        }
        System.setProperty("java.specification.version", javaSpecVersion);
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName() + javaSpecVersion);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        String osgiEE = equinox.getBundleContext().getProperty("org.osgi.framework.executionenvironment");
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        Assert.assertTrue((String)("Wrong osgi EE: expected: " + expectedEEName + " but was: " + osgiEE), (boolean)osgiEE.endsWith(expectedEEName));
    }

    private static File[] createBundles(File outputDir, int bundleCount) throws IOException {
        outputDir.mkdirs();
        File[] bundles = new File[bundleCount];
        int i = 0;
        while (i < bundleCount) {
            bundles[i] = SystemBundleTests.createBundle(outputDir, "-b" + i, false, false);
            ++i;
        }
        return bundles;
    }

    private static File[] createBundles(File outputDir, int bundleCount, Map<String, String> extraHeaders) throws IOException {
        outputDir.mkdirs();
        File[] bundles = new File[bundleCount];
        int i = 0;
        while (i < bundleCount) {
            HashMap<String, String> headers = new HashMap<String, String>(extraHeaders);
            headers.put("Bundle-SymbolicName", "-b" + i);
            bundles[i] = SystemBundleTests.createBundle(outputDir, "-b" + i, headers, new Map[0]);
            ++i;
        }
        return bundles;
    }

    public static File createBundle(File outputDir, String id, boolean emptyManifest, boolean dirBundle) throws IOException {
        File file = new File(outputDir, "bundle" + id + (dirBundle ? "" : ".jar"));
        if (!dirBundle) {
            JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(file), SystemBundleTests.createManifest(id, emptyManifest));
            jos.flush();
            jos.close();
        } else {
            File manifest = new File(file, "META-INF/MANIFEST.MF");
            manifest.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(manifest);
            SystemBundleTests.createManifest(id, emptyManifest).write(out);
            out.close();
        }
        return file;
    }

    private static Manifest createManifest(String id, boolean emptyManifest) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        if (!emptyManifest) {
            attributes.putValue("Bundle-ManifestVersion", "2");
            attributes.putValue("Bundle-SymbolicName", "bundle" + id);
        }
        return manifest;
    }

    public static File createBundle(File outputDir, String bundleName, Map<String, String> headers, Map<String, String> ... entries) throws IOException {
        Manifest m = new Manifest();
        Attributes attributes = m.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            attributes.putValue(entry.getKey(), entry.getValue());
        }
        File file = new File(outputDir, "bundle" + bundleName + ".jar");
        JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(file), m);
        if (entries != null) {
            Map<String, String>[] mapArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                Map<String, String> entryMap = mapArray[n2];
                for (Map.Entry<String, String> entry : entryMap.entrySet()) {
                    jos.putNextEntry(new JarEntry(entry.getKey()));
                    if (entry.getValue() != null) {
                        jos.write(entry.getValue().getBytes());
                    }
                    jos.closeEntry();
                }
                ++n2;
            }
        }
        jos.flush();
        jos.close();
        return file;
    }

    public static File createBundleWithBytes(File outputDir, String bundleName, Map<String, String> headers, Map<String, byte[]> ... entries) throws IOException {
        Manifest m = new Manifest();
        Attributes attributes = m.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            attributes.putValue(entry.getKey(), entry.getValue());
        }
        File file = new File(outputDir, "bundle" + bundleName + ".jar");
        JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(file), m);
        if (entries != null) {
            Map<String, byte[]>[] mapArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                Map<String, byte[]> entryMap = mapArray[n2];
                for (Map.Entry<String, byte[]> entry : entryMap.entrySet()) {
                    jos.putNextEntry(new JarEntry(entry.getKey()));
                    if (entry.getValue() != null) {
                        jos.write(entry.getValue());
                    }
                    jos.closeEntry();
                }
                ++n2;
            }
        }
        jos.flush();
        jos.close();
        return file;
    }

    @Test
    public void testBug405919() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.framework", "boo");
        Equinox equinox = null;
        equinox = new Equinox(configuration);
        equinox.start();
        try {
            BundleContext systemContext = equinox.getBundleContext();
            Bundle tb1 = systemContext.installBundle(installer.getBundleLocation("test.bug375784"));
            tb1.start();
            BundleRevision inner = (BundleRevision)systemContext.getBundle().adapt(BundleRevision.class);
            BundleRevision outer = (BundleRevision)this.getContext().getBundle(0L).adapt(BundleRevision.class);
            List innerCaps = inner.getCapabilities(null);
            List outerCaps = outer.getCapabilities(null);
            Assert.assertEquals((String)"Number of capabilities differ", (long)outerCaps.size(), (long)innerCaps.size());
            int i = 0;
            while (i < innerCaps.size()) {
                Capability innerCap = (Capability)innerCaps.get(i);
                Capability outerCap = (Capability)outerCaps.get(i);
                Assert.assertEquals((String)("Capability namespaces differ: " + outerCap.getNamespace()), (Object)outerCap.getNamespace(), (Object)innerCap.getNamespace());
                String namespace = outerCap.getNamespace();
                if (!"osgi.native".equals(namespace) && !"eclipse.platform".equals(namespace)) {
                    Assert.assertEquals((String)("Capability attributes differ: " + outerCap.getNamespace()), (Object)outerCap.getAttributes(), (Object)innerCap.getAttributes());
                    Assert.assertEquals((String)("Capability directives differ: " + outerCap.getNamespace()), (Object)outerCap.getDirectives(), (Object)innerCap.getDirectives());
                }
                ++i;
            }
            List innerReqs = inner.getRequirements(null);
            List outerReqs = outer.getRequirements(null);
            Assert.assertEquals((String)"Number of requirements differ", (long)outerReqs.size(), (long)innerReqs.size());
            int i2 = 0;
            while (i2 < innerReqs.size()) {
                Requirement innerReq = (Requirement)innerReqs.get(i2);
                Requirement outerReq = (Requirement)outerReqs.get(i2);
                Assert.assertEquals((String)("Requirement namespaces differ: " + outerReq.getNamespace()), (Object)outerReq.getNamespace(), (Object)innerReq.getNamespace());
                Assert.assertEquals((String)("Requirement attributes differ: " + outerReq.getNamespace()), (Object)outerReq.getAttributes(), (Object)innerReq.getAttributes());
                Assert.assertEquals((String)("Requirement directives differ: " + outerReq.getNamespace()), (Object)outerReq.getDirectives(), (Object)innerReq.getDirectives());
                ++i2;
            }
        }
        finally {
            SystemBundleTests.stop((Framework)equinox);
        }
    }

    @Test
    public void testInitialBundleUpdate() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        File baseDir = new File(config, "bundles");
        baseDir.mkdirs();
        File bundleFile = SystemBundleTests.createBundle(baseDir, this.getName(), true, true);
        String location = "reference:file:///" + bundleFile.getAbsolutePath();
        URL url = new URL(null, location, (URLStreamHandler)new Handler(systemContext.getProperty("osgi.install.area")));
        Bundle testBundle = systemContext.installBundle("initial@" + location, url.openStream());
        testBundle.update();
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testDaemonActiveThread() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.framework.activeThreadType", "daemon");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        this.checkActiveThreadType(equinox, true);
        SystemBundleTests.stop((Framework)equinox);
        configuration.put("osgi.framework.activeThreadType", "normal");
        equinox = new Equinox(configuration);
        equinox.start();
        this.checkActiveThreadType(equinox, false);
        SystemBundleTests.stop((Framework)equinox);
        configuration.remove("osgi.framework.activeThreadType");
        equinox = new Equinox(configuration);
        equinox.start();
        this.checkActiveThreadType(equinox, false);
        equinox.stop();
    }

    @Test
    public void testLazyTriggerOnLoadError() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.compatibility.trigger.lazyActivation.onFailedClassLoad", "true");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle b = systemContext.installBundle(installer.getBundleLocation("chain.test.d"));
        b.start(2);
        Assert.assertEquals((String)"Wrong state of bundle.", (long)8L, (long)b.getState());
        Assert.assertThrows(ClassNotFoundException.class, () -> {
            Class clazz = b.loadClass("does.not.exist.Clazz");
        });
        Assert.assertEquals((String)"Wrong state of bundle.", (long)32L, (long)b.getState());
        SystemBundleTests.stop((Framework)equinox);
        configuration.remove("osgi.compatibility.trigger.lazyActivation.onFailedClassLoad");
        equinox = new Equinox(configuration);
        equinox.start();
        Bundle b1 = equinox.getBundleContext().getBundle(b.getBundleId());
        Assert.assertEquals((String)"Wrong state of bundle.", (long)8L, (long)b1.getState());
        Assert.assertThrows(ClassNotFoundException.class, () -> {
            Class clazz = b1.loadClass("does.not.exist.Clazz");
        });
        Assert.assertEquals((String)"Wrong state of bundle.", (long)8L, (long)b1.getState());
        equinox.stop();
    }

    @Test
    public void testConfigPercentChar() throws BundleException, IOException {
        this.doTestConfigSpecialChar('%');
    }

    @Test
    public void testConfigSpaceChar() throws BundleException, IOException {
        this.doTestConfigSpecialChar(' ');
    }

    @Test
    public void testConfigPlusChar() throws BundleException, IOException {
        this.doTestConfigSpecialChar('+');
    }

    private void doTestConfigSpecialChar(char c) throws BundleException, IOException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName() + c + "config");
        config.mkdirs();
        Properties configIni = new Properties();
        configIni.setProperty("test.config", this.getName());
        configIni.store(new FileOutputStream(new File(config, "config.ini")), "Test config.ini");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertEquals((String)"Wrong value for test.config", (Object)this.getName(), (Object)systemContext.getProperty("test.config"));
        SystemBundleTests.stop((Framework)equinox);
    }

    void checkActiveThreadType(Equinox equinox, boolean expectIsDeamon) {
        String uuid = equinox.getBundleContext().getProperty("org.osgi.framework.uuid");
        ThreadGroup topGroup = Thread.currentThread().getThreadGroup();
        if (topGroup != null) {
            while (topGroup.getParent() != null) {
                topGroup = topGroup.getParent();
            }
        }
        Object[] threads = new Thread[topGroup.activeCount()];
        topGroup.enumerate((Thread[])threads);
        Object found = null;
        Object[] objectArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Object t = objectArray[n2];
            String name = ((Thread)t).getName();
            if (("Active Thread: Equinox Container: " + uuid).equals(name)) {
                found = t;
                break;
            }
            ++n2;
        }
        Assert.assertNotNull((String)("No framework active thread for \"" + uuid + "\" found in : " + Arrays.toString(threads)), found);
        Assert.assertEquals((String)"Wrong daemon type.", (Object)expectIsDeamon, (Object)((Thread)found).isDaemon());
    }

    @Test
    public void testWindowsAlias() throws BundleException {
        String origOS = System.getProperty("os.name");
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        System.setProperty("os.name", "Windows 5000");
        Equinox equinox = null;
        try {
            equinox = new Equinox(configuration);
            equinox.init();
            Assert.assertEquals((String)"Wrong framework os name value", (Object)"win32", (Object)equinox.getBundleContext().getProperty("org.osgi.framework.os.name"));
        }
        finally {
            System.setProperty("os.name", origOS);
            SystemBundleTests.stop((Framework)equinox);
        }
    }

    @Test
    public void testOverrideEquinoxConfigAreaProp() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.configuration.area", config.getAbsolutePath() + "-override");
        configuration.put("equinox.log.history.max", "10");
        Equinox equinox = null;
        try {
            equinox = new Equinox(configuration);
            equinox.init();
            BundleContext bc = equinox.getBundleContext();
            LogReaderService logReader = (LogReaderService)bc.getService(bc.getServiceReference(LogReaderService.class));
            Enumeration logs = logReader.getLog();
            Assert.assertTrue((String)"No logs found.", (boolean)logs.hasMoreElements());
            LogEntry entry = (LogEntry)logs.nextElement();
            Assert.assertEquals((String)"Wrong log level.", (Object)LogLevel.WARN, (Object)entry.getLogLevel());
            Assert.assertTrue((String)("Wrong message found: " + entry.getMessage()), (boolean)entry.getMessage().contains("osgi.configuration.area"));
        }
        catch (Throwable throwable) {
            SystemBundleTests.stop(equinox);
            throw throwable;
        }
        SystemBundleTests.stop((Framework)equinox);
    }

    @Test
    public void testLogOrderMultipleListeners() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = null;
        try {
            equinox = new Equinox(configuration);
            equinox.start();
            SystemBundleTests.doLoggingOnMultipleListeners(equinox);
            SystemBundleTests.stop((Framework)equinox);
            equinox.start();
            SystemBundleTests.doLoggingOnMultipleListeners(equinox);
        }
        catch (Throwable throwable) {
            SystemBundleTests.stop(equinox);
            throw throwable;
        }
        SystemBundleTests.stop((Framework)equinox);
    }

    static void doLoggingOnMultipleListeners(Equinox equinox) throws InterruptedException {
        int listenersSize = 100;
        int logSize = 10000;
        BundleContext bc = equinox.getBundleContext();
        ExtendedLogReaderService logReader = (ExtendedLogReaderService)bc.getService(bc.getServiceReference(ExtendedLogReaderService.class));
        ExtendedLogService log = (ExtendedLogService)bc.getService(bc.getServiceReference(ExtendedLogService.class));
        ArrayList<TestListener2> listeners = new ArrayList<TestListener2>();
        CountDownLatch latch = new CountDownLatch(logSize * listenersSize);
        int i = 0;
        while (i < listenersSize) {
            TestListener2 listener = new TestListener2(latch);
            listeners.add(listener);
            logReader.addLogListener((LogListener)listener);
            ++i;
        }
        i = 0;
        while (i < logSize) {
            log.warn(String.valueOf(i));
            ++i;
        }
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Failed to log all entries", (long)0L, (long)latch.getCount());
        int expected = 0;
        for (String msg : ((TestListener2)listeners.get(0)).getLogs()) {
            Assert.assertEquals((String)"Unexpected log found.", (long)expected, (long)Integer.parseInt(msg));
            ++expected;
        }
        int i2 = 1;
        while (i2 < listenersSize) {
            Assert.assertTrue((boolean)((TestListener2)listeners.get(i2)).getLogs().equals(((TestListener2)listeners.get(0)).getLogs()));
            ++i2;
        }
    }

    @Test
    public void testCaptureLogEntryLocation() throws BundleException, InterruptedException {
        this.doTestCaptureLogEntryLocation(true);
        this.doTestCaptureLogEntryLocation(false);
    }

    private void doTestCaptureLogEntryLocation(boolean captureLocation) throws BundleException, InterruptedException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        if (!captureLocation) {
            configuration.put("equinox.log.capture.entry.location", Boolean.toString(captureLocation));
        }
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.start();
            BundleContext bc = equinox.getBundleContext();
            LogReaderService logReader = (LogReaderService)bc.getService(bc.getServiceReference(LogReaderService.class));
            LogService logService = (LogService)bc.getService(bc.getServiceReference(LogService.class));
            TestListener listener = new TestListener("System Bundle");
            logReader.addLogListener((LogListener)listener);
            String testMsg = "TEST MESSAGE";
            logService.getLogger(this.getClass()).error("TEST MESSAGE");
            ExtendedLogEntry logEntry = listener.getEntryX();
            Assert.assertEquals((String)"Wrong message.", (Object)"TEST MESSAGE", (Object)logEntry.getMessage());
            if (captureLocation) {
                Assert.assertNotNull((String)"No location found.", (Object)logEntry.getLocation());
            } else {
                Assert.assertNull((String)"Found location.", (Object)logEntry.getLocation());
            }
        }
        finally {
            SystemBundleTests.stop((Framework)equinox);
        }
    }

    @Test
    public void testSystemCapabilitiesBug522125() throws Exception {
        String frameworkLocation = OSGiTestsActivator.getContext().getProperty("osgi.framework");
        URI uri = new URI(frameworkLocation);
        File f = new File(uri);
        if (!f.isFile()) {
            System.out.println("Cannot test when framework location is a directory: " + f.getAbsolutePath());
            return;
        }
        File testDestination = OSGiTestsActivator.getContext().getDataFile(this.getName() + ".framework.jar");
        BaseSecurityTest.copy(new FileInputStream(f), testDestination);
        FilePath userDir = new FilePath(System.getProperty("user.dir"));
        FilePath testPath = new FilePath(testDestination);
        String relative = userDir.makeRelative(testPath);
        System.out.println(relative);
        URL relativeURL = new URL("file:" + relative);
        relativeURL.openStream().close();
        final ClassLoader osgiClassLoader = this.getClass().getClassLoader();
        URLClassLoader cl = new URLClassLoader(new URL[]{relativeURL}){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.startsWith("org.osgi.")) {
                    return osgiClassLoader.loadClass(name);
                }
                return super.loadClass(name, resolve);
            }
        };
        ServiceLoader<FrameworkFactory> sLoader = ServiceLoader.load(FrameworkFactory.class, cl);
        FrameworkFactory factory = sLoader.iterator().next();
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.framework", relativeURL.toExternalForm());
        Framework framework = factory.newFramework(configuration);
        framework.init();
        SystemBundleTests.stop(framework);
        BundleRevision systemRevision1 = (BundleRevision)framework.adapt(BundleRevision.class);
        int capCount1 = systemRevision1.getCapabilities(null).size();
        framework = factory.newFramework(configuration);
        framework.init();
        SystemBundleTests.stop(framework);
        BundleRevision systemRevision2 = (BundleRevision)framework.adapt(BundleRevision.class);
        int capCount2 = systemRevision2.getCapabilities(null).size();
        Assert.assertEquals((String)"Wrong number of capabilities", (long)capCount1, (long)capCount2);
    }

    @Test
    public void testStartLevelSorting() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = null;
        int numBundles = 200;
        final File[] testBundleFiles = SystemBundleTests.createBundles(new File(config, "testBundles"), 200);
        try {
            equinox = new Equinox(configuration);
            equinox.start();
            final List<Bundle> testBundles = Collections.synchronizedList(new ArrayList());
            final List startedBundles = Collections.synchronizedList(new ArrayList());
            int i = 0;
            while (i < 100) {
                Bundle b = equinox.getBundleContext().installBundle("reference:file:///" + testBundleFiles[i].getAbsolutePath());
                ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(i + 2);
                testBundles.add(b);
                b.start();
                ++i;
            }
            final Equinox finalEquinox = equinox;
            SynchronousBundleListener initialListener = new SynchronousBundleListener(){
                AtomicBoolean reverseStartLevel = new AtomicBoolean();
                AtomicBoolean installBundles = new AtomicBoolean();

                public void bundleChanged(BundleEvent event) {
                    block6: {
                        block5: {
                            Bundle eBundle = event.getBundle();
                            String bsn = eBundle.getSymbolicName();
                            if (!bsn.startsWith("bundle-b") || event.getType() != 2) {
                                return;
                            }
                            startedBundles.add(eBundle);
                            if (!this.reverseStartLevel.compareAndSet(false, true)) break block5;
                            int i = 50;
                            int j = 200;
                            while (i < 100) {
                                BundleStartLevel tbsl = (BundleStartLevel)((Bundle)testBundles.get(i)).adapt(BundleStartLevel.class);
                                tbsl.setStartLevel(j + 2 + 200);
                                ++i;
                                --j;
                            }
                            break block6;
                        }
                        if (!this.installBundles.compareAndSet(false, true)) break block6;
                        int i = 100;
                        while (i < 200) {
                            try {
                                Bundle b = finalEquinox.getBundleContext().installBundle("reference:file:///" + testBundleFiles[i].getAbsolutePath());
                                ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(i + 2);
                                testBundles.add(b);
                                b.start();
                            }
                            catch (BundleException bundleException) {
                                // empty catch block
                            }
                            ++i;
                        }
                    }
                }
            };
            equinox.getBundleContext().addBundleListener((BundleListener)initialListener);
            long startTime = System.currentTimeMillis();
            CountDownLatch waitForStartLevel = new CountDownLatch(1);
            ((FrameworkStartLevel)equinox.adapt(FrameworkStartLevel.class)).setStartLevel(600, new FrameworkListener[]{event -> waitForStartLevel.countDown()});
            waitForStartLevel.await(20L, TimeUnit.SECONDS);
            System.out.println("Start time: " + (System.currentTimeMillis() - startTime));
            Assert.assertEquals((String)"Did not finish start level setting.", (long)0L, (long)waitForStartLevel.getCount());
            Assert.assertEquals((String)"Did not install all the expected bundles.", (long)200L, (long)testBundles.size());
            ArrayList<Bundle> expectedStartOrder = new ArrayList<Bundle>();
            int i2 = 0;
            while (i2 < 50) {
                expectedStartOrder.add((Bundle)testBundles.get(i2));
                ++i2;
            }
            i2 = 100;
            while (i2 < 200) {
                expectedStartOrder.add((Bundle)testBundles.get(i2));
                ++i2;
            }
            i2 = 99;
            while (i2 >= 50) {
                expectedStartOrder.add((Bundle)testBundles.get(i2));
                --i2;
            }
            Assert.assertEquals((String)"Size on expected order is wrong.", (long)200L, (long)expectedStartOrder.size());
            i2 = 0;
            while (i2 < 200) {
                Assert.assertEquals((String)("Wrong bundle at: " + i2), expectedStartOrder.get(i2), startedBundles.get(i2));
                ++i2;
            }
            equinox.getBundleContext().removeBundleListener((BundleListener)initialListener);
            final List stoppedBundles = Collections.synchronizedList(new ArrayList());
            SynchronousBundleListener shutdownListener = new SynchronousBundleListener(){
                AtomicBoolean reverseStartLevel = new AtomicBoolean();
                AtomicBoolean uninstallBundles = new AtomicBoolean();
                AtomicBoolean inUninstall = new AtomicBoolean();

                public void bundleChanged(BundleEvent event) {
                    block11: {
                        block10: {
                            if (this.inUninstall.get()) {
                                return;
                            }
                            Bundle eBundle = event.getBundle();
                            String bsn = eBundle.getSymbolicName();
                            if (!bsn.startsWith("bundle-b") || event.getType() != 4) {
                                return;
                            }
                            stoppedBundles.add(eBundle);
                            if (!this.reverseStartLevel.compareAndSet(false, true)) break block10;
                            int i = 100;
                            int j = 199;
                            while (i < 200) {
                                BundleStartLevel tbsl = (BundleStartLevel)((Bundle)testBundles.get(i)).adapt(BundleStartLevel.class);
                                tbsl.setStartLevel(j + 2);
                                ++i;
                                --j;
                            }
                            break block11;
                        }
                        if (!this.uninstallBundles.compareAndSet(false, true)) break block11;
                        int i = 0;
                        while (i < 50) {
                            block9: {
                                try {
                                    try {
                                        this.inUninstall.set(true);
                                        ((Bundle)testBundles.get(i)).uninstall();
                                    }
                                    catch (BundleException bundleException) {
                                        this.inUninstall.set(false);
                                        break block9;
                                    }
                                }
                                catch (Throwable throwable) {
                                    this.inUninstall.set(false);
                                    throw throwable;
                                }
                                this.inUninstall.set(false);
                            }
                            ++i;
                        }
                    }
                }
            };
            equinox.getBundleContext().addBundleListener((BundleListener)shutdownListener);
            ArrayList expectedStopOrder = new ArrayList(expectedStartOrder);
            Collections.reverse(expectedStopOrder);
            Collections.reverse(expectedStopOrder.subList(50, 150));
            expectedStopOrder = new ArrayList(expectedStopOrder.subList(0, 150));
            long stopTime = System.currentTimeMillis();
            SystemBundleTests.stop((Framework)equinox, false, 20000L);
            System.out.println("Stop time: " + (System.currentTimeMillis() - stopTime));
            Assert.assertEquals((String)"Size on expected order is wrong.", (long)expectedStopOrder.size(), (long)stoppedBundles.size());
            int i3 = 0;
            while (i3 < expectedStopOrder.size()) {
                Assert.assertEquals((String)("Wrong bundle at: " + i3), expectedStopOrder.get(i3), stoppedBundles.get(i3));
                ++i3;
            }
        }
        catch (Throwable throwable) {
            SystemBundleTests.stop(equinox);
            throw throwable;
        }
        SystemBundleTests.stop((Framework)equinox);
    }

    @Test
    public void testStartLevelSingleThread() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = null;
        int numBundles = 20;
        File[] testBundleFiles = SystemBundleTests.createBundles(new File(config, "testBundles"), 20);
        try {
            equinox = new Equinox(configuration);
            equinox.start();
            int i = 0;
            while (i < 20) {
                Bundle b = equinox.getBundleContext().installBundle("reference:file:///" + testBundleFiles[i].getAbsolutePath());
                ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(5);
                b.start();
                ++i;
            }
            Set startingThreads = Collections.synchronizedSet(new HashSet());
            equinox.getBundleContext().addBundleListener((BundleListener)((SynchronousBundleListener)event -> {
                if (event.getType() == 128) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    startingThreads.add(Thread.currentThread());
                }
            }));
            CountDownLatch waitForStartLevel = new CountDownLatch(1);
            ((FrameworkStartLevel)equinox.adapt(FrameworkStartLevel.class)).setStartLevel(5, new FrameworkListener[]{event -> waitForStartLevel.countDown()});
            waitForStartLevel.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((String)"Did not finish start level setting.", (long)0L, (long)waitForStartLevel.getCount());
            Assert.assertEquals((String)"Wrong number of start threads.", (long)1L, (long)startingThreads.size());
        }
        catch (Throwable throwable) {
            SystemBundleTests.stop(equinox);
            throw throwable;
        }
        SystemBundleTests.stop((Framework)equinox);
    }

    @Test
    public void testStartLevelMultiThreadExplicit4() throws Exception {
        this.doTestStartLevelMultiThread(4, false);
    }

    @Test
    public void testStartLevelMultiThreadExplicit1() throws Exception {
        this.doTestStartLevelMultiThread(1, false);
    }

    @Test
    public void testStartLevelMultiThreadAvailableProcessors() throws Exception {
        this.doTestStartLevelMultiThread(0, false);
    }

    @Test
    public void testStartLevelRestrictMultiThreadExplicit4() throws Exception {
        this.doTestStartLevelMultiThread(4, true);
    }

    private void doTestStartLevelMultiThread(int expectedCount, boolean restrictParallel) throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("equinox.start.level.thread.count", String.valueOf(expectedCount));
        if (restrictParallel) {
            configuration.put("equinox.start.level.restrict.parallel", "true");
        }
        if (expectedCount <= 0) {
            expectedCount = Runtime.getRuntime().availableProcessors();
        }
        Equinox equinox = null;
        int numBundles = 60;
        File[] testBundleFiles = SystemBundleTests.createBundles(new File(config, "testBundles"), 60);
        try {
            equinox = new Equinox(configuration);
            equinox.start();
            FrameworkWiring fwkWiring = (FrameworkWiring)equinox.adapt(FrameworkWiring.class);
            int i = 0;
            while (i < 60) {
                Bundle b = equinox.getBundleContext().installBundle("reference:file:///" + testBundleFiles[i].getAbsolutePath());
                if (i < 30) {
                    ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(5);
                } else {
                    ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(10);
                }
                Module m = (Module)b.adapt(Module.class);
                Assert.assertFalse((String)"Wrong initial value for parallelActivation", (boolean)m.isParallelActivated());
                if (b.getBundleId() % 2L == 0L) {
                    ((Module)b.adapt(Module.class)).setParallelActivation(true);
                    Assert.assertTrue((String)"Wrong value for parallelActivation", (boolean)m.isParallelActivated());
                }
                fwkWiring.resolveBundles(Collections.singleton(b));
                b.start();
                ++i;
            }
            Set startingThreads = Collections.synchronizedSet(new HashSet());
            List startingBundles = Collections.synchronizedList(new ArrayList());
            equinox.getBundleContext().addBundleListener((BundleListener)((SynchronousBundleListener)event -> {
                if (event.getType() == 128) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    startingBundles.add(event.getBundle());
                    startingThreads.add(Thread.currentThread());
                }
            }));
            CountDownLatch waitForStartLevel = new CountDownLatch(1);
            ((FrameworkStartLevel)equinox.adapt(FrameworkStartLevel.class)).setStartLevel(10, new FrameworkListener[]{event -> waitForStartLevel.countDown()});
            waitForStartLevel.await(20L, TimeUnit.SECONDS);
            Assert.assertEquals((String)"Did not finish start level setting.", (long)0L, (long)waitForStartLevel.getCount());
            if (restrictParallel && expectedCount > 1) {
                Assert.assertEquals((String)"Wrong number of start threads.", (long)(expectedCount + 1), (long)startingThreads.size());
            } else {
                Assert.assertEquals((String)"Wrong number of start threads.", (long)expectedCount, (long)startingThreads.size());
            }
            Assert.assertEquals((String)"Wrong number of started bundles.", (long)60L, (long)startingBundles.size());
            ListIterator itr = startingBundles.listIterator();
            while (itr.hasNext()) {
                if (itr.hasPrevious()) {
                    Bundle b1 = (Bundle)itr.previous();
                    itr.next();
                    Bundle b2 = (Bundle)itr.next();
                    int b1sl = ((BundleStartLevel)b1.adapt(BundleStartLevel.class)).getStartLevel();
                    int b2sl = ((BundleStartLevel)b2.adapt(BundleStartLevel.class)).getStartLevel();
                    Assert.assertTrue((String)("Wrong order to start bundles: " + String.valueOf(b1) + " - " + String.valueOf(b2)), (b1sl <= b2sl ? 1 : 0) != 0);
                    if (!restrictParallel || b1sl != b2sl) continue;
                    boolean b1pa = ((Module)b1.adapt(Module.class)).isParallelActivated();
                    boolean b2pa = ((Module)b2.adapt(Module.class)).isParallelActivated();
                    Assert.assertTrue((String)("Wrong order to start bundles: " + String.valueOf(b1) + " - " + String.valueOf(b2)), (b1pa || !b1pa && !b2pa ? 1 : 0) != 0);
                    if (b1pa) continue;
                    Assert.assertTrue((String)("Wrong order to start bundles: " + String.valueOf(b1) + " - " + String.valueOf(b2)), (b1.getBundleId() < b2.getBundleId() ? 1 : 0) != 0);
                    continue;
                }
                itr.next();
            }
        }
        catch (Throwable throwable) {
            SystemBundleTests.stop(equinox);
            throw throwable;
        }
        SystemBundleTests.stop((Framework)equinox);
    }

    @Test
    public void testParallelActivationPersistence() throws IOException, BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        int numBundles = 4;
        File[] testBundleFiles = SystemBundleTests.createBundles(new File(config, "testParallelPersistence"), 4);
        Equinox equinox = null;
        try {
            Bundle b;
            equinox = new Equinox(configuration);
            equinox.start();
            FrameworkWiring fwkWiring = (FrameworkWiring)equinox.adapt(FrameworkWiring.class);
            int i = 0;
            while (i < 4) {
                b = equinox.getBundleContext().installBundle("reference:file:///" + testBundleFiles[i].getAbsolutePath());
                Module m = (Module)b.adapt(Module.class);
                Assert.assertFalse((String)"Wrong initial value for parallelActivation", (boolean)m.isParallelActivated());
                if (b.getBundleId() % 2L == 0L) {
                    ((Module)b.adapt(Module.class)).setParallelActivation(true);
                    Assert.assertTrue((String)"Wrong value for parallelActivation", (boolean)m.isParallelActivated());
                }
                fwkWiring.resolveBundles(Collections.singleton(b));
                b.start();
                ++i;
            }
            SystemBundleTests.stop((Framework)equinox);
            equinox = null;
            equinox = new Equinox(configuration);
            equinox.start();
            Bundle[] bundles = equinox.getBundleContext().getBundles();
            Assert.assertEquals((String)"Wrong number of bundles on restart.", (long)5L, (long)bundles.length);
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                b = bundleArray[n2];
                if (b.getBundleId() != 0L) {
                    if (b.getBundleId() % 2L == 0L) {
                        Assert.assertTrue((String)"Wrong value for parallelActivation", (boolean)((Module)b.adapt(Module.class)).isParallelActivated());
                    } else {
                        Assert.assertFalse((String)"Wrong value for parallelActivation", (boolean)((Module)b.adapt(Module.class)).isParallelActivated());
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            SystemBundleTests.stop(equinox);
            throw throwable;
        }
        SystemBundleTests.stop((Framework)equinox);
    }

    @Test
    public void testBundleIDLock() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("osgi.bundlefile.limit", "10");
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        int numBundles = 5000;
        File[] testBundles = SystemBundleTests.createBundles(new File(config, "bundles"), 5000);
        ExecutorService executor = Executors.newFixedThreadPool(50);
        CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
        try {
            File[] fileArray = testBundles;
            int n = testBundles.length;
            int n2 = 0;
            while (n2 < n) {
                File testBundleFile = fileArray[n2];
                executor.execute(() -> {
                    try {
                        systemContext.installBundle("file:///" + testBundleFile.getAbsolutePath());
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                        errors.add(e);
                    }
                });
                ++n2;
            }
        }
        finally {
            executor.shutdown();
            executor.awaitTermination(600L, TimeUnit.SECONDS);
        }
        Assert.assertEquals((String)"Errors found.", Collections.emptyList(), errors);
        Assert.assertEquals((String)"Wrong number of bundles.", (long)5001L, (long)systemContext.getBundles().length);
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
    }

    @Test
    public void testMRUBundleFileListOverflow() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        int numBundles = 5000;
        File[] testBundles = SystemBundleTests.createBundles(new File(config, "bundles"), 5000);
        File debugOptions = new File(config, "debugOptions");
        Properties debugProps = new Properties();
        debugProps.setProperty("org.eclipse.osgi/debug/bundleFile", "true");
        FileOutputStream debugOut = new FileOutputStream(debugOptions);
        debugProps.store(debugOut, "Equinox Debug Options");
        debugOut.close();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("osgi.bundlefile.limit", "10");
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        File[] fileArray = testBundles;
        int n = testBundles.length;
        int n2 = 0;
        while (n2 < n) {
            File testBundleFile = fileArray[n2];
            bundles.add(systemContext.installBundle("file:///" + testBundleFile.getAbsolutePath()));
            ++n2;
        }
        long startTime = System.nanoTime();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            int i = 0;
            while (i < 10) {
                executor.execute(() -> {
                    ArrayList shuffled = new ArrayList(bundles);
                    Collections.shuffle(shuffled);
                    for (Bundle bundle : shuffled) {
                        bundle.getEntry("does/not/exist");
                    }
                });
                ++i;
            }
        }
        finally {
            executor.shutdown();
            executor.awaitTermination(600L, TimeUnit.SECONDS);
        }
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        long timeTaken = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime);
        System.out.println(this.getName() + " time taken: " + timeTaken);
        Assert.assertTrue((String)("Test took too long: " + timeTaken), (timeTaken < 30L ? 1 : 0) != 0);
    }

    @Test
    public void testZipBundleFileOpenLock() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> bundleHeaders = new HashMap<String, String>();
        bundleHeaders.put("Bundle-ManifestVersion", "2");
        bundleHeaders.put("Bundle-SymbolicName", this.getName());
        LinkedHashMap<String, String> bundleEntries = new LinkedHashMap<String, String>();
        bundleEntries.put("dirA/", null);
        bundleEntries.put("dirA/fileA", "fileA");
        bundleEntries.put("dirA/dirB/", null);
        bundleEntries.put("dirA/dirB/fileB", "fileB");
        bundleEntries.put("dirA/dirC/fileC", "fileC");
        File testBundleFile = SystemBundleTests.createBundle(config, this.getName(), bundleHeaders, bundleEntries);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        String converterFilter = "(&(objectClass=" + URLConverter.class.getName() + ")(protocol=bundleentry))";
        URLConverter converter = (URLConverter)systemContext.getService((ServiceReference)systemContext.getServiceReferences(URLConverter.class, converterFilter).iterator().next());
        Bundle testBundle = systemContext.installBundle("file:///" + testBundleFile.getAbsolutePath());
        testBundle.start();
        CopyOnWriteArrayList errorsAndWarnings = new CopyOnWriteArrayList();
        FrameworkListener fwkListener = event -> {
            int type = event.getType();
            if (type == 2 || type == 16) {
                errorsAndWarnings.add(event);
            }
        };
        systemContext.addFrameworkListener(fwkListener);
        Runnable asyncTest = () -> {
            try {
                Assert.assertNotNull((String)"Entry not found.", (Object)testBundle.getEntry("dirA/fileA"));
                Assert.assertNotNull((String)"Entry not found.", (Object)testBundle.getEntry("dirA/dirB/fileB"));
                Assert.assertNotNull((String)"Entry not found.", (Object)testBundle.getEntry("dirA/dirC/fileC"));
                Assert.assertNotNull((String)"Entry not found.", (Object)testBundle.getEntry("dirA/dirC/"));
                URL dirBURL = converter.toFileURL(testBundle.getEntry("dirA/dirB/"));
                Assert.assertNotNull((String)"Failed to convert to file URL", (Object)dirBURL);
                URL dirAURL = converter.toFileURL(testBundle.getEntry("dirA/"));
                Assert.assertNotNull((String)"Failed to convert to file URL", (Object)dirAURL);
                List allEntries = ((BundleWiring)testBundle.adapt(BundleWiring.class)).findEntries("/", "*", 1);
                Assert.assertEquals((String)("Wrong number of entries: " + String.valueOf(allEntries)), (long)8L, (long)allEntries.size());
            }
            catch (IOException e) {
                throw new AssertionFailedError(e.getMessage());
            }
        };
        ExecutorService executor1 = Executors.newFixedThreadPool(1);
        ExecutorService executor2 = Executors.newFixedThreadPool(1);
        try {
            try {
                executor1.submit(asyncTest).get();
                executor2.submit(asyncTest).get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw (RuntimeException)e.getCause();
            }
        }
        finally {
            executor1.shutdown();
            executor2.shutdown();
        }
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        if (!errorsAndWarnings.isEmpty()) {
            StringWriter errorStackTraces = new StringWriter();
            PrintWriter writer = new PrintWriter(errorStackTraces);
            for (FrameworkEvent frameworkEvent : errorsAndWarnings) {
                if (frameworkEvent.getThrowable() == null) continue;
                frameworkEvent.getThrowable().printStackTrace(writer);
            }
            writer.close();
            Assert.fail((String)("Found errors or warnings: " + errorsAndWarnings.size() + " - " + errorStackTraces.toString()));
        }
    }

    @Test
    public void testContextFinderGetResource() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.contextClassLoaderParent", "fwk");
        Equinox equinox = null;
        try {
            equinox = new Equinox(configuration);
            equinox.init();
            BundleContext bc = equinox.getBundleContext();
            ClassLoader contextFinder = (ClassLoader)bc.getService((ServiceReference)bc.getServiceReferences(ClassLoader.class, "(equinox.classloader.type=contextClassLoader)").iterator().next());
            String resource = "profile.list";
            URL fwkURL = Bundle.class.getClassLoader().getResource(resource);
            Assert.assertNotNull((String)("Did not find a parent resource: " + resource), (Object)fwkURL);
            URL url = contextFinder.getResource(resource);
            ArrayList<URL> urls = Collections.list(contextFinder.getResources(resource));
            Assert.assertTrue((String)("Did not find a parent resource: " + String.valueOf(urls)), (urls.size() > 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)url.toExternalForm(), (Object)((URL)urls.get(0)).toExternalForm());
        }
        catch (Throwable throwable) {
            SystemBundleTests.stop(equinox);
            throw throwable;
        }
        SystemBundleTests.stop((Framework)equinox);
    }

    @Test
    public void testDynamicImportFromSystemBundle() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.system.packages.extra", "some.system.pkg");
        Equinox equinox = null;
        try {
            equinox = new Equinox(configuration);
            equinox.init();
            BundleContext bc = equinox.getBundleContext();
            HashMap<String, String> h2 = new HashMap<String, String>();
            h2.put("Bundle-ManifestVersion", "2");
            h2.put("Bundle-SymbolicName", this.getName() + ".dynamicimporter");
            h2.put("DynamicImport-Package", "some.system.*; version=1.0");
            File f2 = SystemBundleTests.createBundle(config, this.getName() + ".importer", h2, new Map[0]);
            Bundle b2 = bc.installBundle("reference:file:///" + f2.getAbsolutePath());
            b2.getResource("does/not/exist.txt");
            HashMap<String, String> h1 = new HashMap<String, String>();
            h1.put("Bundle-ManifestVersion", "2");
            h1.put("Bundle-SymbolicName", this.getName() + ".exporter");
            h1.put("Export-Package", "some.system.pkg; version=1.0");
            File f1 = SystemBundleTests.createBundle(config, this.getName() + ".exporter", h1, new Map[0]);
            Bundle b1 = bc.installBundle("reference:file:///" + f1.getAbsolutePath());
            b2.getResource("some/system/pkg/Test");
            BundleWiring w = (BundleWiring)b2.adapt(BundleWiring.class);
            Assert.assertNotNull((String)"Null wiring.", (Object)w);
            List pkgWires = w.getRequiredWires("osgi.wiring.package");
            Assert.assertFalse((String)"Empty wires.", (boolean)pkgWires.isEmpty());
            Assert.assertEquals((String)"Wrong provider", (Object)b1.adapt(BundleRevision.class), (Object)((BundleWire)pkgWires.iterator().next()).getProvider());
        }
        catch (Throwable throwable) {
            SystemBundleTests.stop(equinox);
            throw throwable;
        }
        SystemBundleTests.stop((Framework)equinox);
    }

    @Test
    public void testDynamicImportPrivatePackage() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = null;
        try {
            equinox = new Equinox(configuration);
            equinox.start();
            BundleContext bc = equinox.getBundleContext();
            Bundle importer = bc.installBundle(installer.getBundleLocation("test.dynamic.privateimport"));
            importer.start();
            HashMap<String, String> exporter = new HashMap<String, String>();
            exporter.put("Bundle-ManifestVersion", "2");
            exporter.put("Bundle-SymbolicName", this.getName() + ".exporter");
            exporter.put("Export-Package", "test.dynamic.privateimport");
            File f1 = SystemBundleTests.createBundle(config, this.getName() + ".exporter", exporter, new Map[0]);
            Bundle exporterBundle = bc.installBundle("reference:file:///" + f1.getAbsolutePath());
            exporterBundle.start();
            try {
                importer.loadClass("test.dynamic.privateimport.DoesNotExist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            importer.stop();
            importer.start();
        }
        catch (Throwable throwable) {
            SystemBundleTests.stop(equinox);
            throw throwable;
        }
        SystemBundleTests.stop((Framework)equinox);
    }

    @Test
    public void testCorruptStageInstallUpdate() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
        equinox.init();
        File dirBundleFile = SystemBundleTests.createBundle(config, "dir.bundle", false, true);
        File jarBundleFile = SystemBundleTests.createBundle(config, "jar.bundle", false, false);
        BundleContext bc = equinox.getBundleContext();
        Bundle dirBundle = bc.installBundle(dirBundleFile.toURI().toASCIIString());
        Assert.assertEquals((String)"Wrong BSN", (Object)"bundledir.bundle", (Object)dirBundle.getSymbolicName());
        URLConverter converter = (URLConverter)bc.getService(bc.getServiceReference(URLConverter.class));
        URL dirFileURL = converter.resolve(dirBundle.getEntry("/"));
        File dirFile = new File(dirFileURL.getPath());
        File rootStore = dirFile.getParentFile().getParentFile().getParentFile();
        dirBundle.uninstall();
        long next = dirBundle.getBundleId() + 1L;
        next = this.doTestExistingBundleFile(bc, next, rootStore, jarBundleFile, "bundlejar.bundle", true);
        next = this.doTestExistingBundleFile(bc, next, rootStore, jarBundleFile, "bundlejar.bundle", false);
        next = this.doTestExistingBundleFile(bc, next, rootStore, dirBundleFile, "bundledir.bundle", true);
        next = this.doTestExistingBundleFile(bc, next, rootStore, dirBundleFile, "bundledir.bundle", false);
    }

    private long doTestExistingBundleFile(BundleContext bc, long next, File rootStore, File content, String bsn, boolean d) throws IOException, BundleException {
        this.createGenerationContent(next, rootStore, d);
        Bundle b = bc.installBundle(content.toURI().toASCIIString());
        Assert.assertEquals((String)"Wrong BSN", (Object)bsn, (Object)b.getSymbolicName());
        Assert.assertEquals((String)"Wrong Bundle ID", (long)next, (long)b.getBundleId());
        b.uninstall();
        return b.getBundleId() + 1L;
    }

    private Path createGenerationContent(long nextBundleID, File rootStore, boolean directory) throws IOException {
        Path nextBundleFile = rootStore.toPath().resolve(nextBundleID + "/0/bundleFile");
        if (directory) {
            nextBundleFile = nextBundleFile.resolve("testContent.txt");
        }
        Files.createDirectories(nextBundleFile.getParent(), new FileAttribute[0]);
        return Files.write(nextBundleFile, Arrays.asList("Some Content"), new OpenOption[0]);
    }

    @Test
    public void testMassiveParallelInstallStart() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        long startCreateBundle = System.nanoTime();
        int numBundles = 2000;
        File[] testBundles = SystemBundleTests.createBundles(new File(config, "bundles"), 2000, Collections.singletonMap("DynamicImport-Package", "*"));
        System.out.println("Time to create: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startCreateBundle));
        long startReslveTime = System.nanoTime();
        ExecutorService executor = Executors.newFixedThreadPool(50);
        CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
        try {
            File[] fileArray = testBundles;
            int n = testBundles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                executor.execute(() -> {
                    try {
                        String location = f.toURI().toURL().toExternalForm();
                        System.out.println("Installing: " + f.getName());
                        Bundle b = systemContext.installBundle(location);
                        b.start();
                        BundleWiring wiring = (BundleWiring)b.adapt(BundleWiring.class);
                        wiring.getClassLoader().loadClass(BundleContext.class.getName());
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                });
                ++n2;
            }
        }
        finally {
            executor.shutdown();
            Assert.assertTrue((String)"Operation took too long", (boolean)executor.awaitTermination(5L, TimeUnit.MINUTES));
        }
        System.out.println("Time to resolve: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startReslveTime));
        Assert.assertEquals((String)"Errors found.", Collections.emptyList(), errors);
        Assert.assertEquals((String)"Wrong number of bundles.", (long)2001L, (long)systemContext.getBundles().length);
        List providedWires = ((BundleWiring)equinox.adapt(BundleWiring.class)).getProvidedWires("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of provided wires.", (long)2000L, (long)providedWires.size());
        SystemBundleTests.stop((Framework)equinox);
    }

    @Test
    public void testDeleteBundleFile() throws IOException, BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
        equinox.start();
        BundleContext bc = equinox.getBundleContext();
        File b1File = SystemBundleTests.createBundle(config, "b1", false, false);
        bc.installBundle("reference:" + b1File.toURI().toASCIIString()).start();
        File b2File = SystemBundleTests.createBundle(config, "b2", false, false);
        bc.installBundle("reference:" + b2File.toURI().toASCIIString()).start();
        SystemBundleTests.stop((Framework)equinox);
        b1File.delete();
        b2File.delete();
        HashMap<String, String> launchProps = new HashMap<String, String>();
        launchProps.put("org.osgi.framework.storage", config.getAbsolutePath());
        boolean unsetSecurityManager = false;
        if (SecurityManagerTests.isSecurityManagerAllowed()) {
            unsetSecurityManager = true;
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm) {
                }
            });
        }
        try {
            equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
        }
        finally {
            if (unsetSecurityManager) {
                System.setSecurityManager(null);
            }
        }
        equinox.start();
        SystemBundleTests.stop((Framework)equinox);
    }

    @Test
    public void testCorruptedStorage() throws Exception {
        Object[] managerFolderChildren;
        String fileTablePrefix = ".fileTable.";
        String osgiManagerFolder = "org.eclipse.osgi/.manager/";
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        Bundle b = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        b.start();
        SystemBundleTests.stop((Framework)equinox);
        int latestStamp = 0;
        File latestFileTable = null;
        File managerFolder = new File(config, osgiManagerFolder);
        Object[] objectArray = managerFolderChildren = managerFolder.listFiles();
        int n = managerFolderChildren.length;
        int n2 = 0;
        while (n2 < n) {
            String stampString;
            int stamp;
            File child = objectArray[n2];
            String fileName = child.getName();
            boolean isFileTable = fileName.startsWith(fileTablePrefix);
            if (isFileTable && latestStamp < (stamp = Integer.valueOf(stampString = fileName.substring(fileTablePrefix.length())).intValue())) {
                latestFileTable = child;
                latestStamp = stamp;
            }
            ++n2;
        }
        Assert.assertNotNull((String)("Found no .fileTable files at \"" + String.valueOf(managerFolder) + "\", files found in the directory: " + Arrays.toString(managerFolderChildren)), latestFileTable);
        Files.write(latestFileTable.toPath(), new byte[0], StandardOpenOption.TRUNCATE_EXISTING);
        Assert.assertEquals((String)("Expected file to have 0 length after truncating it: " + String.valueOf(latestFileTable)), (long)0L, (long)Files.size(latestFileTable.toPath()));
        equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
        equinox.start();
        SystemBundleTests.stop((Framework)equinox);
    }

    @Test
    public void testGetBundleAfterShutdown() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        Bundle b = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        b.start();
        BundleContext testContext = b.getBundleContext();
        long id = b.getBundleId();
        Assert.assertEquals((String)"Unexpected bundle", (Object)b, (Object)systemContext.getBundle(id));
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Unexpected bundle", (Object)b, (Object)systemContext.getBundle(id));
        Assert.assertEquals((String)"Unexpected bundle count", (long)2L, (long)systemContext.getBundles().length);
        Assert.assertNull((String)"Expected null bundle after stop.", (Object)testContext.getBundle(id));
        Assert.assertEquals((String)"Unexpected bundle count", (long)0L, (long)testContext.getBundles().length);
    }

    @Test
    public void testBannedWeavingHookBundle() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("equinox.banned.weaving.hook.bundles", "weavingB1:weavingB2@[2.0,3.0):weavingB3@[1.0,2.0)");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        HashMap<String, String> testHeaders = new HashMap<String, String>();
        testHeaders.put("Bundle-ManifestVersion", "2");
        testHeaders.put("Bundle-SymbolicName", "weavingB1");
        testHeaders.put("Bundle-Version", "2.0.0");
        File b1File = SystemBundleTests.createBundle(config, (String)testHeaders.get("Bundle-SymbolicName"), testHeaders, new Map[0]);
        Bundle b1 = systemContext.installBundle("reference:file:///" + b1File.getAbsolutePath());
        b1.start();
        testHeaders.put("Bundle-SymbolicName", "weavingB2");
        File b2File = SystemBundleTests.createBundle(config, (String)testHeaders.get("Bundle-SymbolicName"), testHeaders, new Map[0]);
        Bundle b2 = systemContext.installBundle("reference:file:///" + b2File.getAbsolutePath());
        b2.start();
        testHeaders.put("Bundle-SymbolicName", "weavingB3");
        File b3File = SystemBundleTests.createBundle(config, (String)testHeaders.get("Bundle-SymbolicName"), testHeaders, new Map[0]);
        Bundle b3 = systemContext.installBundle("reference:file:///" + b3File.getAbsolutePath());
        b3.start();
        testHeaders.put("Bundle-SymbolicName", "weavingB4");
        File b4File = SystemBundleTests.createBundle(config, (String)testHeaders.get("Bundle-SymbolicName"), testHeaders, new Map[0]);
        Bundle b4 = systemContext.installBundle("reference:file:///" + b4File.getAbsolutePath());
        b4.start();
        AtomicInteger b1Called = new AtomicInteger();
        b1.getBundleContext().registerService(WeavingHook.class, w -> b1Called.incrementAndGet(), null);
        AtomicInteger b2Called = new AtomicInteger();
        b2.getBundleContext().registerService(WeavingHook.class, w -> b2Called.incrementAndGet(), null);
        AtomicInteger b3Called = new AtomicInteger();
        b3.getBundleContext().registerService(WeavingHook.class, w -> b3Called.incrementAndGet(), null);
        AtomicInteger b4Called = new AtomicInteger();
        b4.getBundleContext().registerService(WeavingHook.class, w -> b4Called.incrementAndGet(), null);
        ArrayList errors = new ArrayList();
        systemContext.addFrameworkListener(e -> {
            if (e.getType() == 2) {
                errors.add(e);
            }
        });
        Bundle testBundle = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        testBundle.loadClass("substitutes.x.Ax");
        testBundle.update();
        testBundle.loadClass("substitutes.x.Ax");
        Assert.assertEquals((String)"weavingB1 should not be called", (long)0L, (long)b1Called.get());
        Assert.assertEquals((String)"weavingB2 should not be called", (long)0L, (long)b2Called.get());
        Assert.assertEquals((String)"weavingB3 should be called", (long)2L, (long)b3Called.get());
        Assert.assertEquals((String)"weavingB4 should be called", (long)2L, (long)b4Called.get());
        SystemBundleTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong number of errors", (long)2L, (long)errors.size());
        Assert.assertEquals((String)"Wrong error bundle.", (Object)b1, (Object)((FrameworkEvent)errors.get(0)).getBundle());
        Assert.assertEquals((String)"Wrong error bundle.", (Object)b2, (Object)((FrameworkEvent)errors.get(1)).getBundle());
    }

    class TestHandler
    extends AbstractURLStreamHandlerService {
        TestHandler() {
        }

        public URLConnection openConnection(URL u) throws IOException {
            throw new IOException();
        }

        public URLConnection openConnection(URL u, Proxy p) throws IOException {
            throw new IOException();
        }
    }
}

