/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.configuration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.net.SocketFactory;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.tests.session.ConfigurationSessionTestSuite;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class EclipseStarterConfigIniTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(EclipseStarterConfigIniTest.class.getName());
        ConfigurationSessionTestSuite falseCompatBootDelegation = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", EclipseStarterConfigIniTest.class.getName());
        OSGiTestsActivator.addRequiredOSGiTestsBundles(falseCompatBootDelegation);
        falseCompatBootDelegation.addTest((Test)new EclipseStarterConfigIniTest("testFalseCompatBootDelegation"));
        falseCompatBootDelegation.setConfigIniValue("osgi.compatibility.bootdelegation", "false");
        suite.addTest((Test)falseCompatBootDelegation);
        ConfigurationSessionTestSuite defaultCompatBootDelegation = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", EclipseStarterConfigIniTest.class.getName());
        OSGiTestsActivator.addRequiredOSGiTestsBundles(defaultCompatBootDelegation);
        defaultCompatBootDelegation.addTest((Test)new EclipseStarterConfigIniTest("testDefaultCompatBootDelegation"));
        suite.addTest((Test)defaultCompatBootDelegation);
        return suite;
    }

    public EclipseStarterConfigIniTest(String name) {
        super(name);
    }

    public void testFalseCompatBootDelegation() throws Exception {
        this.doTestCompatBootDelegation(true);
    }

    public void testDefaultCompatBootDelegation() throws Exception {
        this.doTestCompatBootDelegation(false);
    }

    public void doTestCompatBootDelegation(boolean expectFailure) throws Exception {
        BundleContext context = OSGiTestsActivator.getContext();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(bytesOut);
        zipOut.putNextEntry(new ZipEntry("nothing"));
        zipOut.closeEntry();
        zipOut.close();
        Bundle b = context.installBundle(this.getName(), (InputStream)new ByteArrayInputStream(bytesOut.toByteArray()));
        String testClassName = SocketFactory.class.getName();
        if (expectFailure) {
            Assert.assertThrows((String)"Expected to fail to load VM class from bundle that does not import it", ClassNotFoundException.class, () -> {
                Class clazz = b.loadClass(testClassName);
            });
        } else {
            try {
                b.loadClass(testClassName);
            }
            catch (ClassNotFoundException e) {
                AssertionFailedError error = new AssertionFailedError("Expected to successfully load VM class from bundle that does not import it");
                error.initCause((Throwable)e);
                throw error;
            }
        }
    }
}

