/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.configuration;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.core.tests.harness.FileSystemComparator;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.session.ConfigurationSessionTestSuite;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class MovableConfigurationAreaTest
extends TestCase {
    static void doMove(IPath sourcePath, IPath destinationPath) {
        MovableConfigurationAreaTest.assertTrue((String)("Failed moving " + String.valueOf(sourcePath) + " to " + String.valueOf(destinationPath)), (boolean)sourcePath.toFile().renameTo(destinationPath.toFile()));
    }

    static void doTakeSnapshot(IPath destinationPath) {
        File configurationDir = destinationPath.toFile();
        FileSystemComparator comparator = new FileSystemComparator();
        Object snapshot = comparator.takeSnapshot(configurationDir, true);
        try {
            comparator.saveSnapshot(snapshot, configurationDir);
        }
        catch (IOException e) {
            MovableConfigurationAreaTest.fail((String)"1.0");
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(MovableConfigurationAreaTest.class.getName());
        ConfigurationSessionTestSuite initialization = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", MovableConfigurationAreaTest.class.getName());
        OSGiTestsActivator.addRequiredOSGiTestsBundles(initialization);
        initialization.setReadOnly(true);
        initialization.setCleanup(false);
        initialization.addTest((Test)new MovableConfigurationAreaTest("testInitialization"));
        suite.addTest((Test)initialization);
        final IPath sourcePath = initialization.getConfigurationPath();
        final IPath destinationPath = FileSystemHelper.getRandomLocation((IPath)FileSystemHelper.getTempDir());
        suite.addTest((Test)new TestCase("testMove"){

            public void runBare() throws Throwable {
                MovableConfigurationAreaTest.doMove(sourcePath, destinationPath);
            }
        });
        suite.addTest((Test)new TestCase("testTakeSnapshot"){

            public void runBare() throws Throwable {
                MovableConfigurationAreaTest.doTakeSnapshot(destinationPath);
            }
        });
        ConfigurationSessionTestSuite afterMoving = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", MovableConfigurationAreaTest.class.getName());
        afterMoving.setConfigurationPath(destinationPath);
        afterMoving.addMinimalBundleSet();
        afterMoving.setReadOnly(true);
        afterMoving.setPrime(false);
        afterMoving.addTest((Test)new MovableConfigurationAreaTest("testAfterMoving"));
        afterMoving.addTest((Test)new MovableConfigurationAreaTest("testVerifySnapshot"));
        suite.addTest((Test)afterMoving);
        return suite;
    }

    public MovableConfigurationAreaTest(String name) {
        super(name);
    }

    public void testAfterMoving() throws MalformedURLException, IOException, BundleException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/configuration/bundle02");
                MovableConfigurationAreaTest.fail((String)"1.0");
            }
            catch (BundleException bundleException) {
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    public void testInitialization() throws Exception {
        Bundle installed = BundleTestingHelper.installBundle((String)"1.0", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/configuration/bundle01");
        MovableConfigurationAreaTest.assertTrue((String)("installed bundle could not be resolved: " + String.valueOf(installed)), (boolean)BundleTestingHelper.resolveBundles((BundleContext)OSGiTestsActivator.getContext(), (Bundle[])new Bundle[]{installed}));
    }

    public void testVerifySnapshot() throws IOException {
        FileSystemComparator comparator = new FileSystemComparator();
        File configurationDir = ConfigurationSessionTestSuite.getConfigurationDir();
        Object oldSnaphot = comparator.loadSnapshot(configurationDir);
        Object newSnapshot = comparator.takeSnapshot(configurationDir, true);
        comparator.compareSnapshots("1.0", oldSnaphot, newSnapshot);
    }
}

