/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.configuration;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.core.tests.harness.FileSystemComparator;
import org.eclipse.core.tests.session.ConfigurationSessionTestSuite;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class ReadOnlyConfigurationAreaTest
extends TestCase {
    public static Test suite() {
        ConfigurationSessionTestSuite suite = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", ReadOnlyConfigurationAreaTest.class);
        suite.setReadOnly(true);
        OSGiTestsActivator.addRequiredOSGiTestsBundles(suite);
        return suite;
    }

    public ReadOnlyConfigurationAreaTest(String name) {
        super(name);
    }

    public void test0thSession() throws Exception {
        Bundle installed = BundleTestingHelper.installBundle((String)"1.0", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/configuration/bundle01");
        ReadOnlyConfigurationAreaTest.assertTrue((String)("installed bundle could not be resolved: " + String.valueOf(installed)), (boolean)BundleTestingHelper.resolveBundles((BundleContext)OSGiTestsActivator.getContext(), (Bundle[])new Bundle[]{installed}));
    }

    public void test1stSession() throws IOException {
        File configurationDir = ConfigurationSessionTestSuite.getConfigurationDir();
        FileSystemComparator comparator = new FileSystemComparator();
        Object snapshot = comparator.takeSnapshot(configurationDir, true);
        comparator.saveSnapshot(snapshot, configurationDir);
    }

    public void test1stSessionFollowUp() throws IOException {
        FileSystemComparator comparator = new FileSystemComparator();
        File configurationDir = ConfigurationSessionTestSuite.getConfigurationDir();
        Object oldSnaphot = comparator.loadSnapshot(configurationDir);
        Object newSnapshot = comparator.takeSnapshot(configurationDir, true);
        comparator.compareSnapshots("1.0", oldSnaphot, newSnapshot);
    }

    public void test2ndSession() throws BundleException, IOException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/configuration/bundle02");
                ReadOnlyConfigurationAreaTest.fail((String)"1.0");
            }
            catch (BundleException bundleException) {
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    public void test2ndSessionFollowUp() throws IOException {
        FileSystemComparator comparator = new FileSystemComparator();
        File configurationDir = ConfigurationSessionTestSuite.getConfigurationDir();
        Object oldSnaphot = comparator.loadSnapshot(configurationDir);
        Object newSnapshot = comparator.takeSnapshot(configurationDir, true);
        comparator.compareSnapshots("1.0", oldSnaphot, newSnapshot);
    }

    public void test3rdSession() throws BundleException, IOException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/configuration/bundle03");
                ReadOnlyConfigurationAreaTest.fail((String)"1.0");
            }
            catch (BundleException bundleException) {
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    public void test3rdSessionFollowUp() throws IOException {
        FileSystemComparator comparator = new FileSystemComparator();
        File configurationDir = ConfigurationSessionTestSuite.getConfigurationDir();
        Object oldSnaphot = comparator.loadSnapshot(configurationDir);
        Object newSnapshot = comparator.takeSnapshot(configurationDir, true);
        comparator.compareSnapshots("1.0", oldSnaphot, newSnapshot);
    }
}

