/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.container;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.builders.OSGiManifestBuilderFactory;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.tests.container.dummys.DummyCollisionHook;
import org.eclipse.osgi.tests.container.dummys.DummyContainerAdaptor;
import org.eclipse.osgi.tests.container.dummys.DummyResolverHookFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.resolver.ResolverHook;

public abstract class AbstractTest {
    protected Set<ServiceRegistration<?>> serviceRegistrations;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() {
        this.serviceRegistrations = new HashSet();
    }

    @After
    public void tearDown() {
        for (ServiceRegistration<?> serviceRegistration : this.serviceRegistrations) {
            try {
                serviceRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    protected DummyContainerAdaptor createDummyAdaptor() {
        return new DummyContainerAdaptor(new DummyCollisionHook(false), null);
    }

    protected DummyContainerAdaptor createDummyAdaptor(ResolverHook hook) {
        return new DummyContainerAdaptor(new DummyCollisionHook(false), null, new DummyResolverHookFactory(hook));
    }

    protected DummyContainerAdaptor createDummyAdaptor(DebugOptions debugOptions) {
        return new DummyContainerAdaptor(new DummyCollisionHook(false), null, new DummyResolverHookFactory(), debugOptions);
    }

    protected Bundle getBundle() {
        return ((BundleReference)this.getClass().getClassLoader()).getBundle();
    }

    protected BundleContext getBundleContext() {
        return this.getBundle().getBundleContext();
    }

    protected Map<String, String> getManifest(String manifestFile) throws IOException, BundleException {
        URL manifest = this.getBundle().getEntry("/test_files/containerTests/" + manifestFile);
        Assert.assertNotNull((String)("Could not find manifest: " + manifestFile), (Object)manifest);
        return ManifestElement.parseBundleManifest((InputStream)manifest.openStream(), null);
    }

    protected Bundle getSystemBundle() {
        return this.getBundleContext().getBundle(0L);
    }

    protected BundleContext getSystemBundleContext() {
        return this.getSystemBundle().getBundleContext();
    }

    protected Module installDummyModule(String manifestFile, String location, ModuleContainer container) throws BundleException, IOException {
        return this.installDummyModule(manifestFile, location, null, null, null, container);
    }

    protected Module installDummyModule(String manifestFile, String location, String alias, String extraExports, String extraCapabilities, ModuleContainer container) throws BundleException, IOException {
        Map<String, String> manifest = this.getManifest(manifestFile);
        ModuleRevisionBuilder builder = OSGiManifestBuilderFactory.createBuilder(manifest, (String)alias, (String)extraExports, (String)extraCapabilities);
        Module system = container.getModule(0L);
        return container.install(system, location, builder, null);
    }

    protected Module installDummyModule(Map<String, String> manifest, String location, ModuleContainer container) throws BundleException {
        return this.installDummyModule(manifest, -1L, location, container);
    }

    protected Module installDummyModule(Map<String, String> manifest, long id, String location, ModuleContainer container) throws BundleException {
        ModuleRevisionBuilder builder = OSGiManifestBuilderFactory.createBuilder(manifest);
        if (id > 0L) {
            builder.setId(id);
        }
        Module system = container.getModule(0L);
        return container.install(system, location, builder, null);
    }

    protected void registerService(Class<?> clazz, Object service) {
        this.serviceRegistrations.add(this.getSystemBundleContext().registerService(clazz.getName(), service, null));
    }

    protected void unregisterService(Object service) {
        for (ServiceRegistration<?> serviceRegistration : this.serviceRegistrations) {
            if (!this.getSystemBundleContext().getService(serviceRegistration.getReference()).equals(service)) continue;
            serviceRegistration.unregister();
        }
    }
}

