/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.builders.OSGiManifestBuilderFactory;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.eclipse.osgi.tests.container.AbstractTest;
import org.eclipse.osgi.tests.container.dummys.DummyContainerAdaptor;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleException;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;

public class ModuleContainerUsageTest
extends AbstractTest {
    static final String EE_INDEX = "internal.ee.index";

    @Test
    public void testMultipleExecutionEnvironments() throws BundleException {
        List<BundleCapability> executionEnvironments = Collections.synchronizedList(new ArrayList());
        ResolverHook resolverHook = new ResolverHook(){

            public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
                collisionCandidates.clear();
            }

            public void filterResolvable(Collection<BundleRevision> candidates) {
            }

            public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                if ("osgi.wiring.package".equals(requirement.getNamespace())) {
                    this.filterBasedOnEE((AtomicReference)((ModuleRevision)requirement.getRevision()).getRevisionInfo(), candidates);
                }
            }

            private void filterBasedOnEE(AtomicReference<Long> revisionInfo, Collection<BundleCapability> candidates) {
                Long eeIndex = revisionInfo.get();
                if (eeIndex != null) {
                    Iterator<BundleCapability> iCandidates = candidates.iterator();
                    while (iCandidates.hasNext()) {
                        Object candidateEEIndex;
                        ModuleCapability candidate = (ModuleCapability)iCandidates.next();
                        if (candidate.getRevision().getRevisions().getModule().getId() != 0L || (candidateEEIndex = candidate.getAttributes().get(ModuleContainerUsageTest.EE_INDEX)) == null || eeIndex.equals(candidateEEIndex)) continue;
                        iCandidates.remove();
                    }
                }
            }

            public void end() {
            }
        };
        DummyContainerAdaptor adaptor = this.createDummyAdaptor(resolverHook);
        ModuleContainer container = adaptor.getContainer();
        StringBuilder systemPackages = new StringBuilder();
        systemPackages.append("test.pkg1; internal.ee.index:Long=1");
        systemPackages.append(",test.pkg1; test.pkg2; internal.ee.index:Long=2");
        systemPackages.append(",test.pkg1; test.pkg2; test.pkg3; internal.ee.index:Long=3");
        systemPackages.append(",test.pkg1; test.pkg2; test.pkg3; test.pkg4; internal.ee.index:Long=4");
        systemPackages.append(",test.pkg1; test.pkg2; test.pkg3; test.pkg4; test.pkg5; internal.ee.index:Long=5");
        StringBuilder systemEEs = new StringBuilder();
        systemEEs.append("osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"1.0, 1.1, 1.2, 1.3, 1.4, 1.5\"; internal.ee.index:Long=1");
        systemEEs.append(",osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6\"; internal.ee.index:Long=2");
        systemEEs.append(",osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7\"; internal.ee.index:Long=3");
        systemEEs.append(",osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8\"; internal.ee.index:Long=4");
        systemEEs.append(",osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 9.0\"; internal.ee.index:Long=5");
        ModuleRevisionBuilder systemModuleBuilder = OSGiManifestBuilderFactory.createBuilder(this.getSystemManifest(), (String)"system.bundle", (String)systemPackages.toString(), (String)systemEEs.toString());
        Module systemBundle = container.install(null, "System Bundle", systemModuleBuilder, new AtomicReference());
        executionEnvironments.addAll(systemBundle.getCurrentRevision().getDeclaredCapabilities("osgi.ee"));
        Module m1 = this.installModule(container, "m1", "1.0", "test.pkg1", "JavaSE-1.5", executionEnvironments);
        Module m2 = this.installModule(container, "m2", "1.0", "test.pkg1,test.pkg2", "JavaSE-1.5", executionEnvironments);
        Module m3 = this.installModule(container, "m3", "1.0", "test.pkg1,test.pkg2,test.pkg3", "JavaSE-1.7", executionEnvironments);
        Module m4 = this.installModule(container, "m4", "1.0", "test.pkg1,test.pkg2,test.pkg3,test.pkg4", "JavaSE-1.7", executionEnvironments);
        ResolutionReport report = container.resolve(Arrays.asList(m1, m2, m3, m4), false);
        Assert.assertEquals((String)"Wrong state for m1.", (Object)Module.State.RESOLVED, (Object)m1.getState());
        Assert.assertEquals((String)"Wrong state for m2.", (Object)Module.State.INSTALLED, (Object)m2.getState());
        Assert.assertEquals((String)"Wrong state for m3.", (Object)Module.State.RESOLVED, (Object)m3.getState());
        Assert.assertEquals((String)"Wrong state for m4.", (Object)Module.State.INSTALLED, (Object)m4.getState());
        String resolutionErrorM2 = report.getResolutionReportMessage((Resource)m2.getCurrentRevision());
        Assert.assertNotNull((String)"Expected resolution message", (Object)resolutionErrorM2);
        Assert.assertTrue((String)"Wrong resolution message.", (boolean)resolutionErrorM2.contains("test.pkg2"));
        String resolutionErrorM4 = report.getResolutionReportMessage((Resource)m4.getCurrentRevision());
        Assert.assertNotNull((String)"Expected resolution message", (Object)resolutionErrorM4);
        Assert.assertTrue((String)"Wrong resolution message.", (boolean)resolutionErrorM4.contains("test.pkg4"));
    }

    private Map<String, String> getSystemManifest() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Bundle-ManifestVersion", "2");
        result.put("Bundle-SymbolicName", "org.eclipse.osgi");
        result.put("Bundle-Version", "1.0");
        result.put("Export-Package", "org.osgi.framework; version=1.10");
        return result;
    }

    Module installModule(ModuleContainer container, String bsn, String version, String imports, String eeReqs, List<BundleCapability> availableEEs) throws BundleException {
        ModuleRevisionBuilder builder = this.createModuleRevisionBuilder(bsn, version, imports, eeReqs);
        Module m = container.install(null, bsn, builder, new AtomicReference());
        List eeBundleReqs = m.getCurrentRevision().getDeclaredRequirements("osgi.ee");
        eeBundleReqs.stream().findFirst().ifPresent(r -> {
            for (BundleCapability ee : availableEEs) {
                if (!r.matches(ee)) continue;
                ((AtomicReference)m.getCurrentRevision().getRevisionInfo()).set((Long)ee.getAttributes().get(EE_INDEX));
                return;
            }
        });
        return m;
    }

    ModuleRevisionBuilder createModuleRevisionBuilder(String bsn, String version, String imports, String eeReq) throws BundleException {
        HashMap<String, String> manifest = new HashMap<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", bsn);
        manifest.put("Bundle-Version", version);
        manifest.put("Import-Package", imports);
        manifest.put("Bundle-RequiredExecutionEnvironment", eeReq);
        return OSGiManifestBuilderFactory.createBuilder(manifest);
    }
}

