/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.tests.container.AbstractTest;
import org.eclipse.osgi.tests.container.dummys.DummyContainerAdaptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class ModuleWiringTest
extends AbstractTest {
    private ModuleWiring wiring;

    @Before
    public void setUpBefore() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        ModuleRevision systemRevision = systemBundle.getCurrentRevision();
        container.resolve(Arrays.asList(systemBundle), true);
        ModuleWiring systemWiring = systemRevision.getWiring();
        Assert.assertNotNull((String)"system wiring is null", (Object)systemWiring);
        Module b1 = this.installDummyModule("b1_v1.MF", "b1", container);
        ModuleRevision b1Revision = b1.getCurrentRevision();
        container.resolve(Arrays.asList(b1), true);
        this.wiring = b1Revision.getWiring();
        Assert.assertNotNull((String)"b1 wiring is null", (Object)this.wiring);
    }

    @Test
    public void testGetModuleCapabilities_isUnmodifiable() {
        List capabilities = this.wiring.getModuleCapabilities(null);
        ModuleWiringTest.assertUnmodifiable(capabilities);
    }

    @Test
    public void testGetModuleRequirements_isUnmodifiable() {
        List requirements = this.wiring.getModuleRequirements(null);
        ModuleWiringTest.assertUnmodifiable(requirements);
    }

    @Test
    public void testGetProvidedModuleWires_isUnmodifiable() {
        List wiries = this.wiring.getProvidedModuleWires(null);
        ModuleWiringTest.assertUnmodifiable(wiries);
    }

    @Test
    public void testGetRequiredModuleWires_isUnmodifiable() {
        List wiries = this.wiring.getRequiredModuleWires(null);
        ModuleWiringTest.assertUnmodifiable(wiries);
    }

    @Test
    public void testGetCapabilities_isModifiable() {
        List capabilities = this.wiring.getCapabilities(null);
        ModuleWiringTest.assertModifiable(capabilities);
    }

    @Test
    public void testGetRequirements_isModifiable() {
        List requirements = this.wiring.getRequirements(null);
        ModuleWiringTest.assertModifiable(requirements);
    }

    @Test
    public void testGetProvidedWires_isModifiable() {
        List wiries = this.wiring.getProvidedWires(null);
        ModuleWiringTest.assertModifiable(wiries);
    }

    @Test
    public void testGetRequiredWires_isModifiable() {
        List wiries = this.wiring.getRequiredWires(null);
        ModuleWiringTest.assertModifiable(wiries);
    }

    @Test
    public void testGetResourceCapabilities_isModifiable() {
        List capabilities = this.wiring.getResourceCapabilities(null);
        ModuleWiringTest.assertModifiable(capabilities);
    }

    @Test
    public void testGetResourceRequirements_isModifiable() {
        List requirements = this.wiring.getResourceRequirements(null);
        ModuleWiringTest.assertModifiable(requirements);
    }

    @Test
    public void testGetProvidedResourceWires_isModifiable() {
        List wiries = this.wiring.getProvidedResourceWires(null);
        ModuleWiringTest.assertModifiable(wiries);
    }

    @Test
    public void testGetRequiredResourceWires_isModifiable() {
        List wiries = this.wiring.getRequiredResourceWires(null);
        ModuleWiringTest.assertModifiable(wiries);
    }

    private static <T> void assertUnmodifiable(List<T> list) {
        Assert.assertThrows(RuntimeException.class, () -> {
            boolean bl = list.add(null);
        });
        Assert.assertThrows(RuntimeException.class, () -> {
            Object e = list.remove(0);
        });
        Assert.assertThrows(RuntimeException.class, () -> {
            Object v0 = list.set(0, null);
        });
    }

    private static <T> void assertModifiable(List<T> list) {
        ArrayList<T> copy = new ArrayList<T>(list);
        list.add(null);
        copy.add(null);
        Assert.assertEquals(copy, list);
        list.set(0, null);
        copy.set(0, null);
        Assert.assertEquals(copy, list);
        list.remove(0);
        copy.remove(0);
        Assert.assertEquals(copy, list);
    }
}

