/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.osgi.tests.container.NamespaceListTest;
import org.junit.Assert;
import org.junit.Test;

public class NamespaceListBuilderTest {
    @Test
    public void testCreate() throws Exception {
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        Assert.assertTrue((String)"Builder is not initially empty", (boolean)builder.isEmpty());
    }

    @Test
    public void testIteratorsElementSequence_multipleNamespace() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Iterator<NamespaceListTest.NamespaceElement> iterator = builder.iterator();
        int i = 0;
        while (i < 12) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertSame((Object)elements.get(i), (Object)iterator.next());
            ++i;
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorsElementSequence_oneNamespace() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(3, "ns-1");
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Iterator<NamespaceListTest.NamespaceElement> iterator = builder.iterator();
        int i = 0;
        while (i < 3) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertSame((Object)elements.get(i), (Object)iterator.next());
            ++i;
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorsElementSequence_empty() throws Exception {
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        Iterator<NamespaceListTest.NamespaceElement> iterator = builder.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorsElementSequence_iterationBeyoundEnd_NoSuchElementException() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(2, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Iterator<NamespaceListTest.NamespaceElement> iterator = builder.iterator();
        int i = 0;
        while (i < 6) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertSame((Object)elements.get(i), (Object)iterator.next());
            ++i;
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertThrows(NoSuchElementException.class, iterator::next);
    }

    @Test
    public void testIteratorsElementSequence_iterationBeyoundEndOfEmptyBuilder_NoSuchElementException() throws Exception {
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        Iterator<NamespaceListTest.NamespaceElement> iterator = builder.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertThrows(NoSuchElementException.class, iterator::next);
    }

    @Test
    public void testIteratorRemove_removeOneElement() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Iterator<NamespaceListTest.NamespaceElement> iterator = builder.iterator();
        int i = 0;
        while (i < 6) {
            iterator.next();
            ++i;
        }
        iterator.remove();
        elements.remove(5);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testIteratorRemove_RemoveAllElements() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Iterator<NamespaceListTest.NamespaceElement> iterator = builder.iterator();
        int i = 0;
        while (i < 12) {
            iterator.next();
            iterator.remove();
            ++i;
        }
        NamespaceListBuilderTest.assertStricEqualContent(builder, Collections.emptyList());
    }

    @Test
    public void testIteratorRemove_RemoveTwice_IllegalStateException() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Iterator<NamespaceListTest.NamespaceElement> iterator = builder.iterator();
        iterator.next();
        iterator.remove();
        Assert.assertThrows(IllegalStateException.class, iterator::remove);
        elements.remove(0);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testIteratorRemove_NextNotCalled_IllegalStateException() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(1, 1);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Iterator<NamespaceListTest.NamespaceElement> iterator = builder.iterator();
        Assert.assertThrows(IllegalStateException.class, iterator::remove);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testClear() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(3, 2);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Object namespaceList = NamespaceListTest.build(builder);
        builder.clear();
        Assert.assertEquals((long)0L, (long)builder.size());
        NamespaceListBuilderTest.assertIterationOrderEquals(Collections.emptyList(), builder);
        Assert.assertEquals(NamespaceListTest.getList(namespaceList, null), elements);
        Assert.assertEquals(NamespaceListTest.getList(namespaceList, "ns-0"), elements.subList(0, 3));
        Assert.assertEquals(NamespaceListTest.getList(namespaceList, "ns-1"), elements.subList(3, 6));
    }

    @Test
    public void testGetNamespaceElements_contaiendNamespace() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(3, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        List<NamespaceListTest.NamespaceElement> namespaceElements = NamespaceListTest.builderGetNamespaceElements(builder, "ns-1");
        Assert.assertEquals(namespaceElements, elements.subList(3, 6));
    }

    @Test
    public void testGetNamespaceElements_nullNamespace() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(3, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        List<NamespaceListTest.NamespaceElement> namespaceElements = NamespaceListTest.builderGetNamespaceElements(builder, null);
        Assert.assertEquals(elements, namespaceElements);
    }

    @Test
    public void testGetNamespaceElements_notContainedNamespace() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(3, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        List<NamespaceListTest.NamespaceElement> namespaceElements = NamespaceListTest.builderGetNamespaceElements(builder, "ns-100");
        Assert.assertEquals(Collections.emptyList(), namespaceElements);
    }

    @Test
    public void testTransformIntoCopy_notEmptyBuilder() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(3, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Function<String, String> getNamespace = e -> e.substring(0, 4);
        Collection<String> transformedBuilder = NamespaceListTest.builderTransformIntoCopy(builder, Object::toString, getNamespace);
        List transformedElements = elements.stream().map(Object::toString).collect(Collectors.toList());
        NamespaceListBuilderTest.assertStricEqualContent(transformedBuilder, transformedElements, getNamespace);
        Assert.assertNotSame(builder, transformedBuilder);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testTransformIntoCopy_emptyBuilder() throws Exception {
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        Function<String, String> getNamespace = e -> e.substring(0, 4);
        Collection<String> transformedBuilder = NamespaceListTest.builderTransformIntoCopy(builder, Object::toString, getNamespace);
        Assert.assertNotSame(builder, transformedBuilder);
        NamespaceListBuilderTest.assertStricEqualContent(transformedBuilder, Collections.emptyList(), getNamespace);
        NamespaceListBuilderTest.assertStricEqualContent(builder, Collections.emptyList());
    }

    @Test
    public void testAdd_singleElement() throws Exception {
        NamespaceListTest.NamespaceElement e = new NamespaceListTest.NamespaceElement(1, "ns-1");
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.add(e);
        Assert.assertEquals(Collections.singletonList(e), NamespaceListTest.getList(NamespaceListTest.build(builder), "ns-1"));
        NamespaceListBuilderTest.assertStricEqualContent(builder, Collections.singletonList(e));
    }

    @Test
    public void testAdd_multipleElements() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        for (NamespaceListTest.NamespaceElement element : elements) {
            builder.add(element);
        }
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testAddAll_namespaceSortedList() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 7);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testAddAll_randomlySortedList() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 7);
        NamespaceListTest.randomListSort(elements);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        NamespaceListBuilderTest.assertEqualContent(builder, elements);
    }

    @Test
    public void testAddAll_emptyList() throws Exception {
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(Collections.emptyList());
        NamespaceListBuilderTest.assertEqualContent(builder, Collections.emptyList());
    }

    @Test
    public void testAddAll_namespaceList() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(5, 5);
        Object namespaceList = NamespaceListTest.newNamespace(elements);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        NamespaceListTest.builderAddAll(builder, namespaceList);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testAddAll_emptyNamespaceList() throws Exception {
        Object namespaceList = NamespaceListTest.createEmptyNamespaceList(NamespaceListTest.NamespaceElement::getNamespace);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        NamespaceListTest.builderAddAll(builder, namespaceList);
        NamespaceListBuilderTest.assertStricEqualContent(builder, Collections.emptyList());
    }

    @Test
    public void testAddAll_builderArgument() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(2, 2);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Collection<NamespaceListTest.NamespaceElement> builder2 = NamespaceListTest.builderCreate();
        List<NamespaceListTest.NamespaceElement> elements2 = NamespaceListTest.populate(2, 2);
        builder2.addAll(elements2);
        builder.addAll(builder2);
        elements.addAll(4, elements2.subList(2, 4));
        elements.addAll(2, elements2.subList(0, 2));
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testAddAllFiltered_notEmptyBuilder() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        ArrayList<NamespaceListTest.NamespaceElement> newElements = new ArrayList<NamespaceListTest.NamespaceElement>();
        newElements.add(new NamespaceListTest.NamespaceElement(0, "ns-1"));
        newElements.add(new NamespaceListTest.NamespaceElement(10, "ns-1"));
        newElements.add(new NamespaceListTest.NamespaceElement(2, "ns-20"));
        newElements.add(new NamespaceListTest.NamespaceElement(0, "ns-2"));
        newElements.add(new NamespaceListTest.NamespaceElement(2, "ns-0"));
        newElements.add(new NamespaceListTest.NamespaceElement(1, "ns-2"));
        newElements.add(new NamespaceListTest.NamespaceElement(10, "ns-20"));
        newElements.add(new NamespaceListTest.NamespaceElement(0, "ns-20"));
        Object namespaceList = NamespaceListTest.newNamespace(newElements);
        NamespaceListTest.builderAddAllFiltered(builder, namespaceList, n -> !n.equals("ns-2"), e -> e.id < 10);
        ArrayList<NamespaceListTest.NamespaceElement> expectedElements = new ArrayList<NamespaceListTest.NamespaceElement>();
        expectedElements.add(new NamespaceListTest.NamespaceElement(0, "ns-0"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(1, "ns-0"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(2, "ns-0"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(3, "ns-0"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(2, "ns-0"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(0, "ns-1"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(1, "ns-1"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(2, "ns-1"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(3, "ns-1"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(0, "ns-1"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(0, "ns-2"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(1, "ns-2"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(2, "ns-2"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(3, "ns-2"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(2, "ns-20"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(0, "ns-20"));
        NamespaceListBuilderTest.assertStricEqualContent(builder, expectedElements);
    }

    @Test
    public void testAddAllFiltered_emptyBuilder() throws Exception {
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        ArrayList<NamespaceListTest.NamespaceElement> newElements2 = new ArrayList<NamespaceListTest.NamespaceElement>();
        newElements2.add(new NamespaceListTest.NamespaceElement(0, "ns-1"));
        newElements2.add(new NamespaceListTest.NamespaceElement(10, "ns-1"));
        newElements2.add(new NamespaceListTest.NamespaceElement(2, "ns-20"));
        newElements2.add(new NamespaceListTest.NamespaceElement(0, "ns-2"));
        newElements2.add(new NamespaceListTest.NamespaceElement(2, "ns-0"));
        newElements2.add(new NamespaceListTest.NamespaceElement(1, "ns-2"));
        newElements2.add(new NamespaceListTest.NamespaceElement(10, "ns-20"));
        newElements2.add(new NamespaceListTest.NamespaceElement(0, "ns-20"));
        Object namespaceList = NamespaceListTest.newNamespace(newElements2);
        NamespaceListTest.builderAddAllFiltered(builder, namespaceList, n -> !n.equals("ns-2"), e -> e.id < 10);
        ArrayList<NamespaceListTest.NamespaceElement> expectedElements = new ArrayList<NamespaceListTest.NamespaceElement>();
        expectedElements.add(new NamespaceListTest.NamespaceElement(0, "ns-1"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(2, "ns-20"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(0, "ns-20"));
        expectedElements.add(new NamespaceListTest.NamespaceElement(2, "ns-0"));
        NamespaceListBuilderTest.assertStricEqualContent(builder, expectedElements);
    }

    @Test
    public void testAddAllFiltered_allElementsOfNewNamespaceFiltered() throws Exception {
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        ArrayList<NamespaceListTest.NamespaceElement> newElements = new ArrayList<NamespaceListTest.NamespaceElement>();
        newElements.add(new NamespaceListTest.NamespaceElement(10, "ns-1"));
        newElements.add(new NamespaceListTest.NamespaceElement(11, "ns-1"));
        Object namespaceList = NamespaceListTest.newNamespace(newElements);
        NamespaceListTest.builderAddAllFiltered(builder, namespaceList, n -> true, e -> e.id < 5);
        NamespaceListBuilderTest.assertStricEqualContent(builder, Collections.emptyList());
    }

    @Test
    public void testAddAllFilteredAfterLastMatch_matchUpUntilTheMiddle() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, "ns-0");
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        NamespaceListTest.NamespaceElement element = new NamespaceListTest.NamespaceElement(5, "ns-0");
        Object namespaceList = NamespaceListTest.newNamespace(Collections.singletonList(element));
        NamespaceListTest.builderAddAllFilteredAfterLastMatch(builder, namespaceList, n -> true, e -> true, (toAdd, e) -> e.id < 2);
        elements.add(2, element);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testAddAllFilteredAfterLastMatch_allElementsMatches() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, "ns-0");
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        NamespaceListTest.NamespaceElement element = new NamespaceListTest.NamespaceElement(5, "ns-0");
        Object namespaceList = NamespaceListTest.newNamespace(Collections.singletonList(element));
        NamespaceListTest.builderAddAllFilteredAfterLastMatch(builder, namespaceList, n -> true, e -> true, (toAdd, e) -> true);
        elements.add(4, element);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testAddAllFilteredAfterLastMatch_noMatch() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, "ns-0");
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        NamespaceListTest.NamespaceElement element = new NamespaceListTest.NamespaceElement(5, "ns-0");
        Object namespaceList = NamespaceListTest.newNamespace(Collections.singletonList(element));
        NamespaceListTest.builderAddAllFilteredAfterLastMatch(builder, namespaceList, n -> true, e -> true, (toAdd, e) -> e.id > 100);
        elements.add(0, element);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testAddAllFilteredAfterLastMatch_emptyNamespaceList() throws Exception {
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        NamespaceListTest.NamespaceElement element = new NamespaceListTest.NamespaceElement(5, "ns-0");
        Object namespaceList = NamespaceListTest.newNamespace(Collections.singletonList(element));
        NamespaceListTest.builderAddAllFilteredAfterLastMatch(builder, namespaceList, n -> true, e -> true, (toAdd, e) -> e.id < 2);
        NamespaceListBuilderTest.assertStricEqualContent(builder, Collections.singletonList(element));
    }

    @Test
    public void testRemove_elementIsOneOfMultipleOfNamespace() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 4);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Assert.assertTrue((boolean)builder.remove(new NamespaceListTest.NamespaceElement(2, "ns-0")));
        elements.remove(2);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemove_onlyElementOfNamspace() throws Exception {
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.add(new NamespaceListTest.NamespaceElement(3, "ns-0"));
        Assert.assertTrue((boolean)builder.remove(new NamespaceListTest.NamespaceElement(3, "ns-0")));
        NamespaceListBuilderTest.assertStricEqualContent(builder, Collections.emptyList());
    }

    @Test
    public void testRemove_elementNotContainedInNamespaceList() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Assert.assertFalse((boolean)builder.remove(new NamespaceListTest.NamespaceElement(100, "ns-0")));
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemove_elementWithNotPresentNamespace() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Assert.assertFalse((boolean)builder.remove(new NamespaceListTest.NamespaceElement(1, "ns-100")));
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemove_emptyBuilder() throws Exception {
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        Assert.assertFalse((boolean)builder.remove(new NamespaceListTest.NamespaceElement(3, "ns-0")));
        NamespaceListBuilderTest.assertStricEqualContent(builder, Collections.emptyList());
    }

    @Test
    public void testRemove_argumentOfOtherClass() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(2, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Assert.assertFalse((boolean)builder.remove("someString"));
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemoveAll_multipleElementsInMultipleNamsespaces() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 5);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        ArrayList<NamespaceListTest.NamespaceElement> toRemove = new ArrayList<NamespaceListTest.NamespaceElement>();
        toRemove.add(new NamespaceListTest.NamespaceElement(1, "ns-0"));
        toRemove.add(new NamespaceListTest.NamespaceElement(2, "ns-1"));
        toRemove.add(new NamespaceListTest.NamespaceElement(0, "ns-1"));
        toRemove.add(new NamespaceListTest.NamespaceElement(3, "ns-3"));
        toRemove.add(new NamespaceListTest.NamespaceElement(2, "ns-3"));
        Assert.assertTrue((boolean)builder.removeAll(toRemove));
        elements.remove(15);
        elements.remove(14);
        elements.remove(6);
        elements.remove(4);
        elements.remove(1);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemoveAll_multipleElementsInMultipleNamsespacesAndSomeNotPresent() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 5);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        ArrayList<NamespaceListTest.NamespaceElement> toRemove = new ArrayList<NamespaceListTest.NamespaceElement>();
        toRemove.add(new NamespaceListTest.NamespaceElement(1, "ns-0"));
        toRemove.add(new NamespaceListTest.NamespaceElement(2, "ns-1"));
        toRemove.add(new NamespaceListTest.NamespaceElement(100, "ns-2"));
        toRemove.add(new NamespaceListTest.NamespaceElement(0, "ns-1"));
        toRemove.add(new NamespaceListTest.NamespaceElement(3, "ns-3"));
        toRemove.add(new NamespaceListTest.NamespaceElement(100, "ns-3"));
        toRemove.add(new NamespaceListTest.NamespaceElement(2, "ns-3"));
        toRemove.add(new NamespaceListTest.NamespaceElement(100, "ns-3"));
        toRemove.add(new NamespaceListTest.NamespaceElement(1, "ns-100"));
        Assert.assertTrue((boolean)builder.removeAll(toRemove));
        elements.remove(15);
        elements.remove(14);
        elements.remove(6);
        elements.remove(4);
        elements.remove(1);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemoveAll_listOfAllElementsInBuilder() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 5);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Assert.assertTrue((boolean)builder.removeAll(elements));
        NamespaceListBuilderTest.assertStricEqualContent(builder, Collections.emptyList());
    }

    @Test
    public void testRemoveAll_emptyList() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 5);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Assert.assertFalse((boolean)builder.removeAll(Collections.emptyList()));
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemoveAll_emptyBuilder() throws Exception {
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        Assert.assertFalse((boolean)builder.removeAll(NamespaceListTest.populate(4, 3)));
        NamespaceListBuilderTest.assertStricEqualContent(builder, Collections.emptyList());
    }

    @Test
    public void testRemoveAll_argumentListOfOtherClass() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(2, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        List<String> listOfOtherElements = Arrays.asList("someString", "other");
        Assert.assertFalse((boolean)builder.removeAll(listOfOtherElements));
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemoveNamespaceIf_NamespaceMatches() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 5);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        List<String> namespacesToRemove = Arrays.asList("ns-0", "ns-2");
        NamespaceListTest.builderRemoveNamespaceIf(builder, namespacesToRemove::contains);
        elements.subList(8, 12).clear();
        elements.subList(0, 4).clear();
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemoveNamespaceIf_NamespaceMatchesExpunging() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(3, 2);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        NamespaceListTest.builderRemoveNamespaceIf(builder, n -> true);
        NamespaceListBuilderTest.assertStricEqualContent(builder, Collections.emptyList());
    }

    @Test
    public void testRemoveNamespaceIf_NoNamespaceMatches() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(3, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        NamespaceListTest.builderRemoveNamespaceIf(builder, "ns-100"::equals);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemoveIf_multipleMatches() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(5, 5);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        builder.removeIf(e -> e.id % 3 == 0 || "ns-1".equals(e.namespace));
        elements.remove(23);
        elements.remove(20);
        elements.remove(18);
        elements.remove(15);
        elements.remove(13);
        elements.remove(10);
        elements.subList(5, 10).clear();
        elements.remove(3);
        elements.remove(0);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemoveIf_allMatches() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        builder.removeIf(e -> true);
        NamespaceListBuilderTest.assertStricEqualContent(builder, Collections.emptyList());
    }

    @Test
    public void testRemoveIf_noMatches() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 3);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        builder.removeIf(e -> false);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemoveElementsOfNamespaceIf_multipleMatches() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 2);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        NamespaceListTest.builderRemoveElementsOfNamespaceIf(builder, "ns-0", e -> e.id == 1 || e.id == 2);
        elements.remove(2);
        elements.remove(1);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemoveElementsOfNamespaceIf_allElementsOfNamespaceMatch() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 2);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        NamespaceListTest.builderRemoveElementsOfNamespaceIf(builder, "ns-0", e -> e.id == 1 || e.id == 2);
        elements.remove(2);
        elements.remove(1);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemoveElementsOfNamespaceIf_allElementsMatch() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 1);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        NamespaceListTest.builderRemoveElementsOfNamespaceIf(builder, "ns-0", e -> true);
        NamespaceListBuilderTest.assertStricEqualContent(builder, Collections.emptyList());
    }

    @Test
    public void testRemoveElementsOfNamespaceIf_noMatch() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 1);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        NamespaceListTest.builderRemoveElementsOfNamespaceIf(builder, "ns-0", e -> false);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testRemoveElementsOfNamespaceIf_namespaceNotPresent() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 1);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        NamespaceListTest.builderRemoveElementsOfNamespaceIf(builder, "ns-100", e -> true);
        NamespaceListBuilderTest.assertStricEqualContent(builder, elements);
    }

    @Test
    public void testBuild_notEmptyBuilder() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 2);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Object namespaceList1 = NamespaceListTest.build(builder);
        Assert.assertEquals(elements, NamespaceListTest.getList(namespaceList1, null));
        Assert.assertEquals(elements.subList(0, 4), NamespaceListTest.getList(namespaceList1, "ns-0"));
        Assert.assertEquals(elements.subList(4, 8), NamespaceListTest.getList(namespaceList1, "ns-1"));
        Object namespaceList2 = NamespaceListTest.build(builder);
        Assert.assertEquals(elements, NamespaceListTest.getList(namespaceList1, null));
        Assert.assertEquals(elements.subList(0, 4), NamespaceListTest.getList(namespaceList1, "ns-0"));
        Assert.assertEquals(elements.subList(4, 8), NamespaceListTest.getList(namespaceList1, "ns-1"));
        Assert.assertEquals(elements, NamespaceListTest.getList(namespaceList2, null));
        Assert.assertEquals(elements.subList(0, 4), NamespaceListTest.getList(namespaceList2, "ns-0"));
        Assert.assertEquals(elements.subList(4, 8), NamespaceListTest.getList(namespaceList2, "ns-1"));
    }

    @Test
    public void testBuild_emptyBuilder() throws Exception {
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        Object namespaceList = NamespaceListTest.build(builder);
        Assert.assertEquals(Collections.emptyList(), NamespaceListTest.getList(namespaceList, null));
    }

    @Test
    public void testBuild_subsequentModificationOfBuilder() throws Exception {
        List<NamespaceListTest.NamespaceElement> elements = NamespaceListTest.populate(4, 2);
        Collection<NamespaceListTest.NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        Object namespaceList1 = NamespaceListTest.build(builder);
        Assert.assertEquals(elements, NamespaceListTest.getList(namespaceList1, null));
        Assert.assertEquals(elements.subList(0, 4), NamespaceListTest.getList(namespaceList1, "ns-0"));
        Assert.assertEquals(elements.subList(4, 8), NamespaceListTest.getList(namespaceList1, "ns-1"));
        List<NamespaceListTest.NamespaceElement> additionalElements = NamespaceListTest.populate(1, 3);
        builder.addAll(additionalElements);
        ArrayList<NamespaceListTest.NamespaceElement> newElements = new ArrayList<NamespaceListTest.NamespaceElement>(elements);
        newElements.add(8, additionalElements.get(2));
        newElements.add(8, additionalElements.get(1));
        newElements.add(4, additionalElements.get(0));
        Assert.assertEquals(elements, NamespaceListTest.getList(namespaceList1, null));
        Assert.assertEquals(elements.subList(0, 4), NamespaceListTest.getList(namespaceList1, "ns-0"));
        Assert.assertEquals(elements.subList(4, 8), NamespaceListTest.getList(namespaceList1, "ns-1"));
        NamespaceListBuilderTest.assertStricEqualContent(builder, newElements);
    }

    private static void assertStricEqualContent(Collection<NamespaceListTest.NamespaceElement> builder, List<NamespaceListTest.NamespaceElement> expectedElements) throws Exception {
        NamespaceListBuilderTest.assertStricEqualContent(builder, expectedElements, NamespaceListTest.NamespaceElement::getNamespace);
    }

    private static <E> void assertStricEqualContent(Collection<E> builder, List<E> expectedElements, Function<E, String> getNamespace) throws Exception {
        NamespaceListBuilderTest.assertIterationOrderEquals(expectedElements, builder);
        Assert.assertEquals((long)expectedElements.size(), (long)builder.size());
        Map<String, List<E>> namespaceElements = NamespaceListBuilderTest.getNamespaceElements(expectedElements, getNamespace);
        Object namespaceList = NamespaceListTest.build(builder);
        Assert.assertEquals((long)expectedElements.size(), (long)NamespaceListTest.getList(namespaceList, null).size());
        for (Map.Entry<String, List<E>> entry : namespaceElements.entrySet()) {
            String namespace = entry.getKey();
            List<E> elements = entry.getValue();
            Assert.assertEquals(elements, NamespaceListTest.getList(namespaceList, namespace));
            Assert.assertEquals(elements, NamespaceListTest.builderGetNamespaceElements(builder, namespace));
        }
        Assert.assertEquals(expectedElements, NamespaceListTest.getList(namespaceList, null));
    }

    private static void assertEqualContent(Collection<NamespaceListTest.NamespaceElement> builder, List<NamespaceListTest.NamespaceElement> expectedElements) throws Exception {
        NamespaceListBuilderTest.assertContentEquals(expectedElements, builder);
        Assert.assertEquals((long)expectedElements.size(), (long)builder.size());
        Map<String, List<NamespaceListTest.NamespaceElement>> namespaceElements = NamespaceListBuilderTest.getNamespaceElements(expectedElements, NamespaceListTest.NamespaceElement::getNamespace);
        Object namespaceList = NamespaceListTest.build(builder);
        Assert.assertEquals((long)expectedElements.size(), (long)NamespaceListTest.getList(namespaceList, null).size());
        for (Map.Entry<String, List<NamespaceListTest.NamespaceElement>> entry : namespaceElements.entrySet()) {
            String namespace = entry.getKey();
            List<NamespaceListTest.NamespaceElement> elements = entry.getValue();
            NamespaceListBuilderTest.assertContentEquals(elements, NamespaceListTest.getList(namespaceList, namespace));
            NamespaceListBuilderTest.assertContentEquals(elements, NamespaceListTest.builderGetNamespaceElements(builder, namespace));
        }
        NamespaceListBuilderTest.assertContentEquals(expectedElements, NamespaceListTest.getList(namespaceList, null));
    }

    private static <E> void assertIterationOrderEquals(Collection<E> expected, Collection<E> actual) {
        Assert.assertEquals(new ArrayList<E>(expected), new ArrayList<E>(actual));
    }

    private static <E> void assertContentEquals(List<E> expected, Collection<E> actual) {
        Assert.assertEquals(new HashSet<E>(expected), new HashSet<E>(actual));
    }

    private static <E> Map<String, List<E>> getNamespaceElements(List<E> elements, Function<E, String> getNamespace) {
        HashMap<String, List<E>> namespaceElements = new HashMap<String, List<E>>();
        for (E element : elements) {
            namespaceElements.computeIfAbsent(getNamespace.apply(element), n -> new ArrayList()).add(element);
        }
        return namespaceElements;
    }
}

