/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.container;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.osgi.tests.container.AbstractTest;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class NamespaceListTest
extends AbstractTest {
    static final Method NAMESPACELIST_GET_LIST;
    static final Method NAMESPACELIST_IS_EMPTY;
    static final Method NAMESPACELIST_EMPTY;
    static final Method NAMESPACELIST_CREATE_BUILDER;
    static final Method BUILDER_CREATE;
    static final Method BUILDER_GET_NAMESPACE_ELEMENTS;
    static final Method BUILDER_TRANSFORM_INTO_COPY;
    static final Method BUILDER_ADD_ALL;
    static final Method BUILDER_ADD_ALL_FILTERED;
    static final Method BUILDER_ADD_ALL_FILTERED_AFTER_LAST_MATCH;
    static final Method BUILDER_REMOVE_NAMESPACE_IF;
    static final Method BUILDER_REMOVE_ELEMENTS_OF_NAMESPACE_IF;
    static final Method BUILDER_BUILD;

    static {
        try {
            ClassLoader classLoader = Bundle.class.getClassLoader();
            Class<?> namespaceList = classLoader.loadClass("org.eclipse.osgi.internal.container.NamespaceList");
            Class<?> namespaceListBuilder = classLoader.loadClass("org.eclipse.osgi.internal.container.NamespaceList$Builder");
            NAMESPACELIST_GET_LIST = namespaceList.getMethod("getList", String.class);
            NAMESPACELIST_IS_EMPTY = namespaceList.getMethod("isEmpty", new Class[0]);
            NAMESPACELIST_EMPTY = namespaceList.getMethod("empty", Function.class);
            NAMESPACELIST_CREATE_BUILDER = namespaceList.getMethod("createBuilder", new Class[0]);
            BUILDER_CREATE = namespaceListBuilder.getMethod("create", Function.class);
            BUILDER_GET_NAMESPACE_ELEMENTS = namespaceListBuilder.getMethod("getNamespaceElements", String.class);
            BUILDER_TRANSFORM_INTO_COPY = namespaceListBuilder.getMethod("transformIntoCopy", Function.class, Function.class);
            BUILDER_ADD_ALL = namespaceListBuilder.getMethod("addAll", namespaceList);
            BUILDER_ADD_ALL_FILTERED = namespaceListBuilder.getMethod("addAllFiltered", namespaceList, Predicate.class, Predicate.class);
            BUILDER_ADD_ALL_FILTERED_AFTER_LAST_MATCH = namespaceListBuilder.getMethod("addAllFilteredAfterLastMatch", namespaceList, Predicate.class, Predicate.class, BiPredicate.class);
            BUILDER_REMOVE_NAMESPACE_IF = namespaceListBuilder.getMethod("removeNamespaceIf", Predicate.class);
            BUILDER_REMOVE_ELEMENTS_OF_NAMESPACE_IF = namespaceListBuilder.getMethod("removeElementsOfNamespaceIf", String.class, Predicate.class);
            BUILDER_BUILD = namespaceListBuilder.getMethod("build", new Class[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static Object newNamespace(List<NamespaceElement> elements) throws Exception {
        Collection<NamespaceElement> builder = NamespaceListTest.builderCreate();
        builder.addAll(elements);
        return NamespaceListTest.build(builder);
    }

    static <E> Object createEmptyNamespaceList(Function<E, String> getNamespace) throws Exception {
        return NAMESPACELIST_EMPTY.invoke(null, getNamespace);
    }

    static boolean isEmpty(Object namespaceList) throws Exception {
        return (Boolean)NAMESPACELIST_IS_EMPTY.invoke(namespaceList, new Object[0]);
    }

    static List<NamespaceElement> getList(Object namespaceList, String namespace) throws Exception {
        return (List)NAMESPACELIST_GET_LIST.invoke(namespaceList, namespace);
    }

    static Collection<NamespaceElement> createBuilder(Object namespaceList) throws Exception {
        return (Collection)NAMESPACELIST_CREATE_BUILDER.invoke(namespaceList, new Object[0]);
    }

    static Collection<NamespaceElement> builderCreate() throws Exception {
        Function<NamespaceElement, String> getNamespace = NamespaceElement::getNamespace;
        return (Collection)BUILDER_CREATE.invoke(null, getNamespace);
    }

    static <E> List<E> builderGetNamespaceElements(Collection<E> builder, String namespace) throws Exception {
        return (List)BUILDER_GET_NAMESPACE_ELEMENTS.invoke(builder, namespace);
    }

    static <T, R> Collection<R> builderTransformIntoCopy(Collection<T> builder, Function<T, R> transformation, Function<R, String> newGetNamespace) throws Exception {
        return (Collection)BUILDER_TRANSFORM_INTO_COPY.invoke(builder, transformation, newGetNamespace);
    }

    static <E> void builderAddAll(Collection<E> builder, Object namespaceList) throws Exception {
        BUILDER_ADD_ALL.invoke(builder, namespaceList);
    }

    static <E> void builderAddAllFiltered(Collection<E> builder, Object namespaceList, Predicate<? super String> namespaceFilter, Predicate<E> elementFilter) throws Exception {
        BUILDER_ADD_ALL_FILTERED.invoke(builder, namespaceList, namespaceFilter, elementFilter);
    }

    static <E> void builderAddAllFilteredAfterLastMatch(Collection<E> builder, Object namespaceList, Predicate<? super String> namespaceFilter, Predicate<E> elementFilter, BiPredicate<E, E> insertionMatcher) throws Exception {
        BUILDER_ADD_ALL_FILTERED_AFTER_LAST_MATCH.invoke(builder, namespaceList, namespaceFilter, elementFilter, insertionMatcher);
    }

    static <E> void builderRemoveNamespaceIf(Collection<E> builder, Predicate<String> filter) throws Exception {
        BUILDER_REMOVE_NAMESPACE_IF.invoke(builder, filter);
    }

    static <E> void builderRemoveElementsOfNamespaceIf(Collection<E> builder, String namespace, Predicate<E> filter) throws Exception {
        BUILDER_REMOVE_ELEMENTS_OF_NAMESPACE_IF.invoke(builder, namespace, filter);
    }

    static <E> Object build(Collection<E> builder) throws Exception {
        return BUILDER_BUILD.invoke(builder, new Object[0]);
    }

    @Test
    public void testCreateEmptyList() throws Exception {
        Object namespaceList = NamespaceListTest.createEmptyNamespaceList(NamespaceElement::getNamespace);
        Assert.assertTrue((String)"List is not empty.", (boolean)NamespaceListTest.isEmpty(namespaceList));
    }

    @Test
    public void testIsEmpty() throws Exception {
        Object namespaceList = NamespaceListTest.newNamespace(Collections.emptyList());
        Assert.assertTrue((String)"List is not empty.", (boolean)NamespaceListTest.isEmpty(namespaceList));
        ArrayList<NamespaceElement> elements = new ArrayList<NamespaceElement>();
        elements.add(new NamespaceElement(0, "ns1"));
        namespaceList = NamespaceListTest.newNamespace(elements);
        Assert.assertFalse((String)"List is empty.", (boolean)NamespaceListTest.isEmpty(namespaceList));
        elements.add(new NamespaceElement(1, "ns2"));
        namespaceList = NamespaceListTest.newNamespace(elements);
        Assert.assertFalse((String)"List is empty.", (boolean)NamespaceListTest.isEmpty(namespaceList));
    }

    @Test
    public void testGetList() throws Exception {
        Object namespaceList = NamespaceListTest.newNamespace(Collections.emptyList());
        List<NamespaceElement> list = NamespaceListTest.getList(namespaceList, null);
        Assert.assertTrue((String)"List is not empty.", (boolean)list.isEmpty());
        this.failAdd(list);
        list = NamespaceListTest.getList(namespaceList, "ns-1");
        Assert.assertTrue((String)"List is not empty.", (boolean)list.isEmpty());
        this.failAdd(list);
        List<NamespaceElement> elements = NamespaceListTest.populate(5, 10);
        namespaceList = NamespaceListTest.newNamespace(elements);
        int i = 0;
        while (i < 10) {
            list = NamespaceListTest.getList(namespaceList, "ns-" + i);
            this.failAdd(list);
            Assert.assertEquals((String)"Wrong list.", NamespaceListTest.populate(5, "ns-" + i), list);
            ++i;
        }
        list = NamespaceListTest.getList(namespaceList, null);
        this.failAdd(list);
        Assert.assertEquals((String)"Wrong list.", NamespaceListTest.populate(5, 10), list);
    }

    @Test
    public void testOutOfOrderNamespace() throws Exception {
        List<NamespaceElement> elements = NamespaceListTest.populate(4, 4);
        NamespaceListTest.randomListSort(elements);
        Object namespaceList = NamespaceListTest.newNamespace(elements);
        int i = 0;
        while (i < 4) {
            List<NamespaceElement> list = NamespaceListTest.getList(namespaceList, "ns-" + i);
            this.failAdd(list);
            Assert.assertEquals((String)"Wrong number of elements", (long)4L, (long)list.size());
            for (NamespaceElement e : list) {
                Assert.assertEquals((String)"Wrong namespace", (Object)("ns-" + i), (Object)e.getNamespace());
            }
            ++i;
        }
    }

    @Test
    public void testCreateBuilder() throws Exception {
        List<NamespaceElement> elements = NamespaceListTest.populate(5, 10);
        Object namespaceList = NamespaceListTest.newNamespace(elements);
        Collection<NamespaceElement> builder = NamespaceListTest.createBuilder(namespaceList);
        Object buildNamespaceList = NamespaceListTest.build(builder);
        Assert.assertEquals((String)"Builder not populated correctly", NamespaceListTest.getList(buildNamespaceList, null), NamespaceListTest.getList(namespaceList, null));
    }

    private void failAdd(List<NamespaceElement> list) {
        NamespaceElement e = new NamespaceElement(0, "ns");
        Assert.assertThrows(UnsupportedOperationException.class, () -> {
            boolean bl = list.add(e);
        });
    }

    static List<NamespaceElement> populate(int numElementsPerNS, int numNS) {
        ArrayList<NamespaceElement> elements = new ArrayList<NamespaceElement>(numElementsPerNS * numNS);
        int namespace = 0;
        while (namespace < numNS) {
            int element = 0;
            while (element < numElementsPerNS) {
                elements.add(new NamespaceElement(element, "ns-" + namespace));
                ++element;
            }
            ++namespace;
        }
        return elements;
    }

    static List<NamespaceElement> populate(int numElements, String namespace) {
        ArrayList<NamespaceElement> elements = new ArrayList<NamespaceElement>(numElements);
        int element = 0;
        while (element < numElements) {
            elements.add(new NamespaceElement(element, namespace));
            ++element;
        }
        return elements;
    }

    static void randomListSort(List<NamespaceElement> elements) {
        Collections.shuffle(elements, new Random(43L));
    }

    static class NamespaceElement {
        final int id;
        final String namespace;

        public NamespaceElement(int id, String namespace) {
            this.id = id;
            this.namespace = namespace;
        }

        public int getId() {
            return this.id;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public boolean equals(Object o) {
            if (o instanceof NamespaceElement) {
                NamespaceElement other = (NamespaceElement)o;
                return this.id == other.id && this.namespace.equals(other.namespace);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.id);
        }

        public String toString() {
            return this.namespace + ":" + this.id;
        }
    }
}

