/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.container;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.eclipse.osgi.tests.container.AbstractTest;
import org.eclipse.osgi.tests.container.dummys.DummyContainerAdaptor;
import org.eclipse.osgi.tests.container.dummys.DummyResolverHook;
import org.eclipse.osgi.tests.container.dummys.DummyResolverHookFactory;
import org.eclipse.osgi.tests.container.dummys.UnresolvedProviderEntryBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class ResolutionReportTest
extends AbstractTest {
    @Test
    public void testResolutionReportListenerService() throws Exception {
        DummyResolverHook hook = new DummyResolverHook();
        this.registerService(ResolverHookFactory.class, new DummyResolverHookFactory(hook));
        ((FrameworkWiring)this.getSystemBundle().adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(this.getSystemBundle()));
        Assert.assertEquals((String)"No resolution report listener callback", (long)1L, (long)hook.getResolutionReports().size());
        Assert.assertNotNull((String)"Resolution report was null", (Object)hook.getResolutionReports().get(0));
    }

    @Test
    public void testResolutionReportListenerModule() throws Exception {
        DummyResolverHook hook = new DummyResolverHook();
        DummyContainerAdaptor adaptor = this.createDummyAdaptor(hook);
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Assert.assertEquals((String)"No resolution report listener callback", (long)1L, (long)hook.getResolutionReports().size());
        Assert.assertNotNull((String)"Resolution report was null", (Object)hook.getResolutionReports().get(0));
    }

    @Test
    public void testResolutionReportEntryFilteredByResolverHook() throws Exception {
        DummyResolverHook hook = new DummyResolverHook(){

            @Override
            public void filterResolvable(Collection<BundleRevision> candidates) {
                candidates.clear();
            }
        };
        DummyContainerAdaptor adaptor = this.createDummyAdaptor(hook);
        ModuleContainer container = adaptor.getContainer();
        Module module = this.installDummyModule("resolution.report.a.MF", "resolution.report.a", container);
        this.assertResolutionDoesNotSucceed(container, Arrays.asList(module));
        ResolutionReport report = hook.getResolutionReports().get(0);
        Map resourceToEntries = report.getEntries();
        this.assertResolutionReportEntriesSize(resourceToEntries, 1);
        List entries = (List)resourceToEntries.get(module.getCurrentRevision());
        this.assertResolutionReportEntriesSize(entries, 1);
        ResolutionReport.Entry entry = (ResolutionReport.Entry)entries.get(0);
        this.assertResolutionReportEntryTypeFilteredByResolverHook(entry.getType());
        this.assertResolutionReportEntryDataNull(entry.getData());
    }

    @Test
    public void testResolutionReportEntrySingletonSelectionNoneResolved() throws Exception {
        DummyResolverHook hook = new DummyResolverHook();
        DummyContainerAdaptor adaptor = this.createDummyAdaptor(hook);
        ModuleContainer container = adaptor.getContainer();
        Module resolutionReporta = this.installDummyModule("resolution.report.a.MF", "resolution.report.a", container);
        Module resolutionReportaV1 = this.installDummyModule("resolution.report.a.v1.MF", "resolution.report.a.v1", container);
        this.assertResolutionDoesNotSucceed(container, Arrays.asList(resolutionReporta, resolutionReportaV1));
        ResolutionReport report = hook.getResolutionReports().get(0);
        Map resourceToEntries = report.getEntries();
        this.assertResolutionReportEntriesSize(resourceToEntries, 1);
        List entries = (List)resourceToEntries.get(resolutionReporta.getCurrentRevision());
        this.assertResolutionReportEntriesSize(entries, 1);
        ResolutionReport.Entry entry = (ResolutionReport.Entry)entries.get(0);
        this.assertResolutionReportEntryTypeSingletonSelection(entry.getType());
        this.assertResolutionReportEntryDataNotNull(entry.getData());
    }

    @Test
    public void testResolutionReportEntrySingletonSelectionHighestVersionResolved() throws Exception {
        DummyResolverHook hook = new DummyResolverHook();
        DummyContainerAdaptor adaptor = this.createDummyAdaptor(hook);
        ModuleContainer container = adaptor.getContainer();
        Module resolutionReporta = this.installDummyModule("resolution.report.a.MF", "resolution.report.a", container);
        Module resolutionReportaV1 = this.installDummyModule("resolution.report.a.v1.MF", "resolution.report.a.v1", container);
        container.resolve(Arrays.asList(resolutionReportaV1), true);
        this.clearResolutionReports(hook);
        this.assertResolutionDoesNotSucceed(container, Arrays.asList(resolutionReporta));
        ResolutionReport report = hook.getResolutionReports().get(0);
        Map resourceToEntries = report.getEntries();
        this.assertResolutionReportEntriesSize(resourceToEntries, 1);
        List entries = (List)resourceToEntries.get(resolutionReporta.getCurrentRevision());
        this.assertResolutionReportEntriesSize(entries, 1);
        ResolutionReport.Entry entry = (ResolutionReport.Entry)entries.get(0);
        this.assertResolutionReportEntryTypeSingletonSelection(entry.getType());
        this.assertResolutionReportEntryDataNotNull(entry.getData());
    }

    @Test
    public void testResolutionReportEntrySingletonSelectionLowestVersionResolved() throws Exception {
        DummyResolverHook hook = new DummyResolverHook();
        DummyContainerAdaptor adaptor = this.createDummyAdaptor(hook);
        ModuleContainer container = adaptor.getContainer();
        Module resolutionReporta = this.installDummyModule("resolution.report.a.MF", "resolution.report.a", container);
        container.resolve(Arrays.asList(resolutionReporta), true);
        this.clearResolutionReports(hook);
        Module resolutionReportaV1 = this.installDummyModule("resolution.report.a.v1.MF", "resolution.report.a.v1", container);
        this.assertResolutionDoesNotSucceed(container, Arrays.asList(resolutionReportaV1));
        ResolutionReport report = hook.getResolutionReports().get(0);
        Map resourceToEntries = report.getEntries();
        this.assertResolutionReportEntriesSize(resourceToEntries, 1);
        List entries = (List)resourceToEntries.get(resolutionReportaV1.getCurrentRevision());
        this.assertResolutionReportEntriesSize(entries, 1);
        ResolutionReport.Entry entry = (ResolutionReport.Entry)entries.get(0);
        this.assertResolutionReportEntryTypeSingletonSelection(entry.getType());
        this.assertResolutionReportEntryDataNotNull(entry.getData());
    }

    @Test
    public void testResolutionReportEntryMissingCapability() throws Exception {
        DummyResolverHook hook = new DummyResolverHook();
        DummyContainerAdaptor adaptor = this.createDummyAdaptor(hook);
        ModuleContainer container = adaptor.getContainer();
        Module resolutionReportB = this.installDummyModule("resolution.report.b.MF", "resolution.report.b", container);
        this.assertResolutionDoesNotSucceed(container, Arrays.asList(resolutionReportB));
        ResolutionReport report = hook.getResolutionReports().get(0);
        Map resourceToEntries = report.getEntries();
        this.assertResolutionReportEntriesSize(resourceToEntries, 1);
        List entries = (List)resourceToEntries.get(resolutionReportB.getCurrentRevision());
        this.assertResolutionReportEntriesSize(entries, 1);
        ResolutionReport.Entry entry = (ResolutionReport.Entry)entries.get(0);
        this.assertResolutionReportEntryTypeMissingCapability(entry.getType());
        this.assertResolutionReportEntryDataMissingCapability(entry.getData(), "osgi.wiring.package", "resolution.report.a");
    }

    @Test
    public void testResolutionReportEntryUnresolvedProvider01() throws Exception {
        DummyResolverHook hook = new DummyResolverHook();
        DummyContainerAdaptor adaptor = this.createDummyAdaptor(hook);
        ModuleContainer container = adaptor.getContainer();
        Module resolutionReportC = this.installDummyModule("resolution.report.c.MF", "resolution.report.c", container);
        Module resolutionReportD = this.installDummyModule("resolution.report.d.MF", "resolution.report.d", container);
        this.assertResolutionDoesNotSucceed(container, Arrays.asList(resolutionReportC, resolutionReportD));
        ResolutionReport report = hook.getResolutionReports().get(0);
        Map resourceToEntries = report.getEntries();
        this.assertResolutionReportEntriesSize(resourceToEntries, 2);
        List entries = (List)resourceToEntries.get(resolutionReportC.getCurrentRevision());
        this.assertResolutionReportEntriesSize(entries, 1);
        ResolutionReport.Entry entry = (ResolutionReport.Entry)entries.get(0);
        this.assertResolutionReportEntryTypeUnresolvedProvider(entry.getType());
        this.assertResolutionReportEntryDataUnresolvedProvider(entry.getData(), new UnresolvedProviderEntryBuilder().requirement((Requirement)resolutionReportC.getCurrentRevision().getRequirements("resolution.report.d").get(0)).capability((Capability)resolutionReportD.getCurrentRevision().getCapabilities("resolution.report.d").get(0)).build());
        entries = (List)resourceToEntries.get(resolutionReportD.getCurrentRevision());
        this.assertResolutionReportEntriesSize(entries, 1);
        entry = (ResolutionReport.Entry)entries.get(0);
        this.assertResolutionReportEntryTypeMissingCapability(entry.getType());
        this.assertResolutionReportEntryDataMissingCapability(entry.getData(), "does.not.exist", null);
    }

    @Test
    public void testResolutionReportEntryUnresolvedProvider02() throws Exception {
        DummyResolverHook hook = new DummyResolverHook();
        DummyContainerAdaptor adaptor = this.createDummyAdaptor(hook);
        ModuleContainer container = adaptor.getContainer();
        Module resolutionReportE = this.installDummyModule("resolution.report.e.MF", "resolution.report.e", container);
        Module resolutionReportF = this.installDummyModule("resolution.report.f.MF", "resolution.report.f", container);
        Module resolutionReportG = this.installDummyModule("resolution.report.g.MF", "resolution.report.g", container);
        this.assertResolutionSucceeds(container, Arrays.asList(resolutionReportG, resolutionReportE, resolutionReportF));
        ResolutionReport report = hook.getResolutionReports().get(0);
        Map resourceToEntries = report.getEntries();
        this.assertResolutionReportEntriesSize(resourceToEntries, 2);
        List entries = (List)resourceToEntries.get(resolutionReportG.getCurrentRevision());
        this.assertResolutionReportEntriesSize(entries, 1);
        ResolutionReport.Entry entry = (ResolutionReport.Entry)entries.get(0);
        this.assertResolutionReportEntryTypeUnresolvedProvider(entry.getType());
        this.assertResolutionReportEntryDataUnresolvedProvider(entry.getData(), new UnresolvedProviderEntryBuilder().requirement((Requirement)resolutionReportG.getCurrentRevision().getRequirements("osgi.wiring.package").get(1)).capability((Capability)resolutionReportF.getCurrentRevision().getCapabilities("osgi.wiring.package").get(0)).build());
        entries = (List)resourceToEntries.get(resolutionReportF.getCurrentRevision());
        this.assertResolutionReportEntriesSize(entries, 1);
        entry = (ResolutionReport.Entry)entries.get(0);
        this.assertResolutionReportEntryTypeMissingCapability(entry.getType());
        this.assertResolutionReportEntryDataMissingCapability(entry.getData(), "does.not.exist", null);
    }

    private void clearResolutionReports(DummyResolverHook hook) {
        hook.getResolutionReports().clear();
    }

    private void assertResolutionDoesNotSucceed(ModuleContainer container, Collection<Module> modules) {
        ResolutionReport report = container.resolve(modules, true);
        Assert.assertNotNull((String)"Resolution should not have succeeded", (Object)report.getResolutionException());
    }

    private void assertResolutionSucceeds(ModuleContainer container, Collection<Module> modules) {
        ResolutionReport report = container.resolve(modules, false);
        Assert.assertNull((String)"Unexpected resolution exception", (Object)report.getResolutionException());
    }

    private void assertResolutionReportEntriesNotNull(Map<Resource, List<ResolutionReport.Entry>> entries) {
        Assert.assertNotNull((String)"Resolution report entries was null", entries);
    }

    private void assertResolutionReportEntriesSize(Map<Resource, List<ResolutionReport.Entry>> entries, int expected) {
        this.assertResolutionReportEntriesNotNull(entries);
        Assert.assertEquals((String)"Wrong number of total resolution report entries", (long)expected, (long)entries.size());
    }

    private void assertResolutionReportEntriesNotNull(List<ResolutionReport.Entry> entries) {
        Assert.assertNotNull((String)"Resolution report entries for resource was null", entries);
    }

    private void assertResolutionReportEntriesSize(List<ResolutionReport.Entry> entries, int expected) {
        this.assertResolutionReportEntriesNotNull(entries);
        Assert.assertEquals((String)"Wrong number of resolution report entries", (long)expected, (long)entries.size());
    }

    private void assertResolutionReportEntryDataNotNull(Object data) {
        Assert.assertNotNull((String)"No resolution report entry data", (Object)data);
    }

    private void assertResolutionReportEntryDataNull(Object data) {
        Assert.assertEquals((String)"Unexpected resolution report entry data", null, (Object)data);
    }

    private void assertResolutionReportEntryTypeFilteredByResolverHook(ResolutionReport.Entry.Type type) {
        this.assertResolutionReportEntryType(ResolutionReport.Entry.Type.FILTERED_BY_RESOLVER_HOOK, type);
    }

    private void assertResolutionReportEntryTypeSingletonSelection(ResolutionReport.Entry.Type type) {
        this.assertResolutionReportEntryType(ResolutionReport.Entry.Type.SINGLETON_SELECTION, type);
    }

    private void assertResolutionReportEntryTypeUnresolvedProvider(ResolutionReport.Entry.Type type) {
        this.assertResolutionReportEntryType(ResolutionReport.Entry.Type.UNRESOLVED_PROVIDER, type);
    }

    private void assertResolutionReportEntryDataMissingCapability(Object data, String namespace, String namespaceValue) {
        this.assertResolutionReportEntryDataNotNull(data);
        Assert.assertTrue((String)"Wrong resolution report entry data type", (boolean)(data instanceof Requirement));
        Requirement requirement = (Requirement)data;
        Assert.assertEquals((String)"Wrong requirement namespace", (Object)namespace, (Object)requirement.getNamespace());
        if (namespaceValue == null) {
            return;
        }
        Assert.assertTrue((String)"Wrong requirement namespace value", (boolean)((String)requirement.getDirectives().get("filter")).contains(namespace + "=" + namespaceValue));
    }

    private void assertResolutionReportEntryDataUnresolvedProvider(Object data, Map<Requirement, List<Capability>> expected) {
        this.assertResolutionReportEntryDataNotNull(data);
        Assert.assertTrue((String)"Wrong resolution report entry data type", (boolean)(data instanceof Map));
        Map unresolvedProviders = (Map)data;
        Assert.assertEquals((String)"Wrong number of unresolved providers", (long)expected.size(), (long)unresolvedProviders.size());
        for (Map.Entry<Requirement, List<Capability>> entry : expected.entrySet()) {
            Set actualCapabilities = (Set)unresolvedProviders.get(entry.getKey());
            Assert.assertEquals((String)"Wrong number of capabilities", (long)entry.getValue().size(), (long)actualCapabilities.size());
            for (Capability c : entry.getValue()) {
                Assert.assertTrue((String)"Capability not found", (boolean)actualCapabilities.contains(c));
            }
        }
    }

    private void assertResolutionReportEntryTypeMissingCapability(ResolutionReport.Entry.Type type) {
        this.assertResolutionReportEntryType(ResolutionReport.Entry.Type.MISSING_CAPABILITY, type);
    }

    private void assertResolutionReportEntryType(ResolutionReport.Entry.Type expected, ResolutionReport.Entry.Type actual) {
        Assert.assertEquals((String)"Wrong resolution report entry type", (Object)expected, (Object)actual);
    }
}

