/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.container.dummys;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleDatabase;
import org.osgi.framework.FrameworkListener;

public class DummyModuleDatabase
extends ModuleDatabase {
    private final List<DummyModuleEvent> moduleEvents = new ArrayList<DummyModuleEvent>();
    private final List<DummyContainerEvent> containerEvents = new ArrayList<DummyContainerEvent>();

    public DummyModuleDatabase(ModuleContainerAdaptor adaptor) {
        super(adaptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvent(DummyModuleEvent event) {
        List<DummyModuleEvent> list = this.moduleEvents;
        synchronized (list) {
            this.moduleEvents.add(event);
            this.moduleEvents.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvent(DummyContainerEvent event) {
        List<DummyContainerEvent> list = this.containerEvents;
        synchronized (list) {
            this.containerEvents.add(event);
            this.containerEvents.notifyAll();
        }
    }

    public List<DummyModuleEvent> getModuleEvents() {
        return DummyModuleDatabase.getEvents(this.moduleEvents);
    }

    public List<DummyContainerEvent> getContainerEvents() {
        return DummyModuleDatabase.getEvents(this.containerEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E> List<E> getEvents(List<E> events) {
        List<E> list = events;
        synchronized (list) {
            ArrayList<E> result = new ArrayList<E>(events);
            events.clear();
            return result;
        }
    }

    public List<DummyModuleEvent> getModuleEvents(int expectedNum) {
        return DummyModuleDatabase.getEvents(expectedNum, this.moduleEvents);
    }

    public List<DummyContainerEvent> getContainerEvents(int expectedNum) {
        return DummyModuleDatabase.getEvents(expectedNum, this.containerEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E> List<E> getEvents(int expectedNum, List<E> events) {
        List<E> list = events;
        synchronized (list) {
            long timeout = 5000L;
            while (events.size() < expectedNum && timeout > 0L) {
                long startTime = System.currentTimeMillis();
                try {
                    events.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                timeout -= System.currentTimeMillis() - startTime;
            }
            ArrayList<E> result = new ArrayList<E>(events);
            events.clear();
            return result;
        }
    }

    public static class DummyContainerEvent {
        public final ModuleContainerAdaptor.ContainerEvent type;
        public final Module module;
        public final Throwable error;
        public final FrameworkListener[] listeners;

        public DummyContainerEvent(ModuleContainerAdaptor.ContainerEvent type, Module module, Throwable error, FrameworkListener ... listeners) {
            this.type = type;
            this.module = module;
            this.error = error;
            this.listeners = listeners;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            void that;
            if (!(o instanceof DummyContainerEvent)) {
                return false;
            }
            DummyContainerEvent dummyContainerEvent = (DummyContainerEvent)o;
            return this.type.equals((Object)that.type) && this.module.equals(that.module);
        }

        public String toString() {
            return String.valueOf(this.module) + ": " + String.valueOf(this.type);
        }
    }

    public static class DummyModuleEvent {
        public final Module module;
        public final ModuleContainerAdaptor.ModuleEvent event;
        public final Module.State state;

        public DummyModuleEvent(Module module, ModuleContainerAdaptor.ModuleEvent event, Module.State state) {
            this.module = module;
            this.event = event;
            this.state = state;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            void that;
            if (!(o instanceof DummyModuleEvent)) {
                return false;
            }
            DummyModuleEvent dummyModuleEvent = (DummyModuleEvent)o;
            return this.event.equals((Object)that.event) && this.module.equals(that.module) && this.state.equals((Object)that.state);
        }

        public String toString() {
            return String.valueOf(this.module) + ": " + String.valueOf(this.event) + ": " + String.valueOf(this.state);
        }
    }
}

