/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.debugoptions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.AssertionFailedError;
import org.eclipse.osgi.internal.debug.FrameworkDebugOptions;
import org.eclipse.osgi.internal.debug.FrameworkDebugTraceEntry;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class DebugOptionsTestCase {
    @Rule
    public TestName testName = new TestName();
    DebugOptions debugOptions;
    ServiceReference ref;
    Dictionary props = null;
    TestDebugOptionsListener listener = null;
    ServiceRegistration reg = null;
    private static final String TRACE_ELEMENT_DELIMITER = "|";
    private static final String TRACE_ELEMENT_DELIMITER_ENCODED = "&#124;";
    private static final SimpleDateFormat TRACE_FILE_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String LINE_SEPARATOR;
    private boolean verboseDebug = true;
    private static final String TAB_CHARACTER = "\t";

    static {
        String s = System.lineSeparator();
        LINE_SEPARATOR = s == null ? "\n" : s;
    }

    @Before
    public void setUp() throws Exception {
        this.ref = OSGiTestsActivator.getContext().getServiceReference(DebugOptions.class.getName());
        Assert.assertNotNull((String)"DebugOptions service is not available", (Object)this.ref);
        this.debugOptions = (DebugOptions)OSGiTestsActivator.getContext().getService(this.ref);
        Assert.assertNotNull((String)"DebugOptions service is not available", (Object)this.debugOptions);
        this.props = new Hashtable();
        this.props.put("listener.symbolic.name", this.getName());
        this.listener = new TestDebugOptionsListener();
        this.reg = OSGiTestsActivator.getContext().registerService(DebugOptionsListener.class.getName(), (Object)this.listener, this.props);
    }

    @After
    public void tearDown() throws Exception {
        if (this.debugOptions == null) {
            return;
        }
        this.debugOptions.setDebugEnabled(false);
        this.debugOptions = null;
        OSGiTestsActivator.getContext().ungetService(this.ref);
        if (this.reg != null) {
            this.reg.unregister();
        }
    }

    private String getName() {
        return this.testName.getMethodName();
    }

    @Test
    public void testRegistration01() {
        Assert.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
    }

    @Test
    public void testTracingEntry01() {
        String bundleName = OSGiTestsActivator.getBundle().getSymbolicName();
        String optionPath = "/debug";
        String message = "Test message";
        FrameworkDebugTraceEntry traceEntry = new FrameworkDebugTraceEntry(bundleName, optionPath, message, null);
        String correctClassName = "org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase";
        String correctMethodName = "testTracingEntry01";
        Assert.assertEquals((String)"The class calling the trace API does not match the expected value.", (Object)correctClassName, (Object)traceEntry.getClassName());
        Assert.assertEquals((String)"The method calling the trace API does not match the expected value.", (Object)correctMethodName, (Object)traceEntry.getMethodName());
    }

    @Test
    public void testTracingEntry02() {
        String correctClassName = Runner1.class.getName();
        String correctMethodName = "run";
        FrameworkDebugTraceEntry traceEntry = new Runner1().run();
        Assert.assertEquals((String)"The class calling the trace API does not match the expected value.", (Object)correctClassName, (Object)traceEntry.getClassName());
        Assert.assertEquals((String)"The method calling the trace API does not match the expected value.", (Object)correctMethodName, (Object)traceEntry.getMethodName());
    }

    @Test
    public void testDyanmicEnablement01() {
        if (this.debugOptions.isDebugEnabled()) {
            return;
        }
        this.debugOptions.setDebugEnabled(true);
        Assert.assertTrue((String)"Debug is not enabled", (boolean)this.debugOptions.isDebugEnabled());
        this.listener.clear();
        HashMap<CallSite, String> checkValues = new HashMap<CallSite, String>();
        checkValues.put((CallSite)((Object)(this.getName() + "/debug")), "true");
        this.listener.setCheckValues(checkValues);
        this.debugOptions.setOption(this.getName() + "/debug", "true");
        Assert.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
        Assert.assertNull((String)("Found bad value: " + this.listener.getIncorrectValue()), (Object)this.listener.getIncorrectValue());
    }

    @Test
    public void testDyanmicEnablement02() {
        if (this.debugOptions.isDebugEnabled()) {
            return;
        }
        this.debugOptions.setDebugEnabled(true);
        Assert.assertTrue((String)"Debug is not enabled", (boolean)this.debugOptions.isDebugEnabled());
        this.listener.clear();
        HashMap<CallSite, String> checkValues = new HashMap<CallSite, String>();
        checkValues.put((CallSite)((Object)(this.getName() + "/debug")), "false");
        this.listener.setCheckValues(checkValues);
        this.debugOptions.setOption(this.getName() + "/debug", "true");
        Assert.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
        Assert.assertNotNull((String)("Should find bad value: " + this.listener.getIncorrectValue()), (Object)this.listener.getIncorrectValue());
    }

    @Test
    public void testDyanmicEnablement03() {
        this.listener.clear();
        if (this.debugOptions.isDebugEnabled()) {
            return;
        }
        TestDebugOptionsListener anotherListener = new TestDebugOptionsListener();
        Hashtable<String, String> anotherProps = new Hashtable<String, String>();
        ((Dictionary)anotherProps).put("listener.symbolic.name", "anotherListener");
        ServiceRegistration anotherReg = OSGiTestsActivator.getContext().registerService(DebugOptionsListener.class.getName(), (Object)anotherListener, anotherProps);
        Assert.assertTrue((String)"Not called", (boolean)anotherListener.gotCalled());
        this.debugOptions.setDebugEnabled(true);
        Assert.assertTrue((String)"Debug is not enabled", (boolean)this.debugOptions.isDebugEnabled());
        this.listener.clear();
        anotherListener.clear();
        HashMap<CallSite, String> checkValues = new HashMap<CallSite, String>();
        checkValues.put((CallSite)((Object)(this.getName() + "/debug")), "true");
        this.listener.setCheckValues(checkValues);
        this.debugOptions.setOption(this.getName() + "/debug", "true");
        Assert.assertFalse((String)"Should not call wrong listener", (boolean)anotherListener.gotCalled());
        Assert.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
        Assert.assertNull((String)("Found bad value: " + this.listener.getIncorrectValue()), (Object)this.listener.getIncorrectValue());
        this.listener.clear();
        anotherListener.clear();
        this.debugOptions.setOption("anotherListener/test", "blah");
        Assert.assertFalse((String)"Listener should not have been called", (boolean)this.listener.gotCalled());
        Assert.assertTrue((String)"Another listener should have been called", (boolean)anotherListener.gotCalled());
        this.listener.clear();
        anotherListener.clear();
        ((Dictionary)anotherProps).put("listener.symbolic.name", this.getName());
        anotherReg.setProperties(anotherProps);
        this.debugOptions.setOption(this.getName() + "/debug", "false");
        Assert.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
        Assert.assertTrue((String)"Another listener did not get called", (boolean)anotherListener.gotCalled());
        anotherReg.unregister();
    }

    @Test
    public void testDyanmicEnablement04() {
        if (this.debugOptions.isDebugEnabled()) {
            return;
        }
        this.debugOptions.setDebugEnabled(true);
        this.listener.clear();
        Assert.assertTrue((String)"Debug is not enabled", (boolean)this.debugOptions.isDebugEnabled());
        HashMap<CallSite, String> checkValues = new HashMap<CallSite, String>();
        checkValues.put((CallSite)((Object)(this.getName() + "/debug")), "true");
        this.listener.setCheckValues(checkValues);
        this.debugOptions.setOption(this.getName() + "/debug", "true");
        Assert.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
        Assert.assertNull((String)("Found bad value: " + this.listener.getIncorrectValue()), (Object)this.listener.getIncorrectValue());
        this.listener.clear();
        checkValues.put((CallSite)((Object)(this.getName() + "/debug")), (String)null);
        this.listener.setCheckValues(checkValues);
        this.debugOptions.setDebugEnabled(false);
        Assert.assertFalse((String)"Debug is enabled", (boolean)this.debugOptions.isDebugEnabled());
        Assert.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
        Assert.assertNull((String)("Found bad value: " + this.listener.getIncorrectValue()), (Object)this.listener.getIncorrectValue());
        this.listener.clear();
        checkValues.put((CallSite)((Object)(this.getName() + "/debug")), "true");
        this.listener.setCheckValues(checkValues);
        this.debugOptions.setDebugEnabled(true);
        Assert.assertTrue((String)"Debug is not enabled", (boolean)this.debugOptions.isDebugEnabled());
        Assert.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
        Assert.assertNull((String)("Found bad value: " + this.listener.getIncorrectValue()), (Object)this.listener.getIncorrectValue());
    }

    @Test
    public void testBatchSetOptionsWhenEnabled() {
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
        }
        String key1 = this.getName() + "/debug/disableCheck1";
        String key2 = this.getName() + "/debug/disableCheck2";
        String key3 = this.getName() + "/debug/disableCheck3";
        HashMap<CallSite, String> newOptions = new HashMap<CallSite, String>();
        newOptions.put((CallSite)((Object)key1), "ok1");
        newOptions.put((CallSite)((Object)key2), "ok2");
        newOptions.put((CallSite)((Object)key3), "ok3");
        this.listener.clear();
        this.debugOptions.setOptions(newOptions);
        Assert.assertTrue((String)"Listener did not get called when setting batch options when tracing is enabled", (boolean)this.listener.gotCalled());
        Map currentOptions = this.debugOptions.getOptions();
        Assert.assertNotSame((String)"The Map object set is the exact same Map object returned", newOptions, (Object)currentOptions);
        Assert.assertEquals((String)"The amount of options retrieved is not correct", (long)newOptions.size(), (long)currentOptions.size());
        String actualValue = (String)currentOptions.get(key1);
        Assert.assertEquals((String)"The original option for key1 does not match the retrieved option when tracing is enabled", (Object)"ok1", (Object)actualValue);
        actualValue = (String)currentOptions.get(key2);
        Assert.assertEquals((String)"The original option for key1 does not match the retrieved option when tracing is enabled", (Object)"ok2", (Object)actualValue);
        actualValue = (String)currentOptions.get(key3);
        Assert.assertEquals((String)"The original option for key1 does not match the retrieved option when tracing is enabled", (Object)"ok3", (Object)actualValue);
        String key4 = this.getName() + "/debug/disableCheck4";
        String key5 = this.getName() + "/debug/disableCheck5";
        String key6 = this.getName() + "/debug/disableCheck6";
        HashMap<CallSite, String> newOptions2 = new HashMap<CallSite, String>();
        newOptions2.put((CallSite)((Object)key4), "ok4");
        newOptions2.put((CallSite)((Object)key5), "ok5");
        newOptions2.put((CallSite)((Object)key6), "ok6");
        this.listener.clear();
        this.debugOptions.setOptions(newOptions2);
        Assert.assertTrue((String)"Listener did not get called when setting batch options when tracing is enabled", (boolean)this.listener.gotCalled());
        Map currentOptions2 = this.debugOptions.getOptions();
        Assert.assertNotSame((String)"The Map object set is the exact same Map object returned", newOptions, (Object)currentOptions2);
        Assert.assertEquals((String)"The amount of options retrieved is not correct", (long)newOptions.size(), (long)currentOptions2.size());
        actualValue = (String)currentOptions2.get(key1);
        Assert.assertNull((String)"The original option for key1 is in the returned options (it should not be there)", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key2);
        Assert.assertNull((String)"The original option for key2 is in the returned options (it should not be there)", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key3);
        Assert.assertNull((String)"The original option for key3 is in the returned options (it should not be there)", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key4);
        Assert.assertEquals((String)"The new option for key4 does not match the retrieved option when tracing is enabled", (Object)"ok4", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key5);
        Assert.assertEquals((String)"The new option for key5 does not match the retrieved option when tracing is enabled", (Object)"ok5", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key6);
        Assert.assertEquals((String)"The new option for key6 does not match the retrieved option when tracing is enabled", (Object)"ok6", (Object)actualValue);
    }

    @Test
    public void testSetNullOptions() {
        boolean exceptionThrown = false;
        try {
            this.debugOptions.setOptions(null);
        }
        catch (Exception ex) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"An exception was not thrown when calling setOptions() with a null parameter", (boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            this.debugOptions.setOption("key", null);
        }
        catch (Exception ex) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"An exception was not thrown when calling setOption() with a null value", (boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            this.debugOptions.setOption(null, "value");
        }
        catch (Exception ex) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"An exception was not thrown when calling setOption() with a null key", (boolean)exceptionThrown);
    }

    @Test
    public void testBatchSetOptionsWhenDisabled() {
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
        }
        String key1 = this.getName() + "/debug/disableCheck1";
        String key2 = this.getName() + "/debug/disableCheck2";
        String key3 = this.getName() + "/debug/disableCheck3";
        HashMap<CallSite, String> newOptions = new HashMap<CallSite, String>();
        newOptions.put((CallSite)((Object)key1), "ok1");
        newOptions.put((CallSite)((Object)key2), "ok2");
        newOptions.put((CallSite)((Object)key3), "ok3");
        this.listener.clear();
        this.debugOptions.setOptions(newOptions);
        Assert.assertTrue((String)"Listener did not get called when setting batch options when tracing is enabled", (boolean)this.listener.gotCalled());
        this.debugOptions.setDebugEnabled(false);
        Map currentOptions = this.debugOptions.getOptions();
        Assert.assertNotSame((String)"The Map object retrieved is the exact same Map object returned when tracing is disabled.", newOptions, (Object)currentOptions);
        Assert.assertEquals((String)"The amount of options retrieved is not the same after tracing is disabled", (long)newOptions.size(), (long)currentOptions.size());
        String actualValue = (String)currentOptions.get(key1);
        Assert.assertNotNull((String)"The value for key1 is null", (Object)actualValue);
        Assert.assertEquals((String)"The original option for key1 does not match the retrieved option when tracing is disabled", (Object)"ok1", (Object)actualValue);
        actualValue = (String)currentOptions.get(key2);
        Assert.assertNotNull((String)"The value for key2 is null", (Object)actualValue);
        Assert.assertEquals((String)"The original option for key2 does not match the retrieved option when tracing is disabled", (Object)"ok2", (Object)actualValue);
        actualValue = (String)currentOptions.get(key3);
        Assert.assertNotNull((String)"The value for key3 is null", (Object)actualValue);
        Assert.assertEquals((String)"The original option for key3 does not match the retrieved option when tracing is disabled", (Object)"ok3", (Object)actualValue);
        String key4 = this.getName() + "/debug/disableCheck4";
        String key5 = this.getName() + "/debug/disableCheck5";
        String key6 = this.getName() + "/debug/disableCheck6";
        HashMap<CallSite, String> newOptions2 = new HashMap<CallSite, String>();
        newOptions2.put((CallSite)((Object)key4), "ok4");
        newOptions2.put((CallSite)((Object)key5), "ok5");
        newOptions2.put((CallSite)((Object)key6), "ok6");
        this.listener.clear();
        this.debugOptions.setOptions(newOptions2);
        Assert.assertFalse((String)"Listener got called when settings batch options with tracing disabled", (boolean)this.listener.gotCalled());
        Map currentOptions2 = this.debugOptions.getOptions();
        Assert.assertNotSame((String)"The Map object set is the exact same Map object returned", newOptions, (Object)currentOptions2);
        Assert.assertEquals((String)"The amount of options retrieved is not correct", (long)newOptions.size(), (long)currentOptions2.size());
        actualValue = (String)currentOptions2.get(key1);
        Assert.assertNull((String)"The original option for key1 is in the returned options (it should not be there)", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key2);
        Assert.assertNull((String)"The original option for key2 is in the returned options (it should not be there)", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key3);
        Assert.assertNull((String)"The original option for key3 is in the returned options (it should not be there)", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key4);
        Assert.assertEquals((String)"The new option for key4 does not match the retrieved option when tracing is disabled", (Object)"ok4", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key5);
        Assert.assertEquals((String)"The new option for key5 does not match the retrieved option when tracing is disabled", (Object)"ok5", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key6);
        Assert.assertEquals((String)"The new option for key6 does not match the retrieved option when tracing is disabled", (Object)"ok6", (Object)actualValue);
    }

    @Test
    public void testSetOptionsWhenDisabled() {
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
        }
        String testKey = this.getName() + "/debug/disableCheck";
        this.debugOptions.setOption(testKey, "ok");
        String actualValue = this.debugOptions.getOption(testKey, "not ok");
        Assert.assertEquals((String)("The correct option value was not returned from the debug option: " + testKey), (Object)"ok", (Object)actualValue);
        this.debugOptions.setDebugEnabled(false);
        actualValue = this.debugOptions.getOption(testKey, "not ok");
        Assert.assertEquals((String)"The 'default' value supplied was not returned when tracing is disabled.", (Object)"not ok", (Object)actualValue);
        this.debugOptions.setOption(testKey, "ok");
        actualValue = this.debugOptions.getOption(testKey, "not ok");
        Assert.assertEquals((String)"The 'default' value supplied was not returned when tracing is disabled.", (Object)"not ok", (Object)actualValue);
        this.debugOptions.removeOption(testKey);
        this.debugOptions.setDebugEnabled(true);
        actualValue = this.debugOptions.getOption(testKey, "not ok");
        Assert.assertEquals((String)"The value after re-enabling tracing is invalid.", (Object)"ok", (Object)actualValue);
    }

    @Test
    public void testStringValues() {
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
        }
        String testKey = this.getName() + "/debug/stringValue";
        this.debugOptions.setOption(testKey, "test");
        String actualValue = this.debugOptions.getOption(testKey, "default");
        Assert.assertEquals((String)("The correct option value was not returned from the debug option: " + testKey), (Object)"test", (Object)actualValue);
        this.debugOptions.removeOption(testKey);
        actualValue = this.debugOptions.getOption(testKey, "default");
        Assert.assertEquals((String)"The 'default' value supplied was not returned when the key does not exist in the DebugOptions.", (Object)"default", (Object)actualValue);
    }

    @Test
    public void testIntegerValues() {
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
        }
        String testKey = this.getName() + "/debug/intValue";
        this.debugOptions.setOption(testKey, "42");
        int actualValue = this.debugOptions.getIntegerOption(testKey, 0);
        Assert.assertEquals((String)("The correct option value was not returned from the debug option: " + testKey), (long)42L, (long)actualValue);
        this.debugOptions.setOption(testKey, "test");
        actualValue = this.debugOptions.getIntegerOption(testKey, 0);
        Assert.assertEquals((String)"The 'default' value supplied was not returned when a NumberFormatException occurs.", (long)0L, (long)actualValue);
        this.debugOptions.removeOption(testKey);
        actualValue = this.debugOptions.getIntegerOption(testKey, 0);
        Assert.assertEquals((String)"The 'default' value supplied was not returned when the key does not exist in the DebugOptions.", (long)0L, (long)actualValue);
    }

    @Test
    public void testBooleanValues() {
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
        }
        String testKey = this.getName() + "/debug";
        boolean testValue = this.debugOptions.getBooleanOption(testKey, false);
        Assert.assertFalse((String)(testKey + " is true"), (boolean)testValue);
        this.debugOptions.setOption(testKey, "false");
        testValue = this.debugOptions.getBooleanOption(testKey, true);
        Assert.assertFalse((String)(testKey + " is true"), (boolean)testValue);
        this.debugOptions.setOption(testKey, "true");
        testValue = this.debugOptions.getBooleanOption(testKey, false);
        Assert.assertTrue((String)(testKey + " is false"), (boolean)testValue);
        testValue = this.debugOptions.getBooleanOption(testKey, true);
        Assert.assertTrue((String)(testKey + " is false"), (boolean)testValue);
    }

    private TestDebugTrace createDebugTrace(File traceFile) {
        TestDebugTrace debugTrace = null;
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
            Assert.assertTrue((String)"Debug is not enabled", (boolean)this.debugOptions.isDebugEnabled());
        }
        this.debugOptions.setOption(this.getName() + "/debug", "true");
        this.debugOptions.setFile(traceFile);
        DebugTrace wrapped = this.debugOptions.newDebugTrace(this.getName(), TestDebugTrace.class);
        debugTrace = new TestDebugTrace(wrapped);
        return debugTrace;
    }

    @Test
    public void testVerboseDebugging() throws IOException {
        FrameworkDebugOptions fwDebugOptions = (FrameworkDebugOptions)this.debugOptions;
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
        }
        File traceFile = OSGiTestsActivator.getContext().getDataFile(this.getName() + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        String exceptionMessage1 = "An error 1";
        try {
            fwDebugOptions.setVerbose(false);
            debugTrace.trace("/debug", "testing 1", new Exception("An error 1"));
            fwDebugOptions.setVerbose(true);
            debugTrace.trace("/debug", "testing 2");
            fwDebugOptions.setVerbose(false);
            debugTrace.trace("/debug", "testing 3");
            debugTrace.traceEntry("/debug");
            debugTrace.traceEntry("/debug", "arg");
            debugTrace.traceEntry("/debug", new String[]{"arg1", "arg2"});
            debugTrace.traceExit("/debug");
            debugTrace.traceExit("/debug", "returnValue");
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            this.failWithInvalidTrace("DebugTrace.trace(option, message)", invalidEx);
        }
        Assert.assertEquals((String)"Wrong number of trace entries", (long)8L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[0].getThreadName());
        Assert.assertNull((String)"A bundle was found when it should be null", (Object)traceOutput[0].getBundleSymbolicName());
        Assert.assertNull((String)"A class name was found when it should be null", (Object)traceOutput[0].getClassName());
        Assert.assertNull((String)"A method name was found when it should be null", (Object)traceOutput[0].getMethodName());
        Assert.assertTrue((String)"A line number other than -1 was read in", (traceOutput[0].getLineNumber() == -1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"trace message is incorrect", (Object)"testing 1", (Object)traceOutput[0].getMessage());
        StringBuilder expectedThrowableText1 = new StringBuilder("java.lang.Exception: ");
        expectedThrowableText1.append("An error 1");
        expectedThrowableText1.append(LINE_SEPARATOR);
        expectedThrowableText1.append(TAB_CHARACTER);
        expectedThrowableText1.append("at org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase.testVerboseDebugging(DebugOptionsTestCase.java:");
        if (!traceOutput[0].getThrowableText().startsWith(expectedThrowableText1.toString())) {
            StringBuilder errorMessage = new StringBuilder("The expected throwable text does not start with the actual throwable text.");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("Expected");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("--------");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(expectedThrowableText1.toString());
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("Actual");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("--------");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(traceOutput[0].getThrowableText());
            Assert.fail((String)errorMessage.toString());
        }
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[1].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[1].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[1].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[1].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testVerboseDebugging", (Object)traceOutput[1].getMethodName());
        Assert.assertEquals((String)"trace message is incorrect", (Object)"testing 2", (Object)traceOutput[1].getMessage());
        Assert.assertNull((String)"The throwable text was found when it should be null", (Object)traceOutput[1].getThrowableText());
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[2].getThreadName());
        Assert.assertNull((String)"A bundle was found when it should be null", (Object)traceOutput[2].getBundleSymbolicName());
        Assert.assertNull((String)"A class name was found when it should be null", (Object)traceOutput[2].getClassName());
        Assert.assertNull((String)"A method name was found when it should be null", (Object)traceOutput[2].getMethodName());
        Assert.assertTrue((String)"A line number other than -1 was read in", (traceOutput[2].getLineNumber() == -1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"trace message is incorrect", (Object)"testing 3", (Object)traceOutput[2].getMessage());
        Assert.assertNull((String)"The throwable text was found when it should be null", (Object)traceOutput[2].getThrowableText());
        Assert.assertEquals((String)"trace message is incorrect", (Object)"Entering method org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase#testVerboseDebugging with no parameters", (Object)traceOutput[3].getMessage());
        Assert.assertEquals((String)"trace message is incorrect", (Object)"Entering method org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase#testVerboseDebugging with parameters: (arg)", (Object)traceOutput[4].getMessage());
        Assert.assertEquals((String)"trace message is incorrect", (Object)"Entering method org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase#testVerboseDebugging with parameters: (arg1 arg2)", (Object)traceOutput[5].getMessage());
        Assert.assertEquals((String)"trace message is incorrect", (Object)"Exiting method org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase#testVerboseDebugging with a void return", (Object)traceOutput[6].getMessage());
        Assert.assertEquals((String)"trace message is incorrect", (Object)"Exiting method org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase#testVerboseDebugging with result: returnValue", (Object)traceOutput[7].getMessage());
        traceFile.delete();
        fwDebugOptions.setVerbose(true);
    }

    @Test
    public void testTraceFile01() throws IOException {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(this.getName() + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.trace("/debug", "testing 1");
            debugTrace.trace("/notset", "testing 2");
            debugTrace.trace("/debug", "testing 3");
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            this.failWithInvalidTrace("DebugTrace.trace(option, message)", invalidEx);
        }
        Assert.assertEquals((String)"Wrong number of trace entries", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[0].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[0].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[0].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[0].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile01", (Object)traceOutput[0].getMethodName());
        Assert.assertEquals((String)"trace message is incorrect", (Object)"testing 1", (Object)traceOutput[0].getMessage());
        Assert.assertNull((String)"throwable should be null", (Object)traceOutput[0].getThrowableText());
        Assert.assertEquals((String)"Wrong number of trace entries for trace without an exception", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[1].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[1].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[1].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[1].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile01", (Object)traceOutput[1].getMethodName());
        Assert.assertEquals((String)"trace message is incorrect", (Object)"testing 3", (Object)traceOutput[1].getMessage());
        Assert.assertNull((String)"throwable should be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    @Test
    public void testTraceFile02() throws IOException {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(this.getName() + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        String exceptionMessage1 = "An error 1";
        String exceptionMessage2 = "An error 2";
        String exceptionMessage3 = "An error 3";
        try {
            debugTrace.trace("/debug", "testing 1", new Exception("An error 1"));
            debugTrace.trace("/notset", "testing 2", new Exception("An error 2"));
            debugTrace.trace("/debug", "testing 3", new Exception("An error 3"));
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            this.failWithInvalidTrace("DebugTrace.trace(option, message, Throwable)", invalidEx);
        }
        StringBuilder expectedThrowableText1 = new StringBuilder("java.lang.Exception: ");
        expectedThrowableText1.append("An error 1");
        expectedThrowableText1.append(LINE_SEPARATOR);
        expectedThrowableText1.append(TAB_CHARACTER);
        expectedThrowableText1.append("at org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase.testTraceFile02(DebugOptionsTestCase.java:");
        Assert.assertEquals((String)"Wrong number of trace entries", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[0].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[0].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[0].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[0].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile02", (Object)traceOutput[0].getMethodName());
        Assert.assertEquals((String)"trace message is incorrect", (Object)"testing 1", (Object)traceOutput[0].getMessage());
        Assert.assertNotNull((String)"throwable text should not be null", (Object)traceOutput[0].getThrowableText());
        if (!traceOutput[0].getThrowableText().startsWith(expectedThrowableText1.toString())) {
            StringBuilder errorMessage = new StringBuilder("The expected throwable text does not start with the actual throwable text.");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("Expected");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("--------");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(expectedThrowableText1.toString());
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("Actual");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("--------");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(traceOutput[0].getThrowableText());
            Assert.fail((String)errorMessage.toString());
        }
        Assert.assertNotNull((String)"throwable should not be null", (Object)traceOutput[0].getThrowableText());
        Assert.assertEquals((String)"Wrong number of trace entries for trace without an exception", (long)2L, (long)traceOutput.length);
        StringBuilder expectedThrowableText2 = new StringBuilder("java.lang.Exception: ");
        expectedThrowableText2.append("An error 3");
        expectedThrowableText2.append(LINE_SEPARATOR);
        expectedThrowableText2.append(TAB_CHARACTER);
        expectedThrowableText2.append("at org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase.testTraceFile02(DebugOptionsTestCase.java:");
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[1].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[1].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[1].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[1].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile02", (Object)traceOutput[1].getMethodName());
        Assert.assertEquals((String)"trace message is incorrect", (Object)"testing 3", (Object)traceOutput[1].getMessage());
        Assert.assertNotNull((String)"throwable text should not be null", (Object)traceOutput[1].getThrowableText());
        if (!traceOutput[1].getThrowableText().startsWith(expectedThrowableText2.toString())) {
            StringBuilder errorMessage = new StringBuilder("The expected throwable text does not start with the actual throwable text.");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("Expected");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("--------");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(expectedThrowableText2.toString());
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("Actual");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("--------");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(traceOutput[1].getThrowableText());
            Assert.fail((String)errorMessage.toString());
        }
        Assert.assertNotNull((String)"throwable should not be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    @Test
    public void testTraceFile03() throws IOException {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(this.getName() + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.traceDumpStack("/debug");
            debugTrace.traceDumpStack("/notset");
            debugTrace.traceDumpStack("/debug");
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            this.failWithInvalidTrace("DebugTrace.traceDumpStack(option)", invalidEx);
        }
        Assert.assertEquals((String)"Wrong number of trace entries", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[0].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[0].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[0].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[0].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile03", (Object)traceOutput[0].getMethodName());
        Assert.assertTrue((String)"Trace message is not a stack dump", (boolean)traceOutput[0].getMessage().startsWith("Thread Stack dump: "));
        Assert.assertNull((String)"throwable should be null", (Object)traceOutput[0].getThrowableText());
        Assert.assertEquals((String)"Wrong number of trace entries for trace without an exception", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[1].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[1].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[1].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[1].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile03", (Object)traceOutput[1].getMethodName());
        Assert.assertTrue((String)"Trace message is not a stack dump", (boolean)traceOutput[1].getMessage().startsWith("Thread Stack dump: "));
        Assert.assertNull((String)"throwable should be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    @Test
    public void testTraceFile04() throws IOException {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(this.getName() + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.traceEntry("/debug");
            debugTrace.traceEntry("/notset");
            debugTrace.traceEntry("/debug");
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            this.failWithInvalidTrace("DebugTrace.traceEntry(option)", invalidEx);
        }
        Assert.assertEquals((String)"Wrong number of trace entries", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[0].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[0].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[0].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[0].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile04", (Object)traceOutput[0].getMethodName());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Entering method with no parameters", (Object)traceOutput[0].getMessage());
        Assert.assertNull((String)"throwable should be null", (Object)traceOutput[0].getThrowableText());
        Assert.assertEquals((String)"Wrong number of trace entries for trace without an exception", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[1].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[1].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[1].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[1].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile04", (Object)traceOutput[1].getMethodName());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Entering method with no parameters", (Object)traceOutput[1].getMessage());
        Assert.assertNull((String)"throwable should be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    @Test
    public void testTraceFile05() throws IOException {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(this.getName() + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.traceEntry("/debug", new String("arg1"));
            debugTrace.traceEntry("/notset", new String("arg2"));
            debugTrace.traceEntry("/debug", new String("arg3"));
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            this.failWithInvalidTrace("DebugTrace.traceEntry(option, methodArgument)", invalidEx);
        }
        Assert.assertEquals((String)"Wrong number of trace entries", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[0].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[0].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[0].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[0].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile05", (Object)traceOutput[0].getMethodName());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Entering method with parameters: (arg1)", (Object)traceOutput[0].getMessage());
        Assert.assertNull((String)"throwable should be null", (Object)traceOutput[0].getThrowableText());
        Assert.assertEquals((String)"Wrong number of trace entries for trace without an exception", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[1].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[1].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[1].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[1].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile05", (Object)traceOutput[1].getMethodName());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Entering method with parameters: (arg3)", (Object)traceOutput[1].getMessage());
        Assert.assertNull((String)"throwable should be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    @Test
    public void testTraceFile06() throws IOException {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(this.getName() + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.traceEntry("/debug", new String[]{"arg1", "arg2"});
            debugTrace.traceEntry("/notset", new String[]{"arg3", "arg4"});
            debugTrace.traceEntry("/debug", new String[]{"arg5", "arg6"});
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            this.failWithInvalidTrace("DebugTrace.traceEntry(option, methodArgument[])", invalidEx);
        }
        Assert.assertEquals((String)"Wrong number of trace entries", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[0].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[0].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[0].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[0].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile06", (Object)traceOutput[0].getMethodName());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Entering method with parameters: (arg1 arg2)", (Object)traceOutput[0].getMessage());
        Assert.assertNull((String)"throwable should be null", (Object)traceOutput[0].getThrowableText());
        Assert.assertEquals((String)"Wrong number of trace entries for trace without an exception", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[1].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[1].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[1].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[1].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile06", (Object)traceOutput[1].getMethodName());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Entering method with parameters: (arg5 arg6)", (Object)traceOutput[1].getMessage());
        Assert.assertNull((String)"throwable should be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    @Test
    public void testEntryExitWithBracesInArgs() throws InvalidTraceEntry, IOException {
        FrameworkDebugOptions fwDebugOptions = (FrameworkDebugOptions)this.debugOptions;
        File traceFile = OSGiTestsActivator.getContext().getDataFile(this.getName() + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        debugTrace.traceEntry("/debug", new String[]{"test0 {data: stuff;}"});
        debugTrace.traceEntry("/debug", "test1 {data: stuff;}");
        debugTrace.traceExit("/debug", "test2 {data: stuff;}");
        debugTrace.traceEntry("/notset", new String[]{"test-unexpected {data: stuff;}"});
        debugTrace.traceEntry("/notset", "test-unexpected {data: stuff;}");
        debugTrace.traceExit("/notset", "test-unexpected {data: stuff;}");
        fwDebugOptions.setVerbose(false);
        debugTrace.traceEntry("/debug", new String[]{"test3 {data: stuff;}"});
        debugTrace.traceEntry("/debug", "test4 {data: stuff;}");
        debugTrace.traceExit("/debug", "test5 {data: stuff;}");
        traceOutput = this.readTraceFile(traceFile);
        Assert.assertEquals((String)"Wrong number of trace entries", (long)6L, (long)traceOutput.length);
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Entering method with parameters: (test0 {data: stuff;})", (Object)traceOutput[0].getMessage());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Entering method with parameters: (test1 {data: stuff;})", (Object)traceOutput[1].getMessage());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Exiting method with result: test2 {data: stuff;}", (Object)traceOutput[2].getMessage());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Entering method org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase#testEntryExitWithBracesInArgs with parameters: (test3 {data: stuff;})", (Object)traceOutput[3].getMessage());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Entering method org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase#testEntryExitWithBracesInArgs with parameters: (test4 {data: stuff;})", (Object)traceOutput[4].getMessage());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Exiting method org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase#testEntryExitWithBracesInArgs with result: test5 {data: stuff;}", (Object)traceOutput[5].getMessage());
        fwDebugOptions.setVerbose(true);
    }

    @Test
    public void testTraceFile07() throws IOException {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(this.getName() + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.traceExit("/debug");
            debugTrace.traceExit("/notset");
            debugTrace.traceExit("/debug");
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            this.failWithInvalidTrace("DebugTrace.traceExit(option)", invalidEx);
        }
        Assert.assertEquals((String)"Wrong number of trace entries", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[0].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[0].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[0].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[0].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile07", (Object)traceOutput[0].getMethodName());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Exiting method with a void return", (Object)traceOutput[0].getMessage());
        Assert.assertNull((String)"throwable should be null", (Object)traceOutput[0].getThrowableText());
        Assert.assertEquals((String)"Wrong number of trace entries for trace without an exception", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[1].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[1].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[1].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[1].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile07", (Object)traceOutput[1].getMethodName());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Exiting method with a void return", (Object)traceOutput[1].getMessage());
        Assert.assertNull((String)"throwable should be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    @Test
    public void testTraceFile08() throws IOException {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(this.getName() + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.traceExit("/debug", new String("returnValue1"));
            debugTrace.traceExit("/notset", new String("returnValue2"));
            debugTrace.traceExit("/debug", new String("returnValue3"));
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            this.failWithInvalidTrace("DebugTrace.traceExit(option, result)", invalidEx);
        }
        Assert.assertEquals((String)"Wrong number of trace entries", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[0].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[0].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[0].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[0].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile08", (Object)traceOutput[0].getMethodName());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Exiting method with result: returnValue1", (Object)traceOutput[0].getMessage());
        Assert.assertNull((String)"throwable should be null", (Object)traceOutput[0].getThrowableText());
        Assert.assertEquals((String)"Wrong number of trace entries for trace without an exception", (long)2L, (long)traceOutput.length);
        Assert.assertEquals((String)"Thread name is incorrect", (Object)Thread.currentThread().getName(), (Object)traceOutput[1].getThreadName());
        Assert.assertEquals((String)"Bundle name is incorrect", (Object)this.getName(), (Object)traceOutput[1].getBundleSymbolicName());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)traceOutput[1].getOptionPath());
        Assert.assertEquals((String)"class name value is incorrect", (Object)DebugOptionsTestCase.class.getName(), (Object)traceOutput[1].getClassName());
        Assert.assertEquals((String)"method name value is incorrect", (Object)"testTraceFile08", (Object)traceOutput[1].getMethodName());
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Exiting method with result: returnValue3", (Object)traceOutput[1].getMessage());
        Assert.assertNull((String)"throwable should be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    @Test
    public void testTraceFile09() throws IOException {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(this.getName() + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        this.debugOptions.setOption(this.getName() + "/debug|path", "true");
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.trace("/debug|path", "A message with a | character.");
            debugTrace.trace("/debug|path", "|A message with | multiple || characters.|");
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            this.failWithInvalidTrace("DebugTrace.trace(option, message)", invalidEx);
        }
        Assert.assertEquals((String)"Wrong number of entries", (long)2L, (long)traceOutput.length);
        String optionPath = DebugOptionsTestCase.decodeString(traceOutput[0].getOptionPath());
        String message = DebugOptionsTestCase.decodeString(traceOutput[0].getMessage());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug|path", (Object)optionPath);
        Assert.assertEquals((String)"Trace message is not correct", (Object)"A message with a | character.", (Object)message);
        optionPath = DebugOptionsTestCase.decodeString(traceOutput[1].getOptionPath());
        message = DebugOptionsTestCase.decodeString(traceOutput[1].getMessage());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug|path", (Object)optionPath);
        Assert.assertEquals((String)"Trace message is not correct", (Object)"|A message with | multiple || characters.|", (Object)message);
        traceFile.delete();
    }

    @Test
    public void testTraceSystemOut() throws IOException {
        PrintStream old = System.out;
        File traceFile = OSGiTestsActivator.getContext().getDataFile(this.getName() + ".trace");
        final AtomicReference<Boolean> closed = new AtomicReference<Boolean>(Boolean.FALSE);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FilterOutputStream out = new FilterOutputStream(new FileOutputStream(traceFile)){

            @Override
            public void close() throws IOException {
                super.close();
                closed.set(Boolean.TRUE);
            }
        };){
            System.setOut(new PrintStream(out));
            try {
                TestDebugTrace debugTrace = this.createDebugTrace(new File("/does/not/exist/trace.out"));
                this.debugOptions.setOption(this.getName() + "/debug", "true");
                debugTrace.trace("/debug", "A message to System.out.");
                debugTrace.trace("/debug", "Another message.");
                Assert.assertFalse((String)"Closed System.out.", (boolean)closed.get());
            }
            finally {
                System.setOut(old);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        TraceEntry[] traceOutput = null;
        try {
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry e) {
            this.failWithInvalidTrace("DebugTrace.trace(option, message)", e);
        }
        Assert.assertEquals((String)"Wrong number of entries", (long)2L, (long)traceOutput.length);
        String optionPath = DebugOptionsTestCase.decodeString(traceOutput[0].getOptionPath());
        String message = DebugOptionsTestCase.decodeString(traceOutput[0].getMessage());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)optionPath);
        Assert.assertEquals((String)"Trace message is not correct", (Object)"A message to System.out.", (Object)message);
        optionPath = DebugOptionsTestCase.decodeString(traceOutput[1].getOptionPath());
        message = DebugOptionsTestCase.decodeString(traceOutput[1].getMessage());
        Assert.assertEquals((String)"option-path value is incorrect", (Object)"/debug", (Object)optionPath);
        Assert.assertEquals((String)"Trace message is not correct", (Object)"Another message.", (Object)message);
        traceFile.delete();
    }

    private static String decodeString(String inputString) {
        if (inputString == null || inputString.indexOf(TRACE_ELEMENT_DELIMITER_ENCODED) < 0) {
            return inputString;
        }
        StringBuilder tempBuffer = new StringBuilder(inputString);
        int currentIndex = tempBuffer.indexOf(TRACE_ELEMENT_DELIMITER_ENCODED);
        while (currentIndex >= 0) {
            tempBuffer.replace(currentIndex, currentIndex + TRACE_ELEMENT_DELIMITER_ENCODED.length(), TRACE_ELEMENT_DELIMITER);
            currentIndex = tempBuffer.indexOf(TRACE_ELEMENT_DELIMITER_ENCODED);
        }
        return tempBuffer.toString();
    }

    private TraceEntry[] readTraceFile(File traceFile) throws InvalidTraceEntry, IOException {
        BufferedReader traceReader = null;
        ArrayList<TraceEntry> traceEntries = new ArrayList<TraceEntry>();
        this.verboseDebug = true;
        try {
            traceReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(traceFile), StandardCharsets.UTF_8));
            TraceEntry entry = null;
            while ((entry = this.readMessage(traceReader)) != null) {
                traceEntries.add(entry);
            }
        }
        finally {
            if (traceReader != null) {
                try {
                    traceReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return traceEntries.toArray(new TraceEntry[traceEntries.size()]);
    }

    private TraceEntry readMessage(BufferedReader traceReader) throws IOException, InvalidTraceEntry {
        TraceEntry result = null;
        int input = traceReader.read();
        while (input != -1) {
            char inputChar = (char)input;
            if (inputChar == '#') {
                String comment = traceReader.readLine();
                if (comment != null) {
                    comment = comment.trim();
                }
                if (comment.startsWith("verbose")) {
                    int splitIndex = comment.indexOf(58);
                    String verboseValue = comment.substring(splitIndex + 1, comment.length()).trim();
                    this.verboseDebug = Boolean.valueOf(verboseValue);
                }
            }
            if (inputChar == TRACE_ELEMENT_DELIMITER.charAt(0)) {
                String threadName = this.readEntry(traceReader);
                if (threadName == null || threadName.length() == 0) {
                    throw new InvalidTraceEntry("The thread name in a trace entry is null or empty", threadName);
                }
                String date = this.readEntry(traceReader);
                if (date == null || date.length() == 0) {
                    throw new InvalidTraceEntry("The timestamp in a trace entry is null or empty", date);
                }
                long timestamp = 0L;
                try {
                    timestamp = TRACE_FILE_DATE_FORMATTER.parse(date).getTime();
                }
                catch (ParseException parseEx) {
                    throw new InvalidTraceEntry("The date in a trace entry '" + date + "' could not be parsed.", date);
                }
                String symbolicName = null;
                String optionPath = null;
                String className = null;
                String methodName = null;
                int lineNumber = -1;
                if (this.verboseDebug) {
                    symbolicName = this.readEntry(traceReader);
                    if (symbolicName == null || symbolicName.length() == 0) {
                        throw new InvalidTraceEntry("The bundle symbolic name in a trace entry is null or empty", symbolicName);
                    }
                    optionPath = this.readEntry(traceReader);
                    if (optionPath == null || optionPath.length() == 0) {
                        throw new InvalidTraceEntry("The option-path in a trace entry is null or empty", optionPath);
                    }
                    className = this.readEntry(traceReader);
                    if (className == null || className.length() == 0) {
                        throw new InvalidTraceEntry("The class name in a trace entry is null or empty", className);
                    }
                    methodName = this.readEntry(traceReader);
                    if (methodName == null || methodName.length() == 0) {
                        throw new InvalidTraceEntry("The method name in a trace entry is null or empty", methodName);
                    }
                    String lineNumberString = this.readEntry(traceReader);
                    if (lineNumberString == null || lineNumberString.length() == 0) {
                        throw new InvalidTraceEntry("The line number in a trace entry is null or empty", lineNumberString);
                    }
                    lineNumber = Integer.valueOf(lineNumberString);
                }
                String message = this.readEntry(traceReader);
                traceReader.mark(1);
                inputChar = (char)traceReader.read();
                String throwable = null;
                if (inputChar != '\n' && inputChar != '\r') {
                    traceReader.reset();
                    throwable = this.readEntry(traceReader);
                    if (throwable == null || throwable.length() == 0) {
                        throw new InvalidTraceEntry("The throwable in a trace entry is null or empty", throwable);
                    }
                }
                result = new TraceEntry(threadName, timestamp, symbolicName, optionPath, className, methodName, lineNumber, message, throwable);
                break;
            }
            input = traceReader.read();
        }
        return result;
    }

    private String readEntry(Reader traceReader) throws IOException {
        char inputChar = (char)traceReader.read();
        StringBuilder buffer = new StringBuilder();
        while (inputChar != TRACE_ELEMENT_DELIMITER.charAt(0)) {
            inputChar = (char)traceReader.read();
            if (inputChar == TRACE_ELEMENT_DELIMITER.charAt(0)) continue;
            buffer.append(inputChar);
        }
        return buffer.toString().trim();
    }

    private void failWithInvalidTrace(String methodSignature, InvalidTraceEntry invalidEx) {
        AssertionFailedError error = new AssertionFailedError("Failed '" + methodSignature + "' test as an invalid trace entry was found.  Actual Value: '" + invalidEx.getActualValue() + "'.");
        error.initCause((Throwable)invalidEx);
        throw error;
    }

    static class InvalidTraceEntry
    extends Exception {
        private static final long serialVersionUID = -63837787081750344L;
        String actualValue;
        String expectedValue;

        public InvalidTraceEntry(String message, String actual) {
            super(message);
            this.actualValue = actual;
        }

        public final String getActualValue() {
            return this.actualValue;
        }
    }

    static class Runner1 {
        Runner1() {
        }

        public FrameworkDebugTraceEntry run() {
            return new Runner2().run();
        }
    }

    static class Runner2 {
        Runner2() {
        }

        public FrameworkDebugTraceEntry run() {
            String bundleName = OSGiTestsActivator.getBundle().getSymbolicName();
            String optionPath = "/debug";
            String message = "Test message";
            String tracingClass = this.getClass().getName();
            return new FrameworkDebugTraceEntry(bundleName, optionPath, message, tracingClass);
        }
    }

    class TestDebugOptionsListener
    implements DebugOptionsListener {
        boolean called = false;
        String incorrectValue;
        Map checkValues;

        TestDebugOptionsListener() {
        }

        public void optionsChanged(DebugOptions options) {
            this.called = true;
            if (this.checkValues == null) {
                return;
            }
            Iterator iterator = this.checkValues.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element;
                Map.Entry entry = element = iterator.next();
                String debugValue = options.getOption((String)entry.getKey());
                String error = "Value is incorrect for key: " + String.valueOf(entry.getKey()) + " " + debugValue;
                if (debugValue == null) {
                    if (entry.getValue() == null) continue;
                    this.incorrectValue = error;
                    return;
                }
                if (debugValue.equals(entry.getValue())) continue;
                this.incorrectValue = error;
                return;
            }
        }

        public boolean gotCalled() {
            return this.called;
        }

        public void clear() {
            this.called = false;
            this.checkValues = null;
            this.incorrectValue = null;
        }

        public void setCheckValues(Map checkValues) {
            this.checkValues = checkValues;
        }

        public String getIncorrectValue() {
            return this.incorrectValue;
        }
    }

    static class TestDebugTrace
    implements DebugTrace {
        private final DebugTrace wrapped;

        public TestDebugTrace(DebugTrace wrapped) {
            this.wrapped = wrapped;
        }

        public void trace(String option, String message) {
            this.wrapped.trace(option, message);
        }

        public void trace(String option, String message, Throwable error) {
            this.wrapped.trace(option, message, error);
        }

        public void traceDumpStack(String option) {
            this.wrapped.traceDumpStack(option);
        }

        public void traceEntry(String option) {
            this.wrapped.traceEntry(option);
        }

        public void traceEntry(String option, Object methodArgument) {
            this.wrapped.traceEntry(option, methodArgument);
        }

        public void traceEntry(String option, Object[] methodArguments) {
            this.wrapped.traceEntry(option, methodArguments);
        }

        public void traceExit(String option) {
            this.wrapped.traceExit(option);
        }

        public void traceExit(String option, Object result) {
            this.wrapped.traceExit(option, result);
        }
    }

    public static class TraceEntry {
        public static final String DEFAULT_OPTION_PATH = "/debug";
        private final String threadName;
        private final long timestamp;
        private final String optionPath;
        private final String bundleSymbolicName;
        private final String className;
        private String methodName = null;
        private final int lineNumber;
        private final String message;
        private final String throwableText;

        public TraceEntry(String traceThreadName, long traceTimestamp, String traceBundleName, String traceOptionPath, String traceClassName, String traceMethodName, int traceLineNumber, String traceMessage) {
            this.threadName = traceThreadName;
            this.bundleSymbolicName = traceBundleName;
            this.optionPath = traceOptionPath;
            this.className = traceClassName;
            this.methodName = traceMethodName;
            this.lineNumber = traceLineNumber;
            this.message = traceMessage;
            this.timestamp = traceTimestamp;
            this.throwableText = null;
        }

        public TraceEntry(String traceThreadName, long traceTimestamp, String traceBundleName, String traceOptionPath, String traceClassName, String traceMethodName, int traceLineNumber, String traceMessage, String traceThrowable) {
            this.threadName = traceThreadName;
            this.bundleSymbolicName = traceBundleName;
            this.optionPath = traceOptionPath;
            this.className = traceClassName;
            this.methodName = traceMethodName;
            this.lineNumber = traceLineNumber;
            this.message = traceMessage;
            this.timestamp = traceTimestamp;
            this.throwableText = traceThrowable;
        }

        public final String getThreadName() {
            return this.threadName;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final String getBundleSymbolicName() {
            return this.bundleSymbolicName;
        }

        public final String getMessage() {
            return this.message;
        }

        public final String getThrowableText() {
            return this.throwableText;
        }

        public final String getClassName() {
            return this.className;
        }

        public final String getMethodName() {
            return this.methodName;
        }

        public final String getOptionPath() {
            return this.optionPath;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }
    }
}

