/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.eventmgr;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.junit.Assert;
import org.junit.Test;

public class EventManagerTests {
    @Test
    public void testCopyOnWriteIdentityMap() {
        Object l1 = new Object();
        Object l2 = new Object();
        Object l3 = new Object();
        Object l4 = new Object();
        Object c1 = new Object();
        Object c2 = new Object();
        Object c3 = new Object();
        Object c4 = new Object();
        CopyOnWriteIdentityMap el1 = new CopyOnWriteIdentityMap();
        Assert.assertTrue((String)"not empty", (boolean)el1.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)0L, (long)el1.size());
        Assert.assertNull((String)"non null", (Object)el1.put(l1, c1));
        Assert.assertFalse((String)"empty", (boolean)el1.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)1L, (long)el1.size());
        Assert.assertNull((String)"non null", (Object)el1.put(l2, c2));
        Assert.assertFalse((String)"empty", (boolean)el1.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)2L, (long)el1.size());
        Assert.assertNull((String)"non null", (Object)el1.put(l3, c3));
        Assert.assertFalse((String)"empty", (boolean)el1.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)3L, (long)el1.size());
        Assert.assertNull((String)"non null", (Object)el1.put(l4, c4));
        Assert.assertFalse((String)"empty", (boolean)el1.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)4L, (long)el1.size());
        Assert.assertEquals((String)"wrong value", (Object)c1, (Object)el1.get(l1));
        Assert.assertEquals((String)"wrong value", (Object)c2, (Object)el1.get(l2));
        Assert.assertEquals((String)"wrong value", (Object)c3, (Object)el1.get(l3));
        Assert.assertEquals((String)"wrong value", (Object)c4, (Object)el1.get(l4));
        CopyOnWriteIdentityMap el2 = new CopyOnWriteIdentityMap(el1);
        Assert.assertFalse((String)"empty", (boolean)el2.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)4L, (long)el2.size());
        Assert.assertEquals((String)"wrong value", (Object)c1, (Object)el2.get(l1));
        Assert.assertEquals((String)"wrong value", (Object)c2, (Object)el2.get(l2));
        Assert.assertEquals((String)"wrong value", (Object)c3, (Object)el2.get(l3));
        Assert.assertEquals((String)"wrong value", (Object)c4, (Object)el2.get(l4));
        Assert.assertEquals((String)"wrong value", (Object)c2, (Object)el1.remove(l2));
        Assert.assertFalse((String)"empty", (boolean)el1.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)3L, (long)el1.size());
        Assert.assertEquals((String)"not null", null, (Object)el1.remove(l2));
        Assert.assertFalse((String)"empty", (boolean)el1.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)3L, (long)el1.size());
        Assert.assertEquals((String)"wrong value", (Object)c4, (Object)el1.remove(l4));
        Assert.assertFalse((String)"empty", (boolean)el1.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)2L, (long)el1.size());
        Assert.assertEquals((String)"not null", null, (Object)el1.remove(l4));
        Assert.assertFalse((String)"empty", (boolean)el1.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)2L, (long)el1.size());
        Assert.assertEquals((String)"wrong value", (Object)c1, (Object)el1.get(l1));
        Assert.assertEquals((String)"wrong value", (Object)c3, (Object)el1.get(l3));
        Assert.assertFalse((String)"empty", (boolean)el2.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)4L, (long)el2.size());
        Assert.assertEquals((String)"wrong value", (Object)c1, (Object)el2.get(l1));
        Assert.assertEquals((String)"wrong value", (Object)c2, (Object)el2.get(l2));
        Assert.assertEquals((String)"wrong value", (Object)c3, (Object)el2.get(l3));
        Assert.assertEquals((String)"wrong value", (Object)c4, (Object)el2.get(l4));
        Assert.assertEquals((String)"wrong value", (Object)c1, (Object)el2.remove(l1));
        Assert.assertEquals((String)"wrong value", (Object)c3, (Object)el2.remove(l3));
        el1.putAll((Map)el2);
        Assert.assertFalse((String)"empty", (boolean)el1.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)4L, (long)el1.size());
        Assert.assertEquals((String)"wrong value", (Object)c1, (Object)el1.get(l1));
        Assert.assertEquals((String)"wrong value", (Object)c2, (Object)el1.get(l2));
        Assert.assertEquals((String)"wrong value", (Object)c3, (Object)el1.get(l3));
        Assert.assertEquals((String)"wrong value", (Object)c4, (Object)el1.get(l4));
        Assert.assertFalse((String)"empty", (boolean)el2.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)2L, (long)el2.size());
        Assert.assertEquals((String)"wrong value", (Object)c2, (Object)el2.get(l2));
        Assert.assertEquals((String)"wrong value", (Object)c4, (Object)el2.get(l4));
        el2.putAll((Map)el1);
        Assert.assertFalse((String)"empty", (boolean)el1.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)4L, (long)el1.size());
        Assert.assertEquals((String)"wrong value", (Object)c1, (Object)el1.get(l1));
        Assert.assertEquals((String)"wrong value", (Object)c2, (Object)el1.get(l2));
        Assert.assertEquals((String)"wrong value", (Object)c3, (Object)el1.get(l3));
        Assert.assertEquals((String)"wrong value", (Object)c4, (Object)el1.get(l4));
        Assert.assertFalse((String)"empty", (boolean)el2.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)4L, (long)el2.size());
        Assert.assertEquals((String)"wrong value", (Object)c1, (Object)el2.get(l1));
        Assert.assertEquals((String)"wrong value", (Object)c2, (Object)el2.get(l2));
        Assert.assertEquals((String)"wrong value", (Object)c3, (Object)el2.get(l3));
        Assert.assertEquals((String)"wrong value", (Object)c4, (Object)el2.get(l4));
        el2.clear();
        Assert.assertTrue((String)"not empty", (boolean)el2.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)0L, (long)el2.size());
        Assert.assertNull((String)"non null", (Object)el2.put(l1, c1));
        Assert.assertEquals((String)"wrong value", (Object)c1, (Object)el2.put(l1, c3));
        Assert.assertEquals((String)"wrong value", (Object)c3, (Object)el2.get(l1));
        Assert.assertTrue((String)"missed key", (boolean)el2.containsKey(l1));
        Assert.assertTrue((String)"missed value", (boolean)el2.containsValue(c3));
        Assert.assertFalse((String)"invalid key", (boolean)el2.containsKey(l2));
        Assert.assertFalse((String)"invalid value", (boolean)el2.containsValue(c1));
        el2.clear();
        HashMap<Object, Object> source = new HashMap<Object, Object>();
        source.put(l1, c1);
        source.put(l4, c4);
        el2.putAll(source);
        Assert.assertFalse((String)"empty", (boolean)el2.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)2L, (long)el2.size());
        Assert.assertEquals((String)"wrong value", (Object)c1, (Object)el2.get(l1));
        Assert.assertEquals((String)"wrong value", (Object)c4, (Object)el2.get(l4));
        el2.clear();
        Set k1 = el1.keySet();
        Set k2 = el2.keySet();
        Set k3 = el1.keySet();
        Set k4 = el1.keySet();
        Collection v1 = el1.values();
        Collection v2 = el2.values();
        Collection v3 = el1.values();
        Collection v4 = el1.values();
        Set e1 = el1.entrySet();
        Set e2 = el2.entrySet();
        Set e3 = el1.entrySet();
        Set e4 = el1.entrySet();
        Set e5 = el1.entrySet();
        el1.clear();
        Assert.assertFalse((String)"empty", (boolean)k1.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)4L, (long)k1.size());
        Assert.assertTrue((String)"missed key", (boolean)k1.contains(l1));
        Assert.assertTrue((String)"missed key", (boolean)k1.contains(l2));
        Assert.assertTrue((String)"missed key", (boolean)k1.contains(l3));
        Assert.assertTrue((String)"missed key", (boolean)k1.contains(l4));
        Assert.assertTrue((String)"missed key", (boolean)k1.containsAll(Arrays.asList(l1, l2, l3, l4)));
        Assert.assertTrue((String)"array unequal", (boolean)Arrays.equals(new Object[]{l1, l3, l2, l4}, k1.toArray()));
        Assert.assertTrue((String)"array unequal", (boolean)Arrays.equals(new Object[]{l1, l3, l2, l4}, k1.toArray(new Object[4])));
        Iterator i1 = k1.iterator();
        Assert.assertTrue((String)"missing next", (boolean)i1.hasNext());
        Assert.assertEquals((String)"wrong key", (Object)l1, i1.next());
        i1.remove();
        Assert.assertEquals((String)"wrong size", (long)3L, (long)k1.size());
        Assert.assertFalse((String)"still present", (boolean)k1.contains(l1));
        Assert.assertTrue((String)"missing next", (boolean)i1.hasNext());
        Assert.assertEquals((String)"wrong key", (Object)l3, i1.next());
        i1.remove();
        Assert.assertEquals((String)"wrong size", (long)2L, (long)k1.size());
        Assert.assertFalse((String)"still present", (boolean)k1.contains(l3));
        Assert.assertTrue((String)"missing next", (boolean)i1.hasNext());
        Assert.assertEquals((String)"wrong key", (Object)l2, i1.next());
        i1.remove();
        Assert.assertEquals((String)"wrong size", (long)1L, (long)k1.size());
        Assert.assertFalse((String)"still present", (boolean)k1.contains(l2));
        Assert.assertTrue((String)"missing next", (boolean)i1.hasNext());
        Assert.assertEquals((String)"wrong key", (Object)l4, i1.next());
        i1.remove();
        Assert.assertEquals((String)"wrong size", (long)0L, (long)k1.size());
        Assert.assertFalse((String)"still present", (boolean)k1.contains(l4));
        Assert.assertFalse((String)"extra next", (boolean)i1.hasNext());
        try {
            i1.next();
            Assert.fail((String)"next did not throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertTrue((String)"not empty", (boolean)k2.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)0L, (long)k2.size());
        Iterator i2 = k2.iterator();
        Assert.assertFalse((String)"extra next", (boolean)i2.hasNext());
        try {
            i2.next();
            Assert.fail((String)"next did not throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            k2.add(l1);
            Assert.fail((String)"add did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            k2.addAll(Arrays.asList(l1, l2));
            Assert.fail((String)"addAll did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        k3.remove(l3);
        Assert.assertFalse((String)"not removed", (boolean)k3.contains(l3));
        k3.removeAll(Arrays.asList(l1, l2));
        Assert.assertFalse((String)"not removed", (boolean)k3.contains(l1));
        Assert.assertFalse((String)"not removed", (boolean)k3.contains(l2));
        k4.retainAll(Arrays.asList(l1, l2));
        Assert.assertTrue((String)"missing", (boolean)k4.contains(l1));
        Assert.assertTrue((String)"missing", (boolean)k4.contains(l2));
        Assert.assertFalse((String)"not removed", (boolean)k4.contains(l3));
        Assert.assertFalse((String)"not removed", (boolean)k4.contains(l4));
        k4.clear();
        Assert.assertTrue((String)"not empty", (boolean)k4.isEmpty());
        Assert.assertFalse((String)"empty", (boolean)v1.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)4L, (long)v1.size());
        Assert.assertTrue((String)"missed key", (boolean)v1.contains(c1));
        Assert.assertTrue((String)"missed key", (boolean)v1.contains(c2));
        Assert.assertTrue((String)"missed key", (boolean)v1.contains(c3));
        Assert.assertTrue((String)"missed key", (boolean)v1.contains(c4));
        Assert.assertTrue((String)"missed key", (boolean)v1.containsAll(Arrays.asList(c1, c2, c3, c4)));
        Assert.assertTrue((String)"array unequal", (boolean)Arrays.equals(new Object[]{c1, c3, c2, c4}, v1.toArray()));
        Assert.assertTrue((String)"array unequal", (boolean)Arrays.equals(new Object[]{c1, c3, c2, c4}, v1.toArray(new Object[4])));
        Iterator i3 = v1.iterator();
        Assert.assertTrue((String)"missing next", (boolean)i3.hasNext());
        Assert.assertEquals((String)"wrong key", (Object)c1, i3.next());
        i3.remove();
        Assert.assertEquals((String)"wrong size", (long)3L, (long)v1.size());
        Assert.assertFalse((String)"still present", (boolean)v1.contains(c1));
        Assert.assertTrue((String)"missing next", (boolean)i3.hasNext());
        Assert.assertEquals((String)"wrong key", (Object)c3, i3.next());
        i3.remove();
        Assert.assertEquals((String)"wrong size", (long)2L, (long)v1.size());
        Assert.assertFalse((String)"still present", (boolean)v1.contains(c3));
        Assert.assertTrue((String)"missing next", (boolean)i3.hasNext());
        Assert.assertEquals((String)"wrong key", (Object)c2, i3.next());
        i3.remove();
        Assert.assertEquals((String)"wrong size", (long)1L, (long)v1.size());
        Assert.assertFalse((String)"still present", (boolean)v1.contains(c2));
        Assert.assertTrue((String)"missing next", (boolean)i3.hasNext());
        Assert.assertEquals((String)"wrong key", (Object)c4, i3.next());
        i3.remove();
        Assert.assertEquals((String)"wrong size", (long)0L, (long)v1.size());
        Assert.assertFalse((String)"still present", (boolean)v1.contains(c4));
        Assert.assertFalse((String)"extra next", (boolean)i3.hasNext());
        try {
            i3.next();
            Assert.fail((String)"next did not throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertTrue((String)"not empty", (boolean)v2.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)0L, (long)v2.size());
        Iterator i4 = v2.iterator();
        Assert.assertFalse((String)"extra next", (boolean)i4.hasNext());
        try {
            i4.next();
            Assert.fail((String)"next did not throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            v2.add(c1);
            Assert.fail((String)"add did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            v2.addAll(Arrays.asList(c1, c2));
            Assert.fail((String)"addAll did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        v3.remove(c3);
        Assert.assertFalse((String)"not removed", (boolean)v3.contains(c3));
        v3.removeAll(Arrays.asList(c1, c2));
        Assert.assertFalse((String)"not removed", (boolean)v3.contains(c1));
        Assert.assertFalse((String)"not removed", (boolean)v3.contains(c2));
        v4.retainAll(Arrays.asList(c1, c2));
        Assert.assertTrue((String)"missing", (boolean)v4.contains(c1));
        Assert.assertTrue((String)"missing", (boolean)v4.contains(c2));
        Assert.assertFalse((String)"not removed", (boolean)v4.contains(c3));
        Assert.assertFalse((String)"not removed", (boolean)v4.contains(c4));
        v4.clear();
        Assert.assertTrue((String)"not empty", (boolean)v4.isEmpty());
        Assert.assertFalse((String)"empty", (boolean)e1.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)4L, (long)e1.size());
        Iterator i5 = e1.iterator();
        Assert.assertTrue((String)"missing next", (boolean)i5.hasNext());
        Map.Entry me1 = (Map.Entry)i5.next();
        Assert.assertEquals((String)"wrong key", (Object)l1, me1.getKey());
        Assert.assertEquals((String)"wrong value", (Object)c1, me1.getValue());
        try {
            me1.setValue(c2);
            Assert.fail((String)"remove did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        i5.remove();
        Assert.assertEquals((String)"wrong size", (long)3L, (long)e1.size());
        Assert.assertFalse((String)"still present", (boolean)e1.contains(me1));
        Assert.assertTrue((String)"missing next", (boolean)i5.hasNext());
        Map.Entry me3 = (Map.Entry)i5.next();
        Assert.assertEquals((String)"wrong key", (Object)l3, me3.getKey());
        Assert.assertEquals((String)"wrong value", (Object)c3, me3.getValue());
        try {
            me3.setValue(c2);
            Assert.fail((String)"remove did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        i5.remove();
        Assert.assertEquals((String)"wrong size", (long)2L, (long)e1.size());
        Assert.assertFalse((String)"still present", (boolean)e1.contains(me3));
        Assert.assertTrue((String)"missing next", (boolean)i5.hasNext());
        Map.Entry me2 = (Map.Entry)i5.next();
        Assert.assertEquals((String)"wrong key", (Object)l2, me2.getKey());
        Assert.assertEquals((String)"wrong value", (Object)c2, me2.getValue());
        try {
            me2.setValue(c3);
            Assert.fail((String)"remove did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        i5.remove();
        Assert.assertEquals((String)"wrong size", (long)1L, (long)e1.size());
        Assert.assertFalse((String)"still present", (boolean)e1.contains(me2));
        Assert.assertTrue((String)"missing next", (boolean)i5.hasNext());
        Map.Entry me4 = (Map.Entry)i5.next();
        Assert.assertEquals((String)"wrong key", (Object)l4, me4.getKey());
        Assert.assertEquals((String)"wrong value", (Object)c4, me4.getValue());
        try {
            me4.setValue(c2);
            Assert.fail((String)"remove did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        i5.remove();
        Assert.assertEquals((String)"wrong size", (long)0L, (long)e1.size());
        Assert.assertFalse((String)"still present", (boolean)e1.contains(me4));
        Assert.assertFalse((String)"extra next", (boolean)i5.hasNext());
        try {
            i1.next();
            Assert.fail((String)"next did not throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertTrue((String)"not empty", (boolean)e2.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)0L, (long)e2.size());
        Iterator i6 = e2.iterator();
        Assert.assertFalse((String)"extra next", (boolean)i6.hasNext());
        try {
            i6.next();
            Assert.fail((String)"next did not throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            e2.add(me1);
            Assert.fail((String)"add did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            e2.addAll(Arrays.asList(me2, me4));
            Assert.fail((String)"addAll did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        e3.remove(me3);
        Assert.assertFalse((String)"not removed", (boolean)e3.contains(me3));
        e3.removeAll(Arrays.asList(me1, me2));
        Assert.assertFalse((String)"not removed", (boolean)e3.contains(me1));
        Assert.assertFalse((String)"not removed", (boolean)e3.contains(me2));
        e4.retainAll(Arrays.asList(me1, me2));
        Assert.assertTrue((String)"missing", (boolean)e4.contains(me1));
        Assert.assertTrue((String)"missing", (boolean)e4.contains(me2));
        Assert.assertFalse((String)"not removed", (boolean)e4.contains(me3));
        Assert.assertFalse((String)"not removed", (boolean)e4.contains(me4));
        e4.clear();
        Assert.assertTrue((String)"not empty", (boolean)e4.isEmpty());
        Assert.assertTrue((String)"array unequal", (boolean)Arrays.equals(new Map.Entry[]{me1, me3, me2, me4}, e5.toArray()));
        Assert.assertTrue((String)"array unequal", (boolean)Arrays.equals(new Map.Entry[]{me1, me3, me2, me4}, e5.toArray(new Map.Entry[4])));
        el2.clear();
        el2.putAll(new Object[]{l1, l3});
        Assert.assertFalse((String)"empty", (boolean)el2.isEmpty());
        Assert.assertEquals((String)"wrong size", (long)2L, (long)el2.size());
        Assert.assertTrue((String)"missed key", (boolean)el2.containsKey(l1));
        Assert.assertTrue((String)"missed key", (boolean)el2.containsKey(l3));
        Assert.assertNull((String)"value not null", (Object)el2.get(l1));
        Assert.assertNull((String)"value not null", (Object)el2.get(l3));
    }
}

