/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Objects;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.util.MapDictionary;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@RunWith(value=Parameterized.class)
public class FilterTests {
    @Parameterized.Parameter(value=0)
    public String name;
    @Parameterized.Parameter(value=1)
    public FilterFactory filterFactory;
    static final int ISTRUE = 1;
    static final int ISFALSE = 2;
    static final int ISILLEGAL = 3;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> allFilterFactories() {
        Object[][] objectArrayArray = new Object[2][];
        Object[] objectArray = new Object[2];
        objectArray[0] = "BundleContextFilter";
        objectArray[1] = arg_0 -> ((BundleContext)OSGiTestsActivator.getContext()).createFilter(arg_0);
        objectArrayArray[0] = objectArray;
        objectArrayArray[1] = new Object[]{"FrameworkUtilFilter", FrameworkUtil::createFilter};
        return Arrays.asList(objectArrayArray);
    }

    private Filter createFilter(String filterString) throws InvalidSyntaxException {
        return this.filterFactory.createFilter(filterString);
    }

    private Dictionary<String, Object> getProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("room", "bedroom");
        ((Dictionary)props).put("channel", new Object[]{34, "101"});
        ((Dictionary)props).put("status", "(on\\)*");
        ArrayList<Object> vec = new ArrayList<Object>(10);
        vec.add(150L);
        vec.add("100");
        ((Dictionary)props).put("max record time", vec);
        ((Dictionary)props).put("canrecord", "true(x)");
        ((Dictionary)props).put("shortvalue", (short)1000);
        ((Dictionary)props).put("intvalue", 100000);
        ((Dictionary)props).put("longvalue", 10000000000L);
        ((Dictionary)props).put("bytevalue", (byte)10);
        ((Dictionary)props).put("floatvalue", Float.valueOf(1.01f));
        ((Dictionary)props).put("doublevalue", 2.01);
        ((Dictionary)props).put("charvalue", Character.valueOf('A'));
        ((Dictionary)props).put("booleanvalue", Boolean.TRUE);
        ((Dictionary)props).put("weirdvalue", new Hashtable());
        ((Dictionary)props).put("primintarrayvalue", new int[]{1, 2, 3});
        ((Dictionary)props).put("primlongarrayvalue", new long[]{1L, 2L, 3L});
        ((Dictionary)props).put("primbytearrayvalue", new byte[]{1, 2, 3});
        ((Dictionary)props).put("primshortarrayvalue", new short[]{1, 2, 3});
        ((Dictionary)props).put("primfloatarrayvalue", new float[]{1.1f, 2.2f, 3.3f});
        ((Dictionary)props).put("primdoublearrayvalue", new double[]{1.1, 2.2, 3.3});
        ((Dictionary)props).put("primchararrayvalue", new char[]{'A', 'b', 'C', 'd'});
        ((Dictionary)props).put("primbooleanarrayvalue", new boolean[1]);
        ((Dictionary)props).put("bigintvalue", new BigInteger("4123456"));
        ((Dictionary)props).put("bigdecvalue", new BigDecimal("4.123456"));
        ((Dictionary)props).put("*", "foo");
        ((Dictionary)props).put("!  ab", "b");
        ((Dictionary)props).put("|   ab", "b");
        ((Dictionary)props).put("&    ab", "b");
        ((Dictionary)props).put("!", "c");
        ((Dictionary)props).put("|", "c");
        ((Dictionary)props).put("&", "c");
        ((Dictionary)props).put("empty", "");
        ((Dictionary)props).put("space", Character.valueOf(' '));
        return props;
    }

    @Test
    public void testFilter() throws InvalidSyntaxException {
        Dictionary<String, Object> props = this.getProperties();
        this.testFilter("(room=*)", props, 1);
        this.testFilter("(room=bedroom)", props, 1);
        this.testFilter("(room~= B E D R O O M )", props, 1);
        this.testFilter("(room=abc)", props, 2);
        this.testFilter(" ( room >=aaaa)", props, 1);
        this.testFilter("(room <=aaaa)", props, 2);
        this.testFilter("  ( room =b*) ", props, 1);
        this.testFilter("  ( room =*m) ", props, 1);
        this.testFilter("(room=bed*room)", props, 1);
        this.testFilter("  ( room =b*oo*m) ", props, 1);
        this.testFilter("  ( room =*b*oo*m*) ", props, 1);
        this.testFilter("  ( room =b*b*  *m*) ", props, 2);
        this.testFilter("  (& (room =bedroom) (channel ~=34))", props, 1);
        this.testFilter("  (&  (room =b*)  (room =*x) (channel=34))", props, 2);
        this.testFilter("(| (room =bed*)(channel=222)) ", props, 1);
        this.testFilter("(| (room =boom*)(channel=101)) ", props, 1);
        this.testFilter("  (! (room =ab*b*oo*m*) ) ", props, 1);
        this.testFilter("  (status =\\(o*\\\\\\)\\*) ", props, 1);
        this.testFilter("  (canRecord =true\\(x\\)) ", props, 1);
        this.testFilter("(max Record Time <=140) ", props, 1);
        this.testFilter("(shortValue >=100) ", props, 1);
        this.testFilter("(intValue <=100001) ", props, 1);
        this.testFilter("(longValue >=10000000000) ", props, 1);
        this.testFilter("  (  &  (  byteValue <=100)  (  byteValue >=10)  )  ", props, 1);
        this.testFilter("(weirdValue =100) ", props, 2);
        this.testFilter("(bigIntValue =4123456) ", props, 1);
        this.testFilter("(bigDecValue =4.123456) ", props, 1);
        this.testFilter("(floatValue >=1.0) ", props, 1);
        this.testFilter("(doubleValue <=2.011) ", props, 1);
        this.testFilter("(charValue ~=a) ", props, 1);
        this.testFilter("(booleanValue =true) ", props, 1);
        this.testFilter("(primIntArrayValue =1) ", props, 1);
        this.testFilter("(primLongArrayValue =2) ", props, 1);
        this.testFilter("(primByteArrayValue =3) ", props, 1);
        this.testFilter("(primShortArrayValue =1) ", props, 1);
        this.testFilter("(primFloatArrayValue =1.1) ", props, 1);
        this.testFilter("(primDoubleArrayValue =2.2) ", props, 1);
        this.testFilter("(primCharArrayValue ~=D) ", props, 1);
        this.testFilter("(primBooleanArrayValue =false) ", props, 1);
        this.testFilter("(& (| (room =d*m) (room =bed*) (room=abc)) (! (channel=999)))", props, 1);
        this.testFilter("(room=bedroom)", null, 2);
        this.testFilter("(*=foo)", props, 1);
        this.testFilter("(!  ab=b)", props, 1);
        this.testFilter("(|   ab=b)", props, 1);
        this.testFilter("(&=c)", props, 1);
        this.testFilter("(!=c)", props, 1);
        this.testFilter("(|=c)", props, 1);
        this.testFilter("(&    ab=b)", props, 1);
        this.testFilter("(!ab=*)", props, 2);
        this.testFilter("(|ab=*)", props, 2);
        this.testFilter("(&ab=*)", props, 2);
        this.testFilter("(empty=)", props, 1);
        this.testFilter("(empty=*)", props, 1);
        this.testFilter("(space= )", props, 1);
        this.testFilter("(space=*)", props, 1);
    }

    @Test
    public void testInvalidValues() throws InvalidSyntaxException {
        Dictionary<String, Object> props = this.getProperties();
        this.testFilter("(intvalue=*)", props, 1);
        this.testFilter("(intvalue=b)", props, 2);
        this.testFilter("(intvalue=)", props, 2);
        this.testFilter("(longvalue=*)", props, 1);
        this.testFilter("(longvalue=b)", props, 2);
        this.testFilter("(longvalue=)", props, 2);
        this.testFilter("(shortvalue=*)", props, 1);
        this.testFilter("(shortvalue=b)", props, 2);
        this.testFilter("(shortvalue=)", props, 2);
        this.testFilter("(bytevalue=*)", props, 1);
        this.testFilter("(bytevalue=b)", props, 2);
        this.testFilter("(bytevalue=)", props, 2);
        this.testFilter("(charvalue=*)", props, 1);
        this.testFilter("(charvalue=)", props, 2);
        this.testFilter("(floatvalue=*)", props, 1);
        this.testFilter("(floatvalue=b)", props, 2);
        this.testFilter("(floatvalue=)", props, 2);
        this.testFilter("(doublevalue=*)", props, 1);
        this.testFilter("(doublevalue=b)", props, 2);
        this.testFilter("(doublevalue=)", props, 2);
        this.testFilter("(booleanvalue=*)", props, 1);
        this.testFilter("(booleanvalue=b)", props, 2);
        this.testFilter("(booleanvalue=)", props, 2);
    }

    @Test
    public void testIllegal() throws InvalidSyntaxException {
        Dictionary<String, Object> props = this.getProperties();
        this.testFilter("", props, 3);
        this.testFilter("()", props, 3);
        this.testFilter("(=foo)", props, 3);
        this.testFilter("(", props, 3);
        this.testFilter("(abc = ))", props, 3);
        this.testFilter("(& (abc = xyz) (& (345))", props, 3);
        this.testFilter("  (room = b**oo!*m*) ) ", props, 3);
        this.testFilter("  (room = b**oo)*m*) ) ", props, 3);
        this.testFilter("  (room = *=b**oo*m*) ) ", props, 3);
        this.testFilter("  (room = =b**oo*m*) ) ", props, 3);
    }

    @Test
    public void testScalarSubstring() throws InvalidSyntaxException {
        Dictionary<String, Object> props = this.getProperties();
        this.testFilter("(shortValue =100*) ", props, 2);
        this.testFilter("(intValue =100*) ", props, 2);
        this.testFilter("(longValue =100*) ", props, 2);
        this.testFilter("(  byteValue =1*00  )", props, 2);
        this.testFilter("(bigIntValue =4*23456) ", props, 2);
        this.testFilter("(bigDecValue =4*123456) ", props, 2);
        this.testFilter("(floatValue =1*0) ", props, 2);
        this.testFilter("(doubleValue =2*011) ", props, 2);
        this.testFilter("(charValue =a*) ", props, 2);
        this.testFilter("(booleanValue =t*ue) ", props, 2);
    }

    @Test
    public void testNormalization() throws InvalidSyntaxException {
        Filter f1 = this.createFilter("( a = bedroom  )");
        Filter f2 = this.createFilter(" (a= bedroom  ) ");
        Assert.assertEquals((String)"not equal", (Object)"(a= bedroom  )", (Object)f1.toString());
        Assert.assertEquals((String)"not equal", (Object)"(a= bedroom  )", (Object)f2.toString());
        Assert.assertEquals((String)"not equal", (Object)f1, (Object)f2);
        Assert.assertEquals((String)"not equal", (Object)f2, (Object)f1);
        Assert.assertEquals((String)"not equal", (long)f1.hashCode(), (long)f2.hashCode());
    }

    private void testFilter(String query, Dictionary<String, Object> props, int expect) throws InvalidSyntaxException {
        if (expect == 3) {
            Assert.assertThrows(InvalidSyntaxException.class, () -> {
                Filter filter = this.createFilter(query);
            });
            return;
        }
        Filter f1 = this.createFilter(query);
        DictionaryServiceReference ref = new DictionaryServiceReference(props);
        boolean val = f1.match(props);
        Assert.assertEquals((String)"wrong result", (Object)(expect == 1 ? 1 : 0), (Object)val);
        val = f1.match((ServiceReference)ref);
        Assert.assertEquals((String)"wrong result", (Object)(expect == 1 ? 1 : 0), (Object)val);
        String normalized = f1.toString();
        Filter f2 = this.createFilter(normalized);
        val = f2.match(props);
        Assert.assertEquals((String)"wrong result", (Object)(expect == 1 ? 1 : 0), (Object)val);
        val = f2.match((ServiceReference)ref);
        Assert.assertEquals((String)"wrong result", (Object)(expect == 1 ? 1 : 0), (Object)val);
        Assert.assertEquals((String)"normalized not equal", (Object)normalized, (Object)f2.toString());
    }

    @Test
    public void testComparable() throws InvalidSyntaxException {
        SampleComparable comp42 = new SampleComparable("42");
        SampleComparable comp43 = new SampleComparable("43");
        Hashtable<String, SampleComparable> hash = new Hashtable<String, SampleComparable>();
        Filter f1 = this.createFilter("(comparable=42)");
        ((Dictionary)hash).put("comparable", comp42);
        Assert.assertTrue((String)"does not match filter", (boolean)f1.match(hash));
        Assert.assertTrue((String)"does not match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        ((Dictionary)hash).put("comparable", comp43);
        Assert.assertFalse((String)"does match filter", (boolean)f1.match(hash));
        Assert.assertFalse((String)"does match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        f1 = this.createFilter("(comparable<=42)");
        ((Dictionary)hash).put("comparable", comp42);
        Assert.assertTrue((String)"does not match filter", (boolean)f1.match(hash));
        Assert.assertTrue((String)"does not match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        ((Dictionary)hash).put("comparable", comp43);
        Assert.assertFalse((String)"does match filter", (boolean)f1.match(hash));
        Assert.assertFalse((String)"does match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        f1 = this.createFilter("(comparable>=42)");
        ((Dictionary)hash).put("comparable", comp42);
        Assert.assertTrue((String)"does not match filter", (boolean)f1.match(hash));
        Assert.assertTrue((String)"does not match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        ((Dictionary)hash).put("comparable", comp43);
        Assert.assertTrue((String)"does not match filter", (boolean)f1.match(hash));
        Assert.assertTrue((String)"does not match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        f1 = this.createFilter("(comparable=4*2)");
        ((Dictionary)hash).put("comparable", comp42);
        Assert.assertFalse((String)"does match filter", (boolean)f1.match(hash));
        Assert.assertFalse((String)"does match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
    }

    @Test
    public void testObject() throws InvalidSyntaxException {
        SampleObject obj42 = new SampleObject("42");
        SampleObject obj43 = new SampleObject("43");
        Hashtable<String, SampleObject> hash = new Hashtable<String, SampleObject>();
        Filter f1 = this.createFilter("(object=42)");
        ((Dictionary)hash).put("object", obj42);
        Assert.assertTrue((String)"does not match filter", (boolean)f1.match(hash));
        Assert.assertTrue((String)"does not match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        ((Dictionary)hash).put("object", obj43);
        Assert.assertFalse((String)"does match filter", (boolean)f1.match(hash));
        Assert.assertFalse((String)"does match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        f1 = this.createFilter("(object=4*2)");
        ((Dictionary)hash).put("object", obj42);
        Assert.assertFalse((String)"does match filter", (boolean)f1.match(hash));
        Assert.assertFalse((String)"does match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
    }

    @Test
    public void testNullValueMatch() throws InvalidSyntaxException {
        MapDictionary<String, String> nullProps = new MapDictionary<String, String>();
        ((Dictionary)nullProps).put("test.null", null);
        ((Dictionary)nullProps).put("test.non.null", "v1");
        Assert.assertFalse((boolean)this.createFilter("(test.null=*)").match(nullProps));
        Assert.assertTrue((boolean)this.createFilter("(&(!(test.null=*))(test.non.null=v1))").match(nullProps));
    }

    @Test
    public void testNullKeyMatch() throws InvalidSyntaxException {
        MapDictionary<String, String> nullProps = new MapDictionary<String, String>();
        ((Dictionary)nullProps).put(null, "null.v1");
        ((Dictionary)nullProps).put("test.non.null", "v1");
        Assert.assertTrue((boolean)this.createFilter("(test.non.null=v1)").match(nullProps));
    }

    @Test
    public void testFrameworkUtilCreateFilter() throws InvalidSyntaxException {
        Filter bundleContextFilter = OSGiTestsActivator.getContext().createFilter("(simplefilter=true)");
        Filter frameworkUtilFilter = FrameworkUtil.createFilter((String)"(simplefilter=true)");
        Assert.assertTrue((String)("Wrong Fitler impl type: " + frameworkUtilFilter.getClass().getName()), (boolean)bundleContextFilter.getClass().equals(frameworkUtilFilter.getClass()));
    }

    private static class DictionaryServiceReference
    implements ServiceReference<Object> {
        private final Dictionary<String, ?> dictionary;

        DictionaryServiceReference(Dictionary<String, ?> dictionary) {
            this.dictionary = new CaseInsensitiveDictionaryMap((Dictionary)(dictionary == null ? new Hashtable() : dictionary));
        }

        public Object getProperty(String k) {
            return this.dictionary.get(k);
        }

        public String[] getPropertyKeys() {
            throw new UnsupportedOperationException();
        }

        public int compareTo(Object reference) {
            throw new UnsupportedOperationException();
        }

        public Bundle getBundle() {
            throw new UnsupportedOperationException();
        }

        public Bundle[] getUsingBundles() {
            throw new UnsupportedOperationException();
        }

        public boolean isAssignableTo(Bundle bundle, String className) {
            throw new UnsupportedOperationException();
        }

        public Dictionary<String, Object> getProperties() {
            throw new UnsupportedOperationException();
        }

        public Object adapt(Class type) {
            throw new UnsupportedOperationException();
        }
    }

    @FunctionalInterface
    private static interface FilterFactory {
        public Filter createFilter(String var1) throws InvalidSyntaxException;
    }

    private static class SampleComparable
    implements Comparable<SampleComparable> {
        private int value = -1;

        public SampleComparable(String value) {
            this.value = Integer.parseInt(value);
        }

        @Override
        public int compareTo(SampleComparable o) {
            return Integer.compare(this.value, o.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SampleObject {
        private int value = -1;

        public SampleObject(String value) {
            this.value = Integer.parseInt(value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object o) {
            return o instanceof SampleObject && this.value == ((SampleObject)o).value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

