/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.hooks.framework;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.osgi.launch.EquinoxFactory;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.BundleInstaller;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.connect.FrameworkUtilHelper;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public abstract class AbstractFrameworkHookTests {
    @Rule
    public TestName testName = new TestName();
    protected static final String BUNDLES_ROOT = "bundle_tests";
    protected BasicURLClassLoader classLoader;
    protected String testURL = null;
    protected BundleInstaller bundleInstaller;

    public BundleContext getContext() {
        return OSGiTestsActivator.getContext();
    }

    protected void assertBundleDiscarded(String location, Framework framework) {
        Assert.assertNull((String)("Bundle " + location + " was not discarded"), (Object)framework.getBundleContext().getBundle(location));
    }

    protected void assertBundleNotDiscarded(String location, Framework framework) {
        Assert.assertNotNull((String)("Bundle " + location + " was discarded"), (Object)framework.getBundleContext().getBundle(location));
    }

    protected Framework createFramework(Map<String, String> configuration) throws Exception {
        FrameworkFactory factory = (FrameworkFactory)this.classLoader.loadClass(EquinoxFactory.class.getName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Framework framework = factory.newFramework(configuration);
        return framework;
    }

    protected void initAndStart(Framework framework) throws Exception {
        framework.init();
        framework.start();
    }

    protected Framework restart(Framework framework, Map<String, String> configuration) throws Exception {
        AbstractBundleTests.stop(framework);
        framework = this.createFramework(configuration);
        this.initAndStart(framework);
        return framework;
    }

    @Before
    public void setUp() throws Exception {
        this.setUpBundleInstaller();
        this.setUpClassLoader();
    }

    @After
    public void tearDown() throws Exception {
        this.bundleInstaller.shutdown();
    }

    private void setUpBundleInstaller() throws Exception {
        this.bundleInstaller = new BundleInstaller(BUNDLES_ROOT, this.getContext());
    }

    private void setUpClassLoader() throws Exception {
        BundleContext context = this.getContext();
        String osgiFramework = context.getProperty("osgi.framework");
        URL[] urls = "folder".equals(context.getProperty("osgi.framework.shape")) ? new URL[]{new URL(osgiFramework), new URL(osgiFramework + "bin/")} : new URL[]{new URL(osgiFramework)};
        this.classLoader = new BasicURLClassLoader(urls, this.getClass().getClassLoader(), this.testURL);
    }

    protected static class BasicURLClassLoader
    extends URLClassLoader {
        private volatile String testURL;

        public BasicURLClassLoader(URL[] urls, ClassLoader parent, String testURL) {
            super(urls, parent);
            this.testURL = testURL;
        }

        @Override
        public URL getResource(String name) {
            if (this.isLocalResource(name)) {
                return this.findResource(name);
            }
            return super.getResource(name);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (this.isLocalResource(name)) {
                return this.findResources(name);
            }
            return super.getResources(name);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.testURL != null) {
                try {
                    URL fileUrl = new URI(this.testURL).toURL();
                    fileUrl.toString();
                }
                catch (MalformedURLException | URISyntaxException e) {
                    this.testURL = null;
                    throw new RuntimeException(e);
                }
            }
            if (name.startsWith("org.eclipse") || name.startsWith("org.osgi.framework.FrameworkUtil") || name.equals(FrameworkUtilHelper.class.getName())) {
                Class<?> result = this.findLoadedClass(name);
                if (result == null) {
                    result = this.findClass(name);
                }
                return result;
            }
            return super.loadClass(name, resolve);
        }

        private boolean isLocalResource(String name) {
            return name.startsWith("org/eclipse") || name.equals("hookconfigurators.properties");
        }
    }
}

