/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.hooks.framework;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.hooks.framework.AbstractFrameworkHookTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.launch.Framework;

public class ActivatorOrderTest
extends AbstractFrameworkHookTests {
    private Framework framework;
    private static final String HOOK_CONFIGURATOR_BUNDLE = "activator.hooks.a";
    private static final String HOOK_CONFIGURATOR_CLASS1 = "org.eclipse.osgi.tests.hooks.framework.activator.a.TestHookConfigurator1";
    private static final String HOOK_CONFIGURATOR_CLASS2 = "org.eclipse.osgi.tests.hooks.framework.activator.a.TestHookConfigurator2";
    private static final String HOOK_CONFIGURATOR_CLASS3 = "org.eclipse.osgi.tests.hooks.framework.activator.a.TestHookConfigurator3";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        String loc = this.bundleInstaller.getBundleLocation(HOOK_CONFIGURATOR_BUNDLE);
        loc = loc.substring(loc.indexOf("file:"));
        this.classLoader.addURL(new URL(loc));
        File file = OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", file.getAbsolutePath());
        configuration.put("osgi.hook.configurators", "org.eclipse.osgi.tests.hooks.framework.activator.a.TestHookConfigurator1,org.eclipse.osgi.tests.hooks.framework.activator.a.TestHookConfigurator2,org.eclipse.osgi.tests.hooks.framework.activator.a.TestHookConfigurator3");
        this.framework = this.createFramework(configuration);
    }

    @Test
    public void testActivatorOrder() throws Exception {
        ArrayList actualEvents = new ArrayList();
        Class<?> clazz1 = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS1);
        clazz1.getField("events").set(null, actualEvents);
        Class<?> clazz2 = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS2);
        clazz2.getField("events").set(null, actualEvents);
        Class<?> clazz3 = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS3);
        clazz3.getField("events").set(null, actualEvents);
        List<String> expectedEvents = Arrays.asList("HOOK1 STARTED", "HOOK2 STARTED", "HOOK3 STARTED", "HOOK3 STOPPED", "HOOK2 STOPPED", "HOOK1 STOPPED");
        this.initAndStart(this.framework);
        AbstractBundleTests.stop(this.framework);
        Assert.assertEquals((String)"Activator order not as expected", expectedEvents, actualEvents);
    }
}

