/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.hooks.framework;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.hooks.framework.AbstractFrameworkHookTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.launch.Framework;

public class BundleFileWrapperFactoryHookTests
extends AbstractFrameworkHookTests {
    private static final String TEST_BUNDLE = "substitutes.a";
    private static final String HOOK_CONFIGURATOR_BUNDLE = "wrapper.hooks.a";
    private static final String HOOK_CONFIGURATOR_CLASS = "org.eclipse.osgi.tests.wrapper.hooks.a.TestHookConfigurator";
    private Map<String, String> configuration;
    private Framework framework;
    private String location;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        String loc = this.bundleInstaller.getBundleLocation(HOOK_CONFIGURATOR_BUNDLE);
        loc = loc.substring(loc.indexOf("file:"));
        this.classLoader.addURL(new URL(loc));
        this.location = this.bundleInstaller.getBundleLocation(TEST_BUNDLE);
        File file = OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName());
        this.configuration = new HashMap<String, String>();
        this.configuration.put("org.osgi.framework.storage", file.getAbsolutePath());
        this.configuration.put("osgi.hook.configurators.include", HOOK_CONFIGURATOR_CLASS);
        this.framework = this.createFramework(this.configuration);
    }

    @Override
    public void tearDown() throws Exception {
        AbstractBundleTests.stopQuietly(this.framework);
        super.tearDown();
    }

    private void initAndStartFramework() throws Exception {
        this.initAndStart(this.framework);
    }

    private Bundle installBundle() throws Exception {
        return this.framework.getBundleContext().installBundle(this.location);
    }

    @Test
    public void testGetResourceURL() throws Exception {
        this.initAndStartFramework();
        Bundle b = this.installBundle();
        URL url1 = b.getResource("data/resource1");
        Assert.assertEquals((String)("Wrong protocol used: " + String.valueOf(url1)), (Object)"custom", (Object)url1.getProtocol());
        Assert.assertEquals((String)"Wrong content found.", (Object)"CUSTOM_CONTENT", (Object)this.readURL(url1));
    }

    private String readURL(URL url) throws IOException {
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line = reader.readLine();
            while (line != null) {
                sb.append(line);
                line = reader.readLine();
                if (line == null) continue;
                sb.append('\n');
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return sb.toString();
    }
}

