/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.hooks.framework;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.hooks.framework.AbstractFrameworkHookTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;

public class ContextFinderTests
extends AbstractFrameworkHookTests {
    private Map<String, String> configuration;
    private Framework framework;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        File file = OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName());
        this.configuration = new HashMap<String, String>();
        this.configuration.put("org.osgi.framework.storage", file.getAbsolutePath());
        this.framework = this.createFramework(this.configuration);
        this.initAndStart(this.framework);
    }

    @Override
    public void tearDown() throws Exception {
        AbstractBundleTests.stopQuietly(this.framework);
        super.tearDown();
    }

    @Test
    public void testContextClassLoaderNullLocal() throws InvalidSyntaxException, IOException {
        BundleContext bc = this.framework.getBundleContext();
        ClassLoader contextFinder = (ClassLoader)bc.getService((ServiceReference)bc.getServiceReferences(ClassLoader.class, "(equinox.classloader.type=contextClassLoader)").iterator().next());
        Enumeration<URL> result = contextFinder.getResources("does/not/exist.txt");
        Assert.assertNotNull((String)"Null result.", result);
        Assert.assertFalse((String)"Found unexpected result", (boolean)result.hasMoreElements());
    }
}

