/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.hooks.framework;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.SystemBundleTests;
import org.eclipse.osgi.tests.hooks.framework.AbstractFrameworkHookTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.launch.Framework;

public class DevClassPathDuplicateTests
extends AbstractFrameworkHookTests {
    private Map<String, String> configuration;
    private Framework framework;
    private String location;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        File store = OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName());
        this.configuration = new HashMap<String, String>();
        this.configuration.put("org.osgi.framework.storage", store.getAbsolutePath());
        this.configuration.put("osgi.dev", "duplicate/");
        this.framework = this.createFramework(this.configuration);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-SymbolicName", "b.dup.cp");
        headers.put("Bundle-ClassPath", "duplicate/");
        HashMap<String, String> entries = new HashMap<String, String>();
        entries.put("duplicate/", null);
        entries.put("duplicate/resource.txt", "hello");
        File testBundle = SystemBundleTests.createBundle(store, "b.dup.cp", headers, entries);
        this.location = testBundle.toURI().toASCIIString();
    }

    @Override
    public void tearDown() throws Exception {
        AbstractBundleTests.stopQuietly(this.framework);
        super.tearDown();
    }

    private void initAndStartFramework() throws Exception {
        this.initAndStart(this.framework);
    }

    private Bundle installBundle() throws Exception {
        return this.framework.getBundleContext().installBundle(this.location);
    }

    @Test
    public void testDevClassPathWithExtension() throws Exception {
        this.initAndStartFramework();
        Bundle b = this.installBundle();
        b.start();
        Enumeration resources = b.getResources("resource.txt");
        Assert.assertNotNull((String)"no resources", (Object)resources);
        int cnt = 0;
        while (resources.hasMoreElements()) {
            ++cnt;
            resources.nextElement();
        }
        Assert.assertEquals((String)"Wrong number of resources.", (long)1L, (long)cnt);
    }
}

