/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.hooks.framework;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.hooks.framework.AbstractFrameworkHookTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.FrameworkWiring;

public class DevClassPathWithExtensionTests
extends AbstractFrameworkHookTests {
    private static final String TEST_BUNDLE = "ext.framework.a";
    private Map<String, String> configuration;
    private Framework framework;
    private String location;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.location = this.bundleInstaller.getBundleLocation(TEST_BUNDLE);
        File file = OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName());
        this.configuration = new HashMap<String, String>();
        this.configuration.put("org.osgi.framework.storage", file.getAbsolutePath());
        this.configuration.put("osgi.dev", "bin/");
        this.framework = this.createFramework(this.configuration);
    }

    @Override
    public void tearDown() throws Exception {
        AbstractBundleTests.stopQuietly(this.framework);
        super.tearDown();
    }

    private void initAndStartFramework() throws Exception {
        this.initAndStart(this.framework);
    }

    private Bundle installBundle() throws Exception {
        return this.framework.getBundleContext().installBundle(this.location);
    }

    @Test
    public void testDevClassPathWithExtension() throws Exception {
        this.initAndStartFramework();
        Bundle b = this.installBundle();
        Assert.assertTrue((String)"Did not resolve test extension", (boolean)this.resolveBundles(Collections.singleton(b)));
        AbstractBundleTests.stop(this.framework);
        this.framework = this.createFramework(this.configuration);
        this.initAndStart(this.framework);
    }

    private boolean resolveBundles(Collection<Bundle> bundles) {
        return ((FrameworkWiring)this.framework.adapt(FrameworkWiring.class)).resolveBundles(bundles);
    }
}

