/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.hooks.framework;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.hooks.framework.AbstractFrameworkHookTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.launch.Framework;

public class EmbeddedEquinoxWithURLInClassLoadTests
extends AbstractFrameworkHookTests {
    private Framework framework;

    @Override
    public void setUp() throws Exception {
        URL myManifest = this.getClass().getResource("/META-INF/MANIFEST.MF");
        this.testURL = myManifest.toExternalForm();
        super.setUp();
        File file = OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", file.getAbsolutePath());
        this.framework = this.createFramework(configuration);
    }

    @Override
    public void tearDown() throws Exception {
        AbstractBundleTests.stopQuietly(this.framework);
        super.tearDown();
    }

    private void initAndStartFramework() throws Exception {
        this.initAndStart(this.framework);
    }

    @Test
    public void testFrameworkClassLoaderWithNewURI() throws Exception {
        this.initAndStartFramework();
    }

    @Test
    public void testEmbeddedURLHandler() throws Exception {
        this.initAndStart(this.framework);
        Bundle testHandler = this.framework.getBundleContext().installBundle(this.bundleInstaller.getBundleLocation("test.protocol.handler"));
        testHandler.start();
        Bundle testHandlerUser = this.framework.getBundleContext().installBundle(this.bundleInstaller.getBundleLocation("test.protocol.handler.user"));
        testHandlerUser.start();
        try {
            URL testingURL = new URL("testing1://test");
            Assert.fail((String)("Should not find testing1 protocol: " + String.valueOf(testingURL)));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

