/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.hooks.framework;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.SystemBundleTests;
import org.eclipse.osgi.tests.hooks.framework.AbstractFrameworkHookTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.service.packageadmin.PackageAdmin;

public class StorageHookTests
extends AbstractFrameworkHookTests {
    private static final String TEST_BUNDLE = "test";
    private static final String HOOK_CONFIGURATOR_BUNDLE = "storage.hooks.a";
    private static final String HOOK_CONFIGURATOR_CLASS = "org.eclipse.osgi.tests.hooks.framework.storage.a.TestHookConfigurator";
    private static final String HOOK_CONFIGURATOR_FIELD_CREATE_STORAGE_HOOK_CALLED = "createStorageHookCalled";
    private static final String HOOK_CONFIGURATOR_FIELD_FAIL_LOAD = "failLoad";
    private static final String HOOK_CONFIGURATOR_FIELD_INVALID = "invalid";
    private static final String HOOK_CONFIGURATOR_FIELD_INVALID_FACTORY_CLASS = "invalidFactoryClass";
    private static final String HOOK_CONFIGURATOR_FIELD_VALIDATE_CALLED = "validateCalled";
    private static final String HOOK_CONFIGURATOR_FIELD_DELETING_CALLED = "deletingGenerationCalled";
    private static final String HOOK_CONFIGURATOR_FIELD_ADAPT_MANIFEST = "adaptManifest";
    private static final String HOOK_CONFIGURATOR_FIELD_ADAPT_CAPABILITY_ATTRIBUTE = "adaptCapabilityAttribute";
    private static final String HOOK_CONFIGURATOR_FIELD_REPLACE_BUILDER = "replaceModuleBuilder";
    private static final String HOOK_CONFIGURATOR_FIELD_HANDLE_CONTENT = "handleContentConnection";
    private static final String HOOK_CONFIGURATOR_FIELD_NULL_STORAGE_HOOK = "returnNullStorageHook";
    private Map<String, String> configuration;
    private Framework framework;
    private String location;

    @Test
    public void testBundleDiscardedWhenClasspathStorageHookInvalidates() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        this.setStorageHookInvalid(true);
        this.restartFramework();
        this.assertStorageHookValidateCalled();
        this.assertBundleDiscarded();
    }

    @Test
    public void testBundleNotDiscardedWhenClasspathStorageHookValidates() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        this.setStorageHookInvalid(false);
        this.restartFramework();
        this.assertStorageHookValidateCalled();
        this.assertBundleNotDiscarded();
    }

    @Test
    public void testWrongStorageHookFactoryClassOnBundleInstall() throws Exception {
        this.setFactoryClassInvalid(true);
        this.initAndStartFramework();
        try {
            this.installBundle();
            Assert.fail((String)"Bundle install should have failed");
        }
        catch (BundleException e) {
            this.assertBundleException(e);
        }
        this.assertCreateStorageHookCalled();
    }

    @Test
    public void testWrongStorageHookFactoryClassOnBundleUpdate() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        this.setFactoryClassInvalid(true);
        try {
            this.updateBundle();
            Assert.fail((String)"Bundle update should have failed");
        }
        catch (BundleException e) {
            this.assertBundleException(e);
        }
        this.assertCreateStorageHookCalled();
    }

    @Test
    public void testWrongStorageHookFactoryClassOnFrameworkRestart() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        this.setFactoryClassInvalid(true);
        try {
            this.restartFramework();
            Assert.fail((String)"Framework restart should have failed");
        }
        catch (RuntimeException e) {
            this.assertThrowable(e.getCause());
        }
        this.assertCreateStorageHookCalled();
    }

    @Test
    public void testCleanOnFailLoad() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        this.setFactoryHookFailLoad(true);
        this.restartFramework();
        this.assertBundleDiscarded();
        File bundlesBase = new File(OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName()), "bundles");
        bundlesBase.mkdirs();
        this.framework.getBundleContext().installBundle(SystemBundleTests.createBundle(bundlesBase, this.testName.getMethodName(), false, false).toURI().toString());
    }

    @Test
    public void testDeletingGenerationCalledOnDiscard() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        this.setStorageHookInvalid(true);
        this.restartFramework();
        this.assertStorageHookDeletingGenerationCalled();
        this.assertBundleDiscarded();
    }

    @Test
    public void testDeletingGenerationCalledUninstall() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        Bundle b = this.framework.getBundleContext().getBundle(this.location);
        Assert.assertNotNull((String)"Missing test bundle.", (Object)b);
        b.uninstall();
        this.assertStorageHookDeletingGenerationCalled();
    }

    @Test
    public void testDeletingGenerationCalledUpdate() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        Bundle b = this.framework.getBundleContext().getBundle(this.location);
        Assert.assertNotNull((String)"Missing test bundle.", (Object)b);
        b.update();
        this.assertStorageHookDeletingGenerationCalled();
    }

    @Test
    public void testAdaptModuleRevisionBuilder() throws Exception {
        this.setFactoryClassAdaptManifest(true);
        this.initAndStartFramework();
        this.installBundle();
        Bundle b = this.framework.getBundleContext().getBundle(this.location);
        Assert.assertNotEquals((String)"Wrong ID.", (long)5678L, (long)b.getBundleId());
        Assert.assertNotNull((String)"Missing test bundle.", (Object)b);
        List testCaps = ((BundleRevision)b.adapt(BundleRevision.class)).getCapabilities("test.file.path");
        Assert.assertEquals((String)"Wrong number of test caps.", (long)1L, (long)testCaps.size());
        String path1 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.file.path");
        Assert.assertNotNull((String)"No path", (Object)path1);
        String operation1 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.operation");
        Assert.assertEquals((String)"Wrong operation", (Object)ModuleContainerAdaptor.ModuleEvent.INSTALLED.toString(), (Object)operation1);
        String location1 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.origin");
        Assert.assertEquals((String)"Wrong origin", (Object)this.framework.getBundleContext().getBundle().getLocation(), (Object)location1);
        b.update();
        Assert.assertNotEquals((String)"Wrong ID.", (long)5678L, (long)b.getBundleId());
        testCaps = ((BundleRevision)b.adapt(BundleRevision.class)).getCapabilities("test.file.path");
        Assert.assertEquals((String)"Wrong number of test caps.", (long)1L, (long)testCaps.size());
        String path2 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.file.path");
        Assert.assertNotNull((String)"No path", (Object)path2);
        String operation2 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.operation");
        Assert.assertEquals((String)"Wrong operation", (Object)ModuleContainerAdaptor.ModuleEvent.UPDATED.toString(), (Object)operation2);
        String location2 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.origin");
        Assert.assertEquals((String)"Wrong origin", (Object)this.location, (Object)location2);
        Assert.assertNotEquals((String)"Path of updated bundle is the same.", (Object)path1, (Object)path2);
        AbstractBundleTests.stop(this.framework);
        this.framework = this.createFramework(this.configuration);
        this.framework.start();
        b = this.framework.getBundleContext().getBundle(this.location);
        Assert.assertNotEquals((String)"Wrong ID.", (long)5678L, (long)b.getBundleId());
        testCaps = ((BundleRevision)b.adapt(BundleRevision.class)).getCapabilities("test.file.path");
        Assert.assertEquals((String)"Wrong number of test caps.", (long)1L, (long)testCaps.size());
        path2 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.file.path");
        Assert.assertNotNull((String)"No path", (Object)path2);
        operation2 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.operation");
        Assert.assertEquals((String)"Wrong operation", (Object)ModuleContainerAdaptor.ModuleEvent.UPDATED.toString(), (Object)operation2);
        location2 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.origin");
        Assert.assertEquals((String)"Wrong origin", (Object)this.location, (Object)location2);
        this.setFactoryClassAdaptManifest(false);
        this.setFactoryClassReplaceBuilder(true);
        b.uninstall();
        this.installBundle();
        b = this.framework.getBundleContext().getBundle(this.location);
        Assert.assertNotEquals((String)"Wrong ID.", (long)5678L, (long)b.getBundleId());
        Assert.assertNotNull((String)"Missing test bundle.", (Object)b);
        Assert.assertEquals((String)"Wrong BSN.", (Object)"replace", (Object)b.getSymbolicName());
        testCaps = ((BundleRevision)b.adapt(BundleRevision.class)).getCapabilities("replace");
        Assert.assertEquals((String)"Wrong number of capabilities.", (long)1L, (long)testCaps.size());
        this.setFactoryClassReplaceBuilder(false);
        this.setFactoryClassAdaptCapabilityAttribute(true);
        b.uninstall();
        this.installBundle();
        b = this.framework.getBundleContext().getBundle(this.location);
        BundleCapability bundleCap = (BundleCapability)((BundleRevision)b.adapt(BundleRevision.class)).getDeclaredCapabilities("osgi.wiring.bundle").iterator().next();
        Assert.assertEquals((String)"Wrong attribute value", (Object)"testAttribute", bundleCap.getAttributes().get("matching.attribute"));
        Assert.assertEquals((String)"Wrong attribute value", (Object)"testDirective", bundleCap.getDirectives().get("matching.directive"));
    }

    @Test
    public void testFrameworkUtilHelper() throws Exception {
        this.initAndStartFramework();
        Class<?> frameworkUtilClass = this.classLoader.loadClass("org.osgi.framework.FrameworkUtil");
        Bundle b = (Bundle)frameworkUtilClass.getMethod("getBundle", Class.class).invoke(null, String.class);
        Assert.assertEquals((String)"Wrong bundle found.", (Object)this.framework.getBundleContext().getBundle("System Bundle"), (Object)b);
        PackageAdmin packageAdmin = (PackageAdmin)this.framework.getBundleContext().getService(this.framework.getBundleContext().getServiceReference(PackageAdmin.class));
        b = packageAdmin.getBundle(String.class);
        Assert.assertEquals((String)"Wrong bundle found.", (Object)this.framework.getBundleContext().getBundle("System Bundle"), (Object)b);
    }

    @Test
    public void testHandleContent() throws Exception {
        this.initAndStartFramework();
        this.setFactoryClassHandleContent(true);
        Bundle b = this.framework.getBundleContext().installBundle("testBundle", (InputStream)new ByteArrayInputStream(new byte[0]));
        Assert.assertEquals((String)"Wrong symbolicName", (Object)"testHandleContentConnection", (Object)b.getSymbolicName());
        b.uninstall();
        b = this.framework.getBundleContext().installBundle("testBundle");
        Assert.assertEquals((String)"Wrong symbolicName", (Object)"testHandleContentConnection", (Object)b.getSymbolicName());
        b.uninstall();
        this.setFactoryClassHandleContent(false);
        b = this.installBundle();
        Assert.assertEquals((String)"Wrong symbolicName", (Object)"test1", (Object)b.getSymbolicName());
        this.setFactoryClassHandleContent(true);
        b.update((InputStream)new ByteArrayInputStream(new byte[0]));
        Assert.assertEquals((String)"Wrong symbolicName", (Object)"testHandleContentConnection", (Object)b.getSymbolicName());
        this.setFactoryClassHandleContent(false);
        b.update();
        Assert.assertEquals((String)"Wrong symbolicName", (Object)"test1", (Object)b.getSymbolicName());
        this.setFactoryClassHandleContent(true);
        b.update();
        Assert.assertEquals((String)"Wrong symbolicName", (Object)"testHandleContentConnection", (Object)b.getSymbolicName());
    }

    @Test
    public void testNullStorageHook() throws Exception {
        this.initAndStartFramework();
        File bundlesBase = new File(OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName()), "bundles");
        bundlesBase.mkdirs();
        String initialBundleLoc = SystemBundleTests.createBundle(bundlesBase, this.testName.getMethodName(), false, false).toURI().toString();
        Bundle initialBundle = this.framework.getBundleContext().installBundle(initialBundleLoc);
        Assert.assertNotNull((String)"Expected to have an initial bundle.", (Object)initialBundle);
        this.setFactoryNullStorageHook(true);
        Bundle b = this.installBundle();
        Assert.assertNotNull((String)"Expected to have a bundle after install.", (Object)b);
        AbstractBundleTests.stop(this.framework);
        this.framework = this.createFramework(this.configuration);
        this.framework.init();
        initialBundle = this.framework.getBundleContext().getBundle(initialBundleLoc);
        Assert.assertNotNull((String)"Expected to have initial bundle after restart.", (Object)initialBundle);
        b = this.framework.getBundleContext().getBundle(this.location);
        Assert.assertNotNull((String)"Expected to have a bundle after restart.", (Object)b);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        String loc = this.bundleInstaller.getBundleLocation(HOOK_CONFIGURATOR_BUNDLE);
        loc = loc.substring(loc.indexOf("file:"));
        this.classLoader.addURL(new URL(loc));
        this.location = this.bundleInstaller.getBundleLocation(TEST_BUNDLE);
        File file = OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName());
        this.configuration = new HashMap<String, String>();
        this.configuration.put("org.osgi.framework.storage", file.getAbsolutePath());
        this.configuration.put("osgi.hook.configurators.include", HOOK_CONFIGURATOR_CLASS);
        this.framework = this.createFramework(this.configuration);
        this.resetStorageHook();
    }

    @Override
    public void tearDown() throws Exception {
        AbstractBundleTests.stopQuietly(this.framework);
        super.tearDown();
    }

    private void assertBundleDiscarded() {
        this.assertBundleDiscarded(this.location, this.framework);
    }

    private void assertBundleException(BundleException e) {
        this.assertThrowable(e.getCause());
    }

    private void assertBundleNotDiscarded() {
        this.assertBundleNotDiscarded(this.location, this.framework);
    }

    private void assertCreateStorageHookCalled() throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        Assert.assertTrue((String)"Storage hook factory createStorageHook not called by framework", (boolean)clazz.getField(HOOK_CONFIGURATOR_FIELD_CREATE_STORAGE_HOOK_CALLED).getBoolean(null));
    }

    private void assertThrowable(Throwable t) {
        Assert.assertTrue((String)"Unexpected exception", (t != null && t instanceof IllegalStateException && t.getMessage().startsWith("The factory class ") ? 1 : 0) != 0);
    }

    private void assertStorageHookValidateCalled() throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        Assert.assertTrue((String)"Storage hook validate not called by framework", (boolean)clazz.getField(HOOK_CONFIGURATOR_FIELD_VALIDATE_CALLED).getBoolean(null));
    }

    private void assertStorageHookDeletingGenerationCalled() throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        Assert.assertTrue((String)"Storage hook deletingGeneration not called by framework", (boolean)clazz.getField(HOOK_CONFIGURATOR_FIELD_DELETING_CALLED).getBoolean(null));
    }

    private void initAndStartFramework() throws Exception {
        this.initAndStart(this.framework);
    }

    private Bundle installBundle() throws Exception {
        return this.framework.getBundleContext().installBundle(this.location);
    }

    private void resetStorageHook() throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_CREATE_STORAGE_HOOK_CALLED).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_INVALID).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_VALIDATE_CALLED).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_INVALID_FACTORY_CLASS).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_DELETING_CALLED).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_ADAPT_MANIFEST).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_FAIL_LOAD).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_HANDLE_CONTENT).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_REPLACE_BUILDER).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_NULL_STORAGE_HOOK).set(null, false);
    }

    private void restartFramework() throws Exception {
        this.framework = this.restart(this.framework, this.configuration);
    }

    private void setFactoryClassInvalid(boolean value) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_INVALID_FACTORY_CLASS).set(null, value);
    }

    private void setStorageHookInvalid(boolean value) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_INVALID).set(null, value);
    }

    private void setFactoryClassAdaptManifest(boolean value) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_ADAPT_MANIFEST).set(null, value);
    }

    private void setFactoryClassAdaptCapabilityAttribute(boolean value) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_ADAPT_CAPABILITY_ATTRIBUTE).set(null, value);
    }

    private void setFactoryClassReplaceBuilder(boolean value) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_REPLACE_BUILDER).set(null, value);
    }

    private void setFactoryHookFailLoad(boolean value) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_FAIL_LOAD).set(null, value);
    }

    private void setFactoryClassHandleContent(boolean value) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_HANDLE_CONTENT).set(null, value);
    }

    private void setFactoryNullStorageHook(boolean value) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_NULL_STORAGE_HOOK).set(null, value);
    }

    private void updateBundle() throws Exception {
        this.framework.getBundleContext().getBundle(this.location).update();
    }
}

