/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.internal.plugins;

import java.io.IOException;
import junit.framework.AssertionFailedError;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.util.ManifestElement;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;

public class InstallTests {
    @Test
    public void testInstallNoVersionManifest01() throws BundleException, IOException {
        Bundle installed = null;
        try {
            installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle03");
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    @Test
    public void testInstallInvalidManifest02() throws IOException, BundleException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((String)"testInstallInvalidManifest02", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle11");
                Assert.fail((String)"Expected a failure with no Bundle-SymbolicName header");
            }
            catch (BundleException be) {
                Assert.assertEquals((String)"Expected manifest error", (long)3L, (long)be.getType());
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    @Test
    public void testInstallInvalidManifest03() throws IOException, BundleException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((String)"testInstallInvalidManifest03", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle12");
                Assert.fail((String)"Expected a failure with duplicate directives");
            }
            catch (BundleException be) {
                Assert.assertEquals((String)"Expected manifest error", (long)3L, (long)be.getType());
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    @Test
    public void testInstallInvalidManifest04() throws IOException, BundleException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((String)"testInstallInvalidManifest04", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle13");
                Assert.fail((String)"Expected a failure with duplicate attributes");
            }
            catch (BundleException be) {
                Assert.assertEquals((String)"Expected manifest error", (long)3L, (long)be.getType());
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    @Test
    public void testInstallInvalidManifest05() throws IOException, BundleException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((String)"testInstallInvalidManifest05", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle14");
                Assert.fail((String)"Expected a failure with duplicate imports");
            }
            catch (BundleException be) {
                Assert.assertEquals((String)"Expected manifest error", (long)3L, (long)be.getType());
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    @Test
    public void testStartError01() throws IOException, BundleException {
        Bundle installed = null;
        try {
            installed = BundleTestingHelper.installBundle((String)"testStartError01", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle15");
            try {
                installed.start();
                Assert.fail((String)"Expected a failure to start unresolved bundle");
            }
            catch (BundleException be) {
                Assert.assertEquals((String)"Expected manifest error", (long)4L, (long)be.getType());
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    @Test
    public void testStartError02() throws IOException, BundleException {
        Bundle host = null;
        Bundle fragment = null;
        try {
            host = BundleTestingHelper.installBundle((String)"testStartError02_host", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle16");
            fragment = BundleTestingHelper.installBundle((String)"testStartError02_frag", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle17");
            try {
                host.start();
            }
            catch (BundleException be) {
                AssertionFailedError error = new AssertionFailedError("Unexpected start host error");
                error.initCause((Throwable)be);
                throw error;
            }
            try {
                fragment.start();
                Assert.fail((String)"Expected a failure to start fragment bundle");
            }
            catch (BundleException be) {
                Assert.assertEquals((String)"Expected manifest error", (long)2L, (long)be.getType());
            }
        }
        finally {
            if (host != null) {
                host.uninstall();
            }
            if (fragment != null) {
                fragment.uninstall();
            }
        }
    }

    @Test
    public void testUnsupportedOperation01() throws IOException, BundleException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((String)"testUnsupportedOperation01", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle18");
                Assert.fail((String)"Expected an unsupported operation exception");
            }
            catch (BundleException be) {
                Assert.assertEquals((String)"Expected unsupported error", (long)1L, (long)be.getType());
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    @Test
    public void testInstallLocationWithSpaces() throws BundleException, IOException {
        Bundle installed = null;
        installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle 01");
        try {
            Assert.assertEquals((String)"1.0", (Object)"bundle01", (Object)installed.getSymbolicName());
            Assert.assertEquals((String)"1.1", (long)2L, (long)installed.getState());
        }
        finally {
            installed.uninstall();
        }
    }

    @Test
    public void testInstallLocationWithUnderscores() throws BundleException, IOException {
        Bundle installed = null;
        installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle02_1.0.0");
        try {
            Assert.assertEquals((String)"1.0", (Object)"bundle02", (Object)installed.getSymbolicName());
            Assert.assertEquals((String)"1.1", (long)2L, (long)installed.getState());
            Assert.assertEquals((String)"1.2", (Object)new Version("2.0"), (Object)new Version((String)installed.getHeaders().get("Bundle-Version")));
        }
        finally {
            installed.uninstall();
        }
    }

    @Test
    public void testInstallBundleWithExtensionPointOnly() throws BundleException, IOException {
        Bundle installed = null;
        installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle04");
        try {
            Assert.assertEquals((String)"1.0", (Object)"bundle04", (Object)installed.getSymbolicName());
            Assert.assertEquals((String)"1.1", (long)2L, (long)installed.getState());
            Assert.assertEquals((String)"1.2", (Object)"1.3.7", installed.getHeaders().get("Bundle-Version"));
            String symbolicNameString = (String)installed.getHeaders().get("Bundle-SymbolicName");
            Assert.assertNotNull((String)"1.3", (Object)symbolicNameString);
            ManifestElement[] symbolicNameHeader = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameString);
            Assert.assertEquals((String)"1.4", (long)1L, (long)symbolicNameHeader.length);
            Assert.assertEquals((String)"1.5", (Object)"true", (Object)symbolicNameHeader[0].getDirective("singleton"));
        }
        finally {
            installed.uninstall();
        }
    }

    @Test
    public void testInstallBundleWithExtensionOnly() throws BundleException, IOException {
        Bundle installed = null;
        installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle05");
        try {
            Assert.assertEquals((String)"1.0", (Object)"bundle05", (Object)installed.getSymbolicName());
            Assert.assertEquals((String)"1.1", (long)2L, (long)installed.getState());
            Assert.assertEquals((String)"1.2", (Object)"1.3.8", installed.getHeaders().get("Bundle-Version"));
            String symbolicNameString = (String)installed.getHeaders().get("Bundle-SymbolicName");
            Assert.assertNotNull((String)"1.3", (Object)symbolicNameString);
            ManifestElement[] symbolicNameHeader = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameString);
            Assert.assertEquals((String)"1.4", (long)1L, (long)symbolicNameHeader.length);
            Assert.assertEquals((String)"1.5", (Object)"true", (Object)symbolicNameHeader[0].getDirective("singleton"));
        }
        finally {
            installed.uninstall();
        }
    }

    @Test
    public void testInstallBundleWithExtensionAndExtensionPoint() throws BundleException, IOException {
        Bundle installed = null;
        installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle06");
        try {
            Assert.assertEquals((String)"1.0", (Object)"bundle06", (Object)installed.getSymbolicName());
            Assert.assertEquals((String)"1.1", (long)2L, (long)installed.getState());
            Assert.assertEquals((String)"1.2", (Object)"1.3.9", installed.getHeaders().get("Bundle-Version"));
            String symbolicNameString = (String)installed.getHeaders().get("Bundle-SymbolicName");
            Assert.assertNotNull((String)"1.3", (Object)symbolicNameString);
            ManifestElement[] symbolicNameHeader = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameString);
            Assert.assertEquals((String)"1.4", (long)1L, (long)symbolicNameHeader.length);
            Assert.assertEquals((String)"1.5", (Object)"true", (Object)symbolicNameHeader[0].getDirective("singleton"));
        }
        finally {
            installed.uninstall();
        }
    }

    @Test
    public void testInstall2NonSingletonBundles() throws BundleException, IOException {
        Bundle installed1 = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle07");
        ServiceReference packageAdminSR = OSGiTestsActivator.getContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)OSGiTestsActivator.getContext().getService(packageAdminSR);
        packageAdmin.resolveBundles(null);
        Bundle installed2 = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle07b");
        packageAdmin.resolveBundles(null);
        OSGiTestsActivator.getContext().ungetService(packageAdminSR);
        try {
            Assert.assertEquals((String)"1.0", (Object)"bundle07", (Object)installed2.getSymbolicName());
            Assert.assertEquals((String)"1.1", (long)4L, (long)installed2.getState());
            Assert.assertEquals((String)"1.2", (Object)"1.0.0.b", installed2.getHeaders().get("Bundle-Version"));
            Assert.assertEquals((String)"1.3", (Object)"bundle07", (Object)installed1.getSymbolicName());
            Assert.assertEquals((String)"1.4", (long)4L, (long)installed1.getState());
            Assert.assertEquals((String)"1.5", (Object)"1.0.0", installed1.getHeaders().get("Bundle-Version"));
        }
        finally {
            installed1.uninstall();
            installed2.uninstall();
        }
    }

    @Test
    public void testInstall2SingletonBundles() throws BundleException, IOException {
        Bundle installed1 = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle08");
        ServiceReference packageAdminSR = OSGiTestsActivator.getContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)OSGiTestsActivator.getContext().getService(packageAdminSR);
        packageAdmin.resolveBundles(null);
        Bundle installed2 = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle08b");
        packageAdmin.resolveBundles(null);
        OSGiTestsActivator.getContext().ungetService(packageAdminSR);
        try {
            Assert.assertEquals((String)"1.0", (Object)"bundle08", (Object)installed1.getSymbolicName());
            Assert.assertEquals((String)"1.1", (long)4L, (long)installed1.getState());
            Assert.assertEquals((String)"1.2", (Object)"1.0.0", installed1.getHeaders().get("Bundle-Version"));
            Assert.assertEquals((String)"1.3", (Object)"bundle08", (Object)installed2.getSymbolicName());
            Assert.assertEquals((String)"1.4", (long)2L, (long)installed2.getState());
            Assert.assertEquals((String)"1.5", (Object)"1.0.0.b", installed2.getHeaders().get("Bundle-Version"));
        }
        finally {
            installed1.uninstall();
            installed2.uninstall();
        }
    }
}

