/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.listeners;

import java.io.IOException;
import java.net.MalformedURLException;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class ExceptionHandlerTests {
    @Test
    public void testNonFatalException() {
        FrameworkEventListenerWithResult fwkListener = new FrameworkEventListenerWithResult();
        OSGiTestsActivator.getContext().addFrameworkListener((FrameworkListener)fwkListener);
        BundleListener npeGenerator = event -> {
            throw new NullPointerException("Generated exception");
        };
        OSGiTestsActivator.getContext().addBundleListener(npeGenerator);
        try {
            BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle09");
            FrameworkEvent eventReceived = fwkListener.getResult(60000L);
            Assert.assertEquals((long)2L, (long)eventReceived.getType());
            Assert.assertEquals((Object)true, (Object)(eventReceived.getThrowable() instanceof NullPointerException));
        }
        catch (MalformedURLException eventReceived) {
        }
        catch (IOException | BundleException e) {
            e.printStackTrace();
        }
        OSGiTestsActivator.getContext().removeFrameworkListener((FrameworkListener)fwkListener);
        OSGiTestsActivator.getContext().removeBundleListener(npeGenerator);
    }

    @Test
    public void testFatalException() {
        FrameworkEventListenerWithResult fwkListener = new FrameworkEventListenerWithResult();
        OSGiTestsActivator.getContext().addFrameworkListener((FrameworkListener)fwkListener);
        BundleListener fatalException = event -> {
            throw new OutOfMemoryError("Generated exception");
        };
        OSGiTestsActivator.getContext().addBundleListener(fatalException);
        try {
            System.setProperty("eclipse.exitOnError", "false");
            BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle10");
            FrameworkEvent eventReceived = fwkListener.getResult(10000L);
            Assert.assertEquals((long)2L, (long)eventReceived.getType());
            Assert.assertEquals((Object)true, (Object)(eventReceived.getThrowable() instanceof VirtualMachineError));
            System.setProperty("eclipse.exitOnError", "true");
        }
        catch (MalformedURLException eventReceived) {
        }
        catch (IOException | BundleException e) {
            e.printStackTrace();
        }
        OSGiTestsActivator.getContext().removeFrameworkListener((FrameworkListener)fwkListener);
        OSGiTestsActivator.getContext().removeBundleListener(fatalException);
    }

    class FrameworkEventListenerWithResult
    implements FrameworkListener {
        FrameworkEvent event = null;

        FrameworkEventListenerWithResult() {
        }

        public synchronized void frameworkEvent(FrameworkEvent newEvent) {
            if (newEvent.getType() != 2) {
                return;
            }
            if (this.event != null) {
                return;
            }
            this.event = newEvent;
            this.notify();
        }

        public synchronized FrameworkEvent getResult(long timeout) {
            if (this.event != null) {
                FrameworkEvent tmp = this.event;
                this.event = null;
                return tmp;
            }
            try {
                this.wait(timeout);
            }
            catch (InterruptedException tmp) {
                // empty catch block
            }
            FrameworkEvent tmp = this.event;
            this.event = null;
            return tmp;
        }
    }
}

