/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.perf;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.framework.util.Headers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestName;

public class CaseMapPerformanceTest {
    @Rule
    public TestName testName = new TestName();
    static final String[] KEYS;
    static final Object VALUE;
    static final String[] COMMON_KEY_NAMES;

    static {
        VALUE = new Object();
        KEYS = new String[1000];
        int i = 0;
        while (i < 1000) {
            CaseMapPerformanceTest.KEYS[i] = "Header-" + i + "-Key";
            ++i;
        }
        COMMON_KEY_NAMES = new String[]{"objectClass", "service.bundleid", "service.changecount", "service.description", "service.id", "service.pid", "service.ranking", "service.scope", "service.vendor", "component.name", "component.id", "metatype.pid", "metatype.factory.pid", "event.topics", "event.filter", "jmx.objectname", "Bundle-ActivationPolicy", "Bundle-Activator", "Bundle-ClassPath", "Bundle-License", "Bundle-Localization", "Bundle-ManifestVersion", "Bundle-Name", "Bundle-NativeCode", "Bundle-RequiredExecutionEnvironment", "Bundle-SCM", "Bundle-SymbolicName", "Bundle-Vendor", "Bundle-Version", "Export-Package", "Fragment-Host", "Import-Package", "Require-Bundle", "Require-Capability"};
    }

    public void testHeaders004() throws Exception {
        Headers headers = new Headers(4);
        this.doTestMap((Map<String, Object>)headers, 4);
    }

    public void testHeaders005() throws Exception {
        Headers headers = new Headers(5);
        this.doTestMap((Map<String, Object>)headers, 5);
    }

    public void testHeaders006() throws Exception {
        Headers headers = new Headers(6);
        this.doTestMap((Map<String, Object>)headers, 6);
    }

    public void testHeaders010() throws Exception {
        Headers headers = new Headers(10);
        this.doTestMap((Map<String, Object>)headers, 10);
    }

    public void testHeaders020() throws Exception {
        Headers headers = new Headers(20);
        this.doTestMap((Map<String, Object>)headers, 20);
    }

    public void testHeaders100() throws Exception {
        Headers headers = new Headers(100);
        this.doTestMap((Map<String, Object>)headers, 100);
    }

    public void testXCaseMap004() throws Exception {
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(4);
        this.doTestMap((Map<String, Object>)headers, 4);
    }

    public void testXCaseMap005() throws Exception {
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(5);
        this.doTestMap((Map<String, Object>)headers, 5);
    }

    public void testXCaseMap006() throws Exception {
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(6);
        this.doTestMap((Map<String, Object>)headers, 6);
    }

    public void testXCaseMap010() throws Exception {
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(10);
        this.doTestMap((Map<String, Object>)headers, 10);
    }

    public void testXCaseMap034() throws Exception {
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(34);
        this.doTestMap((Map<String, Object>)headers, 34);
    }

    public void testXCaseMap100() throws Exception {
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(100);
        this.doTestMap((Map<String, Object>)headers, 100);
    }

    private void doTestMap(final Map<String, Object> map, final int numKeys) throws Exception {
        new PerformanceTestRunner(){

            protected void test() {
                CaseMapPerformanceTest.fillMap(map, numKeys);
                CaseMapPerformanceTest.doMapGet(map, numKeys);
            }
        }.run(this.getClass(), this.testName.getMethodName(), 10, 10000);
    }

    public void testCommonKeyMap() throws Exception {
        CaseInsensitiveDictionaryMap map = new CaseInsensitiveDictionaryMap(34);
        new PerformanceTestRunner((Map)map){
            private final /* synthetic */ Map val$map;
            {
                this.val$map = map;
            }

            protected void test() {
                CaseMapPerformanceTest.fillCommonKeyMap(this.val$map);
                CaseMapPerformanceTest.doCommonKeyMapGet(this.val$map);
            }
        }.run(this.getClass(), this.testName.getMethodName(), 10, 10000);
    }

    public void testCommonHashMap() throws Exception {
        final HashMap map = new HashMap(34);
        new PerformanceTestRunner(){

            protected void test() {
                CaseMapPerformanceTest.fillCommonKeyMap(map);
                CaseMapPerformanceTest.doCommonKeyMapGet(map);
            }
        }.run(this.getClass(), this.testName.getMethodName(), 10, 10000);
    }

    static void fillMap(Map<String, Object> map, int numKeys) {
        map.clear();
        int i = 0;
        while (i < numKeys) {
            map.put(KEYS[i], VALUE);
            ++i;
        }
    }

    static void fillCommonKeyMap(Map<String, Object> map) {
        map.clear();
        String[] stringArray = COMMON_KEY_NAMES;
        int n = COMMON_KEY_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            map.put(key, VALUE);
            ++n2;
        }
    }

    static void doMapGet(Map<String, Object> map, int numKeys) {
        int i = 0;
        while (i < numKeys) {
            Assert.assertEquals((String)"Wrong value found.", (Object)VALUE, (Object)map.get(KEYS[i]));
            ++i;
        }
    }

    static void doCommonKeyMapGet(Map<String, Object> map) {
        String[] stringArray = COMMON_KEY_NAMES;
        int n = COMMON_KEY_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            Assert.assertEquals((String)"Wrong value found.", (Object)VALUE, (Object)map.get(key));
            ++n2;
        }
    }
}

