/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.perf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.tests.perf.BasePerformanceTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatePerformanceTest
extends BasePerformanceTest {
    @Rule
    public TestName testName = new TestName();
    private static final String DEGREDATION_STORE_RETRIEVE = "Performance decrease caused by additional fuctionality required for generic capabilities/requirements in OSGi R4.3 specification. See https://bugs.eclipse.org/bugs/show_bug.cgi?id=324753 for details.";

    State storeAndRetrieve(State toStore) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        toStore.getFactory().writeState(toStore, (OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return toStore.getFactory().readState((InputStream)bais);
    }

    @Test
    public void testCreation() throws Exception {
        int stateSize = 5000;
        new PerformanceTestRunner(){

            protected void test() {
                StatePerformanceTest.this.buildRandomState(5000);
            }
        }.run(this.getClass(), this.testName.getMethodName(), 10, 10);
    }

    private void testResolution(int stateSize, int repetitions, String degradation) throws Exception {
        final State originalState = this.buildRandomState(stateSize);
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void test() {
                originalState.resolve(false);
            }
        };
        runner.setRegressionReason(degradation);
        runner.run(this.getClass(), this.testName.getMethodName(), 10, repetitions);
    }

    @Test
    public void testResolution100() throws Exception {
        this.testResolution(100, 500, "Performance decrease caused by additional fuctionality required for ResovlerHooks in OSGi R4.3 specification. See https://bugs.eclipse.org/bugs/show_bug.cgi?id=324753 for details.");
    }

    @Test
    public void testResolution1000() throws Exception {
        this.testResolution(1000, 15, null);
    }

    @Test
    public void testResolution500() throws Exception {
        this.testResolution(500, 50, "Performance decrease caused by additional fuctionality required for ResovlerHooks in OSGi R4.3 specification. See https://bugs.eclipse.org/bugs/show_bug.cgi?id=324753 for details.");
    }

    @Test
    public void testResolution5000() throws Exception {
        this.testResolution(5000, 1, "Performance decrease caused by additional fuctionality required for ResovlerHooks in OSGi R4.3 specification. See https://bugs.eclipse.org/bugs/show_bug.cgi?id=324753 for details.");
    }

    @Test
    public void testStoreAndRetrieve() throws Exception {
        int stateSize = 5000;
        final State originalState = this.buildRandomState(stateSize);
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void test() throws IOException {
                StatePerformanceTest.this.storeAndRetrieve(originalState);
            }
        };
        runner.setRegressionReason(DEGREDATION_STORE_RETRIEVE);
        runner.run(this.getClass(), this.testName.getMethodName(), 10, 10);
    }
}

