/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.permissions;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.PropertyPermission;
import org.eclipse.osgi.tests.permissions.PermissionTests;
import org.junit.Test;
import org.osgi.framework.AdminPermission;

public class AdminPermissionTests
extends PermissionTests {
    @Test
    public void testAdminPermission() {
        AdminPermission p1 = new AdminPermission();
        AdminPermission p2 = new AdminPermission("*", "*");
        PropertyPermission op = new PropertyPermission("java.home", "read");
        this.shouldImply((Permission)p1, (Permission)p2);
        this.shouldImply((Permission)p1, (Permission)p1);
        this.shouldNotImply((Permission)p1, (Permission)op);
        this.shouldEqual((Permission)p1, (Permission)p2);
        this.shouldNotEqual((Permission)p1, op);
        PermissionCollection pc = p1.newPermissionCollection();
        this.checkEnumeration(pc.elements(), true);
        this.shouldNotImply(pc, (Permission)p1);
        this.shouldAdd(pc, (Permission)p1);
        this.shouldAdd(pc, (Permission)p2);
        this.shouldNotAdd(pc, op);
        pc.setReadOnly();
        this.shouldNotAdd(pc, (Permission)new AdminPermission());
        this.shouldImply(pc, (Permission)p1);
        this.shouldImply(pc, (Permission)p2);
        this.shouldNotImply(pc, (Permission)op);
        this.checkEnumeration(pc.elements(), false);
        this.testSerialization((Permission)p1);
        this.testSerialization((Permission)p2);
    }
}

