/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.permissions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServicePermission;

public class PermissionTests {
    protected void badServicePermission(String name, String actions) {
        try {
            ServicePermission p = new ServicePermission(name, actions);
            Assert.fail((String)(String.valueOf(p) + " created with invalid actions"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void badPackagePermission(String name, String actions) {
        try {
            PackagePermission p = new PackagePermission(name, actions);
            Assert.fail((String)(String.valueOf(p) + " created with invalid actions"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void checkEnumeration(Enumeration en, boolean isEmpty) {
        Assert.assertEquals((String)(String.valueOf(en) + " empty state is invalid"), (Object)(!isEmpty ? 1 : 0), (Object)en.hasMoreElements());
        try {
            while (en.hasMoreElements()) {
                en.nextElement();
            }
        }
        catch (NoSuchElementException e) {
            Assert.fail((String)(String.valueOf(en) + " threw NoSuchElementException"));
        }
        try {
            en.nextElement();
            Assert.fail((String)(String.valueOf(en) + " is empty but didn't throw NoSuchElementException"));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    protected void shouldImply(Permission p1, Permission p2) {
        Assert.assertTrue((String)(String.valueOf(p1) + " does not imply " + String.valueOf(p2)), (boolean)p1.implies(p2));
    }

    protected void shouldNotImply(Permission p1, Permission p2) {
        Assert.assertFalse((String)(String.valueOf(p1) + " does imply " + String.valueOf(p2)), (boolean)p1.implies(p2));
    }

    protected void shouldImply(PermissionCollection p1, Permission p2) {
        Assert.assertTrue((String)(String.valueOf(p1) + " does not imply " + String.valueOf(p2)), (boolean)p1.implies(p2));
    }

    protected void shouldNotImply(PermissionCollection p1, Permission p2) {
        Assert.assertFalse((String)(String.valueOf(p1) + " does imply " + String.valueOf(p2)), (boolean)p1.implies(p2));
    }

    protected void shouldEqual(Permission p1, Permission p2) {
        Assert.assertTrue((String)(String.valueOf(p1) + " does not equal " + String.valueOf(p2)), (boolean)p1.equals(p2));
        Assert.assertTrue((String)(String.valueOf(p2) + " does not equal " + String.valueOf(p1)), (boolean)p2.equals(p1));
    }

    protected void shouldNotEqual(Permission p1, Permission p2) {
        Assert.assertFalse((String)(String.valueOf(p1) + " does equal " + String.valueOf(p2)), (boolean)p1.equals(p2));
    }

    protected void shouldAdd(PermissionCollection p1, Permission p2) {
        try {
            p1.add(p2);
        }
        catch (Exception e) {
            Assert.fail((String)(String.valueOf(p1) + " will not add " + String.valueOf(p2)));
        }
    }

    protected void shouldNotAdd(PermissionCollection p1, Permission p2) {
        try {
            p1.add(p2);
            Assert.fail((String)(String.valueOf(p1) + " will add " + String.valueOf(p2)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void testSerialization(Permission p1) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(p1);
            out.flush();
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            Permission p2 = (Permission)in.readObject();
            this.shouldEqual(p1, p2);
            this.shouldImply(p1, p2);
            this.shouldImply(p2, p1);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }
}

